// This file is part of VisionCpp, a lightweight C++ template library
// for computer vision and image processing.
//
// Copyright (C) 2016 Codeplay Software Limited. All Rights Reserved.
//
// Contact: visioncpp@codeplay.com
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/// \file ops_convert.hpp
/// \brief This header gathers all conversion operations.

#ifndef VISIONCPP_INCLUDE_OPERATORS_CONVERT_OPS_CONVERT_HPP_
#define VISIONCPP_INCLUDE_OPERATORS_CONVERT_OPS_CONVERT_HPP_

#include "OP_BGRToRGB.hpp"
#include "OP_F32C3ToU8C3.hpp"
#include "OP_HSVToRGB.hpp"
#include "OP_HSVToU8C3.hpp"
#include "OP_RGBToBGR.hpp"
#include "OP_RGBToGREY.hpp"
#include "OP_RGBToHSV.hpp"
#include "OP_U8C3ToF32C3.hpp"
#endif  // VISIONCPP_INCLUDE_OPERATORS_CONVERT_OPS_CONVERT_HPP_