define ([    
    'nbextensions/visualpython/src/common/vpCommon'
    , 'nbextensions/visualpython/src/common/StringBuilder'
], function( vpCommon, sb ) {

    var _renderPrefixCode = function(numpyPageRendererThis) {
        // var uuid = vpCommon.getUUID();
        var numpyPageRendererThis = numpyPageRendererThis;
        var importPackageThis = numpyPageRendererThis.getImportPackageThis();
        var numpyStateGenerator = numpyPageRendererThis.getStateGenerator();
        var rootTagSelector = numpyPageRendererThis.getRootTagSelector();

        var sbTagString = new sb.StringBuilder();
        sbTagString.appendFormatLine("<div class='{0} {1} {2}' >", 'vp-numpy-block', 'vp-user-option-box', 'vp-minimize' );
        sbTagString.appendFormatLine("<div class='{0}'>", 'vp-accordion-header');
        sbTagString.appendFormatLine("<div class='{0} {1}' ></div>", 'vp-panel-area-vertical-btn', 'vp-arrow-down' );
        sbTagString.appendFormatLine("<span class='{0}' data-caption-id='{1}'>", 'vp-multilang', 'Variable');
        sbTagString.appendFormatLine("{0}", 'Prefix Code');
        sbTagString.appendLine("</span>");
        sbTagString.appendLine("</div>");
        sbTagString.appendFormatLine("<div id='{0}'>", 'vp_prefixBox');
        sbTagString.appendFormatLine("<textarea class='{0} {1}' placeholder='{2}' rows='3' cols='60'>", 
                                                'vp-numpy-textarea', 'vp-numpy-prefix-textarea', 'prefix code');
        sbTagString.appendFormatLine("{0}", '# Auto-Generated by VisualPython');                                        
        sbTagString.appendLine("</textarea>");
        sbTagString.appendLine("</div>");
        sbTagString.appendLine("</div>");
        var prefixDom = $(sbTagString.toString());  

        var mainPage = $(importPackageThis.wrapSelector(rootTagSelector));
        mainPage.append(prefixDom);

        mainPage.on('focus', '.vp-numpy-prefix-textarea', function() {
            Jupyter.notebook.keyboard_manager.disable();
        });
        mainPage.on('blur', '.vp-numpy-prefix-textarea', function() {
            Jupyter.notebook.keyboard_manager.enable();
        });    
        /** prefix Code */
        $(importPackageThis.wrapSelector(`.vp-numpy-prefix-textarea`)).on('change keyup paste', function() {
            numpyStateGenerator.setState({
                prefixCode: $(this).val()
            });
        });

    }
    return _renderPrefixCode;
});