define ([
    'require'
    , 'nbextensions/visualpython/src/common/vpCommon'

    , 'nbextensions/visualpython/src/numpy/api/numpyStateApi'
], function(requirejs, vpCommon,
            numpyStateApi) {
    "use strict";
    // numpy 함수의 state 데이터를 다루는 api
    var { changeOldToNewState, findStateValue } = numpyStateApi;
    /**
     * @class NumpyStateGenerator
     * @constructor
    */
    var NumpyStateGenerator = function() {
        this.state = {
            
        };
        /** 모든 numpy 함수 state에 들어가는 데이터 들 */
        Object.assign(this.state, {
            prefixCode: `# Auto-Generated by VisualPython`
            , postfixCode: ``
            , userOptionList: []
        });
    };
     /** 자식 클래스에서 반드시! 오버라이드 되는 메소드
     *  nummpy 패키지에서 blueprint에 저장된 state를 받아 새로운 state를 만드는 함수
     * @override
     * @param {Object} state 
     */
    NumpyStateGenerator.prototype.makeState = function(state) {
        Object.assign(this.state, state);
    }
    /**
        state 값 변경 함수
        @param {Object} newState
    */
    NumpyStateGenerator.prototype.setState = function(newState) {
        this.state = changeOldToNewState(this.state, newState);
        this.consoleState();
    }

    /**
        모든 state 값을 가져오는 함수
    */
    NumpyStateGenerator.prototype.getStateAll = function() {
        return this.state;
    }

    /**
        특정 state Name 값을 가져오는 함수
        @param {string} stateKeyName
    */
    NumpyStateGenerator.prototype.getState = function(stateKeyName) {
        return findStateValue(this.state, stateKeyName);
    }

    NumpyStateGenerator.prototype.consoleState = function() {
        // console.log(this.state);
    }
    return NumpyStateGenerator;
});