define([
    'nbextensions/visualpython/src/common/vpCommon'
    , 'nbextensions/visualpython/src/common/vpFuncJS'

    , './api.js'
    , './config.js'
    , './constData.js'
    , './shadowBlock.js'
    , './blockRenderer.js'
], function (vpCommon, vpFuncJS, api, config, constData, shadowBlock, blockRenderer ) {
    const ShadowBlock = shadowBlock;
 
    const { changeOldToNewState
            , findStateValue

            , createOneArrayValueAndGet
            , updateOneArrayValueAndGet
            , deleteOneArrayValueAndGet

            , makeFirstCharToUpperCase
            , mapTypeToName
            , removeSomeBlockAndGetBlockList
            , shuffleArray
            , getImageUrl } = api;

    const { PROCESS_MODE } = config;

    const { renderMainDom
            , renderLeftHolderDom
            , renderMainInnerDom
            , renderMainHeaderDom
            , renderBottomOptionContainer
            , renderBottomOptionContainerInner
            , renderDomContainer
            , renderBottomOptionInnerDom
            , renderBottomOptionName
            , renderInParamContainer
            , renderInParamDom
            , renderDefParamDom
            , renderBottomOptionTitle
            , renderElseBlock
            , renderDefaultOrDetailButton
            , renderInputRequiredColor
            , renderDeleteButton

            , renderDefaultImportDom
            , renderCustomImportDom
            , renderElifOrExceptContainer
            , renderDefaultOrCustomImportContainer

            , renderDeleteBlockButton
            , renderFocusedPage
            , renderOptionTitle
            , renderPropertyDom
            , renderPropertyDomFromDef
            , renderIfConditionDom
            , renderClassParentDom

            , generateClassInParamList
            , generateDefInParamList
            , generateReturnOutParamList
            , generateIfConditionList } = blockRenderer;

    const { BLOCK_CODELINE_BTN_TYPE
            , BLOCK_CODELINE_TYPE
            , BLOCK_DIRECTION
            , BLOCK_TYPE
            , MAKE_CHILD_BLOCK
            , IMPORT_BLOCK_TYPE
            , FOCUSED_PAGE_TYPE

            , NUM_BLOCK_HEIGHT_PX
            , NUM_INDENT_DEPTH_PX
            , NUM_MAX_ITERATION
            , NUM_ZERO
            , NUM_HUNDREAD
            , NUM_THOUSAND
            , NUM_DEFAULT_POS_X
            , NUM_DEFAULT_POS_Y
            , NUM_DEFAULT_BLOCK_LEFT_HOLDER_HEIGHT
            , NUM_BLOCK_MARGIN_TOP_PX
            , NUM_BLOCK_MARGIN_BOTTOM_PX
            , NUM_CODELINE_LEFT_MARGIN_PX
            , NUM_EXCEED_DEPTH

            , STR_NULL
            , STR_ONE_INDENT
            , STR_TOP
            , STR_LEFT
            , STR_DIV
            , STR_BORDER
            , STR_PX
            , STR_OPACITY
            , STR_MARGIN_TOP
            , STR_MARGIN_LEFT
            , STR_BOX_SHADOW
            , STR_DISPLAY
            , STR_BACKGROUND_COLOR
            , STR_WIDTH
            , STR_HEIGHT
            , STR_INHERIT
            , STR_YES
            , STR_DATA_NUM_ID 
            , STR_DATA_DEPTH_ID
            , STR_NONE
            , STR_BLOCK
            , STR_SELECTED
            , STR_COLON_SELECTED
            , STR_POSITION
            , STR_STATIC
            , STR_RELATIVE
            , STR_ABSOLUTE
            , STR_COLOR
            , STR_DOT

            , STR_TITLE
            , STR_SCROLLHEIGHT
            , STR_OVERFLOW_X
            , STR_OVERFLOW_Y
            , STR_HIDDEN
            , STR_AUTO
            , STR_OPTION
            , STR_CLASS
            , STR_DEF
            , STR_IF
            , STR_FOR
            , STR_WHILE
            , STR_IMPORT
            , STR_API
            , STR_TRY
            , STR_EXCEPT
            , STR_RETURN
            , STR_BREAK
            , STR_CONTINUE
            , STR_PASS
            , STR_CODE
            , STR_ELIF
            , STR_PROPERTY
            , STR_SCROLL 
            , STR_ONE_SPACE

            , STR_MSG_BLOCK_DELETED
            , STR_MSG_BLOCK_DEPTH_MUSH_NOT_EXCEED_6
            , STR_INPUT_YOUR_CODE

            , VP_BLOCK

            , VP_BLOCK_CLASS_DEF
            , VP_BLOCK_CONTROL

            , VP_CLASS_BLOCK_CONTAINER
            , VP_CLASS_MAIN_CONTAINER
            , VP_CLASS_BLOCK_SHADOWBLOCK
            , VP_CLASS_BLOCK_OPTION_BTN
            , VP_CLASS_BLOCK_DELETE_BTN
            , VP_CLASS_BLOCK_DEPTH_INFO
            , VP_CLASS_BLOCK_NUM_INFO
            , VP_CLASS_BLOCK_CTRLCLICK_INFO
            , VP_CLASS_NODEEDITOR_LEFT
            , VP_CLASS_NODEEDITOR_BOTTOM_TAB_VIEW
            , VP_CLASS_NODEEDITOR_BOTTOM_OPTIONAL_TAB_VIEW
            , VP_CLASS_BLOCK_LEFT_HOLDER
            , VP_CLASS_BLOCK_BOTTOM_HOLDER
            , VP_CLASS_NODEEDITOR_MINIMIZE
            , VP_CLASS_NODEEDITOR_ARROW_UP
            , VP_CLASS_NODEEDITOR_ARROW_DOWN
            , VP_CLASS_NODEEDITOR_TAB_NAVIGATION_NODE_OPTION_TITLE_SAPN
            , VP_CLASS_NODEEDITOR_SCROLLBAR

            , VP_CLASS_SELECTED_SHADOWBLOCK
            , STR_CHANGE_KEYUP_PASTE

            , STR_ICON_ARROW_UP
            , STR_ICON_ARROW_DOWN

            , STATE_classInParamList
            , STATE_className
            , STATE_defName
            , STATE_defInParamList
            , STATE_ifCodeLine
            , STATE_isIfElse
            , STATE_isForElse
            , STATE_ifConditionList
            , STATE_elifCodeLine
            , STATE_elifList
            , STATE_forCodeLine
            , STATE_whileCodeLine
            , STATE_baseImportList
            , STATE_customImportList
            , STATE_exceptList
            , STATE_exceptCodeLine
            , STATE_isFinally
            , STATE_returnOutParamList
            , STATE_customCodeLine

            , STATE_breakCodeLine
            , STATE_continueCodeLine
            , STATE_passCodeLine
            , STATE_propertyCodeLine

            , COLOR_ORANGE
            , COLOR_BLOCK_YELLOW
            , COLOR_SKY_BLUE
            , COLOR_WHITE
            , COLOR_GRAY_input_your_code
            , COLOR_YELLOW
            , COLOR_FOCUSED_PAGE

            , DEFAULT_VARIABLE_ARRAY_LIST

            , PNG_VP_APIBLOCK_OPTION_ICON
            , PNG_VP_APIBLOCK_DELETE_ICON
        
            , API_BLOCK_PROCESS_DEVELOPMENT } = constData;
            
    var Block = function(blockContainerThis, type, pointObj , isSubBlock) {

        var blockCodeLineType = type;
        if ( blockCodeLineType === BLOCK_CODELINE_TYPE.CLASS) {
            var classNum = blockContainerThis.getClassNum();
            blockContainerThis.addClassNum();
        }
        if ( blockCodeLineType === BLOCK_CODELINE_TYPE.DEF && isSubBlock === undefined) {
            var defNum = blockContainerThis.getDefNum();
            blockContainerThis.addDefNum();
        }
        if ( blockCodeLineType === BLOCK_CODELINE_TYPE.FOR) {
            var forNum = blockContainerThis.getForNum();
            blockContainerThis.addForNum();
        }

        this.state = {
            type
            , blockType: BLOCK_TYPE.BLOCK
            , blockName: STR_NULL
            , pointX: pointObj.pointX 
            , pointY: pointObj.pointY
            , containerPointX: 0
            , containerPointY: 0
            , opacity: 1
            
            , isLowerDepthChild: false
            , isRootBlock: false
            , isCollision: false
            , isSelected: false
            
            , isClicked: false
            , isDraggable: false
            , isCtrlPressed: false
            , isMoved: false

            , uuid: vpCommon.getUUID()
            , direction: BLOCK_DIRECTION.ROOT
            , tempDepth: 0
            , tempBlockLeftHolderHeight: 0
            , blockNumber: 0
            , width: 0
            , blockHeaderWidth: 0
            , blockCodeLineWidth: 0
            , variableIndex: 0

            , codeLine: STR_NULL
            , optionState: {
                classState: {
                    className: `vpClass${classNum}`
                    , classInParamList: [STR_NULL]
                    , selfVariableList: []
                    , methodList: []
                    , init: {
                        isClassInit: false
                        , initParamList: []
                    }
                    , del: {
                        isClassDel: false
                        , delParamList: []
                    }
                }
                , defState: {
                    defName: `vpFunc${defNum}`
                    , defInParamList: []
                    , defOutParamList: []
                }
                , ifState: {
                    if: {
                        ifCodeLine: `('__home__' == '__main__')`
                        , ifConditionList: [
                            {
                                arg1: `'i0'`
                                , arg2: `==`
                                , arg3: `'j0'`
                                , arg6: 'and'
                            }
                        ]
                    }
                    , elifList: []
                    , ifElse: {
                        isIfElse: false
                    }
                    
                }
                , forState: {
                    for: {
                        forCodeLine: `vp_i${forNum} in range(${Math.round(Math.random() * NUM_HUNDREAD)})`
                    }
                    , forElse: {
                        isForElse: false
                    }
                }
                , whileState: {
                    while: {
                        whileCodeLine: 'False'
                    }
                }
                , tryState: {
                    try: {
            
                    }
                    , exceptList: []
                    , finally: {
                        isFinally: false
                    }
                }
                , importState: {
                    baseImportList: [
                        baseImportNumpy = {
                            isImport: false
                            , baseImportName: 'numpy' 
                            , baseAcronyms: 'np' 
                        }   
                        , baseImportPandas = {
                            isImport: false
                            , baseImportName: 'pandas' 
                            , baseAcronyms: 'pd' 
                        }
                        , baseImportMatplotlib = {
                            isImport: false
                            , baseImportName: 'matplotlib.pyplot' 
                            , baseAcronyms: 'plt' 
                        }
                        , baseImportSeaborn = {
                            isImport: false
                            , baseImportName: 'seaborn' 
                            , baseAcronyms: 'sns' 
                        }
                        , baseImportOs = {
                            isImport: false
                            , baseImportName: 'os' 
                            , baseAcronyms: 'os' 
                        }
                        , baseImportSys = {
                            isImport: false
                            , baseImportName: 'sys' 
                            , baseAcronyms: 'sys' 
                        }
                        , baseImportTime = {
                            isImport: false
                            , baseImportName: 'time' 
                            , baseAcronyms: 'time' 
                        }
                        , baseImportDatetime = {
                            isImport: false
                            , baseImportName: 'datetime' 
                            , baseAcronyms: 'datetime' 
                        }
                        , baseImportRandom = {
                            isImport: false
                            , baseImportName: 'random' 
                            , baseAcronyms: 'random' 
                        }
                        , baseImportMath = {
                            isImport: false
                            , baseImportName: 'math' 
                            , baseAcronyms: 'math' 
                        }
                    ]
                    , customImportList: []
                    , isBaseImportPage: true
                }
                , elifState: {
                    elifCodeLine: STR_NULL
                }
                , exceptState :{
                    exceptCodeLine: STR_NULL
                }
                , returnState: {
                    returnOutParamList: []
                }
                , breakState: {
                    breakCodeLine: STR_BREAK
                }
                , continueState: {
                    continueCodeLine: STR_CONTINUE
                }
                , passState: {
                    passCodeLine: STR_PASS
                }
                , propertyState: {
                    propertyCodeLine: '@property'
                }
                , codeState: {
                    customCodeLine: STR_NULL
                }
            }
        }

        this.nextBlockList = [];
        this.blockContainerThis = blockContainerThis;

        /** dom */
        this.rootDom = null;
        this.rootInnerDom = null;
        this.rootHeaderDom = null;
        this.containerDom = null;
        this.blockLeftHolderDom = null;

        /** block */
        this.prevBlock = null;
        this.shadowBlock = null;
        this.firstIndentBlock = null;
        this.holderBlock = null;
        this.parentBlock = null;

        /** type block */
        this.ifElseBlock = null;
        this.forElseBlock = null;
        this.finallyBlock = null;
        this.lastElifBlock = null;
        this.lastChildBlock = null;
        this.propertyBlockFromDef = null;

        var name = mapTypeToName(type);
        this.setBlockName(name);

        this.init();
    
        var blockCodeType = this.getBlockCodeLineType();
        if (blockCodeType === BLOCK_CODELINE_TYPE.CLASS) {
            var defBlock = mapTypeToBlock(this.blockContainerThis, BLOCK_CODELINE_TYPE.DEF, {pointX: 0, pointY: 0}, true);
            defBlock.setState({
                defName: '__init__'
                , defInParamList:[{
                    defParamName: 'self'
                    , defDefaultVal : ''
                    , defType: 'None'
                }]
            });
            defBlock.init();
   
            var holderBlock = mapTypeToBlock(this.blockContainerThis, BLOCK_CODELINE_TYPE.HOLDER, {pointX: 0, pointY: 0});
            this.setFirstIndentBlock(defBlock);

            this.setHolderBlock(holderBlock);
            holderBlock.setSupportingBlock(this);
            $(holderBlock.getBlockMainDom()).addClass(VP_BLOCK_CLASS_DEF);
     
            this.appendBlock(holderBlock, BLOCK_DIRECTION.DOWN);
            this.appendBlock(defBlock, BLOCK_DIRECTION.INDENT);

            $(this.getHolderBlock().getBlockMainDom()).css(STR_BACKGROUND_COLOR,`${COLOR_ORANGE}`);
        } else if ( blockCodeType === BLOCK_CODELINE_TYPE.DEF) {
            var returnBlock = mapTypeToBlock(this.blockContainerThis, BLOCK_CODELINE_TYPE.RETURN_SUB, {pointX: 0, pointY: 0});
            var holderBlock = mapTypeToBlock(this.blockContainerThis, BLOCK_CODELINE_TYPE.HOLDER, {pointX: 0, pointY: 0});
            
            this.setHolderBlock(holderBlock);
            this.setFirstIndentBlock(returnBlock);
            holderBlock.setSupportingBlock(this);
            $(holderBlock.getBlockMainDom()).addClass(VP_BLOCK_CLASS_DEF);
            $(returnBlock.getBlockMainDom()).addClass(VP_BLOCK_CLASS_DEF);
            this.appendBlock(holderBlock, BLOCK_DIRECTION.DOWN);
            this.appendBlock(returnBlock, BLOCK_DIRECTION.INDENT);

            $(this.getHolderBlock().getBlockMainDom()).css(STR_BACKGROUND_COLOR,`${COLOR_ORANGE}`);
        } else if (blockCodeType === BLOCK_CODELINE_TYPE.IF ||
            blockCodeType === BLOCK_CODELINE_TYPE.FOR || blockCodeType === BLOCK_CODELINE_TYPE.WHILE || 
            blockCodeType === BLOCK_CODELINE_TYPE.TRY ) {

            var passBlock = mapTypeToBlock(this.blockContainerThis, BLOCK_CODELINE_TYPE.PASS_SUB, {pointX: 0, pointY: 0});
            var holderBlock = mapTypeToBlock(this.blockContainerThis, BLOCK_CODELINE_TYPE.HOLDER, {pointX: 0, pointY: 0});
            
            this.setHolderBlock(holderBlock);
            this.setFirstIndentBlock(passBlock);
            holderBlock.setSupportingBlock(this);
            $(passBlock.getBlockMainDom()).addClass(VP_BLOCK_CONTROL);

            this.appendBlock(holderBlock, BLOCK_DIRECTION.DOWN);
            this.appendBlock(passBlock, BLOCK_DIRECTION.INDENT);
        } else if (blockCodeType === BLOCK_CODELINE_TYPE.ELSE || 
            blockCodeType === BLOCK_CODELINE_TYPE.ELIF || blockCodeType === BLOCK_CODELINE_TYPE.FOR_ELSE || 
            blockCodeType === BLOCK_CODELINE_TYPE.EXCEPT || blockCodeType === BLOCK_CODELINE_TYPE.FINALLY ) {

            var passBlock = mapTypeToBlock(this.blockContainerThis, BLOCK_CODELINE_TYPE.PASS_SUB, {pointX: 0, pointY: 0});
            var holderBlock = mapTypeToBlock(this.blockContainerThis, BLOCK_CODELINE_TYPE.HOLDER, {pointX: 0, pointY: 0});
            
            this.setHolderBlock(holderBlock);
            this.setFirstIndentBlock(passBlock);
            holderBlock.setSupportingBlock(this);
            $(passBlock.getBlockMainDom()).addClass(VP_BLOCK_CONTROL);

            this.appendBlock(holderBlock, BLOCK_DIRECTION.DOWN);
            this.appendBlock(passBlock, BLOCK_DIRECTION.INDENT);
        }

        // this.init();
        this.blockContainerThis.addBlock(this);
        this.blockContainerThis.renderBlockLeftHolderListHeight();

        this.renderMyColor();
    }

    Block.prototype.init = function() {
        var blockCodeType = this.getBlockCodeLineType();

        {
            var mainDom = this.getBlockMainDom();
            $(mainDom).remove();
            $(mainDom).empty();
        }

        var mainDom = renderMainDom(this);
        mainDom = this.renderBlockLeftHolderDom( mainDom);

        if (blockCodeType === BLOCK_CODELINE_TYPE.HOLDER) {
            mainDom.classList.add(VP_CLASS_BLOCK_BOTTOM_HOLDER);
        }

        var mainInnerDom = renderMainInnerDom();
        var mainHeaderDom = renderMainHeaderDom(this);
        this.setBlockInnerDom(mainInnerDom);
        this.setBlockHeaderDom(mainHeaderDom);
        $(mainInnerDom).append(mainHeaderDom);          
        $(mainDom).append(mainInnerDom);
    
        this.setBlockDom(mainDom);

        // $(VP_CLASS_NODEEDITOR_LEFT).append(mainDom);
     
        this.bindEventAll();
    }

    Block.prototype.initBlockJson = function() {

    }



    // ** --------------------------- Block을 삭제, 수정, 불러오기 혹은 주변 block과의 관계를 규정하는 메소드들 --------------------------- */

    Block.prototype.getPrevBlock = function() {
        return this.prevBlock
    }
    Block.prototype.setPrevBlock = function(prevBlock) {
        this.prevBlock = prevBlock;
    }
    Block.prototype.addNextBlockList = function(nextBlock) {
        this.nextBlockList = [ ...this.nextBlockList, nextBlock]
    }
    Block.prototype.setNextBlockList = function(nextBlockList) {
        this.nextBlockList = nextBlockList;
    }
    Block.prototype.getNextBlockList = function() {
        return this.nextBlockList;
    }
    Block.prototype.setHolderBlock = function(holderBlock) {
        this.holderBlock = holderBlock;
    }
    Block.prototype.getHolderBlock = function() {
        return this.holderBlock;
    }
    Block.prototype.setSupportingBlock = function(supportingBlock) {
        this.supportingBlock = supportingBlock;
    }
    Block.prototype.getSupportingBlock = function() {
        return this.supportingBlock;
    }

    Block.prototype.setFirstIndentBlock = function(firstIndentBlock) {
        this.firstIndentBlock = firstIndentBlock;
    }
    Block.prototype.getFirstIndentBlock = function() {
        return this.firstIndentBlock;
    }

    /**
     *  this block의 논리적인 parent block을 set, get
     *  ex) else, elif의 parent block은 if
     */
    Block.prototype.setParentBlock = function(parentBlock) {
        this.parentBlock = parentBlock;
    }
    Block.prototype.getParentBlock = function() {
        return this.parentBlock;
    }

    Block.prototype.setPropertyBlockFromDef = function(propertyBlockFromDef) {
        this.propertyBlockFromDef = propertyBlockFromDef;
    }
    Block.prototype.getPropertyBlockFromDef = function() {
        return this.propertyBlockFromDef;
    }
    /**
     * if 블럭이 생성한 elifList 중에 가장 아래에 위치한 elif block을 set, get
     * @param {BLOCK} lastElifBlock 
     */
    Block.prototype.setLastElifBlock = function(lastElifBlock) {
        this.lastElifBlock = lastElifBlock;
    }
    Block.prototype.getLastElifBlock = function() {
        return this.lastElifBlock;
    }

    /**
     * @param {*} lastChildBlock 
     */
    Block.prototype.setLastChildBlock = function(lastChildBlock) {
        this.lastChildBlock = lastChildBlock;
    }
    Block.prototype.getLastChildBlock = function() {
        return this.lastChildBlock;
    }
    /**
     * for 블럭의 forElse block을 set, get
     * @param {Block} forElseBlock 
     */
    Block.prototype.setForElseBlock = function(forElseBlock) {
        this.forElseBlock = forElseBlock;
    }
    Block.prototype.getForElseBlock = function() {
        return this.forElseBlock;
    }

    /** 지금 현재 this 블럭부터 밑에 자식 블럭리스트 들을 전체 블럭에서 분리시킨다. */
    Block.prototype.untactBlock = function(x,y) {
        // this블록의 이전 블록이 있다면 데이터 상에서 삭제한다
        var prevBlock = this.getPrevBlock();
        if ( prevBlock ) {
            var nextBlockList = prevBlock.getNextBlockList();
            nextBlockList.some(( block, index) => {
                if (block.getUUID() === this.getUUID()) {
                    nextBlockList.splice(index, 1);
                    this.setPrevBlock(null);
                    return true;
                }
            });
            prevBlock.setNextBlockList(nextBlockList);
        }
        this.setPrevBlock(null);
        this.setDirection(BLOCK_DIRECTION.ROOT);

        var blockContainerThis = this.getBlockContainerThis();
        blockContainerThis.reRenderBlockList();

        var rootBlock = this.getRootBlock();
        var containerDom = rootBlock.getContainerDom();
        $(containerDom).empty();


        rootBlock.setContainerDom(containerDom);

        var childBlockList = rootBlock.renderChildBlockListIndentAndGet();
        childBlockList.forEach((block, index) => {
            var mainDom = block.getBlockMainDom();
 
            $(mainDom).attr(STR_DATA_NUM_ID,`${index}`);
            $(containerDom).append(mainDom);

            block.bindEventAll();
        });
    }

    /** 현재 블럭 트리 구조속의 최상위 루트 block 가져오기 */
    Block.prototype.getRootBlock = function() {
        var rootBlock = null;
        var prevBlock = this.getPrevBlock();

        var _iteration = 0;
        while (prevBlock !== null) {
            /** FIXME: 무한루프 체크 */
            if (_iteration > NUM_MAX_ITERATION) {
                console.log('무한루프');
                break;
            }
            _iteration++;
            var _prevBlock = prevBlock.getPrevBlock();
            if (_prevBlock === null) {
                rootBlock = prevBlock;
                break;
            }
            prevBlock = _prevBlock;
        }

        if (_iteration === 0) {
            rootBlock = this;
        }
        return rootBlock;
    }

    /** 현재 root 블럭부터 모든 자식 블럭리스트 들을 전부 가져온다 */
    Block.prototype.getRootToChildBlockList = function() {
        var rootBlock = this.getRootBlock();
        return rootBlock.getChildBlockList();
    }

    /** 현재 this 블럭부터 모든 자식 블럭리스트 들을 가져온다 */
    Block.prototype.getChildBlockList = function() {
        var nextBlockList = this.getNextBlockList();
        var stack = [];

        if (nextBlockList.length !== 0) {
            stack.push(nextBlockList);
        }

        var travelBlockList = [this];
        travelBlockList = this._getChildBlockList(travelBlockList, stack);
        return travelBlockList;
    }

    /** 현재 root 블럭부터 하위 depth 자식 블럭리스트(동일 depth 블럭 제거) 들을 전부 가져온다 */
    Block.prototype.getRootToChildBlockScopeList = function() {
        var rootBlock = this.getRootBlock();
        return rootBlock.getChildLowerDepthBlockList();
    }

    /** 현재 this 블럭부터 하위 depth 자식 블럭리스트(동일 depth 블럭 제거) 들을 전부 가져온다 */
    Block.prototype.getChildLowerDepthBlockList = function() {
        var nextBlockList = this.getNextBlockList();
        var stack = [];
        var lastChildBlock = null;
        /** indent 위치에 자식 블럭이 있는지 확인 
         *  indent 위치에 자식 블럭이 있어야 하위 depth 자식 블럭들을 가져올 수 있다.
        */
        if (nextBlockList.length !== 0) {
            var selectedBlock = null;
            var is = nextBlockList.some(block => {
                if (block.getDirection() === BLOCK_DIRECTION.INDENT) {
                    selectedBlock = block;
                    return true;
                }
            });
            if (is === true) {
                stack.push(selectedBlock);
            }
        }

        var travelBlockList = [this];



        /** bottom holder block이 있으면 추가 */
        var holderBlock = null;
        var blockCodeLineType = this.getBlockCodeLineType();
        if ( blockCodeLineType === BLOCK_CODELINE_TYPE.CLASS || blockCodeLineType === BLOCK_CODELINE_TYPE.DEF 
            || blockCodeLineType === BLOCK_CODELINE_TYPE.IF || blockCodeLineType === BLOCK_CODELINE_TYPE.TRY
            || blockCodeLineType === BLOCK_CODELINE_TYPE.FOR || blockCodeLineType === BLOCK_CODELINE_TYPE.WHILE) {
            nextBlockList.some(block => {
                if (block.getDirection() === BLOCK_DIRECTION.DOWN) {
                    travelBlockList.push(block);
                    lastChildBlock = holderBlock = block;
                    return true;
                }
            });
        } else {
            lastChildBlock = this;
        }
        
        if ( blockCodeLineType === BLOCK_CODELINE_TYPE.IF ) {
            var elifList = [];
            var nextBlockDataList = holderBlock.getNextBlockList();
            var _stack = [];
            if (nextBlockDataList.length !== 0) {
                _stack.push(nextBlockDataList);
            }

       
            var isBreak = false;
            var current = null;
            while ( _stack.length !== 0 ) {
                current = _stack.shift();
                /** 배열 일 때 */
                if ( Array.isArray(current) ) {
                     current.forEach(element => {
                        if ( element.getDirection() === BLOCK_DIRECTION.DOWN 
                            && element.getBlockCodeLineType() === BLOCK_CODELINE_TYPE.IF) {
                            isBreak = true;
                        }

                        if ( element.getDirection() === BLOCK_DIRECTION.DOWN ) {
                             _stack.push(element);

                            if ( element.getBlockCodeLineType() === BLOCK_CODELINE_TYPE.ELIF ) {
                                element.renderSelectedBlockColor();
                                lastChildBlock = element.getHolderBlock();

                                var elifChildLowerDepthBlockList = element.getChildLowerDepthBlockList();
                                elifChildLowerDepthBlockList.forEach(elifChildLowerDepthBlock => {
                                    elifList.push(elifChildLowerDepthBlock);
                                    // elifChildLowerDepthBlock.renderSelectedBlockColor();
                                });
                            }

                            if ( element.getBlockCodeLineType() === BLOCK_CODELINE_TYPE.ELSE ) {
                                element.renderSelectedBlockColor();
                                lastChildBlock = element.getHolderBlock();

                                var elseChildLowerDepthBlockList = element.getChildLowerDepthBlockList();
                                elseChildLowerDepthBlockList.forEach(elseChildLowerDepthBlock => {
                                    elifList.push(elseChildLowerDepthBlock);
                                    // elseChildLowerDepthBlock.renderSelectedBlockColor();
                                });
                            }
                        }
                    });
                
    
                } else {
                    var currBlock = current;
                    var nextBlockDataList = currBlock.getNextBlockList();
                    _stack.unshift(nextBlockDataList);
                }

                if (isBreak) {
                    break;
                }
            }

        
            travelBlockList = this._getChildBlockList(travelBlockList, stack);
            elifList.forEach(block => {
                travelBlockList.push(block);
            });

            this.setLastChildBlock(lastChildBlock);

            return travelBlockList;
        }

        if ( blockCodeLineType === BLOCK_CODELINE_TYPE.TRY ) {
            var elifList = [];
            var nextBlockDataList = holderBlock.getNextBlockList();
            var _stack = [];
            if (nextBlockDataList.length !== 0) {
                _stack.push(nextBlockDataList);
            }

       
            var isBreak = false;
            var current = null;
            while ( _stack.length !== 0 ) {
                current = _stack.shift();
                /** 배열 일 때 */
                if ( Array.isArray(current) ) {
                     current.forEach(element => {
                        if ( element.getDirection() === BLOCK_DIRECTION.DOWN 
                            && element.getBlockCodeLineType() === BLOCK_CODELINE_TYPE.TRY) {
                            isBreak = true;
                        }

                        if ( element.getDirection() === BLOCK_DIRECTION.DOWN ) {
                             _stack.push(element);

                            if ( element.getBlockCodeLineType() === BLOCK_CODELINE_TYPE.EXCEPT ) {
                                element.renderSelectedBlockColor();
                                lastChildBlock = element.getHolderBlock();

                                var elifChildLowerDepthBlockList = element.getChildLowerDepthBlockList();
                                elifChildLowerDepthBlockList.forEach(elifChildLowerDepthBlock => {
                                    elifList.push(elifChildLowerDepthBlock);
                                    // elifChildLowerDepthBlock.renderSelectedBlockColor();
                                });
                            }

                            if ( element.getBlockCodeLineType() === BLOCK_CODELINE_TYPE.FINALLY ) {
                                element.renderSelectedBlockColor();
                                lastChildBlock = element.getHolderBlock();

                                var elseChildLowerDepthBlockList = element.getChildLowerDepthBlockList();
                                elseChildLowerDepthBlockList.forEach(elseChildLowerDepthBlock => {
                                    elifList.push(elseChildLowerDepthBlock);
                                    // elseChildLowerDepthBlock.renderSelectedBlockColor();
                                });
                            }
                        }
                    });
                
    
                } else {
                    var currBlock = current;
                    var nextBlockDataList = currBlock.getNextBlockList();
                    _stack.unshift(nextBlockDataList);
                }

                if (isBreak) {
                    break;
                }
            }

        
            travelBlockList = this._getChildBlockList(travelBlockList, stack);
            elifList.forEach(block => {
                travelBlockList.push(block);
            });

            // console.log('lastChildBlock',lastChildBlock);
            this.setLastChildBlock(lastChildBlock);

            return travelBlockList;
        }

        if ( blockCodeLineType === BLOCK_CODELINE_TYPE.FOR ) {
            var elifList = [];
            var nextBlockDataList = holderBlock.getNextBlockList();
            var _stack = [];
            if (nextBlockDataList.length !== 0) {
                _stack.push(nextBlockDataList);
            }

            var isBreak = false;
            var current = null;
            while ( _stack.length !== 0 ) {
                current = _stack.shift();
                /** 배열 일 때 */
                if ( Array.isArray(current) ) {
                     current.forEach(element => {
                        if ( element.getDirection() === BLOCK_DIRECTION.DOWN 
                            && element.getBlockCodeLineType() === BLOCK_CODELINE_TYPE.FOR) {
                            isBreak = true;
                        }

                        if ( element.getDirection() === BLOCK_DIRECTION.DOWN ) {
                             _stack.push(element);

                            if ( element.getBlockCodeLineType() === BLOCK_CODELINE_TYPE.FOR_ELSE ) {

                                element.renderSelectedBlockColor();
                                lastChildBlock = element.getHolderBlock();

                                var elseChildLowerDepthBlockList = element.getChildLowerDepthBlockList();
                                elseChildLowerDepthBlockList.forEach(elseChildLowerDepthBlock => {
                                    elifList.push(elseChildLowerDepthBlock);
                                    // elseChildLowerDepthBlock.renderSelectedBlockColor();
                                });
                            }
                        }
                    });
                
    
                } else {
                    var currBlock = current;
                    var nextBlockDataList = currBlock.getNextBlockList();
                    _stack.unshift(nextBlockDataList);
                }

                if (isBreak) {
                    break;
                }
            }

        
            travelBlockList = this._getChildBlockList(travelBlockList, stack);
            elifList.forEach(block => {
                travelBlockList.push(block);
            });

            // console.log('lastChildBlock',lastChildBlock);
            this.setLastChildBlock(lastChildBlock);

            return travelBlockList;
        }

        // console.log('lastChildBlock',lastChildBlock);
        this.setLastChildBlock(lastChildBlock);

        travelBlockList = this._getChildBlockList(travelBlockList, stack);
        return travelBlockList;
    }

    /** getChildLowerDepthBlockList 메소드 로직과 동일
     *  차이점은 하위 depth Block 자식들을 아래로 한칸씩 가면서 가져오다가
     *  class, def, if, for, while, try Block을 만나면 멈추고,
     *  멈추기 직전까지 가져온 하위 depth Block 자식들을 리턴한다.
     * 
     *  Option Page창에 root Block의 하위 depth Block 자식들을 보여주기 위해서 필요
     */
    Block.prototype.getChildLowerDepthBlockList_option = function() {
        var nextBlockList = this.getNextBlockList();
        var stack = [];

        /** indent 위치에 자식 블럭이 있는지 확인 
         *  indent 위치에 자식 블럭이 있어야 하위 depth 자식 블럭들을 가져올 수 있다.
        */
        if (nextBlockList.length !== 0) {
            var selectedBlock = null;
            var blockCodeLineType =  nextBlockList[0].getBlockCodeLineType();
            if (blockCodeLineType === BLOCK_CODELINE_TYPE.CLASS || blockCodeLineType === BLOCK_CODELINE_TYPE.DEF
                || blockCodeLineType === BLOCK_CODELINE_TYPE.IF || blockCodeLineType === BLOCK_CODELINE_TYPE.WHILE
                || blockCodeLineType === BLOCK_CODELINE_TYPE.FOR || blockCodeLineType === BLOCK_CODELINE_TYPE.TRY) {
                return [];
            }

            var is = nextBlockList.some(block => {
                if (block.getDirection() === BLOCK_DIRECTION.INDENT) {
                    selectedBlock = block;
                    return true;
                }
            });
            if (is === true) {
                stack.push(selectedBlock);
            }
        }

        var childLowerDepthBlockList = [];

        var iteration = 0;
        var current;
        while (stack.length !== 0) {
            current = stack.shift();
            /** FIXME: 무한루프 체크 */
            if (iteration > NUM_MAX_ITERATION) {
                console.log('무한루프');
                break;
            }
            iteration++;
            /** 배열 일 때 */
            if (Array.isArray(current)) {
                var currBlockList = current;
                var tempList = [];
                currBlockList.forEach(block => {
                    tempList.push(block);
                });
                
                /** FIXME: 추후 private 함수로 따로 분화
                 *  block데이터를 배열에 담을때 INDENT 타입과 DOWN 타입의 위치 변경
                 *  DOWN 앞으로 INDENT 뒤로
                 */
                tempList = tempList.sort((a,b) => {
                    if (a.getDirection() === BLOCK_DIRECTION.INDENT) {
                        return 1;
                    } else {
                        return -1;
                    }
                });
                tempList.forEach(el => {
                    stack.unshift(el);
                });


            } else {
                var currBlock = current;
                var is = childLowerDepthBlockList.some(travelBlock => {
                    if (current.getUUID() === travelBlock.getUUID()) {
                        return true;
                    }
                });
                if(is === false) {
                    var blockCodeLineType = currBlock.getBlockCodeLineType();
                    if (blockCodeLineType === BLOCK_CODELINE_TYPE.CLASS || blockCodeLineType === BLOCK_CODELINE_TYPE.DEF
                        || blockCodeLineType === BLOCK_CODELINE_TYPE.IF || blockCodeLineType === BLOCK_CODELINE_TYPE.WHILE
                        || blockCodeLineType === BLOCK_CODELINE_TYPE.FOR || blockCodeLineType === BLOCK_CODELINE_TYPE.TRY) {
                        break;
                    }

                    childLowerDepthBlockList.push(currBlock);
                    var nextBlockList = currBlock.getNextBlockList();
                    stack.unshift(nextBlockList);
                }
            }
        }
        return childLowerDepthBlockList;
    }

    /**
     * @private
     * @param {Array<Block>} travelBlockList 
     * @param {Array<Block>} stack 
     */
    Block.prototype._getChildBlockList = function(travelBlockList, stack) {
        var iteration = 0;
        var current;
        while (stack.length !== 0) {
            current = stack.shift();
            /** FIXME: 무한루프 체크 */
            if (iteration > NUM_MAX_ITERATION) {
                console.log('무한루프');
                break;
            }
            iteration++;
            /** 배열 일 때 */
            if (Array.isArray(current)) {
                var currBlockList = current;
                var tempList = [];
                currBlockList.forEach(block => {
                    tempList.push(block);
                });
                
                /** FIXME: 추후 private 함수로 따로 분화
                 *  배열에서 INDENT 타입과 DOWN 타입의 위치 변경
                 *  DOWN 앞으로 INDENT 뒤로
                 */
                tempList = tempList.sort((a,b) => {
                    if (a.getDirection() === BLOCK_DIRECTION.INDENT) {
                        return 1;
                    } else {
                        return -1;
                    }
                });
                tempList.forEach(el => {
                    stack.unshift(el);
                });


            } else {
                var currBlock = current;
                var is = travelBlockList.some(travelBlock => {
                    if (current.getUUID() === travelBlock.getUUID()) {
                        return true;
                    }
                });
                if(is === false) {
                    travelBlockList.push(currBlock);
                    var nextBlockList = currBlock.getNextBlockList();
                    stack.unshift(nextBlockList);
                }
            }
        }
        return travelBlockList;
    }
    
    /** 생성할 블럭이 6뎁스를 초과 할 경우 alert창을 띄워 막음 */
    Block.prototype.alertExceedDepth = function() {
        this.renderEditorScrollTop();
        this.renderResetBottomOption();
        this.renderResetBottomLowerDepthChildsBlockOption();
        this.deleteBlockScope();
        $(VP_CLASS_NODEEDITOR_LEFT).find(VP_BLOCK).remove();
 
        vpCommon.renderAlertModal(STR_MSG_BLOCK_DEPTH_MUSH_NOT_EXCEED_6);
    }

    Block.prototype.appendBlock_old = function(appendedBlock, direction) {
        var depth = this.calculateDepthAndGet();

        /**
         * depth가 6초과할 경우 alert
        */
        if (depth >= NUM_EXCEED_DEPTH && direction === BLOCK_DIRECTION.INDENT) {
     
            appendedBlock.alertExceedDepth();
         
            return;
        }
        if (depth > NUM_EXCEED_DEPTH) {
 
            appendedBlock.alertExceedDepth();
            return;
        }

        var containerDom = appendedBlock.getContainerDom();
        $(containerDom).remove();
        
        appendedBlock.setDirection(direction);

        var prevBlock = appendedBlock.getPrevBlock();
        if ( prevBlock ) {
            var nextBlockList = prevBlock.getNextBlockList();
            nextBlockList.some(( nextBlock, index) => {
                if (nextBlock.getUUID() === appendedBlock.getUUID()) {
                    nextBlockList.splice(index, 1);
                    return true;
                }
            });
        }

        // 새로 들어온 block의 이전 블록을 현재 this블록으로 정함
        appendedBlock.setPrevBlock(this);
        var nextBlockList = this.getNextBlockList();
        if (direction === BLOCK_DIRECTION.DOWN) {
            // console.log('block direction down');

            if (nextBlockList.length !== 0) {
                var getChildBlockList = appendedBlock.getChildBlockList();
                getChildBlockList[getChildBlockList.length - 1].setNextBlockList([...nextBlockList]);
            }
    
            nextBlockList.forEach(block => {
                block.setPrevBlock(getChildBlockList[getChildBlockList.length - 1]);
                return true;          
            });
            this.setNextBlockList([appendedBlock]);  
        } else if (direction === BLOCK_DIRECTION.INDENT) {
            // console.log('block direction indent');

            nextBlockList.some((nextBlock, index ) => {
                if (nextBlock.getDirection() === direction) {
                    // 새로 들어온 block이 기존에 자리잡고 있던 블록을 자식으로 append
                    nextBlock.setDirection(BLOCK_DIRECTION.DOWN);
                  
                    if ( appendedBlock.getHolderBlock() === null) {
                        appendedBlock.addNextBlockList(nextBlock);
                    } else {
                        appendedBlock.getHolderBlock().addNextBlockList(nextBlock);
                    }
    
                    // 기존에 자리잡고 있던 블록이 새로 들어온 block에 밀려남
                    if ( appendedBlock.getHolderBlock() === null) {
                        nextBlock.setPrevBlock(appendedBlock);
                    } else {
                        nextBlock.setPrevBlock(appendedBlock.getHolderBlock());
                    }

                    nextBlockList.splice(index, 1);
                    return true;
                }
            });
            this.addNextBlockList(appendedBlock);  
        } else {
            // console.log('block direction 그 밖의');

            var currBlock = this.getRootBlock();
            var nextBlockList = currBlock.getNextBlockList();
            var iter = 0;
            while (nextBlockList.length !== 0) {
                if (iter > NUM_MAX_ITERATION) {
                    console.log('무한루프');
                    break;
                }
                iter++;

                var is = nextBlockList.some(block => {
                    if (block.getDirection() === BLOCK_DIRECTION.DOWN) {
                        currBlock = block;
                        return true;
                    } else {
                        return false;
                    }
        
                });

                if (is === true) {
                    nextBlockList = currBlock.getNextBlockList();
                } else {
                    break;
                }
            }
            currBlock.addNextBlockList(appendedBlock);  
            appendedBlock.setPrevBlock(currBlock);
        }

        var blockContainerThis = this.getBlockContainerThis();
        blockContainerThis.reRenderBlockList();

    }

    /** param으로 받아온 block을 this블럭의 자식으로 append. 
     *  FIXME: 대대적인 변경 필요
     *  @param {BLOCK} appendedBlock
     *  @param {BLOCK_DIRECTION} direction
     */
    Block.prototype.appendBlock = function(appendedBlock, direction) {
        // console.log('appendBlock');
        // console.log('------------------------------------');
        var depth = this.calculateDepthAndGet();

        /**
         * depth가 6초과할 경우 alert
        */
        if (depth >= NUM_EXCEED_DEPTH && direction === BLOCK_DIRECTION.INDENT) {
            // this.renderEditorScrollTop(true);
            appendedBlock.alertExceedDepth();
         
            return;
        }
        if (depth > NUM_EXCEED_DEPTH) {
            // this.renderEditorScrollTop(true);
            appendedBlock.alertExceedDepth();
            return;
        }

        var prevBlock = appendedBlock.getPrevBlock();
        if ( prevBlock ) {
            /** block을 내 위치에 다시 놓을 때 */
            if (prevBlock.getUUID() === this.getUUID()) {
                return;
            }

            var nextBlockList = prevBlock.getNextBlockList();
        
            nextBlockList.some(( nextBlock, index) => {
                if (nextBlock.getUUID() === appendedBlock.getUUID()) {
                    nextBlockList.splice(index, 1);
                    return true;
                }
            });
        }
        appendedBlock.getChildLowerDepthBlockList();
        var lastChildBlock = appendedBlock.getLastChildBlock();

        if (prevBlock) {
            // console.log('prevBlock', prevBlock.getBlockName());
        }
        if (lastChildBlock) {
            // console.log('lastChildBlock', lastChildBlock.getBlockName());
        }
        // console.log('appendedBlock', appendedBlock.getBlockName());
        // console.log('this Block', this.getBlockName());

        if (lastChildBlock !== null) {
            // console.log('lastChildBlock type', lastChildBlock, lastChildBlock.getBlockCodeLineType(),lastChildBlock.getBlockName());
        }
        // console.log('lastChildBlock',lastChildBlock);
        // console.log('lastChildBlock type', lastChildBlock.getBlockCodeLineType());

        // 새로 들어온 block의 이전 블록을 현재 this블록으로 정함
        appendedBlock.setPrevBlock(this);
        var nextBlockList = this.getNextBlockList();
        if (direction === BLOCK_DIRECTION.DOWN) {
            // console.log('block direction down');

            var nextLastChildBlock = null;
            // var lastChildBlock = appendedBlock.getLastChildBlock();

       
            if (lastChildBlock !== null && prevBlock !== null) {
                if (lastChildBlock.getUUID() === appendedBlock.getUUID()) {

                    lastChildBlock.getNextBlockList().some( (block,index) => {
                        if ( block.getDirection() === BLOCK_DIRECTION.DOWN) {
                            nextLastChildBlock = block;
    
                            nextLastChildBlock.setDirection( appendedBlock.getDirection() );
                            nextLastChildBlock.setPrevBlock(prevBlock);
                            prevBlock.addNextBlockList(nextLastChildBlock);
                            lastChildBlock.getNextBlockList().splice(index, 1);
                            return true;
                        }
                    });
                } else {
                    lastChildBlock.getNextBlockList().some( (block,index) => {
                        if ( block.getDirection() === BLOCK_DIRECTION.DOWN) {
                            nextLastChildBlock = block;
    
                            nextLastChildBlock.setDirection( appendedBlock.getDirection() );
                            nextLastChildBlock.setPrevBlock(prevBlock);
                            prevBlock.addNextBlockList(nextLastChildBlock);
                            lastChildBlock.getNextBlockList().splice(index, 1);
                            return true;
                        }
                    });
                }

            }

            if (lastChildBlock !== null) {
                if (nextBlockList.length !== 0) {
                    lastChildBlock.setNextBlockList([...nextBlockList]);
                }
        
                nextBlockList.forEach(block => {
                    block.setPrevBlock(lastChildBlock);
                    return true;          
                });
            }

            this.setNextBlockList([appendedBlock]);  

            // console.log('nextLastChildBlock', nextLastChildBlock);
        

        } else if (direction === BLOCK_DIRECTION.INDENT) {
            // console.log('block direction indent');

            var nextLastChildBlock = null;
            var lastChildBlock = appendedBlock.getLastChildBlock();
            if (lastChildBlock !== null && prevBlock !== null) {
                lastChildBlock.getNextBlockList().some( (block,index) => {
                    if ( block.getDirection() === BLOCK_DIRECTION.DOWN) {
                        nextLastChildBlock = block;
                        
                        nextLastChildBlock.setDirection( appendedBlock.getDirection() );
                        nextLastChildBlock.setPrevBlock(prevBlock);
                        prevBlock.addNextBlockList(nextLastChildBlock);
                        lastChildBlock.getNextBlockList().splice(index, 1);
                        return true;
                    }
                });
            }

            nextBlockList.some((nextBlock, index ) => {
                if (nextBlock.getDirection() === direction) {
                    // 새로 들어온 block이 기존에 자리잡고 있던 블록을 자식으로 append
                    nextBlock.setDirection(BLOCK_DIRECTION.DOWN);

                    lastChildBlock.addNextBlockList(nextBlock);
    
                    nextBlock.setPrevBlock(lastChildBlock);

                    nextBlockList.splice(index, 1);
                    return true;
                }
            });
            this.addNextBlockList(appendedBlock);
    
        } else {
            // console.log('block direction 그 밖의');

            var currBlock = this.getRootBlock();
            var nextBlockList = currBlock.getNextBlockList();
            var iter = 0;
            while (nextBlockList.length !== 0) {
                if (iter > NUM_MAX_ITERATION) {
                    console.log('무한루프');
                    break;
                }
                iter++;

                var is = nextBlockList.some(block => {
                    if (block.getDirection() === BLOCK_DIRECTION.DOWN) {
                        currBlock = block;
                        return true;
                    } else {
                        return false;
                    }
        
                });

                if (is === true) {
                    nextBlockList = currBlock.getNextBlockList();
                } else {
                    break;
                }
            }
            currBlock.addNextBlockList(appendedBlock);  
            appendedBlock.setPrevBlock(currBlock);
        }

        var blockContainerThis = this.getBlockContainerThis();
        blockContainerThis.reRenderBlockList();

        var containerDom = appendedBlock.getContainerDom();
        $(containerDom).remove();
        
        appendedBlock.setDirection(direction);
    }

    Block.prototype.splitBlockList = function() {
        var currBlock = this;
        var rootToChildBlockList = this.getRootToChildBlockList();
        var splitBlockListIndex = 0;

        rootToChildBlockList.some((block, index) => {
            if (block.getUUID() === currBlock.getUUID()) {
                splitBlockListIndex = index;
                return true;
            }
        });
        
        var beforeBlockList = rootToChildBlockList.slice(0, splitBlockListIndex);
        var afterBlockList = rootToChildBlockList.slice(splitBlockListIndex, rootToChildBlockList.length);

        return {
            beforeBlockList
            , afterBlockList
            , splitBlockListIndex
        };
    }

    /**shadow block을 get */
    Block.prototype.getShadowBlock = function() {
        return this.shadowBlock;
    }
    /**
     * shadow block을 set 
     * @param {BLOCK} shadowBlock
     */
    Block.prototype.setShadowBlock = function(shadowBlock) {
        this.shadowBlock = shadowBlock;
    }

    /** 자식 블럭 리스트들 모두 제거 */
    Block.prototype.deleteBlock = function() {
        var blockContainerThis = this.getBlockContainerThis();

        /** 렌더링된 mainDom 삭제 제거 */
        var mainDom = this.getBlockMainDom();
        $(mainDom).remove();
        $(mainDom).empty();

        /** 부모 에서 this를 제거  */
        var prevBlock = this.getPrevBlock();
        if ( prevBlock ) {
            var nextBlockDataList = prevBlock.getNextBlockList();
            nextBlockDataList.some(( nextBlock, index) => {
                if (nextBlock.getUUID() === this.getUUID()) {
                    nextBlockDataList.splice(index, 1);
                    return true;
                }
            });
        }

        /**  */
        var thisNextBlockDataList = this.getNextBlockList();
        var stack = [];
        
        if (thisNextBlockDataList.length !== 0) {
            stack.push(thisNextBlockDataList);
        }


        var iteration = 0;
        var current;
        while (stack.length !== 0) {
            /** FIXME: 무한루프 체크 */
            if (iteration > NUM_MAX_ITERATION) {
                console.log('무한루프');
                break;
            }
            
            current = stack.pop();
            /** 배열 일 때 */
            if (Array.isArray(current)) {
                current.forEach(element => {
                    stack.push(element);
                });
            } else {
                current.deleteBlock();
            }
        }

        if ( prevBlock ) {
            var type = prevBlock.getBlockCodeLineType();
            if (type === BLOCK_CODELINE_TYPE.CLASS || type === BLOCK_CODELINE_TYPE.DEF || type === BLOCK_CODELINE_TYPE.IF ||
                type === BLOCK_CODELINE_TYPE.FOR || type === BLOCK_CODELINE_TYPE.WHILE || type === BLOCK_CODELINE_TYPE.TRY
                || type === BLOCK_CODELINE_TYPE.ELSE || type === BLOCK_CODELINE_TYPE.ELIF || type === BLOCK_CODELINE_TYPE.FOR_ELSE 
                || type === BLOCK_CODELINE_TYPE.EXCEPT || type === BLOCK_CODELINE_TYPE.FINALLY) {

                $(prevBlock.getRootBlock().getContainerDom()).append(prevBlock.getHolderBlock().getBlockMainDom());
            }
        }


        /** blockContainer에서 block 데이터 삭제 제거 */
        var blockUuid = this.getUUID(); 
        blockContainerThis.deleteBlock(blockUuid);
        blockContainerThis.reRenderBlockList();
        blockContainerThis.renderBlockLeftHolderListHeight();

        /** containerDom 삭제 */
        var containerDom = this.getContainerDom();
        $(containerDom).remove();
        $(containerDom).empty();
        
    }

    Block.prototype.deleteBlockScope = function(isFirst) {
        var that = this;
        var blockContainerThis = this.getBlockContainerThis();
        var thisNextBlockList = this.getNextBlockList();
        var blockCodeLineType = this.getBlockCodeLineType() 
        /** CODE IMPORT PASS CONTINUE PROPERTY BREAK RETURN... */
        if ( blockCodeLineType === BLOCK_CODELINE_TYPE.CODE || blockCodeLineType === BLOCK_CODELINE_TYPE.IMPORT ||
             blockCodeLineType === BLOCK_CODELINE_TYPE.PASS || blockCodeLineType === BLOCK_CODELINE_TYPE.CONTINUE || 
             blockCodeLineType === BLOCK_CODELINE_TYPE.PROPERTY || blockCodeLineType === BLOCK_CODELINE_TYPE.BREAK || 
             blockCodeLineType === BLOCK_CODELINE_TYPE.RETURN ||
             blockCodeLineType === BLOCK_CODELINE_TYPE.PASS_SUB || blockCodeLineType === BLOCK_CODELINE_TYPE.RETURN_SUB
            ) {
            
            if ( this.getRootBlock().getUUID() === this.getUUID()) {
                this.deleteBlock();
                return;
            }

            if (that.getDirection() === BLOCK_DIRECTION.INDENT 
                && (that.getPrevBlock().getDirection() === BLOCK_DIRECTION.DOWN 
                    || that.getPrevBlock().getDirection() === BLOCK_DIRECTION.ROOT)) {
                this.deleteBlockOne(BLOCK_DIRECTION.INDENT);
            } else {
                this.deleteBlockOne();
            }
         
            this.calculateDepthFromRootBlockAndSetDepth();
            return;
        }

        /** CLASS DEF IF FOR TRY... */
        var direction = this.getDirection();
        var prevBlock = this.getPrevBlock();
        if (this.getHolderBlock() && prevBlock !== null && direction === BLOCK_DIRECTION.INDENT) {
            var downBlock = null;
            var is = this.getHolderBlock().getNextBlockList().some(block => {
                if (block.getDirection() === BLOCK_DIRECTION.DOWN) {
                    downBlock = block;
                    return true;
                }
            });
            if(is === true) {
                prevBlock.appendBlock(downBlock, BLOCK_DIRECTION.INDENT);
            }
        }

        if (thisNextBlockList.length === 0) {
            this.deleteBlock();

        } else if (thisNextBlockList.length !== 0) {
            var selectedBlock = null;
            var is = thisNextBlockList.some(block => {
                if (block.getDirection() === BLOCK_DIRECTION.INDENT) {
                    selectedBlock = block;
                    return true;
                }
            });
            if (is === true) {
                if (that.getPrevBlock() === null) {
                    this.deleteBlock();
                    return;
                }
                selectedBlock.untactBlock();
                selectedBlock.deleteBlock();
                this.deleteBlockOne();
                this.getHolderBlock().deleteBlockOne();
            } else {
                if (this.getPrevBlock() === null) {
                    this.deleteBlock();
                } else {
                    this.deleteBlockOne();
                    this.getHolderBlock().deleteBlockOne();
                }
            }
        }
        this.calculateDepthFromRootBlockAndSetDepth();
    }

    /**
     * 하위 depth block들을 지운다
     */
    Block.prototype.deleteLowerDepthChildBlocks = function() {
        var that = this;
        var blockContainerThis = this.getBlockContainerThis();


        /** FIXME: 추후 변경
         *  만약 root 블럭일 경우 */
        if ( this.getRootBlock().getUUID() === this.getUUID()) {
            // var rootBlockList = blockContainerThis.getRootBlockList();
            var rootBlock = this.getRootBlock();

            if (that) {
     
                that.deleteBlock();
                that.renderResetBottomOption();

                blockContainerThis.setFocusedPageTypeAndRender(FOCUSED_PAGE_TYPE.EDITOR);
                blockContainerThis.setBlockList([]);
         
            }

            return;
        }

        var prevBlock = this.getPrevBlock();
        if ( prevBlock ) {
            var nextBlockDataList = prevBlock.getNextBlockList();
            nextBlockDataList.some(( nextBlockBlock, index) => {
                if (nextBlockBlock.getUUID() === this.getUUID()) {
                    nextBlockDataList.splice(index, 1)
                    return true;
                }
            });
        }

        var deletedBlockDirection = this.getDirection();
        this.getChildLowerDepthBlockList();

        var lastChildBlock = this.getLastChildBlock();
        var nextBlockList = lastChildBlock.getNextBlockList();
        nextBlockList.some(nextBlock => {
            if (nextBlock) {
                nextBlock.setDirection(deletedBlockDirection);

                prevBlock.addNextBlockList(nextBlock);
                nextBlock.setPrevBlock(prevBlock);
                return true;
            }
        });

        this._deleteBlockDomAndData();
        this.calculateDepthFromRootBlockAndSetDepth();
    }

    /** TEST: 한개의 블럭만 제거 */
    Block.prototype.deleteBlockOne = function(deletedDirection) {
            
        var prevBlock = this.getPrevBlock();
        if ( prevBlock ) {
            var nextBlockDataList = prevBlock.getNextBlockList();
            nextBlockDataList.some(( nextBlockBlock, index) => {
                if (nextBlockBlock.getUUID() === this.getUUID()) {
                    nextBlockDataList.splice(index, 1)
                    return true;
                }
            });
        }
        
        /**  */
        var thisNextBlockList = this.getNextBlockList();
        thisNextBlockList.forEach((block,index) => {
            if (prevBlock) {
                block.setPrevBlock(prevBlock);
                if (deletedDirection) {
                    prevBlock.appendBlock(block, deletedDirection);
                } else {
                    prevBlock.appendBlock(block, block.getDirection());
                }
                prevBlock = block;
            } 
        });
        
        this.setNextBlockList([]);
        var mainDom = this.getBlockMainDom();
        $(mainDom).remove();
        $(mainDom).empty();

        /** containerDom 삭제 */
        var containerDom = this.getContainerDom();
        $(containerDom).remove();
        $(containerDom).empty();

        /** blockContainer에서 block 데이터 삭제 제거 */
        var blockUuid = this.getUUID(); 
        var blockContainerThis = this.getBlockContainerThis();
        blockContainerThis.deleteBlock(blockUuid);
    }
    
    Block.prototype._deleteBlockDomAndData = function() {
        var mainDom = this.getBlockMainDom();
        $(mainDom).remove();
        $(mainDom).empty();

        /** containerDom 삭제 */
        var containerDom = this.getContainerDom();
        $(containerDom).remove();
        $(containerDom).empty();

        /** blockContainer에서 block 데이터 삭제 제거 */
        var blockUuid = this.getUUID(); 
        var blockContainerThis = this.getBlockContainerThis();
        blockContainerThis.deleteBlock(blockUuid);
    }
    // ** --------------------------- Block dom 관련 메소드들 --------------------------- */

    Block.prototype.getBlockMainDom = function() {
        return this.rootDom;
    }
    Block.prototype.setBlockDom = function(rootDom) {
        this.rootDom = rootDom;
    }
    Block.prototype.getBlockInnerDom = function() {
        return this.rootInnerDom;
    }
    Block.prototype.setBlockInnerDom = function(rootInnerDom) {
        this.rootInnerDom = rootInnerDom;
    }
    Block.prototype.getBlockHeaderDom = function() {
        return this.rootHeaderDom;
    }
    Block.prototype.setBlockHeaderDom = function(rootHeaderDom) {
        this.rootHeaderDom = rootHeaderDom;
    }

    Block.prototype.getContainerDom = function() {
        return this.containerDom;
    }
    Block.prototype.setContainerDom = function(containerDom) {
        this.containerDom = containerDom;
    }
    Block.prototype.setBlockLeftHolderDom = function(blockLeftHolderDom) {
        this.blockLeftHolderDom = blockLeftHolderDom;
    }
    Block.prototype.getBlockLeftHolderDom = function() {
        return this.blockLeftHolderDom;
    }

    Block.prototype.reArrangeChildBlockDomList = function(arrangedBlock, rootBlockChildBlockListExceptChildBlock, direction) {
        var rootBlock = this.getRootBlock();

        var blockList = [];
        if (rootBlockChildBlockListExceptChildBlock === undefined) {
            blockList = rootBlock.getChildBlockList();
        } else {
            blockList = rootBlockChildBlockListExceptChildBlock;
        }

        if (arrangedBlock === undefined) {
            return;
        }
        
        var containerDom = rootBlock.getContainerDom();
        var childDomList = containerDom.childNodes;
        var shadowDom;

        // var shadowIndex = 0;
        childDomList.forEach(( childDom,index) => {
            if ( parseInt( $(childDom).attr(STR_DATA_NUM_ID) ) === -1) {
                shadowDom = childDom;
                return true;
            }
        });


        blockList.some((childBlock, index) => {
            if (childBlock.getUUID() === arrangedBlock.getUUID()) {
                if ( parseInt( $(childBlock.getBlockMainDom().nextSibling).attr(STR_DATA_NUM_ID) )  === -1 ){
                    return true;
                }

                var indentPxNum = 0;
                var depth = parseInt( $(childBlock.getBlockMainDom()).attr(STR_DATA_DEPTH_ID) );
        
                if (isNaN(depth)){

                } else {
    
                    while (depth-- !== 0) {
                        indentPxNum += NUM_INDENT_DEPTH_PX;
                    }
                }

                if (direction === BLOCK_DIRECTION.INDENT) {
                    indentPxNum += NUM_INDENT_DEPTH_PX;
                }
                $(shadowDom).css(STR_MARGIN_LEFT, `${indentPxNum}${STR_PX}`);

                containerDom.insertBefore(shadowDom, childBlock.getBlockMainDom().nextSibling);
                return true;
            }
        });
    }

    Block.prototype._makeChildBlockDomList = function(getChildBlockList) {
    
        var childBlockDomList = [];
        var rootDepth = 0;
        getChildBlockList.forEach((block, index) => {
         
            var depth = block.calculateDepthAndGet();

            /** depth 계산 */
            var _depth = depth;
            var indentPxNum = 0;
            while (_depth-- !== 0) {
                indentPxNum += NUM_INDENT_DEPTH_PX;
            }
            indentPxNum -= rootDepth * NUM_INDENT_DEPTH_PX;

            /** index 0은 건너뛴다 */
            if (index === 0) {
                rootDepth = depth;
                return;
            } else {
                // var blockWidth = block.getWidth();

                // var rect = $(`.vp-block-${block.getUUID()}`)[0].getBoundingClientRect();

                var mainDom = document.createElement(STR_DIV);
                mainDom.classList.add('vp-block');
                mainDom.classList.add(`vp-block-${block.getUUID()}`);
                var rect = $(`.vp-block-${block.getUUID()}`)[0].getBoundingClientRect();
                // $(mainDom).css(STR_WIDTH,blockWidth);

                // console.log('rect.width', rect.width);
                $(mainDom).css(STR_WIDTH, rect.width);
            

                var mainInnerDom = renderMainInnerDom();
                var mainHeaderDom = renderMainHeaderDom(block);

                $(mainInnerDom).append(mainHeaderDom);
                $(mainDom).append(mainInnerDom);
        
                var backColor = '';
                if (block.getBlockCodeLineType() === BLOCK_CODELINE_TYPE.CLASS 
                    || block.getBlockCodeLineType() === BLOCK_CODELINE_TYPE.DEF
                    || block.getBlockCodeLineType() === BLOCK_CODELINE_TYPE.RETURN_SUB) {
                    backColor = `${COLOR_ORANGE}`;
                    $(mainDom).addClass(VP_BLOCK_CLASS_DEF);

                } else if ( block.getBlockCodeLineType() === BLOCK_CODELINE_TYPE.IF 
                    || block.getBlockCodeLineType() === BLOCK_CODELINE_TYPE.FOR
                    || block.getBlockCodeLineType() === BLOCK_CODELINE_TYPE.WHILE 
                    || block.getBlockCodeLineType() === BLOCK_CODELINE_TYPE.TRY
                    || block.getBlockCodeLineType() === BLOCK_CODELINE_TYPE.ELSE 
                    || block.getBlockCodeLineType() === BLOCK_CODELINE_TYPE.ELIF
                    || block.getBlockCodeLineType() === BLOCK_CODELINE_TYPE.FOR_ELSE 
                    || block.getBlockCodeLineType() === BLOCK_CODELINE_TYPE.EXCEPT 
                    || block.getBlockCodeLineType() === BLOCK_CODELINE_TYPE.FINALLY
                    || block.getBlockCodeLineType() === BLOCK_CODELINE_TYPE.PASS_SUB  ) {
                    backColor = `${COLOR_BLOCK_YELLOW}`;
                    $(mainDom).addClass(VP_BLOCK_CONTROL);

                } else if ( block.getBlockCodeLineType() === BLOCK_CODELINE_TYPE.RETURN 
                    || block.getBlockCodeLineType() === BLOCK_CODELINE_TYPE.PROPERTY
                    || block.getBlockCodeLineType() === BLOCK_CODELINE_TYPE.BREAK 
                    || block.getBlockCodeLineType() === BLOCK_CODELINE_TYPE.CONTINUE
                    || block.getBlockCodeLineType() === BLOCK_CODELINE_TYPE.PASS
                    || block.getBlockCodeLineType() === BLOCK_CODELINE_TYPE.CODE ) {
                    backColor = `${COLOR_SKY_BLUE}`;
                }

                var currBlock = block;
                mainDom = currBlock.renderBlockLeftHolderDom(mainDom);

                if (block.getBlockCodeLineType() === BLOCK_CODELINE_TYPE.HOLDER) {
                    $(mainDom).addClass(VP_CLASS_BLOCK_BOTTOM_HOLDER);
                    $(mainDom).css(STR_MARGIN_TOP, `0px`);
                    $(mainDom).css(STR_OPACITY, '10');

                    if (block.getSupportingBlock().getBlockCodeLineType() === BLOCK_CODELINE_TYPE.CLASS
                        || block.getSupportingBlock().getBlockCodeLineType() === BLOCK_CODELINE_TYPE.DEF) {
                        $(mainDom).css(STR_BACKGROUND_COLOR,`${COLOR_ORANGE}`);
                    } else {
                        $(mainDom).css(STR_BACKGROUND_COLOR,`${COLOR_BLOCK_YELLOW}`);
                    }
                }

                $(mainDom).css(STR_MARGIN_LEFT, `${indentPxNum}${STR_PX}`);
                childBlockDomList.push(mainDom);
            }
            block.calculateWidthAndSet();
        });

        return childBlockDomList;
    }

    /** 현재 root 블럭부터 하위 depth 자식 블럭리스트 들을 전부 가져오고,
     *  가져온 block들의 정보를 가지고 html dom을 만들어 return 한다. 
     */
    Block.prototype.makeChildBlockDomList = function() {
        var getChildBlockList = this.getChildBlockList();
        var childBlockDomList = this._makeChildBlockDomList(getChildBlockList);
        return childBlockDomList;
    }

    /** 현재 root 블럭부터 하위 depth 자식 블럭리스트(동일 depth 블럭 제거) 들을 전부 가져오고,
     *  가져온 block들의 정보를 가지고 html dom을 만들어 return 한다. 
     */
    Block.prototype.makeChildLowerDepthBlockDomList = function() {
        var getChildBlockList = this.getChildLowerDepthBlockList();
        var childBlockDomList = this._makeChildBlockDomList(getChildBlockList);
        return childBlockDomList;
    }

    /** block main dom의 width, height 값을 가져온다 */
    Block.prototype.getBlockMainDomPosition = function() {
        var mainDom = this.getBlockMainDom();
        var clientRect = $(mainDom)[0].getBoundingClientRect();
        return clientRect;
    }

    // ** --------------------------- Block 멤버변수의 set, get 관련 메소드들 --------------------------- */
    Block.prototype.setDepth = function(depth) {
        this.setState({
            tempDepth: depth
        })
    }

    Block.prototype.getDepth = function() {
        return this.state.tempDepth;
    }
    
    Block.prototype.setPointX = function(pointX) {
        this.setState({
            pointX
        });
    }
    Block.prototype.setPointY = function(pointY) {
        this.setState({
            pointY
        });
    }
    Block.prototype.getPointX = function() {
        return this.state.pointX;
    }
    Block.prototype.getPointY = function() {
        return this.state.pointY;
    }
    Block.prototype.setContainerPointX = function(containerPointX) {
        this.setState({
            containerPointX
        });
    }
    Block.prototype.setContainerPointY = function(containerPointY) {
        this.setState({
            containerPointY
        });
    }
    Block.prototype.getContainerPointX = function() {
        return this.state.containerPointX;
    }
    Block.prototype.getContainerPointY = function() {
        return this.state.containerPointY;
    }



    Block.prototype.getBlockCodeLineType = function() {
        return this.state.type;
    }
    Block.prototype.setType = function(type) {
        this.setState({
            type
        });
    }
    Block.prototype.getBlockName = function() {
        return this.state.blockName;
    }
    Block.prototype.setBlockName = function(blockName) {
        this.setState({
            blockName
        });
    }
    Block.prototype.getUUID = function() {
        return this.state.uuid;
    }

    /**
     * @param {ENUM} direction INDENT OR DOWN
     */
    Block.prototype.setDirection = function(direction) {
        this.setState({
            direction
        })
    }
    Block.prototype.getDirection = function() {
        return this.state.direction;
    }

    Block.prototype.getBlockContainerThis = function() {
        return this.blockContainerThis;
    }

    /**
     *  순간 순간 임시로 변하는 left holder height
     */
    Block.prototype.getTempBlockLeftHolderHeight = function() {
        // this.calculateLeftHolderHeightAndSet();
        return this.state.tempBlockLeftHolderHeight;
    }
    Block.prototype.setTempBlockLeftHolderHeight = function(tempBlockLeftHolderHeight) {
        this.setState({
            tempBlockLeftHolderHeight
        });
    }

    /**
     * block이 충돌이 되었는지 안 되었는지 표시하는 함수
     */
    Block.prototype.getIsCollision = function() {
        return this.state.isCollision;
    }
    Block.prototype.setIsCollision = function(isCollision) {
        this.setState({
            isCollision
        });
    }

    Block.prototype.setIsClicked = function(isClicked) {
        this.setState({
            isClicked
        });
    }

    Block.prototype.getIsClicked = function() {
        return this.state.isClicked;
    }

    Block.prototype.getIsCtrlPressed = function() {
        return this.state.isCtrlPressed;
    }
    Block.prototype.setIsCtrlPressed = function(isCtrlPressed) {
        this.setState({
            isCtrlPressed
        });
    }

    Block.prototype.getIsMoved = function() {
        return this.state.isMoved;
    }
    Block.prototype.setIsMoved = function(isMoved) {
        this.setState({
            isMoved
        });
    }

    Block.prototype.getIsLowerDepthChild = function() {
        return this.state.isLowerDepthChild;
    }
    Block.prototype.setIsLowerDepthChild = function(isLowerDepthChild) {
        this.setState({
            isLowerDepthChild
        });
    }

    Block.prototype.setIsDraggable = function(isDraggable) {
        this.setState({
            isDraggable
        });
    }
    Block.prototype.getIsDraggable = function() {
        return this.state.isDraggable;
    }

    /**  variableIndex을 set, get  */
    Block.prototype.setVariableIndex = function(variableIndex) {
        this.setState({
            variableIndex
        });
    }
    Block.prototype.getVariableIndex = function() {
        return this.state.variableIndex;
    }
    Block.prototype.addVariableIndex = function() {
        this.state.variableIndex++
        return this.state.variableIndex;
    }

    Block.prototype.setCodeLineAndGet = function(indentString) {
        var thisBlock = this;
        var codeLine = STR_NULL;
        var blockName = this.getBlockName();

        if (indentString === undefined) {
            indentString = '';
        } 

        codeLine += indentString;

        var type = thisBlock.getBlockCodeLineType();
        switch (type) {
            case BLOCK_CODELINE_TYPE.CLASS: {
                codeLine += `${blockName.toLowerCase()} `;
                codeLine += thisBlock.getState(STATE_className);
                codeLine += generateClassInParamList(thisBlock);

                break;
            }
            case BLOCK_CODELINE_TYPE.DEF: {
                codeLine += `${blockName.toLowerCase()} `;
                codeLine += thisBlock.getState(STATE_defName);
                codeLine += generateDefInParamList(thisBlock);
            
                break;
            }
            case BLOCK_CODELINE_TYPE.IF: {
                codeLine += `${blockName.toLowerCase()} `;
                // codeLine += thisBlock.getState(STATE_ifCodeLine);
                codeLine += generateIfConditionList(thisBlock);
                codeLine += `:`;
                break;
            }
            case BLOCK_CODELINE_TYPE.FOR: {
                codeLine += `${blockName.toLowerCase()} `;
                codeLine += thisBlock.getState(STATE_forCodeLine);
                codeLine += `:`;
                break;
            }
            case BLOCK_CODELINE_TYPE.WHILE: {
                codeLine += `${blockName.toLowerCase()} `;
                codeLine += thisBlock.getState(STATE_whileCodeLine);
                codeLine += `:`;
                break;
            }
            /** import */
            case BLOCK_CODELINE_TYPE.IMPORT: {
                var baseImportList = thisBlock.getState(STATE_baseImportList).filter(baseImport => {
                    if ( baseImport.isImport === true) {
                        return true;
                    } else {
                        return false;
                    }
                });
                var customImportList = thisBlock.getState(STATE_customImportList).filter(customImport => {
                    if ( customImport.isImport === true) {
                        return true;
                    } else {
                        return false;
                    }
                });

                var lineNum = 0;
                baseImportList.forEach((baseImport,index) => {
          
                    if (lineNum > 0) {
                        codeLine += indentString;
                    } 
              
                    codeLine += `${blockName.toLowerCase()} ${baseImport.baseImportName} as ${baseImport.baseAcronyms}`;
                    if (index !== baseImportList.length - 1) {
                        codeLine += `\n`;
                    }
                    lineNum++;
                });

                customImportList.forEach((customImport,index ) => {
                    if (lineNum > 0) {
                        codeLine += indentString;
                    } 

                    codeLine += `${blockName.toLowerCase()} ${customImport.baseImportName} as ${customImport.baseAcronyms}`;
                    if (index !== customImportList.length - 1) {
                        codeLine += `\n`;
                    }
                    lineNum++;
                });
                break;
            }
            /** api */
            case BLOCK_CODELINE_TYPE.API: {
                break;
            }
            /** try */
            case BLOCK_CODELINE_TYPE.TRY: {
                codeLine += `${blockName.toLowerCase()}:`;
                break;
            }
            /** return */
            case BLOCK_CODELINE_TYPE.RETURN: {
                codeLine += `${blockName.toLowerCase()} `;
                codeLine += generateReturnOutParamList(thisBlock);

                break;
            }
            case BLOCK_CODELINE_TYPE.RETURN_SUB: {
                codeLine += `${blockName.toLowerCase()} `;
                codeLine += generateReturnOutParamList(thisBlock);

                break;
            }
            /** break */
            case BLOCK_CODELINE_TYPE.BREAK: {
                codeLine += `${thisBlock.getState(STATE_breakCodeLine)} `;
                break;
            }
            /** continue */
            case BLOCK_CODELINE_TYPE.CONTINUE: {
                codeLine += `${thisBlock.getState(STATE_continueCodeLine)} `;
                break;
            }
            /** pass */
            case BLOCK_CODELINE_TYPE.PASS: {
                codeLine += `${thisBlock.getState(STATE_passCodeLine)} `;
                break;
            }
            case BLOCK_CODELINE_TYPE.PASS_SUB: {
                codeLine += `${thisBlock.getState(STATE_passCodeLine)} `;
                break;
            }
            /** elif */
            case BLOCK_CODELINE_TYPE.ELIF: {
                codeLine += `${blockName.toLowerCase()}`;
                codeLine += STR_ONE_SPACE;
                codeLine += thisBlock.getState(STATE_elifCodeLine);
                codeLine += `:`;
                break;
            }
            /** else */
            case BLOCK_CODELINE_TYPE.ELSE: {
                codeLine += `${blockName.toLowerCase()}:`;
                break;
            }
            /** for else */
            case BLOCK_CODELINE_TYPE.FOR_ELSE: {
                codeLine += `${blockName.toLowerCase()}:`;
                break;
            }
            /** init */
            case BLOCK_CODELINE_TYPE.INIT: {
                codeLine += `${blockName.toLowerCase()} `;
                break;
            }
            /** del */
            case BLOCK_CODELINE_TYPE.DEL: {
                codeLine += `${blockName.toLowerCase()} `;
                break;
            }
            /** except */
            case BLOCK_CODELINE_TYPE.EXCEPT: {
                codeLine += `${blockName.toLowerCase()}`;
                codeLine += STR_ONE_SPACE;
                codeLine += thisBlock.getState(STATE_exceptCodeLine);
                codeLine += `:`;
                break;
            }
            /** finally */
            case BLOCK_CODELINE_TYPE.FINALLY: {
                codeLine += `${blockName.toLowerCase()}:`;
                break;
            }
            /** code */
            case BLOCK_CODELINE_TYPE.CODE: {
                codeLine += thisBlock.getState(STATE_customCodeLine);
                break;
            }
            case BLOCK_CODELINE_TYPE.PROPERTY: {
                codeLine += thisBlock.getState(STATE_propertyCodeLine);
                break;
            }
        }
        this.state.codeLine = codeLine;
        return codeLine;
    }
    Block.prototype.getCodeLine = function() {
        return this.state.codeLine;
    }

    /**
     * block의 depth를 계산하고 depth 를 가져오는 함수
     */
    Block.prototype.calculateDepthAndGet = function() {
        var depth = 0;
        var currBlock = this;
        var direction = this.getDirection();

        if (direction === BLOCK_DIRECTION.INDENT) {
            var iteration = 0;
            var prevBlock = currBlock;
            while (prevBlock.getPrevBlock() !== null) {
                prevBlock = prevBlock.getPrevBlock();
                if (iteration > NUM_MAX_ITERATION) {
                    console.log('무한루프');
                    break;
                }
                iteration++;
                if (prevBlock.getDirection() === BLOCK_DIRECTION.DOWN ) {
    
                } else {
                    depth++;
                }
            }
        } else {
            var iteration = 0;
            var prevBlock = currBlock;
            while (prevBlock.getPrevBlock() !== null) {
                prevBlock = prevBlock.getPrevBlock();
                if (iteration > NUM_MAX_ITERATION) {
                    console.log('무한루프');
                    break;
                }
                iteration++;
                if (prevBlock.getDirection() === BLOCK_DIRECTION.INDENT) {
                    depth++;
                } else {
    
                }
            }
        }
        return depth;
    }

    /**
     * block의 depth를 계산하고 block 앞에 depth 를 보여주는 함수
     */
    Block.prototype.calculateDepthFromRootBlockAndSetDepth = function() {
        var rootBlock = this.getRootBlock();
        var getChildBlockList = rootBlock.getChildBlockList();

        getChildBlockList.forEach((block, index) => {
            if (block.getBlockCodeLineType() === BLOCK_CODELINE_TYPE.HOLDER) {
                return;
            }
      
            var depth = block.calculateDepthAndGet();
            block.setDepth(depth);

            var mainDom = block.getBlockMainDom();
            $(mainDom).find(VP_CLASS_BLOCK_DEPTH_INFO).remove();
            $(mainDom).append(`<span class='vp-block-depth-info'>${depth}</span>`);
        });
    }

    /**
     * block의 left holder의 height를 계산하고 height를 set
     */
    Block.prototype.calculateLeftHolderHeightAndSet = function() {
        var blockCodeLineType = this.getBlockCodeLineType();
        var blockHeight = 0;
        if (blockCodeLineType === BLOCK_CODELINE_TYPE.CLASS 
            || blockCodeLineType === BLOCK_CODELINE_TYPE.DEF) {
            blockHeight += 10;
        }

        var childBlockList = this.getChildLowerDepthBlockList();
        childBlockList.forEach(childBlock => {
            var mainDom = childBlock.getBlockMainDom();
            var rect = $(mainDom)[0].getBoundingClientRect();
            blockHeight += rect.height;
        });

        this.setTempBlockLeftHolderHeight(blockHeight);
    }

    /** FIXME: width 계산 다시 점검해야 함. width 값이 Block 이동시 달라지는 에러 발생
     * block의 width를 계산하고 width를 set
     */
    Block.prototype.calculateWidthAndSet = function() {
        /** block 전체의 width */
        var blockCodeLineType = this.getBlockCodeLineType();
        var blockDom = this.getBlockMainDom();

        var rect = $(blockDom)[0].getBoundingClientRect();
        // var width = rect.width;
        // console.log('width', width);
        // this.setWidth(width);

        // var rect = $(blockDom).find('.vp-block-header')[0].getBoundingClientRect();
        var depth = this.getDepth();
        // console.log('depth', depth);
        var indentNum = 0;
        while (depth-- !== 0) {
            indentNum += NUM_INDENT_DEPTH_PX;
        }

        // var width = rect.width - indentNum;
        //    var blockWidth = that.getWidth();

        // $(blockDom).css(STR_WIDTH, rect.width);

        // console.log('width', width);
    
        // this.setWidth(width);

        /** block codeLine의 width */
        if (blockCodeLineType === BLOCK_CODELINE_TYPE.HOLDER || blockCodeLineType === BLOCK_CODELINE_TYPE.PASS 
            || blockCodeLineType === BLOCK_CODELINE_TYPE.CONTINUE || blockCodeLineType === BLOCK_CODELINE_TYPE.BREAK 
            || blockCodeLineType === BLOCK_CODELINE_TYPE.CODE  || blockCodeLineType === BLOCK_CODELINE_TYPE.PROPERTY
            || blockCodeLineType === BLOCK_CODELINE_TYPE.PASS_SUB) {
            var blockHeaderDom = this.getBlockHeaderDom();
            var blockHeaderDomRect = $(blockHeaderDom)[0].getBoundingClientRect();
            var blockHeaderWidth = blockHeaderDomRect.width;
            this.setBlockHeaderWidth(blockHeaderWidth);
        } else {
            var blockHeaderDom = this.getBlockHeaderDom();
            var blockHeaderDomRect = $(blockHeaderDom)[0].getBoundingClientRect();
            var blockHeaderWidth = blockHeaderDomRect.width;
            this.setBlockHeaderWidth(blockHeaderWidth);

            var blockNameRect = $(this.getBlockMainDom()).find('.vp-block-inner').find('.vp-block-header').find('.vp-block-name')[0].getBoundingClientRect();
            var blockNameRectWidth = blockNameRect.width;
            var blockCodeLineWidth = blockHeaderWidth - blockNameRectWidth - NUM_CODELINE_LEFT_MARGIN_PX;
            this.setBlockCodeLineWidth(blockCodeLineWidth);
        }
    }

    /**
     * block의 width를 set, get
     */
    Block.prototype.getWidth = function() {
        return this.state.width;
    }
    Block.prototype.setWidth = function(width) {
        this.setState({
            width
        });
    }

    /**
     * block의 blockHeaderWidth를 set, get
     */
    Block.prototype.getBlockHeaderWidth = function() {
        return this.state.blockHeaderWidth;
    }
    Block.prototype.setBlockHeaderWidth = function(blockHeaderWidth) {
        this.setState({
            blockHeaderWidth
        });
    }

    /**
     * block의 blockCodeLineWidth를 set, get
     */
    Block.prototype.getBlockCodeLineWidth = function() {
        return this.state.blockCodeLineWidth;
    }
    Block.prototype.setBlockCodeLineWidth = function(blockCodeLineWidth) {
        this.setState({
            blockCodeLineWidth
        });
    }

    Block.prototype.setBlockNumber = function(blockNumber) {
        this.blockNumber = blockNumber;
    }
    Block.prototype.getBlockNumber = function() {
        return this.blockNumber;
    }
    // ** --------------------------- Block render 관련 메소드들 --------------------------- */

    Block.prototype.renderBlockLeftHolderHeight = function(px) {
        $( this.getBlockLeftHolderDom() ).css(STR_HEIGHT,`${px}${STR_PX}`);
    }
    Block.prototype.resetBlockLeftHolderHeight = function() {
        $( this.getBlockLeftHolderDom() ).css(STR_HEIGHT,`${NUM_DEFAULT_BLOCK_LEFT_HOLDER_HEIGHT}${STR_PX}`);
    }

    /** FIXME: 추후 쓸데없이 중복되는 IF문 제거 */
    Block.prototype.renderMyColor = function() {
        var that = this;
        var type = this.getBlockCodeLineType();
        if (type === BLOCK_CODELINE_TYPE.HOLDER) {
            return;
        }

        this._renderBlockColor();
    }

    /** FIXME: 추후 쓸데없이 중복되는 IF문 제거 */
    Block.prototype.renderResetColor = function() {
        var that = this;
        var blockContainerThis = that.getBlockContainerThis();
        var blockList = blockContainerThis.getBlockList();
        blockList.forEach(block => {
            block.setIsCtrlPressed(false);

            $(block.getBlockMainDom()).css(STR_BORDER, '2px solid transparent');
            $(block.getBlockMainDom()).find(VP_CLASS_BLOCK_LEFT_HOLDER).css('box-shadow','0');
    
            if (that.getHolderBlock()) {
                $(that.getHolderBlock().getBlockMainDom()).css('box-shadow','0');
                $(that.getHolderBlock().getBlockMainDom()).css(STR_BORDER,'2px solid transparent');
            }
            
            this._renderBlockColor();
        });
        var blockList = blockContainerThis.getBlockList();
        blockList.forEach(block => {
            var mainDom = block.getBlockMainDom();
            $(mainDom).find(VP_CLASS_BLOCK_DELETE_BTN).remove();
            $(mainDom).find(VP_CLASS_BLOCK_OPTION_BTN).remove();
        });
    }
    
    /**
     * @private
     */
    Block.prototype._renderBlockColor = function() {
        var mainDom = this.getBlockMainDom();
        var holderBlockMainDom = null;
        var blockCodeType = this.getBlockCodeLineType();

        if ( blockCodeType === BLOCK_CODELINE_TYPE.CLASS || blockCodeType === BLOCK_CODELINE_TYPE.DEF ) {
            $(mainDom).css(STR_BACKGROUND_COLOR, COLOR_ORANGE);
            $(mainDom).find(VP_CLASS_BLOCK_LEFT_HOLDER).css(STR_BACKGROUND_COLOR, COLOR_ORANGE);
            holderBlockMainDom = this.getHolderBlock().getBlockMainDom();
            $(holderBlockMainDom).css(STR_BACKGROUND_COLOR, COLOR_ORANGE);
        } 
        else if ( blockCodeType === BLOCK_CODELINE_TYPE.RETURN_SUB ) {
            $(mainDom).css(STR_BACKGROUND_COLOR, COLOR_ORANGE);
        }
        else if ( blockCodeType === BLOCK_CODELINE_TYPE.PASS_SUB ) {
            $(mainDom).css(STR_BACKGROUND_COLOR, COLOR_BLOCK_YELLOW);
        }
        else if ( blockCodeType === BLOCK_CODELINE_TYPE.IF || blockCodeType === BLOCK_CODELINE_TYPE.FOR
            || blockCodeType === BLOCK_CODELINE_TYPE.WHILE || blockCodeType === BLOCK_CODELINE_TYPE.TRY
            || blockCodeType === BLOCK_CODELINE_TYPE.ELSE || blockCodeType === BLOCK_CODELINE_TYPE.ELIF 
            || blockCodeType === BLOCK_CODELINE_TYPE.FOR_ELSE || blockCodeType === BLOCK_CODELINE_TYPE.EXCEPT 
            || blockCodeType === BLOCK_CODELINE_TYPE.FINALLY) {

            $(mainDom).css(STR_BACKGROUND_COLOR, COLOR_BLOCK_YELLOW);
            $(mainDom).find(VP_CLASS_BLOCK_LEFT_HOLDER).css(STR_BACKGROUND_COLOR, COLOR_BLOCK_YELLOW);
            holderBlockMainDom = this.getHolderBlock().getBlockMainDom();
            $(holderBlockMainDom).css(STR_BACKGROUND_COLOR, COLOR_BLOCK_YELLOW);
        } 

        else if ( blockCodeType === BLOCK_CODELINE_TYPE.RETURN || blockCodeType === BLOCK_CODELINE_TYPE.PROPERTY ||
                  blockCodeType === BLOCK_CODELINE_TYPE.BREAK || blockCodeType === BLOCK_CODELINE_TYPE.CONTINUE || 
                  blockCodeType === BLOCK_CODELINE_TYPE.PASS || blockCodeType === BLOCK_CODELINE_TYPE.CODE
                  || blockCodeType === BLOCK_CODELINE_TYPE.IMPORT ) {
            $(mainDom).css(STR_BACKGROUND_COLOR, COLOR_SKY_BLUE);
        } 

    }

    Block.prototype.renderChildBlockListIndentAndGet = function(customBlockList) {
        var childBlockList = customBlockList || this.getChildBlockList();
        // var childBlockList = customBlockList || this.getChildLowerDepthBlockList();
        var rootDepth = 0;
    
        //** root Block depth */
        $(this.getRootBlock().getBlockMainDom()).attr(STR_DATA_DEPTH_ID, rootDepth);

        //** root Block의 자식 Block depth */
        childBlockList.forEach((block, index) => {
            var depth = block.calculateDepthAndGet();

            /** depth 계산 */
            var _depth = depth;
            var indentPxNum = 0;
            while (_depth-- !== 0) {
                indentPxNum += NUM_INDENT_DEPTH_PX;
            }
    
            indentPxNum -= rootDepth * NUM_INDENT_DEPTH_PX;
            /** index 0일때 rootDepth를 계산*/
            if (index === 0) {
                rootDepth = depth;
                return;
            }

            var rootDom = block.getBlockMainDom();
            $(rootDom).css(STR_MARGIN_LEFT, `${indentPxNum}${STR_PX}`);
            $(rootDom).attr(STR_DATA_DEPTH_ID, depth);
            // block.setDepth(depth);
        });
        return childBlockList;
    }

    Block.prototype.renderChildLowerDepthBlockListIndentAndGet = function(customBlockList) {
        // var childBlockList = customBlockList || this.getChildBlockList();
        var childBlockList = customBlockList || this.getChildLowerDepthBlockList();
        var rootDepth = 0;
    
        //** root Block depth */
        $(this.getRootBlock().getBlockMainDom()).attr(STR_DATA_DEPTH_ID, rootDepth);

        //** root Block의 자식 Block depth */
        childBlockList.forEach((block, index) => {
            var depth = block.calculateDepthAndGet();

            /** depth 계산 */
            var _depth = depth;
            var indentPxNum = 0;
            while (_depth-- !== 0) {
                indentPxNum += NUM_INDENT_DEPTH_PX;
            }
    
            indentPxNum -= rootDepth * NUM_INDENT_DEPTH_PX;
            /** index 0일때 rootDepth를 계산*/
            if (index === 0) {
                rootDepth = depth;
                return;
            }

            var rootDom = block.getBlockMainDom();
            $(rootDom).css(STR_MARGIN_LEFT, `${indentPxNum}${STR_PX}`);
            $(rootDom).attr(STR_DATA_DEPTH_ID, depth);
            // block.setDepth(depth);
        });
        return childBlockList;
    }
    /**  */
    Block.prototype.renderBlockLeftHolderDom = function(mainDom) {
        var blockCodeType = this.getBlockCodeLineType();
        if (blockCodeType === BLOCK_CODELINE_TYPE.CLASS 
            || blockCodeType === BLOCK_CODELINE_TYPE.DEF ) {
            this._renderBlockLeftHolderDom(COLOR_ORANGE, mainDom);
        }         

        if (blockCodeType === BLOCK_CODELINE_TYPE.IF || blockCodeType === BLOCK_CODELINE_TYPE.FOR
            || blockCodeType === BLOCK_CODELINE_TYPE.WHILE || blockCodeType === BLOCK_CODELINE_TYPE.TRY
            || blockCodeType === BLOCK_CODELINE_TYPE.ELSE || blockCodeType === BLOCK_CODELINE_TYPE.ELIF
            || blockCodeType === BLOCK_CODELINE_TYPE.FOR_ELSE || blockCodeType === BLOCK_CODELINE_TYPE.EXCEPT 
            || blockCodeType === BLOCK_CODELINE_TYPE.FINALLY ) {
            this._renderBlockLeftHolderDom(COLOR_BLOCK_YELLOW, mainDom);
        }

        if (blockCodeType === BLOCK_CODELINE_TYPE.IMPORT || 
            blockCodeType === BLOCK_CODELINE_TYPE.PASS ||
            blockCodeType === BLOCK_CODELINE_TYPE.RETURN ||
            blockCodeType === BLOCK_CODELINE_TYPE.CONTINUE ||
            blockCodeType === BLOCK_CODELINE_TYPE.CODE ||
            blockCodeType === BLOCK_CODELINE_TYPE.BREAK ||  
            blockCodeType === BLOCK_CODELINE_TYPE.PROPERTY ) {
            $(mainDom).css(STR_BACKGROUND_COLOR, COLOR_SKY_BLUE);
        }
        return mainDom;
    }

    Block.prototype._renderBlockLeftHolderDom  = function(backColor, mainDom) {
        $(this.getBlockLeftHolderDom()).remove();

        var blockLeftHolderDom = $('<div class="vp-block-left-holder"></div>');
        var blockLeftHolderHeight = this.getTempBlockLeftHolderHeight();
        blockLeftHolderDom.css(STR_HEIGHT,`${blockLeftHolderHeight}${STR_PX}`);
        $(blockLeftHolderDom).css(STR_BACKGROUND_COLOR,`${backColor}`);

        this.setBlockLeftHolderDom(blockLeftHolderDom);
        $(mainDom).css(STR_BACKGROUND_COLOR, backColor);
        $(mainDom).append(blockLeftHolderDom);
    }

    Block.prototype.renderResetBottomOption = function() {
        $(VP_CLASS_NODEEDITOR_TAB_NAVIGATION_NODE_OPTION_TITLE_SAPN).html(STR_OPTION);
        $(VP_CLASS_NODEEDITOR_BOTTOM_TAB_VIEW).empty();
    }

    Block.prototype.renderResetBottomLowerDepthChildsBlockOption = function() {
    
        var blockContainerThis = this.getBlockContainerThis();
        var blockList = blockContainerThis.getBlockList();
        blockList.forEach(block => {
            block.setIsLowerDepthChild(false);
        });
        $(VP_CLASS_NODEEDITOR_BOTTOM_OPTIONAL_TAB_VIEW).empty();
    
        $('.vp-nodeeditor-option-tab-childs-option').remove();
    }

    /**
     * Block Type에 맵핑되는 Option을 Option tab에 렌더링하는 html 함수
     */
    Block.prototype.renderBottomOption = function() {
        var that = this;
        var uuid = that.getUUID();
        var name = that.getBlockName();
        var capitalizeName = makeFirstCharToUpperCase(name);
        var blockContainerThis = that.getBlockContainerThis();

        var optionPageSelector = STR_NULL;

        var isChild = this.getIsLowerDepthChild();
        if (isChild === true) {
            optionPageSelector = VP_CLASS_NODEEDITOR_BOTTOM_OPTIONAL_TAB_VIEW;
            var optionTitleDom = renderOptionTitle(that);

            $(optionPageSelector).append(optionTitleDom);

            /**  OptionTitle 블럭 up down 버튼 */
            $(`.vp-nodeeditor-panel-area-vertical-btn2-${that.getUUID()}`).click(function() {
                if ($(this).hasClass(`vp-nodeeditor-arrow-down`)) {
                    $(this).removeClass(`vp-nodeeditor-arrow-down`);
                    $(this).addClass(`vp-nodeeditor-arrow-up`);
                    $(this).html(`▲`);
                    $(this).parent().next().removeClass(`vp-nodeeditor-minimize-10px`);
                } else {
                    $(this).removeClass(`vp-nodeeditor-arrow-up`);
                    $(this).addClass(`vp-nodeeditor-arrow-down`);
                    $(this).html(`▼`);
                    $(this).parent().next().addClass(`vp-nodeeditor-minimize-10px`);
                }
            });

        } else {
            $(VP_CLASS_NODEEDITOR_TAB_NAVIGATION_NODE_OPTION_TITLE_SAPN).html(`${capitalizeName} ${STR_OPTION}s`);
            $('.vp-nodeeditor-tab-navigation-node-childs-top-option-title span').html(`${capitalizeName} Child ${STR_OPTION}s`);
            optionPageSelector = VP_CLASS_NODEEDITOR_BOTTOM_TAB_VIEW;
            $(optionPageSelector).empty();
        }
        
        var type = that.getBlockCodeLineType();
        switch(type) {
            /** class */
            case BLOCK_CODELINE_TYPE.CLASS: {
                var classContainer = renderBottomOptionContainer();
                var classBlockOption = renderBottomOptionContainerInner();

                /** class name */
                var classInnerDom = renderBottomOptionInnerDom();
                var classNameState = that.getState(STATE_className);                                
                var classNameDom = renderBottomOptionName(that, classNameState, BLOCK_CODELINE_TYPE.CLASS);
                var classParentDom = renderClassParentDom(that);

                classInnerDom.append( classNameDom );
                classInnerDom.append( classParentDom );
                classBlockOption.append(classInnerDom);

                /** class parameter list */
                var classInParamList = that.getState(STATE_classInParamList);

                /** */
                classContainer.append(classBlockOption);

                /** option 탭에 렌더링된 dom객체 생성 */
                $(optionPageSelector).append(classContainer);

                /** class 파라미터 변경 이벤트 함수 바인딩 */
                classInParamList.forEach((classInParam, index ) => {
                 
                    $(`.vp-nodeeditor-input-param-${index}-${that.getUUID()}`).on(STR_CHANGE_KEYUP_PASTE, function() {
                        // renderInputRequiredColor(this);
                        var newParam = $(this).val();
                        that.setState({
                            classInParamList:  [ ...that.getState(STATE_classInParamList).slice(0, index), newParam,
                                                 ...that.getState(STATE_classInParamList).slice(index+1, that.getState(STATE_classInParamList).length) ]
                        });
                        var classInParamStr = generateClassInParamList(that);
                        $(`.vp-block-header-param-${that.getUUID()}`).html(classInParamStr);
                    });
                });

                /** class 파라미터 생성 이벤트 함수 바인딩 */
                blockContainerThis.bindCreateParamEvent(that, BLOCK_CODELINE_TYPE.CLASS);
            
                /** class 파라미터 삭제 이벤트 함수 바인딩 */
                blockContainerThis.bindDeleteParamEvent(that, BLOCK_CODELINE_TYPE.CLASS);

                /** class 이름 변경 함수 바인딩 */
                $(`.vp-nodeeditor-input-class-name-${that.getUUID()}`).on(STR_CHANGE_KEYUP_PASTE, function() {
                    renderInputRequiredColor(this);
                    that.setState({
                        className: $(this).val()
                    });

                    $(`.vp-block-header-class-name-${that.getUUID()}`).html($(this).val());
                });

                classInParamList.forEach( (_,index) => {
                    // renderInputRequiredColor(`.vp-nodeeditor-input-param-${index}-${that.getUUID()}`);
                });
                break;
            }
            /** def */
            case BLOCK_CODELINE_TYPE.DEF: {
                var defContainer = renderBottomOptionContainer();
                var defBlockOption = renderBottomOptionContainerInner();
                
                
                var defInnerDom = renderBottomOptionInnerDom();

                /** def property */
                var defPropertyDom = renderPropertyDomFromDef(that);
                /**  def 이름 function name */
                var defName = that.getState(STATE_defName);
                var defNameDom = renderBottomOptionName(that,defName, BLOCK_CODELINE_TYPE.DEF);

                defBlockOption.append( defPropertyDom );
                
                defInnerDom.append( defNameDom );
                defBlockOption.append(defInnerDom);

                /** 함수 파라미터 */
                var defInParamList = that.getState(STATE_defInParamList);
                var defInParamContainer = renderInParamContainer(that, defInParamList);

                // defInParam 갯수만큼 bottom block 옵션에 렌더링
                var defInParamBody = $(`<div class='vp-nodeeditor-parambody'>
                                        </div>`);

                var defInParamMenuDom = $(`<div class='vp-nodeeditor-style-flex-row'
                                                style='margin-top:5px; color: gray;'>

                                                <div class='vp-nodeeditor-blockoption-block
                                                            vp-nodeeditor-blockoption-inner 
                                                            vp-nodeeditor-style-flex-row' 
                                                        style='position:relative; 
                                                            margin-top:0px; 
                                                            border:transparent;'>

                                                    <div class='vp-nodeeditor-style-flex-column-center'
                                                        style='margin:0 0.5rem; '>
                                                        No.
                                                    </div>

                                                    <div style='width: 35%; '>   
                                                        Param
                                                    </div>

                                                    <div style='width: 40%;' >  
                                                        Default value
                                                    </div>

                                                    <div class=''>
                                                        Type
                                                    </div>    

                                                </div>
                                                </div>
                                            </div>`);
                defInParamBody.append(defInParamMenuDom);

                defInParamList.forEach((defInParams, index ) => {
                    var defInParamDom = renderDefParamDom(that, defInParams, index);
                    var deleteButton = renderDeleteButton();
                    defInParamDom.append(deleteButton);
                    defInParamBody.append(defInParamDom);

                    $(deleteButton).click(function() {
                        that.setState({
                            defInParamList:  [ ...that.getState(STATE_defInParamList).slice(0, index), 
                                               ...that.getState(STATE_defInParamList).slice(index+1, that.getState(STATE_defInParamList).length) ]
                        });

                        var defInParamStr = generateDefInParamList(that);
                        $(`.vp-block-header-param-${that.getUUID()}`).html(defInParamStr);
                  
                        blockContainerThis.renderBlockOptionTab();
                    });

                });
                defInParamContainer.append(defInParamBody);
                defBlockOption.append(defInParamContainer);
        
                /** */
                defContainer.append(defBlockOption);

                /** bottom block option 탭에 렌더링된 dom객체 생성 */
                $(optionPageSelector).append(defContainer);

                
                blockContainerThis.bindDefInParamListEvent(that, defInParamList);
                /** def 파라미터 생성 이벤트 함수 바인딩 */
                blockContainerThis.bindCreateParamEvent(that, BLOCK_CODELINE_TYPE.DEF);

                /** def 파라미터 삭제 이벤트 함수 바인딩 */
                blockContainerThis.bindDeleteParamEvent(that, BLOCK_CODELINE_TYPE.DEF);

                /** def 이름 변경 */
                $(`.vp-nodeeditor-input-def-name-${that.getUUID()}`).on(STR_CHANGE_KEYUP_PASTE, function() {
                    renderInputRequiredColor(this);
                    that.setState({
                        defName: $(this).val()
                    });
                    $(`.vp-block-header-def-name-${that.getUUID()}`).html($(this).val());
                });

                /** def block property 변경 */
                $(`.vp-nodeeditor-defproperty-input-${uuid}`).on('input', function(event) {
                    var inputValue = $(this).val();
                    var propertyBlock = that.getPropertyBlockFromDef();
                    var prevBlockFromDef = null;
                    
                    /** property block 삭제 */
                    if ( inputValue === STR_NULL ) {
                  
                        prevBlockFromDef = that.getPrevBlock();
                        /** property block이 root block일 경우 */
                        if (prevBlockFromDef.getPrevBlock() === null) {
         
                            if ( prevBlockFromDef ) {
                                var nextBlockList = prevBlockFromDef.getNextBlockList();
                                nextBlockList.some(( nextBlock, index) => {
                                    if (nextBlock.getUUID() === that.getUUID()) {
                                        nextBlockList.splice(index, 1)
                                        return true;
                                    }
                                });
                            }
    
                            that.setPrevBlock(null);
                            that.setDirection(BLOCK_DIRECTION.ROOT);
                            prevBlockFromDef._deleteBlockDomAndData();

                            that.setPropertyBlockFromDef(null);
                        /** property block이 root block이 아닐 경우 */      
                        } else {
                            prevBlockFromDef.deleteLowerDepthChildBlocks();
                            that.setPropertyBlockFromDef(null);
                        }
                 
                   
                    } else {
                        /** property block 생성 */  
                        if ( propertyBlock === null ) {
                 
                            prevBlockFromDef = that.getPrevBlock();
                            var defBlockDirection = that.getDirection();
                            var newBlock = null;
                            /** this block이 root block일 경우 */
                            if (prevBlockFromDef === null) {
                                newBlock = mapTypeToBlock(blockContainerThis, BLOCK_CODELINE_TYPE.PROPERTY, {pointX: 0, pointY: 0});
                                newBlock.appendBlock(that, BLOCK_DIRECTION.DOWN);
                                that.setPropertyBlockFromDef(newBlock);
                            /** this block이 root block이 아닐 경우 */   
                            } else {
                                newBlock = mapTypeToBlock(blockContainerThis, BLOCK_CODELINE_TYPE.PROPERTY, {pointX: 0, pointY: 0});
                                prevBlockFromDef.appendBlock(newBlock, defBlockDirection);
                                newBlock.appendBlock(that, BLOCK_DIRECTION.DOWN);
                                that.setPropertyBlockFromDef(newBlock);
                            }
                    
                            newBlock.setState({
                                propertyCodeLine : `@` + inputValue
                            });
                            newBlock.bindEventAll();
                            $(`.vp-block-header-property-${newBlock.getUUID()}`).html(newBlock.getState(STATE_propertyCodeLine));
                        /** property block 변경 */  
                        } else {
 
                            propertyBlock.setState({
                                propertyCodeLine :  `@` + inputValue
                            });
                            propertyBlock.bindEventAll();
                            $(`.vp-block-header-property-${propertyBlock.getUUID()}`).html(propertyBlock.getState(STATE_propertyCodeLine));
                        }
                    }

                    that.calculateDepthFromRootBlockAndSetDepth(); 

                    blockContainerThis.renderBlockLeftHolderListHeight();
                    blockContainerThis.reRenderBlockList();
                    blockContainerThis.renderBlockLineNumberInfoDom_sortBlockLineAsc();
                });

                defInParamList.forEach( (_,index) => {
                    renderInputRequiredColor(`.vp-nodeeditor-input-param-${index}-${that.getUUID()}`);
                });
                break;
            }

            /** if */
            case BLOCK_CODELINE_TYPE.IF: {
                var uuid = that.getUUID();
                var bottomOptionContainer = renderBottomOptionContainer();
                var ifBlockOption  = renderBottomOptionContainerInner();

                /* --------------------------- if ----------------------------- */
                // var ifNameDom = renderBottomOptionName(that, that.getState(STATE_ifCodeLine), BLOCK_CODELINE_TYPE.IF);
                var ifConditionListState = that.getState(STATE_ifConditionList);  
                var ifContainer = renderElifOrExceptContainer(BLOCK_CODELINE_TYPE.IF, ifConditionListState);
                var ifNameDom = renderIfConditionDom(that, BLOCK_CODELINE_TYPE.IF);

                ifBlockOption.append(ifContainer);
                ifBlockOption.append(ifNameDom);

                /* --------------------------- elif ---------------------------* */
                var elifList = [];
                var nextBlockDataList = that.getNextBlockList();
                var stack = [];
                if (nextBlockDataList.length !== 0) {
                    stack.push(nextBlockDataList);
                }

                var isBreak = false;
                var current;
                while (stack.length !== 0) {
                    current = stack.shift();
                    /** 배열 일 때 */
                    if (Array.isArray(current)) {
                        current.forEach(element => {
                            if ( element.getDirection() === BLOCK_DIRECTION.DOWN 
                                && element.getBlockCodeLineType() === BLOCK_CODELINE_TYPE.IF) {
                                isBreak = true;
                            }

                            if (element.getDirection() === BLOCK_DIRECTION.DOWN ) {
                                stack.push(element);
                                if ( element.getBlockCodeLineType() === BLOCK_CODELINE_TYPE.ELIF) {
                                    element.renderSelectedBlockColor();
                                    elifList.push(element);
                                }

                                if ( element.getBlockCodeLineType() === BLOCK_CODELINE_TYPE.ELSE) {
                                    element.renderSelectedBlockColor();
                                }
                            }
                        });
                    
        
                    } else {
                        var currBlock = current;
                        var nextBlockDataList = currBlock.getNextBlockList();
                        stack.unshift(nextBlockDataList);
                    }

                    if (isBreak) {
                        break;
                    }
                }
                
                if (elifList.length === 0) {
                    that.setLastElifBlock(elifList[0]);
                } else {
                    that.setLastElifBlock(elifList[elifList.length - 1]);
                }

                var elifContainer = renderElifOrExceptContainer(BLOCK_CODELINE_TYPE.ELIF, elifList);

                // elif 갯수만큼 bottom block 옵션에 렌더링
                var elifBody = $(`<div class='vp-nodeeditor-elifbody'
                                       style='margin-left:28px;'>
                                  </div>`);

                elifList.forEach((elifData, index ) => {
                    var elifDom = renderInParamDom(elifData.getState(STATE_elifCodeLine), index, BLOCK_CODELINE_TYPE.ELIF, elifData);
                    var deleteButton = renderDeleteButton();

                    /** elif 블럭을 삭제할 때 */
                    $(deleteButton).click(function() {

                        /** elif가 1개 이상 일 때 */
                        var blockContainerThis = that.getBlockContainerThis();
                        blockContainerThis.deleteElifOrExceptBlock(that, elifData);

                        /** IF 블럭 아래의 맨 마지막 elif를 찾아서 set하는 로직 */
                        if (index === 0 ) {
                            if (index === elifList.length - 1) {
                                that.setLastElifBlock(null);
                            } else {
                                that.setLastElifBlock(elifList[elifList.length - 1]);
                            }
                        } else if (index === elifList.length - 1) {
                            that.setLastElifBlock(elifList[elifList.length - 2]);
                        } else {
                            that.setLastElifBlock(elifList[elifList.length - 1]);
                        }
                    });
                    // elifData.renderBlockLeftHolderDom(elifData.getBlockMainDom());
                    elifDom.append(deleteButton);
                    elifBody.append(elifDom);
                });
                elifContainer.append(elifBody);
                ifBlockOption.append(elifContainer);

                /* ---------------------------------- else ------------------------------------- */
                var elseBlock= renderElseBlock(that, BLOCK_CODELINE_TYPE.IF);
                ifBlockOption.append(elseBlock);
                bottomOptionContainer.append(ifBlockOption);

                /** bottom block option 탭에 렌더링된 dom객체 생성 */
                $(optionPageSelector).append(bottomOptionContainer);


                /** --------------------------------- elif Option 이벤트 함수 바인딩 ---------------------------------- */

                /** elif 생성 이벤트 함수 바인딩 */
                $(`.vp-nodeeditor-elif-plus-btn`).click(function() {
                    /** ++ elif */

                    var selectedBlock = that.getLastElifBlock() || that;
                    
                    var blockContainerThis = that.getBlockContainerThis();
                    var newBlock = mapTypeToBlock(blockContainerThis, BLOCK_CODELINE_TYPE.ELIF, {pointX: 0, pointY: 0});
                    newBlock.setState({
                        elifCodeLine: `${elifList.length} < ${elifList.length + 1}`
                    });
  

                    that.setLastElifBlock(newBlock);
                    selectedBlock.getHolderBlock().appendBlock_old(newBlock, BLOCK_DIRECTION.DOWN);
                    $(`.vp-block-header-elif-code-${newBlock.getUUID()}`).html(newBlock.getState(STATE_elifCodeLine));

                    blockContainerThis.renderBlockOptionTab();
                    that.calculateDepthFromRootBlockAndSetDepth();

                    blockContainerThis.renderBlockLeftHolderListHeight();
                    blockContainerThis.reRenderBlockList();
                    blockContainerThis.renderBlockLineNumberInfoDom_sortBlockLineAsc();
                });
                
                /** elif 삭제 이벤트 함수 바인딩 */
                $(`.vp-nodeeditor-elif-delete-btn`).click(function() {
                    /** elif가 0개 일 때 */
                    if (elifList.length === 0) {
                        return;
                    }

                    /** elif가 1개 이상 일 때 */
                 
                    var elifData = elifList[ elifList.length - 1];
                    blockContainerThis.deleteElifOrExceptBlock(that, elifData);
                    blockContainerThis.renderBlockLineNumberInfoDom_sortBlockLineAsc();
                });

          
                /** elif code 변경 이벤트 함수 바인딩 */
                elifList.forEach((elifData, index) => {
                    $(`.vp-nodeeditor-elif-input-${elifData.getUUID()}`).on(STR_CHANGE_KEYUP_PASTE, function() {
                        renderInputRequiredColor(this);
                        var updatedData = $(this).val();
                        elifData.setState({
                            elifCodeLine: updatedData
                        });
                        $(`.vp-block-header-elif-code-${elifData.getUUID()}`).html(updatedData);
                    });
                });
    
                /** elif block 생성, 삭제 이벤트 함수 바인딩 */
                blockContainerThis.bindElseBlockEvent(that, BLOCK_CODELINE_TYPE.ELSE);

                /** --------------------------------- if Option 이벤트 함수 바인딩 ---------------------------------- */
                ifConditionListState.forEach( ( condition, index ) => {
                    const { arg1, arg2, arg3, arg6 } = condition;
                    var uuid = that.getUUID();

                    /** */
                    $(`.vp-nodeeditor-blockoption-if-arg1-${index}-${uuid}`).on(STR_CHANGE_KEYUP_PASTE, function() {
                        renderInputRequiredColor(this);
                        var inputValue = $(this).val();
                        var ifConditionListState = that.getState(STATE_ifConditionList);
                        var updatedValue = {
                            arg1: inputValue
                            , arg2: ifConditionListState[index].arg2
                            , arg3: ifConditionListState[index].arg3
                            , arg6: ifConditionListState[index].arg6
                        }
                        ifConditionListState = updateOneArrayValueAndGet(ifConditionListState, index, updatedValue);
                        that.setState({
                            ifConditionList: ifConditionListState
                        });
                        var ifConditionCode = generateIfConditionList(that);
                        $(`.vp-block-header-if-code-${that.getUUID()}`).html(ifConditionCode);
                    });


                    /** def type select 변경 이벤트 함수 바인딩 */
                    $(`.vp-nodeeditor-blockoption-if-arg2-${index}-${uuid}`).change(function()  {
                        var selectedValue = $(STR_COLON_SELECTED, this).val();
                        var ifConditionListState = that.getState(STATE_ifConditionList);
                        var updatedValue = {
                            arg1: ifConditionListState[index].arg1
                            , arg2: selectedValue
                            , arg3: ifConditionListState[index].arg3
                            , arg6: ifConditionListState[index].arg6
                        }
                        ifConditionListState = updateOneArrayValueAndGet(ifConditionListState, index, updatedValue);
                        that.setState({
                            ifConditionList: ifConditionListState
                        });
                        var ifConditionCode = generateIfConditionList(that);
                        $(`.vp-block-header-if-code-${that.getUUID()}`).html(ifConditionCode);
                    });


                    /** */
                    $(`.vp-nodeeditor-blockoption-if-arg3-${index}-${uuid}`).on(STR_CHANGE_KEYUP_PASTE, function() {
                        renderInputRequiredColor(this);
                        var inputValue = $(this).val();
                        var ifConditionListState = that.getState(STATE_ifConditionList);
                        var updatedValue = {
                            arg1: ifConditionListState[index].arg1
                            , arg2: ifConditionListState[index].arg2 
                            , arg3: inputValue
                            , arg6: ifConditionListState[index].arg6
                        }
                        ifConditionListState = updateOneArrayValueAndGet(ifConditionListState, index, updatedValue);
                        that.setState({
                            ifConditionList: ifConditionListState
                        });
                        var ifConditionCode = generateIfConditionList(that);
                        $(`.vp-block-header-if-code-${that.getUUID()}`).html(ifConditionCode);
                    });

                    $(`.vp-nodeeditor-blockoption-if-arg6-${index}-${uuid}`).change(function()  {
                        var selectedValue = $(STR_COLON_SELECTED, this).val();
                        var ifConditionListState = that.getState(STATE_ifConditionList);
                        var updatedValue = {
                            arg1: ifConditionListState[index].arg1
                            , arg2: ifConditionListState[index].arg2 
                            , arg3: ifConditionListState[index].arg3
                            , arg6: selectedValue
                        }
                        ifConditionListState = updateOneArrayValueAndGet(ifConditionListState, index, updatedValue);
                        that.setState({
                            ifConditionList: ifConditionListState
                        });
                        var ifConditionCode = generateIfConditionList(that);
                        $(`.vp-block-header-if-code-${that.getUUID()}`).html(ifConditionCode);
                    });
                    /** */                  
                    
                    /** 생성 if condition */
                    $(`.vp-nodeeditor-if-condition-plus-button-${index}-${uuid}`).click(function(){
                 
                        var ifConditionListState = that.getState(STATE_ifConditionList);
                        that.addVariableIndex();
                        var variableIndex = that.getVariableIndex();
                      
                        var newCondition = {
                            arg1: `'i${variableIndex}'`
                            , arg2: '=='
                            , arg3: `'j${variableIndex}'`
                            , arg6: 'and'
                        }
                        ifConditionListState = createOneArrayValueAndGet(ifConditionListState, index, newCondition);
                        that.setState({
                            ifConditionList: ifConditionListState
                        });
                        var ifConditionCode = generateIfConditionList(that);
                        $(`.vp-block-header-if-code-${that.getUUID()}`).html(ifConditionCode);
                        blockContainerThis.renderBlockOptionTab();
                    });

                    /** 삭제 if condition */
                    $(`.vp-nodeeditor-if-condition-delete-button-${index}-${uuid}`).click(function(){
                        var ifConditionListState = that.getState(STATE_ifConditionList);
                        ifConditionListState = deleteOneArrayValueAndGet(ifConditionListState, index);

                        that.setState({
                            ifConditionList: ifConditionListState
                        });
                        var ifConditionCode = generateIfConditionList(that);
                        $(`.vp-block-header-if-code-${that.getUUID()}`).html(ifConditionCode);
                        blockContainerThis.renderBlockOptionTab();
                    }); 
                });
 
                /** if 생성 이벤트 함수 바인딩 */
                $(`.vp-nodeeditor-if-plus-btn`).click(function() {
                    var ifConditionListState = that.getState(STATE_ifConditionList);
                    var ifConditionLength = ifConditionListState.length;
                    that.addVariableIndex();
                    var variableIndex = that.getVariableIndex();
                  
                    var newCondition = {
                        arg1: `'i${variableIndex}'`
                        , arg2: '=='
                        , arg3: `'j${variableIndex}'`
                        , arg6: 'and'
                    }
                    ifConditionListState = createOneArrayValueAndGet(ifConditionListState, ifConditionLength, newCondition);
                    that.setState({
                        ifConditionList: ifConditionListState
                    });
                    var ifConditionCode = generateIfConditionList(that);
                    $(`.vp-block-header-if-code-${that.getUUID()}`).html(ifConditionCode);
                    blockContainerThis.renderBlockOptionTab();
                });
                /** if 삭제 이벤트 함수 바인딩 */
                $(`.vp-nodeeditor-if-delete-btn`).click(function() {
                    var ifConditionListState = that.getState(STATE_ifConditionList);
                    var ifConditionLength = ifConditionListState.length-1;
                    ifConditionListState = deleteOneArrayValueAndGet(ifConditionListState, ifConditionLength);

                    that.setState({
                        ifConditionList: ifConditionListState
                    });
                    var ifConditionCode = generateIfConditionList(that);
                    $(`.vp-block-header-if-code-${that.getUUID()}`).html(ifConditionCode);
                    blockContainerThis.renderBlockOptionTab();
                });
        
                ifConditionListState.forEach( (_,index) => {
                    renderInputRequiredColor(`.vp-nodeeditor-blockoption-if-arg1-${index}-${that.getUUID()}`);
                    renderInputRequiredColor(`.vp-nodeeditor-blockoption-if-arg3-${index}-${that.getUUID()}`);
                });
                break;
            }  
            case BLOCK_CODELINE_TYPE.ELIF: {
                var uuid = that.getUUID();
                var bottomOptionContainer = renderBottomOptionContainer();
                var elifBlockOption  = renderBottomOptionContainerInner();
                var elifContainer = renderBottomOptionTitle(STR_ELIF);
                var elifNameDom = renderBottomOptionName(that, that.getState(STATE_elifCodeLine), BLOCK_CODELINE_TYPE.ELIF, uuid);

                elifContainer.append(elifNameDom);
                elifBlockOption.append(elifContainer);

                bottomOptionContainer.append(elifBlockOption);

                /** bottom block option 탭에 렌더링된 dom객체 생성 */
                $(optionPageSelector).append(bottomOptionContainer);

                $(`.vp-nodeeditor-elif-input-${uuid}`).on(STR_CHANGE_KEYUP_PASTE, function() {
                    renderInputRequiredColor(this);
                    var updatedData = $(this).val();
                    that.setState({
                        elifCodeLine: updatedData
                    });
                    $(`.vp-block-header-elif-code-${uuid}`).html(updatedData);
                });
                break;
            }     
            /** for */
            case BLOCK_CODELINE_TYPE.FOR: {
                var bottomOptionContainer = renderBottomOptionContainer();
                var forBlockOption = renderBottomOptionContainerInner();

                /* ------------- for html dom 생성 -------------- */
                // var forContainer = renderBottomOptionTitle(STR_FOR);
                var forNameDom = renderBottomOptionName(that, that.getState(STATE_forCodeLine), BLOCK_CODELINE_TYPE.FOR);

                // forContainer.append(forNameDom);
                forBlockOption.append(forNameDom);
                /* ------------- else ------------- */
                var elseBlock = renderElseBlock(that, BLOCK_CODELINE_TYPE.FOR);
                forBlockOption.append(elseBlock);
                bottomOptionContainer.append(forBlockOption);

                /** FOR 클릭시 FOR_ELSE 노란색 border 색칠 */
                if (that.getForElseBlock()) {
                    that.getForElseBlock().renderSelectedBlockColor();
                }

                /** bottom block option 탭에 렌더링된 dom객체 생성 */
                $(optionPageSelector).append(bottomOptionContainer);

                /** for code 변경 */
                $(`.vp-nodeeditor-for-input-${uuid}`).on(STR_CHANGE_KEYUP_PASTE, function() {
                    renderInputRequiredColor(this);
                    that.setState({
                        forCodeLine: $(this).val()
                    });
                    $(`.vp-block-header-for-code-${that.getUUID()}`).html(that.getState(STATE_forCodeLine));
                });
                
                blockContainerThis.bindElseBlockEvent(that, BLOCK_CODELINE_TYPE.FOR_ELSE);

                break;
            }
            /** while */
            case BLOCK_CODELINE_TYPE.WHILE: {
                var flexRow = renderBottomOptionContainer();
                var whileBlockOption = renderBottomOptionContainerInner();

                /* ------------- while -------------- */
                // var whileContainer = renderBottomOptionTitle('while');
                var whileDom = renderBottomOptionName(that, that.getState(STATE_whileCodeLine), BLOCK_CODELINE_TYPE.WHILE);

                // whileContainer.append(whileDom );
                whileBlockOption.append(whileDom);
                flexRow.append(whileBlockOption);

                /** bottom block option 탭에 렌더링된 dom객체 생성 */
                $(optionPageSelector).append(flexRow);

                /** while code 변경 */
                $(`.vp-nodeeditor-while-input-${uuid}`).on(STR_CHANGE_KEYUP_PASTE, function() {
                    renderInputRequiredColor(this);
                    that.setState({
                        whileCodeLine: $(this).val()
                    });
                    $(`.vp-block-header-while-code-${that.getUUID()}`).html(that.getState(STATE_whileCodeLine));
                });
                break;
            }
            /** import */
            case BLOCK_CODELINE_TYPE.IMPORT: {
                var uuid = that.getUUID();
                var baseImportList = that.getState('baseImportList');

                var flexRow = renderBottomOptionContainer();
                var defaultOrDetailButton = renderDefaultOrDetailButton(that, uuid, BLOCK_CODELINE_TYPE.IMPORT);
                var importBlockOption = renderBottomOptionContainerInner();
                importBlockOption.append(defaultOrDetailButton);

                /* ------------- import -------------- */
                var countisImport = 0;
                baseImportList.forEach(baseImportData => {
                    if (baseImportData.isImport === true ) {
                        countisImport += 1;
                    };
                });
                var defaultImportContainer = renderDefaultOrCustomImportContainer(IMPORT_BLOCK_TYPE.DEFAULT, countisImport);
                var defaultImportBody = $('<div><div>');
                baseImportList.forEach((baseImportData, index) => {
                    var defaultImportDom = renderDefaultImportDom(baseImportData, index);
                    defaultImportBody.append(defaultImportDom);                        
                });

                /** -------------custom import ------------------ */
                var customImportList = that.getState(STATE_customImportList);
                var countIsCustomImport = 0;
                customImportList.forEach(baseImportData => {
                    if (baseImportData.isImport === true ) {
                        countIsCustomImport += 1;
                    };
                });

                // customImport 갯수만큼 bottom block 옵션에 렌더링
                var customImportContainer = renderDefaultOrCustomImportContainer(IMPORT_BLOCK_TYPE.CUSTOM, countIsCustomImport);
                var customImportBody = $(`<div class='vp-nodeeditor-customimport-body'>
                                        </div>`);
                customImportList.forEach((customImportData, index ) => {
                    var customImportDom = renderCustomImportDom(customImportData, index);
                    var deleteButton = renderDeleteButton();
                    $(deleteButton).click(function() {
                        that.setState({
                            customImportList:  [ ...that.getState(STATE_customImportList).slice(0, index), 
                                                 ...that.getState(STATE_customImportList).slice(index+1, that.getState(STATE_customImportList).length) ]
                        });

                        blockContainerThis.renderBlockOptionTab();
                    });
                    customImportDom.append(deleteButton);
                    customImportBody.append(customImportDom);
                });

                var isBaseImportPage = that.getState('isBaseImportPage');
                if (isBaseImportPage === true) {
                    defaultImportContainer.append(defaultImportBody);
                    importBlockOption.append(defaultImportContainer);
                } else {
                    customImportContainer.append(customImportBody);
                    importBlockOption.append(customImportContainer);
                }
                
                flexRow.append(importBlockOption);
            
                $(optionPageSelector).append(flexRow);

                $('.vp-nodeeditor-custom-import-plus-btn').click(function() {
                    var newData = {
                        baseAcronyms : ''
                        , baseImportName : 'numpy'
                        , isImport : false
                    }
                    that.setState({
                        customImportList: [ ...that.getState(STATE_customImportList), newData ]
                    });

                    blockContainerThis.renderBlockOptionTab();
                });

                // /** default 옵션 클릭 */
                $(`.vp-nodeeditor-default-option-${uuid}`).click(function() {

                    $(defaultImportContainer).css(STR_DISPLAY, STR_BLOCK);
                    $(customImportContainer).css(STR_DISPLAY, STR_NONE);
                    that.setState({
                        isBaseImportPage: true
                    });

                    blockContainerThis.renderBlockOptionTab();
                });

                // /** detail 옵션 클릭 */
                $(`.vp-nodeeditor-detail-option-${uuid}`).click(function() {

                    $(customImportContainer).css(STR_DISPLAY, STR_BLOCK);
                    $(defaultImportContainer).css(STR_DISPLAY, STR_NONE);
                    that.setState({
                        isBaseImportPage: false
                    });
                
                    blockContainerThis.renderBlockOptionTab();
                });

                customImportList.forEach((customImportData, index) => {
                    const { isImport, baseImportName, baseAcronyms } = customImportData;
                    $(`.vp-nodeeditor-blockoption-custom-import-input-${index}`).click(function() {
                        if (isImport === true) {
                            var updatedData = {
                                baseAcronyms: that.getState(STATE_customImportList)[index].baseAcronyms
                                , baseImportName
                                , isImport: false
                            }
                            that.setState({
                                customImportList: [ ...that.getState(STATE_customImportList).slice(0, index), updatedData
                                                    , ...that.getState(STATE_customImportList).slice(index+1, that.getState(STATE_customImportList).length) ]
                            });
                        } else {
                            var updatedData = {
                                baseAcronyms
                                , baseImportName
                                , isImport: true
                            }
                            that.setState({
                                customImportList: [ ...that.getState(STATE_customImportList).slice(0, index), updatedData
                                                    , ...that.getState(STATE_customImportList).slice(index+1, that.getState(STATE_customImportList).length) ]
                            });
                        }
                  
                        blockContainerThis.renderBlockOptionTab();
                    })
                    $(`.vp-nodeeditor-blockoption-custom-import-select-${index}`).change(function()  {
                        var updatedData = {
                            baseAcronyms: that.getState(STATE_customImportList)[index].baseAcronyms
                            , baseImportName : $(STR_COLON_SELECTED, this).val()
                            , isImport
                        }
                        that.setState({
                            customImportList: [ ...that.getState(STATE_customImportList).slice(0, index), updatedData
                                                , ...that.getState(STATE_customImportList).slice(index+1, that.getState(STATE_customImportList).length) ]
                        });
                    
                        blockContainerThis.renderBlockOptionTab();
                    });
                    $(`.vp-nodeeditor-blockoption-custom-import-textinput-${index}`).on(STR_CHANGE_KEYUP_PASTE, function() {
                        renderInputRequiredColor(this);

                        var updatedData = {
                            baseAcronyms : $(this).val()
                            , baseImportName 
                            , isImport
                        }
                        that.setState({
                            customImportList: [ ...that.getState(STATE_customImportList).slice(0, index), updatedData
                                                , ...that.getState(STATE_customImportList).slice(index+1, that.getState(STATE_customImportList).length) ]
                        });

                    });
                });
                
                baseImportList.forEach((_, index) => {
                    $(`.vp-nodeeditor-blockoption-default-import-input-${index}`).click(function() {

                        var isImport = that.getState(STATE_baseImportList)[index].isImport;
                        var baseImportName = that.getState(STATE_baseImportList)[index].baseImportName;
                        var baseAcronyms = that.getState(STATE_baseImportList)[index].baseAcronyms;

                        if (isImport === true) {
                            var updatedData = {
                                isImport: false
                                , baseImportName
                                , baseAcronyms
                            }
                    
                            that.setState({
                                baseImportList: [ ...that.getState(STATE_baseImportList).slice(0, index), updatedData
                                                , ...that.getState(STATE_baseImportList).slice(index+1, that.getState(STATE_baseImportList).length) ]
                            });
                        } 
                        else  {
                            var updatedData = {
                                isImport: true
                                , baseImportName
                                , baseAcronyms
                                
                            }
                        
                            that.setState({
                                baseImportList: [ ...that.getState(STATE_baseImportList).slice(0, index), updatedData
                                                , ...that.getState(STATE_baseImportList).slice(index+1, that.getState(STATE_baseImportList).length) ]
                            });
                        }
             
                        blockContainerThis.renderBlockOptionTab();
                    }); 
                });
                break;
            }
            /** api */
            case BLOCK_CODELINE_TYPE.API: {
                var apiContainer = renderBottomOptionContainer();
                var apiBlockOption  = renderBottomOptionContainerInner();
                /* ---------------- Api --------------- */
                var apiTitle = renderBottomOptionTitle('navigator'); 

                var apiDom = $(`<div class="vp-nodeeditor-tab-navigation-node-body
                                            vp-nodeeditor-tab-navigation-node-block-body
                                            vp-nodeeditor-style-flex-row-between-wrap">
                                            <div class="vp-nodeeditor-tab-navigation-node-block-body-btn">
                                                <span>NUMPY</span>
                                            </div>
                                            <div class="vp-nodeeditor-tab-navigation-node-block-body-btn">
                                                <span>PANDAS</span>
                                            </div>
                                            <div class="vp-nodeeditor-tab-navigation-node-block-body-btn">
                                                <span>OS</span>
                                            </div>
                                            <div class="vp-nodeeditor-tab-navigation-node-block-body-btn">
                                                <span>SYS</span>
                                            </div>
                                            <div class="vp-nodeeditor-tab-navigation-node-block-body-btn">
                                                <span>DATE</span>
                                            </div>
                                            <div class="vp-nodeeditor-tab-navigation-node-block-body-btn">
                                                <span>DATETIME</span>
                                            </div>
                                            <div class="vp-nodeeditor-tab-navigation-node-block-body-btn">
                                                <span>MATH</span>
                                            </div>
                                            <div class="vp-nodeeditor-tab-navigation-node-block-body-btn">
                                                <span>RANDOM</span>
                                            </div>
                                        </div>`);
                apiTitle.append(apiDom);
                apiBlockOption.append(apiTitle);                      
                apiContainer.append(apiBlockOption);
                /** bottom block option 탭에 렌더링된 dom객체 생성 */
                $(optionPageSelector).append(apiContainer);
                break;
            }

            /** try */
            case BLOCK_CODELINE_TYPE.TRY: {
                var blockOptionContainer = renderBottomOptionContainer();
                var tryBlockOption  = renderBottomOptionContainerInner();

                /* ---------------- Try --------------- */
                var tryTitle = renderBottomOptionTitle(STR_TRY);
                tryBlockOption.append(tryTitle);

                /* ---------------- except ------------- */
                var exceptList = [];
                var nextBlockDataList = that.getNextBlockList();
                var stack = [];
                if (nextBlockDataList.length !== 0) {
                    stack.push(nextBlockDataList);
                }

                var current;
                while (stack.length !== 0) {
                    current = stack.shift();
                    /** 배열 일 때 */
                    if (Array.isArray(current)) {
                        current.forEach(element => {
                            if (element.getDirection() === BLOCK_DIRECTION.DOWN) {
                            
                                stack.push(element);
                                if ( element.getBlockCodeLineType() === BLOCK_CODELINE_TYPE.EXCEPT) {
                                    element.renderSelectedBlockColor();
                                    exceptList.push(element);
                                }

                                if ( element.getBlockCodeLineType() === BLOCK_CODELINE_TYPE.FINALLY) {
                                    element.renderSelectedBlockColor();
                                }
                            }
                        });
                    
        
                    } else {
                        var currBlock = current;
                        var nextBlockDataList = currBlock.getNextBlockList();
                        stack.unshift(nextBlockDataList);
                    }

                    if (isBreak) {
                        break;
                    }

                }

                if (exceptList.length === 0) {
                    that.setLastElifBlock(exceptList[0]);
                } else {
                    that.setLastElifBlock(exceptList[exceptList.length - 1]);
                }

                var exceptContainer = renderElifOrExceptContainer(that, exceptList);

                // except 갯수만큼 bottom block 옵션에 렌더링
                var exceptBody = $(`<div class='vp-nodeeditor-elifbody'>
                                    </div>`);

                exceptList.forEach((exceptData, index ) => {
                    var exceptDom = renderInParamDom(exceptData.getState(STATE_exceptCodeLine), index, BLOCK_CODELINE_TYPE.EXCEPT, exceptData);
                    var deleteButton = renderDeleteButton();
                    $(deleteButton).click(function() {
                        /** 부모 에서 this를 제거  */
                        var blockContainerThis = that.getBlockContainerThis();
                        blockContainerThis.deleteElifOrExceptBlock(that, exceptData);

                        /** IF 블럭 아래의 맨 마지막 elif를 찾아서 set하는 로직 */
                        if (index === 0 ) {
                            if (index === exceptList.length - 1) {
                                that.setLastElifBlock(null);
                            } else {
                                that.setLastElifBlock(exceptList[exceptList.length - 1]);
                            }
                        } else if (index === exceptList.length - 1) {
                            that.setLastElifBlock(exceptList[exceptList.length - 2]);
                        } else {
                            that.setLastElifBlock(exceptList[exceptList.length - 1]);
                        }
                    });
                    exceptDom.append(deleteButton);
                    exceptBody.append(exceptDom);
                });

                exceptContainer.append(exceptBody);
                tryBlockOption.append(exceptContainer);

                /* ---------------- Finally ----------- */
                var finallyContainer = renderElseBlock(that, BLOCK_CODELINE_TYPE.TRY);
                tryBlockOption.append(finallyContainer);
                blockOptionContainer.append(tryBlockOption);
                /** bottom block option 탭에 렌더링된 dom객체 생성 */
                $(optionPageSelector).append(blockOptionContainer);

                /** except 생성 이벤트 함수 바인딩 */
                $(`.vp-nodeeditor-except-plus-btn`).click(function() {

                    var selectedBlock = that.getLastElifBlock() || that;
                    
                    var blockContainerThis = that.getBlockContainerThis();
                    var newBlock = mapTypeToBlock(blockContainerThis, BLOCK_CODELINE_TYPE.EXCEPT, {pointX: 0, pointY: 0});
                    newBlock.setState({
                        exceptCodeLine: `${exceptList.length} < ${exceptList.length + 1}`
                    });

                    that.setLastElifBlock(newBlock);
                    selectedBlock.getHolderBlock().appendBlock_old(newBlock, BLOCK_DIRECTION.DOWN);

                    blockContainerThis.renderBlockOptionTab();

                    that.calculateDepthFromRootBlockAndSetDepth();

                    blockContainerThis.renderBlockLeftHolderListHeight();
                    blockContainerThis.reRenderBlockList();
                    blockContainerThis.renderBlockLineNumberInfoDom_sortBlockLineAsc();
                    $(`.vp-block-header-except-code-${newBlock.getUUID()}`).html(newBlock.getState(STATE_exceptCodeLine));
                });

                /** except 삭제 이벤트 함수 바인딩 */
                $(`.vp-nodeeditor-except-delete-btn`).click(function() {
                    /** except가 0개 일 때 */
                    if (exceptList.length === 0) {
                        return;
                    }

                    /** except가 1개 이상 일 때 */
                    var blockContainerThis = that.getBlockContainerThis();
                    var exceptData = exceptList[ exceptList.length - 1];
                    blockContainerThis.deleteElifOrExceptBlock(that, exceptData);
                    blockContainerThis.renderBlockLineNumberInfoDom_sortBlockLineAsc();
                });
                
                /** except code 변경 */
                exceptList.forEach((exceptData, index ) => {
                    $(`.vp-nodeeditor-except-input-${exceptData.getUUID()}`).on(STR_CHANGE_KEYUP_PASTE, function() {
                        renderInputRequiredColor(this);
                        var updatedData = $(this).val();
                        exceptData.setState({
                            exceptCodeLine: updatedData
                        });
                        $(`.vp-block-header-except-code-${exceptData.getUUID()}`).html(updatedData);
                    });
                });

                blockContainerThis.bindElseBlockEvent(that, BLOCK_CODELINE_TYPE.FINALLY);

                break;
            }
            case BLOCK_CODELINE_TYPE.EXCEPT: {
                var uuid = that.getUUID();
                var bottomOptionContainer = renderBottomOptionContainer();
                var elifBlockOption  = renderBottomOptionContainerInner();
                var elifContainer = renderBottomOptionTitle(STR_EXCEPT);
                var elifNameDom = renderBottomOptionName(that, that.getState(STATE_exceptCodeLine), BLOCK_CODELINE_TYPE.EXCEPT, uuid);

                elifContainer.append(elifNameDom);
                elifBlockOption.append(elifContainer);

                bottomOptionContainer.append(elifBlockOption);

                /** bottom block option 탭에 렌더링된 dom객체 생성 */
                $(optionPageSelector).append(bottomOptionContainer);

                $(`.vp-nodeeditor-except-input-${uuid}`).on(STR_CHANGE_KEYUP_PASTE, function() {
                    renderInputRequiredColor(this);
                    var updatedData = $(this).val();
                    that.setState({
                        exceptCodeLine: updatedData
                    });
                    $(`.vp-block-header-except-code-${uuid}`).html(updatedData);
                });
                break;
            }   
            /** return */
            case BLOCK_CODELINE_TYPE.RETURN : 
            case BLOCK_CODELINE_TYPE.RETURN_SUB: {
                var blockOptionContainer = renderBottomOptionContainer();
                var returnBlockOption  = renderBottomOptionContainerInner();

                var returnOutParamList = that.getState(STATE_returnOutParamList);
                var returnOutParamContainer = renderInParamContainer(that, returnOutParamList );

                // defInParam 갯수만큼 bottom block 옵션에 렌더링
                var returnOutParamBody = $(`<div class='vp-nodeeditor-returnbody'>
                                            </div>`);

                returnOutParamList.forEach((returnOutParam, index ) => {
                    var returnOutParamDom = renderInParamDom(returnOutParam, index, BLOCK_CODELINE_TYPE.RETURN, that );
    
                    var deleteButton = renderDeleteButton();
                    $(deleteButton).click(function() {
                        that.setState({
                            returnOutParamList:  [ ...that.getState(STATE_returnOutParamList).slice(0, index), 
                                                   ...that.getState(STATE_returnOutParamList).slice(index+1, that.getState(STATE_returnOutParamList).length) ]
                        });
                        
                        var returnOutParamStr = generateReturnOutParamList(that);
                        $(`.vp-block-header-param-${that.getUUID()}`).html(returnOutParamStr);
              
                        blockContainerThis.renderBlockOptionTab();
                    });
                    returnOutParamDom.append(deleteButton);
                    returnOutParamBody.append(returnOutParamDom);
                });
                returnOutParamContainer.append(returnOutParamBody);
                returnBlockOption.append(returnOutParamContainer);

                /** */
                blockOptionContainer.append(returnBlockOption);

                /** bottom block option 탭에 렌더링된 dom객체 생성 */
                $(optionPageSelector).append(blockOptionContainer);

                /** 함수 파라미터 변경 이벤트 함수 바인딩 */
                returnOutParamList.forEach((_, index ) => {
                    $(`.vp-nodeeditor-input-param-${index}-${that.getUUID()}`).on(STR_CHANGE_KEYUP_PASTE, function() {
                        renderInputRequiredColor(this);
                        var newParam = $(this).val();
                        that.setState({
                            returnOutParamList:  [ ...that.getState(STATE_returnOutParamList).slice(0, index), newParam,
                                                    ...that.getState(STATE_returnOutParamList).slice(index+1, that.getState(STATE_returnOutParamList).length) ]
                        });
                        var returnOutParamStr = generateReturnOutParamList(that);
                        $(`.vp-block-header-param-${that.getUUID()}`).html(returnOutParamStr);
                    });
                });

                /** return Block 파라미터 생성 이벤트 함수 바인딩 */
                blockContainerThis.bindCreateParamEvent(that, BLOCK_CODELINE_TYPE.RETURN);
                /** return Block 파라미터 삭제 이벤트 함수 바인딩 */
                blockContainerThis.bindDeleteParamEvent(that, BLOCK_CODELINE_TYPE.RETURN);
                
                returnOutParamList.forEach( (_,index) => {
                    renderInputRequiredColor(`.vp-nodeeditor-input-param-${index}-${that.getUUID()}`);
                });
                break;
            }
            /** code block */
            case BLOCK_CODELINE_TYPE.CODE: {
                var blockOptionContainer = renderBottomOptionContainer();
                var blockOptionInner = renderBottomOptionContainerInner();

                /* ------------- code -------------- */
                var codeDom = renderBottomOptionName(that, that.getState(STATE_customCodeLine), BLOCK_CODELINE_TYPE.CODE);

                blockOptionInner.append(codeDom);
                blockOptionContainer.append(blockOptionInner);
                /** bottom block option 탭에 렌더링된 dom객체 생성 */
                $(optionPageSelector).append(blockOptionContainer);

                /** code 변경 */
                $(`.vp-nodeeditor-code-input-${uuid}`).on(STR_CHANGE_KEYUP_PASTE, function() {
                    renderInputRequiredColor(this);
                    that.setState({
                        customCodeLine: $(this).val()
                    });

                    /** 어떤 데이터도 입력되지 않을 때 */
                    if ($(this).val() === STR_NULL) {
                        $(`.vp-block-header-custom-code-${that.getUUID()}`).html(STR_INPUT_YOUR_CODE);
                        $(`.vp-block-header-custom-code-${that.getUUID()}`).css(STR_COLOR, COLOR_GRAY_input_your_code);
              
                        return;
                    }

                    /** 데이터가 입력되었을 때 */
                    $(`.vp-block-header-custom-code-${that.getUUID()}`).html(that.getState(STATE_customCodeLine));
                    $(`.vp-block-header-custom-code-${that.getUUID()}`).css(STR_COLOR, COLOR_WHITE);
                });
                break;
            }

            /** break block */
            case BLOCK_CODELINE_TYPE.BREAK: {
                var blockOptionContainer = renderBottomOptionContainer();
                var blockOptionInner = renderBottomOptionContainerInner();

                /* ------------- code -------------- */

                var codeDom = renderBottomOptionName(that, that.getState(STATE_breakCodeLine), BLOCK_CODELINE_TYPE.BREAK);

                blockOptionInner.append(codeDom);
                blockOptionContainer.append(blockOptionInner);
                /** bottom block option 탭에 렌더링된 dom객체 생성 */
                $(optionPageSelector).append(blockOptionContainer);

                /** code 변경 */
                $(`.vp-nodeeditor-break-input-${uuid}`).on(STR_CHANGE_KEYUP_PASTE, function() {
                    renderInputRequiredColor(this);
                    
                    that.setState({
                        breakCodeLine: $(this).val()
                    });
                    $(`.vp-block-header-break-${that.getUUID()}`).html(that.getState(STATE_breakCodeLine));
                });
                break;
            }
       
            /** contine block */
            case BLOCK_CODELINE_TYPE.CONTINUE: {
                var blockOptionContainer = renderBottomOptionContainer();
                var blockOptionInner = renderBottomOptionContainerInner();
                /* ------------- code -------------- */

                var codeDom = renderBottomOptionName(that, that.getState(STATE_continueCodeLine), BLOCK_CODELINE_TYPE.CONTINUE);

                blockOptionInner.append(codeDom);
                blockOptionContainer.append(blockOptionInner);
                /** bottom block option 탭에 렌더링된 dom객체 생성 */
                $(optionPageSelector).append(blockOptionContainer);

                /** code 변경 */
                $(`.vp-nodeeditor-continue-input-${uuid}`).on(STR_CHANGE_KEYUP_PASTE, function() {
                    renderInputRequiredColor(this);
                    
                    that.setState({
                        continueCodeLine: $(this).val()
                    });
                    $(`.vp-block-header-continue-${that.getUUID()}`).html(that.getState(STATE_continueCodeLine));
                });
                break;
            }
          
            /** property block */
            case BLOCK_CODELINE_TYPE.PROPERTY: {
                var blockOptionContainer = renderBottomOptionContainer();
                var blockOptionInner = renderBottomOptionContainerInner();

                /* ------------- code -------------- */
                // var codeDom = renderBottomOptionName(that, that.getState(STATE_propertyCodeLine), BLOCK_CODELINE_TYPE.PROPERTY);
                var codeDom = renderPropertyDom(that);
                blockOptionInner.append(codeDom);
                blockOptionContainer.append(blockOptionInner);
                /** bottom block option 탭에 렌더링된 dom객체 생성 */
                $(optionPageSelector).append(blockOptionContainer);

                /** code 변경 */
                $(`.vp-nodeeditor-property-input-${uuid}`).on(STR_CHANGE_KEYUP_PASTE, function() {
                    renderInputRequiredColor(this);
                    var inputValue = $(this).val();
                    if (inputValue === '') {
                        that.setState({
                            propertyCodeLine: '@'
                        });
                    } else {
                        if (inputValue.indexOf('@') === -1) {
                            that.setState({
                                propertyCodeLine: '@' + inputValue
                            });
                        } else {
                            that.setState({
                                propertyCodeLine: inputValue
                            });
                        }
                     
                    }
                    $(`.vp-block-header-property-${that.getUUID()}`).html(that.getState(STATE_propertyCodeLine));
                });
                break;
            }
            /** pass block */
            case BLOCK_CODELINE_TYPE.PASS: 
            case BLOCK_CODELINE_TYPE.PASS_SUB: {
                var blockOptionContainer = renderBottomOptionContainer();
                var blockOptionInner = renderBottomOptionContainerInner();

                var codeDom = renderBottomOptionName(that, that.getState(STATE_passCodeLine), BLOCK_CODELINE_TYPE.PASS_SUB);

                blockOptionInner.append(codeDom);
                blockOptionContainer.append(blockOptionInner);
                /** bottom block option 탭에 렌더링된 dom객체 생성 */
                $(optionPageSelector).append(blockOptionContainer);

                /** code 변경 */
                $(`.vp-nodeeditor-pass-input-${uuid}`).on(STR_CHANGE_KEYUP_PASTE, function() {
                    renderInputRequiredColor(this);
                    
                    that.setState({
                        passCodeLine: $(this).val()
                    });
                    $(`.vp-block-header-pass-${that.getUUID()}`).html(that.getState(STATE_passCodeLine));
                });
                break;
            }
        }

        // $('.vp-nodeeditor-option-vertical-btn').click(function() {
        //     if ($(this).hasClass(VP_CLASS_NODEEDITOR_ARROW_DOWN)) {
        //         $(this).removeClass(VP_CLASS_NODEEDITOR_ARROW_DOWN);
        //         $(this).addClass(VP_CLASS_NODEEDITOR_ARROW_UP);
        //         $(this).html(STR_ICON_ARROW_UP);
        //         $(this).parent().parent().parent().removeClass(VP_CLASS_NODEEDITOR_MINIMIZE);
        //     } else {
        //         $(this).removeClass(VP_CLASS_NODEEDITOR_ARROW_UP);
        //         $(this).addClass(VP_CLASS_NODEEDITOR_ARROW_DOWN);
        //         $(this).html(STR_ICON_ARROW_DOWN);
        //         $(this).parent().parent().parent().addClass(VP_CLASS_NODEEDITOR_MINIMIZE);
        //     }
        // });
    }

    // ** --------------------------- Block state 관련 메소드들 --------------------------- */
    Block.prototype.setState = function(newState) {
        this.state = changeOldToNewState(this.state, newState);
        this.consoleState();
        this.setCodeLineAndGet();
        this.setBlockTitle();

    }

    /**특정 state Name 값을 가져오는 함수
        @param {string} stateKeyName
    */
    Block.prototype.getState = function(stateKeyName) {
        return findStateValue(this.state, stateKeyName);
    }
    Block.prototype.getStateAll = function() {
        return this.state;
    }
    Block.prototype.consoleState = function() {
        // console.log(this.state);
    }

    /** 변경된 codeline state를 html title로 set */
    Block.prototype.setBlockTitle = function() {
        var codeLine = this.getCodeLine();

        var blockMainDom = this.getBlockMainDom();
        $(blockMainDom).attr(STR_TITLE,  codeLine);
    }

    /** ---------------------------이벤트 함수 바인딩--------------------------- */
    Block.prototype.bindEventAll = function() {
        /** 
         *  root 블럭은 x: 3칸, y: 1칸 고정 
         */
        var blockCodeLineType = this.getBlockCodeLineType();
        if (this.getPrevBlock() === null
            || blockCodeLineType === BLOCK_CODELINE_TYPE.ELIF
            || blockCodeLineType === BLOCK_CODELINE_TYPE.ELSE
            || blockCodeLineType === BLOCK_CODELINE_TYPE.EXCEPT
            || blockCodeLineType === BLOCK_CODELINE_TYPE.FINALLY
            || blockCodeLineType === BLOCK_CODELINE_TYPE.PASS_SUB
            || blockCodeLineType === BLOCK_CODELINE_TYPE.RETURN_SUB) {
            // this.bindDragEvent();
            this.bindClickEvent();
            this.bindDoubleClickEvent();
            return;
        }
        this.bindClickEvent();
        this.bindDoubleClickEvent();
        this.bindDragEvent();

    }

    Block.prototype.bindDoubleClickEvent = function() {
        var that = this;
        var blockMainDom = this.getBlockMainDom();

        $(blockMainDom).dblclick(function() {
            var blockContainerThis = that.getBlockContainerThis();
            blockContainerThis.setIsBlockDoubleClicked(true);

            var code = STR_NULL;

            var childLowerDepthBlockList = that.getChildLowerDepthBlockList();
            // var rootDepth = that.getDepth();
            var rootDepth = parseInt( $(that.getBlockMainDom()).attr(STR_DATA_DEPTH_ID) )
            if (isNaN(rootDepth) === true || rootDepth === undefined || rootDepth <= 0) {
                rootDepth = 0;
            }

            childLowerDepthBlockList.forEach( ( block,index ) => {
                if ( block.getBlockCodeLineType() === BLOCK_CODELINE_TYPE.HOLDER ) {
                    return;
                }

                var depth = parseInt( $(block.getBlockMainDom()).attr(STR_DATA_DEPTH_ID) ) - rootDepth;
                if (isNaN(depth) === true || depth === undefined || depth <= 0) {
                    depth = 0;
                }
       
                var _depth = depth;
                var indentPxNum = STR_NULL;

                var iteration = 0;
                while (_depth-- !== 0) {
                    indentPxNum += STR_ONE_INDENT;
                    if (iteration > NUM_MAX_ITERATION) {
                        console.log('무한루프');
                        break;
                    }
                    iteration++;
                }

                code += indentPxNum + block.setCodeLineAndGet();
                code += '\n';
            });

            blockContainerThis.setAPIBlockCode(code);
            blockContainerThis.generateCode(true);

        });
    }

    /** block drag event */
    Block.prototype.bindDragEvent = function() {
        var that = this;
        var uuid = this.getUUID();
        var blockName = this.getBlockName();
        var blockContainerThis = this.getBlockContainerThis();
        var blockCodeLineType = this.getBlockCodeLineType();

        var oldMainDom = this.getBlockMainDom();
        var x = 0;
        var y = 0;
        // var pos1 = 0;
        // var pos2 = 0;
        var pos3 = 0;
        var pos4 = 0;

        var iii = 0;
        var newMainDom = null;
        var moveChildListDom = null;

        var shadowBlock;
        var shadowBlockList = [];
        var rootBlockChildBlockListExceptChildBlock = [];
        var selectedBlock = null;
        var selectedBlockDirection = null;

        if (that.getIsClicked() === false) {
            $(oldMainDom).draggable({ 
                addClass: 'vp-dragable-btn',
                revert: 'invalid',
                revertDuration: 200,
                containment: VP_CLASS_NODEEDITOR_LEFT,
                cursor: 'move', 
                distance: 10,
                start: (event, ui) => {
                    
                    blockContainerThis.setFocusedPageTypeAndRender(FOCUSED_PAGE_TYPE.EDITOR);

                    newMainDom = document.createElement(STR_DIV);
                    newMainDom.classList.add('vp-block');
                    newMainDom.classList.add(`vp-block-${that.getUUID()}`);
                    $(newMainDom).css(STR_POSITION, STR_ABSOLUTE);
    
                    // var blockWidth = that.getWidth();
                    // $(newMainDom).css(STR_WIDTH, blockWidth);
    
                    var mainInnerDom = $(`<div class='vp-block-inner'></div>`);
                    var nameDom = renderMainHeaderDom(this);
                    $(mainInnerDom).append(nameDom);
                    $(newMainDom).append(mainInnerDom);
    
                    moveChildListDom = $(`<div class='vp-block-stack'><div>`);
                    var childLowerDepthBlockDomList = that.makeChildLowerDepthBlockDomList();
                    childLowerDepthBlockDomList.forEach(childDom => {
                        moveChildListDom.append(childDom);
                    });
       
                    $(newMainDom).append(moveChildListDom);
    
                    newMainDom = that.renderBlockLeftHolderDom(newMainDom);
    
                    // var blockWidth = that.getWidth();
                    // $(blockDom).css(STR_WIDTH, rect.width);
                    // console.log('rect.width', rect.width);
                    var rect = $(`.vp-block-${that.getUUID()}`)[0].getBoundingClientRect();
                    $(newMainDom).css(STR_WIDTH, rect.width);
                    $(VP_CLASS_NODEEDITOR_LEFT).append(newMainDom);
                    
                    /** 이동하는 하위 depth Block 들 */
                    var childLowerDepthBlockList = that.getChildLowerDepthBlockList();
                    childLowerDepthBlockList.forEach(block => {
                        var mainDom = block.getBlockMainDom();
                        $(mainDom).css(STR_OPACITY, '0');
                        $(mainDom).css(STR_DISPLAY, STR_NONE);

                        block.setIsMoved(true);
                    });
    
                    var rootBlockList = blockContainerThis.getRootBlockList();
                    rootBlockList.forEach((rootBlock, index) => {

                        
                        // var shadowChildBlockDomList = that.makeChildBlockDomList();
                        // shadowBlock = new ShadowBlock(blockContainerThis, blockCodeType, {pointX: 0, pointY: 0}, childLowerDepthBlockDomList,  BLOCK_TYPE.BLOCK, that);

                        var shadowChildBlockDomList = that.makeChildLowerDepthBlockDomList();
                        shadowBlock = new ShadowBlock(blockContainerThis, blockCodeLineType, {pointX: 0, pointY: 0}, shadowChildBlockDomList,  BLOCK_TYPE.BLOCK, that);
                        
                        shadowBlock.setRootBlockUUID(rootBlock.getUUID());
                        shadowBlockList.push(shadowBlock);
    
                        var containerDom = rootBlock.getContainerDom();
                        $(shadowBlock.getBlockMainDom()).css(STR_DISPLAY,STR_NONE);
                        $(shadowBlock.getBlockMainDom()).removeClass(VP_CLASS_SELECTED_SHADOWBLOCK);
                        $(containerDom).append(shadowBlock.getBlockMainDom());
                    });
    
                    that.setShadowBlock(shadowBlockList);
                    blockContainerThis.renderBlockLeftHolderListHeight();
                
                },
                drag:(event, ui) => {
                    blockContainerThis.setEventClientY(event.clientY);
                    /** 현재 drag하는 Block의 위치 구현 */
                    blockContainerThis.renderBlockLeftHolderListHeight();
                    var rect = that.getBlockMainDomPosition();
                    
                    that.setPointX(rect.x);
                    that.setPointY(rect.y);
    
                    buttonX = event.clientX; 
                    buttonY = event.clientY; 
    
                    pos1 = pos3 - buttonX;
                    pos2 = pos4 - buttonY;
                    pos3 = buttonX;
                    pos4 = buttonY;
    
                    var scrollHeight =  blockContainerThis.getScrollHeight();
                    var maxWidth =  blockContainerThis.getMaxWidth();
                    // var blockWidth = that.getWidth();
                    /** 블럭 드래그시 
                     *  왼쪽 정렬   x = buttonX - pos2 - $(VP_CLASS_NODEEDITOR_LEFT).offset().left  
                     *  가운데 정렬 x = buttonX - pos2 - $(VP_CLASS_NODEEDITOR_LEFT).offset().left - blockWidth / 2
                     *  오른쪽 정렬 x = buttonX - pos2 - $(VP_CLASS_NODEEDITOR_LEFT).offset().left - blockWidth
                     */
                    x = buttonX - $(VP_CLASS_NODEEDITOR_LEFT).offset().left;
                    y = buttonY - ( $(VP_CLASS_NODEEDITOR_LEFT).offset().top - $(VP_CLASS_NODEEDITOR_LEFT).scrollTop() );
    
                    // if (x < 0) {
                    //     x = 0;
                    // }
                    /** 이동한 블럭들의 루트블럭 x좌표가 editor 화면의 maxWidth 이상 일때 */
                    if (x > maxWidth - $(newMainDom).width()) {
                        x = maxWidth - $(newMainDom).width();
                    }
                    /** 이동한 블럭들의 루트블럭 y좌표가 editor 화면의 maxHeight 이상 일때 */
                    if (y > scrollHeight - ( $(moveChildListDom).height() + NUM_BLOCK_HEIGHT_PX ) ) {
                        y = scrollHeight - ( $(moveChildListDom).height() + NUM_BLOCK_HEIGHT_PX );
                    }
                    /** 이동한 블럭들의 루트블럭 y좌표가 0 이하 일때 */
                    if (y < 0) {
                        y = 0;
                    }
    
                    $(newMainDom).css(STR_TOP,`${y}` + STR_PX);
                    $(newMainDom).css(STR_LEFT,`${x}` + STR_PX);
         
                    /** 블록 전체를 돌면서 drag하는 Block과 Editor위에 생성된 블록들과 충돌 작용  */
                    var blockList = blockContainerThis.getBlockList();
                    blockList.forEach( (block, index) => {
                        
                        /** 자기 자신인 블럭과는 충돌 금지 */
                        if (that.getUUID() === block.getUUID()) {
                            return;
                        }

                        /** elif 블럭의 down 방향으로 블럭 생성 금지  */
                            if (block.getBlockCodeLineType() === BLOCK_CODELINE_TYPE.HOLDER
                            && (block.getSupportingBlock().getBlockCodeLineType() === BLOCK_CODELINE_TYPE.ELIF )) {
                            return;
                        }

                        /** 1. if 블럭과 elif블럭의 사이 생성 금지 
                         *  2. else 블럭의 down 방향으로 블럭 생성 금지  
                         */
                        if (block.getBlockCodeLineType() === BLOCK_CODELINE_TYPE.HOLDER
                            && (block.getSupportingBlock().getBlockCodeLineType() === BLOCK_CODELINE_TYPE.IF)) {
                            var is = block.getNextBlockList().some(nextBlock => {
                                if (nextBlock.getBlockCodeLineType() === BLOCK_CODELINE_TYPE.ELIF 
                                    || nextBlock.getBlockCodeLineType() === BLOCK_CODELINE_TYPE.ELSE) {
                                    return true;
                                }
                            });
                            if (is === true) {
                                return;
                            }
                        }

                        /** board에 생성된 block 중에 
                         * block 하위 뎁스 자식 block리스트 와 그 외 block 리스트를 분리 
                         */
                        var rootBlock = block.getRootBlock();
                        var childBlockList = that.getChildLowerDepthBlockList();
                        var rootBlockChildBlockList = rootBlock.getChildBlockList();
                        rootBlockChildBlockList.forEach((rootBlockChildBlock) => {
                            var is = childBlockList.some((childBlock) => {
                                if ( rootBlockChildBlock.getUUID() === childBlock.getUUID() ) {
                                    return true;
                                } 
                            });
    
                            if (is !== true) {
                                rootBlockChildBlockListExceptChildBlock.push(rootBlockChildBlock);
                            } 
                        });

                        /** 충돌할 block의 x,y, width, height를 가져온다 */
                        var blockCodeLineType = block.getBlockCodeLineType();
                        var { x, y, 
                              width: blockWidth, height: blockHeight} = block.getBlockMainDomPosition();

                        /** 블럭 충돌에서 벗어나는 로직 */
                        var blockLeftHolderHeight = block.getTempBlockLeftHolderHeight();
                        if ( (x > buttonX 
                              || buttonX > (x + blockWidth)
                              || y  > buttonY 
                              || buttonY > (y + blockHeight + blockHeight + blockHeight + blockLeftHolderHeight) )
                   
                            // && block.getIsCollision() === true 
                            ) {
    
                            var isShadowBlock = shadowBlockList.some(shadowBlock => {
                                if (shadowBlock.getSelectBlock() && shadowBlock.getSelectBlock().getUUID() === block.getUUID()) {
                                    return true;
                                }
                            });
    
                            if (isShadowBlock === false) {
                                if ( block.getHolderBlock() ) {
                                    $( block.getHolderBlock().getBlockMainDom() ).css(STR_DISPLAY, STR_NONE);
                                }
                                var blockLeftHolderDom = block.getBlockLeftHolderDom();
                                $(blockLeftHolderDom).css(STR_DISPLAY, STR_NONE);
                                block.setIsCollision(false);
    
                                that.renderHolderRadius();
                            }
                        }

                        /** 블럭 충돌 left holder shadow 생성 로직 */
                        if ( x < buttonX
                            && buttonX < (x + blockWidth )
                            && y  < buttonY
                            && buttonY < (y  + blockHeight + blockHeight + blockLeftHolderHeight    ) ) {     
                            block.renderBlockHolderShadow_2(STR_BLOCK);
                        }
                        /** 블럭 충돌 로직 */  
                        if ( x < buttonX
                                && buttonX < (x + blockWidth + blockWidth)
                                && y  < buttonY
                                && buttonY < (y + blockHeight  + blockHeight) ) { 
                                

                            block.setIsCollision(true);
                            var blockList = blockContainerThis.getBlockList();
                            blockList.forEach(block => {
                                block.setIsCollision(false);
                            });
    
                            that.renderHolderRadius();
    
                            var rootBlockList = blockContainerThis.getRootBlockList();
    
                            shadowBlockList.some(shadowBlock => {
                                if (shadowBlock.getRootBlockUUID() === rootBlock.getUUID()) {
                                    var isChild = childBlockList.some(childBlock => {
                                        if (childBlock.getUUID() === block.getUUID()) {
                                            return true;
                                        }
                                    });
                                    if (isChild === true) {
                                        return true;
                                    }
    
                                    /** shadow 블록 생성하는 로직
                                     * css class로 마크만 해둔다
                                     * 내가 이동한 블럭이 루트 블럭일 경우 쉐도우 블록을 생성하지 않는다 
                                     */
                                    if (that.getUUID() !== rootBlock.getUUID() ) {         
                                        // console.log(STR_BLOCK, block.getBlockName());
                                        $(shadowBlock.getBlockMainDom()).css(STR_DISPLAY,STR_BLOCK);
                                        $(shadowBlock.getBlockMainDom()).addClass(VP_CLASS_SELECTED_SHADOWBLOCK);
                                        shadowBlock.setSelectBlock(block);
                                    }
    
                                    return true;
                                }
                            });
    
                            /** 충돌시 direction 설정
                             * direction은 DOWN,  INDENT
                             */
                            if (blockCodeLineType === BLOCK_CODELINE_TYPE.CLASS || blockCodeLineType === BLOCK_CODELINE_TYPE.DEF 
                                || blockCodeLineType === BLOCK_CODELINE_TYPE.IF || blockCodeLineType === BLOCK_CODELINE_TYPE.FOR 
                                || blockCodeLineType === BLOCK_CODELINE_TYPE.WHILE || blockCodeLineType === BLOCK_CODELINE_TYPE.TRY 
                                || blockCodeLineType === BLOCK_CODELINE_TYPE.ELSE || blockCodeLineType === BLOCK_CODELINE_TYPE.ELIF 
                                || blockCodeLineType === BLOCK_CODELINE_TYPE.FOR_ELSE || blockCodeLineType === BLOCK_CODELINE_TYPE.EXCEPT 
                                || blockCodeLineType === BLOCK_CODELINE_TYPE.FINALLY ) {
                                selectedBlockDirection = BLOCK_DIRECTION.INDENT;
                            } else if (blockCodeLineType === BLOCK_CODELINE_TYPE.HOLDER) {
                                selectedBlockDirection = BLOCK_DIRECTION.DOWN; 
                            } else {
                                selectedBlockDirection = BLOCK_DIRECTION.DOWN; 
                            }
    
                            rootBlock.reArrangeChildBlockDomList(block, rootBlockChildBlockListExceptChildBlock, selectedBlockDirection);
                            blockContainerThis.renderBlockLeftHolderListHeight();
                        } else {
                
                            /** shadow 블록 생성하는 로직
                             * css class로 마크된 block을 selectedBlock에 저장 한다
                             */
                            if ( blockCodeLineType === BLOCK_CODELINE_TYPE.CLASS || blockCodeLineType === BLOCK_CODELINE_TYPE.DEF 
                                || blockCodeLineType === BLOCK_CODELINE_TYPE.IF || blockCodeLineType === BLOCK_CODELINE_TYPE.FOR 
                                || blockCodeLineType === BLOCK_CODELINE_TYPE.WHILE || blockCodeLineType === BLOCK_CODELINE_TYPE.TRY 
                                || blockCodeLineType === BLOCK_CODELINE_TYPE.ELSE || blockCodeLineType === BLOCK_CODELINE_TYPE.ELIF 
                                || blockCodeLineType === BLOCK_CODELINE_TYPE.FOR_ELSE || blockCodeLineType === BLOCK_CODELINE_TYPE.EXCEPT 
                                || blockCodeLineType === BLOCK_CODELINE_TYPE.FINALLY ) {
                                var is = shadowBlockList.some(shadowBlock => {
                                    if ( $(shadowBlock.getBlockMainDom()).hasClass(VP_CLASS_SELECTED_SHADOWBLOCK) ) {
                                        selectedBlock = shadowBlock.getSelectBlock();
                                        return true;
                                    }
                                });
                            }
                            var rootBlock = blockContainerThis.getRootBlock();
                            var containerDom = rootBlock.getContainerDom();
                            var containerDomRect = $(containerDom)[0].getBoundingClientRect();
                            var { x, y, width: containerDomWidth, height: containerDomHeight} = containerDomRect;
            
                            if ( x < event.clientX
                                && event.clientX < (x + containerDomWidth)
                                && y  < event.clientY
                                && event.clientY < (y + containerDomHeight) ) {  
                                // console.log('in colision');
                            } else {
                                /** shadow 블록 해제하는 로직
                                 * css class로 마크된 block을 selectedBlock에 저장 한다
                                 */
                                shadowBlockList.forEach(shadowBlock => {
                                    if (shadowBlock.getRootBlockUUID() === rootBlock.getUUID()) {
                                        $(shadowBlock.getBlockMainDom()).css(STR_DISPLAY,STR_NONE);
                                        $(shadowBlock.getBlockMainDom()).removeClass(VP_CLASS_SELECTED_SHADOWBLOCK);
                                        shadowBlock.setSelectBlock(null);
                                        selectedBlock = null;
                                    }    
                                });
                                // console.log('not colision');
                            }
                        }
                        rootBlockChildBlockListExceptChildBlock = [];
                    });
                }, 
                stop: function(event, ui) {

                    // 화면 밖으로 나갔을 때, 재조정
                    var maxWidth =  blockContainerThis.getMaxWidth();
                    var maxHeight =  blockContainerThis.getMaxHeight();

                    var mainDom = that.getBlockMainDom();
    
                    var isDisappeared = false;
                    /** 이동한 블럭들의 루트블럭 x좌표가 0 이하 일때 */
                    if (x < 0) {
                        x = 0;
                        isDisappeared = true;
                    }
                    /** 이동한 블럭들의 루트블럭 x좌표가 editor 화면의 maxWidth 이상 일때 */
                    if (x > maxWidth - $(mainDom).width()) {
                        x = maxWidth - $(mainDom).width();
                        isDisappeared = true;
                    }
                    /** 이동한 블럭들의 루트블럭 y좌표가 editor 화면의 maxHeight 이상 일때 */
                    if (y > maxHeight - ( $(moveChildListDom).height() + NUM_BLOCK_HEIGHT_PX ) ) {
                        y = maxHeight - ( $(moveChildListDom).height() + NUM_BLOCK_HEIGHT_PX );
    
                    }
                    /** 이동한 블럭들의 루트블럭 y좌표가 0 이하 일때 */
                    if (y < 0) {
                        y = 0;
                        isDisappeared = true;
                    }
    
                    shadowBlockList.forEach(shadowBlock => {
                        if ( $(shadowBlock.getBlockMainDom()).hasClass(VP_CLASS_SELECTED_SHADOWBLOCK) ) {
                            selectedBlock = shadowBlock.getSelectBlock();
                        } 
                    });
    
                    /** 블록이 화면 밖으로 나갈경우, 나간 블럭 전부 삭제 */
                    if (isDisappeared === true && !selectedBlock) {
                    
                        that.deleteBlock();
                        {
                            $(newMainDom).remove();
    
                            $(oldMainDom).remove();
                            $(oldMainDom).empty();
                    
                            $(moveChildListDom).remove();
                            $(moveChildListDom).empty();
    
                            var _containerDom = that.getContainerDom();
                            $(_containerDom).remove();
                            $(_containerDom).empty();
                        }
                        blockContainerThis.reRenderBlockList();

                    /** 블록이 화면 밖으로 나가지 않고 연결되는 경우 */
                    } else {
                        var isConntected = true;
                        /** 어떤 블록의 DOWN이나 INDENT로 조립되지 않는 경우 */
                        // console.log('어떤 블록의 DOWN이나 INDENT로 조립되지 않는 경우');
                        if (!selectedBlock) {
                            /** 이동한 block의 prevBlock이 rootblock일 경우 */
                            if ( that.getPrevBlock().getUUID() === blockContainerThis.getRootBlock().getUUID() ) {
                                isConntected = false;
            
                                if ( blockCodeLineType === BLOCK_CODELINE_TYPE.CLASS || blockCodeLineType === BLOCK_CODELINE_TYPE.DEF
                                    || blockCodeLineType === BLOCK_CODELINE_TYPE.IF || blockCodeLineType === BLOCK_CODELINE_TYPE.FOR
                                    || blockCodeLineType === BLOCK_CODELINE_TYPE.WHILE || blockCodeLineType === BLOCK_CODELINE_TYPE.TRY 
                                    || blockCodeLineType === BLOCK_CODELINE_TYPE.ELIF || blockCodeLineType === BLOCK_CODELINE_TYPE.ELSE 
                                    || blockCodeLineType === BLOCK_CODELINE_TYPE.FOR_ELSE || blockCodeLineType === BLOCK_CODELINE_TYPE.EXCEPT
                                    || blockCodeLineType === BLOCK_CODELINE_TYPE.FINALLY ) {
                                    selectedBlock = blockContainerThis.getRootToLastBottomBlock();
                                } else {
                                    selectedBlock = blockContainerThis.getRootToLastBottomBlock();
                                }

                            /** 이동한 block의 prevBlock이 rootblock일 경우 */
                            } else {
                                isConntected = false;
                                var lastBottomBlock = blockContainerThis.getRootToLastBottomBlock();
              
                                /** block board의  */
                                var isFinalBlock = that.getChildLowerDepthBlockList().some(block => {
                                    if ( block.getUUID() === lastBottomBlock.getUUID() ) {
                                        if (lastBottomBlock.getBlockCodeLineType() === BLOCK_CODELINE_TYPE.HOLDER) {
                                            selectedBlock = lastBottomBlock.getPrevBlock().getPrevBlock();
                                        } else {
                                            selectedBlock = lastBottomBlock.getPrevBlock();
                                        }
                                        return true;
                                    }
                                });

                                if (isFinalBlock === false) {
                                    selectedBlock = lastBottomBlock;
                                }
                            }

                        /** 특정 블록의 DOWN이나 INDENT로 조립된 경우 */
                        // console.log('특정 블록의 DOWN이나 INDENT로 조립된 경우');    
                        } else {
                            // console.log('특정 블록의 DOWN이나 INDENT로 조립된 경우 ');
                        }
                      
                        $(oldMainDom).remove();
                        $(moveChildListDom).remove();
                        $(moveChildListDom).empty();

                        var childBlockList = that.getChildBlockList();
                        childBlockList.forEach(block => {
                            var mainDom = block.getBlockMainDom();
                            $(mainDom).css(STR_OPACITY, '1');
                            $(mainDom).css(STR_DISPLAY, STR_BLOCK);
                        });
   

                        if (isConntected === false) {
                             /** 어떤 블록의 DOWN이나 INDENT로 조립되지 않는 경우 */
                            selectedBlock.appendBlock(that, BLOCK_DIRECTION.DOWN);
                        } else {
                            selectedBlock.appendBlock(that, selectedBlockDirection);
                        }

                        {
                            var myContainerDom = that.getContainerDom();
                            $(myContainerDom).remove();
                            $(myContainerDom).empty();
                        }
    
                        var _containerDom = selectedBlock.getRootBlock().getContainerDom();
    
                        var rootBlock = selectedBlock.getRootBlock();
                        var containerDom = document.createElement(STR_DIV);
                        containerDom.classList.add(VP_CLASS_BLOCK_CONTAINER);
     
                        blockContainerThis.renderBlockLeftHolderListHeight();

                        rootBlock.setContainerDom(containerDom);
                        var rootBlockStackList = rootBlock.renderChildBlockListIndentAndGet();
                        // var rootBlockStackList = rootBlock.renderChildLowerDepthBlockListIndentAndGet();
                        rootBlockStackList.forEach((block,index) => {
                         
                            var newBlockDom = null;
                            if (block.getUUID() === that.getUUID()) {
                                newBlockDom = newMainDom;
                             
                            } else {
                                newBlockDom = block.getBlockMainDom();
                            }
                            $(newBlockDom).css(STR_POSITION, STR_RELATIVE);
                            $(newBlockDom).css(STR_WIDTH, STR_INHERIT);
                            
                            newBlockDom = block.renderBlockLeftHolderDom(newBlockDom);
                            $(containerDom).append(newBlockDom);
                            // block.setBlockDom(newBlockDom);

                            var blockCodeType = block.getBlockCodeLineType();
                            if (( blockCodeType === BLOCK_CODELINE_TYPE.CLASS || blockCodeType === BLOCK_CODELINE_TYPE.DEF || blockCodeType === BLOCK_CODELINE_TYPE.IF ||
                                blockCodeType === BLOCK_CODELINE_TYPE.FOR || blockCodeType === BLOCK_CODELINE_TYPE.WHILE || blockCodeType === BLOCK_CODELINE_TYPE.TRY
                                || blockCodeType === BLOCK_CODELINE_TYPE.ELSE || blockCodeType === BLOCK_CODELINE_TYPE.ELIF || blockCodeType === BLOCK_CODELINE_TYPE.FOR_ELSE 
                                || blockCodeType === BLOCK_CODELINE_TYPE.EXCEPT || blockCodeType === BLOCK_CODELINE_TYPE.FINALLY)) {
    
                                var is = block.getNextBlockList().some(nextBlock => {
                                    if (nextBlock.getDirection() === BLOCK_DIRECTION.INDENT) {
                                        return true;
                                    }
                                });
                                if (is === false) {
                                    $(containerDom).append(block.getHolderBlock().getBlockMainDom());
                                }
                            }
                            block.setBlockDom(newBlockDom);
                            block.bindEventAll();

                        });
    
                        $(VP_CLASS_NODEEDITOR_LEFT).append(containerDom);
            
                        $(_containerDom).remove();
                        $(_containerDom).empty();
    
                        that.bindEventAll();
                        that.selectThisBlock();
   
                    }
     
                    // blockContainerThis.mapBlockListDataToBlockJson();
                    var blockList = blockContainerThis.getBlockList();
                    blockList.forEach(block => {
                        block.renderHolderRadius();
                        
                        block.renderBlockHolderShadow(STR_NONE);
                        block.calculateWidthAndSet();
                    });

                    that.renderResetColor();
                    that.renderSelectedBlockColor();
                    that.selectThisBlock();
                    that.calculateDepthFromRootBlockAndSetDepth();
                    that.renderEditorScrollTop();

                    blockContainerThis.renderBlockOptionTab();
                    blockContainerThis.renderBlockLeftHolderListHeight();
                    blockContainerThis.reRenderBlockList();
                    blockContainerThis.renderBlockLineNumberInfoDom();

                }
            });
        }
        // console.log('blockName', blockName, 'uuid',uuid);
        // blockContainerThis.traverseBlockList();
    }

    /**
     * block 클릭시 block border 노란색으로 변경
     */
    Block.prototype.renderSelectedBlockColor = function() {
        var that = this;

        this.setIsCtrlPressed(true);

        var mainDom = this.getBlockMainDom();
        $(mainDom).css(STR_BORDER,'2px solid yellow');
        // $(mainDom).find(VP_CLASS_BLOCK_LEFT_HOLDER).css(STR_BACKGROUND_COLOR,'yellow');
        $(mainDom).find(VP_CLASS_BLOCK_LEFT_HOLDER).css(STR_BOX_SHADOW, '0 1px 4px rgba(0, 0, 0, .6)');
        if (that.getHolderBlock()) {
            $(that.getHolderBlock().getBlockMainDom()).css(STR_BOX_SHADOW, '0 1px 4px rgba(0, 0, 0, .6)');
            $(that.getHolderBlock().getBlockMainDom()).css(STR_BORDER, '2px solid yellow');
        }

    }

    /**
     *  block border transparent 색으로 변경
     */
    Block.prototype.renderUnselectedBlockColor = function() {
        var that = this;
        var mainDom = this.getBlockMainDom();
        $(mainDom).css(STR_BORDER,'2px solid transparent');
        // $(mainDom).find(VP_CLASS_BLOCK_LEFT_HOLDER).css(STR_BACKGROUND_COLOR,'yellow');
        $(mainDom).find(VP_CLASS_BLOCK_LEFT_HOLDER).css(STR_BOX_SHADOW, '0');
        if (that.getHolderBlock()) {
            $(that.getHolderBlock().getBlockMainDom()).css(STR_BOX_SHADOW, '0');
            $(that.getHolderBlock().getBlockMainDom()).css(STR_BORDER,'2px solid transparent');
        }
    }
    /**
     * block hover시 발생하는 이벤트 함수
     */
    Block.prototype.bindClickEvent = function() {

        var that = this;
        var blockContainerThis = that.getBlockContainerThis();
        var mainDom = that.getBlockMainDom();
        var blockCodeLineType = that.getBlockCodeLineType();

        var deleteBtn = renderDeleteBlockButton();

        /** block 클릭 */
        $(mainDom).click(function(e){

            that.setIsClicked(true);

            if(e.ctrlKey === true){
                if (that.getIsCtrlPressed() === true) {
                    that.setIsCtrlPressed(false);
                    that.renderUnselectedBlockColor();
                } else {
                    that.renderSelectedBlockColor();
                    that.selectThisBlock();
                    that.renderBottomOption();
                }
              
            } else {
                that.renderResetColor();
                that.selectThisBlock();
                that.renderSelectedBlockColor();
    
                that.renderBottomOption();
            }

            var blockList = blockContainerThis.getBlockList();
            blockList.forEach(block => {
                var mainDom = block.getBlockMainDom();
                $(mainDom).find(VP_CLASS_BLOCK_DELETE_BTN).remove();
                $(mainDom).find(VP_CLASS_BLOCK_OPTION_BTN).remove();
            });
            $(mainDom).append(deleteBtn);

            blockContainerThis.renderBlockLeftHolderListHeight();

            /** block 삭제 버튼 클릭 */
            $(deleteBtn).click(function(event) { 
                 /** block에 ctrl + 클릭이 몇번 되었는지 체크 */
                var blockList = blockContainerThis.getBlockList();
                var numIsCtrlPressed = 0;
                var isCtrlPressedBlockList = [];
                blockList.some(block => {
                    if ( block.getIsCtrlPressed() === true) {
                        numIsCtrlPressed++;
                        isCtrlPressedBlockList.push(block);
                    };
                });
                
                /** block에 ctrl + 클릭이 2회 이상 */
                if ( numIsCtrlPressed > 1 ) {
           
                    isCtrlPressedBlockList.some(block => {
                        if ( block.getPrevBlock() === null ) {
                            block.clickBlockDeleteButton();
                            return true;
                        }
                        block.deleteLowerDepthChildBlocks();
                        block.renderResetBottomOption();
                        block.renderResetBottomLowerDepthChildsBlockOption();
                        
                        if (blockCodeLineType === BLOCK_CODELINE_TYPE.ELSE 
                            || blockCodeLineType=== BLOCK_CODELINE_TYPE.FOR_ELSE
                            || blockCodeLineType=== BLOCK_CODELINE_TYPE.FINALLY) {
                            var parentBlock = block.getParentBlock()
                            blockContainerThis.deleteElseBlockEvent(parentBlock, blockCodeLineType);
                        }
                
                        blockContainerThis.reRenderBlockList();
                
                        /** root block이 아니어야 block number 오름차순 sort 실행 */
                        if (block.getPrevBlock() !== null) {
                            blockContainerThis.renderBlockLineNumberInfoDom_sortBlockLineAsc();
                        }
                    });
                /** block에 ctrl + 클릭이 1회 이상 */
                } else {
                    that.clickBlockDeleteButton(); 
                }
          
            });

            /** 옵션 창 리셋 */
            that.renderResetBottomLowerDepthChildsBlockOption();
            that.renderResetBottomOption();
            blockContainerThis.renderBlockOptionTab();

            that.setIsClicked(false);

        });
    }

    /** block을 삭제할 때 실행되는 메소드 */
    Block.prototype.clickBlockDeleteButton = function() {
        var blockContainerThis = this.getBlockContainerThis();
        var blockCodeLineType = this.getBlockCodeLineType();
        this.deleteLowerDepthChildBlocks();
        this.renderResetBottomOption();
        this.renderResetBottomLowerDepthChildsBlockOption();
        
        if (blockCodeLineType === BLOCK_CODELINE_TYPE.ELSE 
            || blockCodeLineType=== BLOCK_CODELINE_TYPE.FOR_ELSE
            || blockCodeLineType=== BLOCK_CODELINE_TYPE.FINALLY) {
            var parentBlock = this.getParentBlock()
            blockContainerThis.deleteElseBlockEvent(parentBlock, blockCodeLineType);
        }

  

        /** root block이 아니어야 block number 오름차순 sort 실행 */
        if (this.getPrevBlock() !== null) {
            blockContainerThis.renderBlockLineNumberInfoDom_sortBlockLineAsc();
        }

        this._deleteBlockDomAndData();
        blockContainerThis.reRenderBlockList();
    }

    /** block shadow에 radius 디자인을 주는 메소드 */
    Block.prototype.renderHolderRadius = function() {
        if (this.getBlockCodeLineType() === BLOCK_CODELINE_TYPE.HOLDER) {
            $(this.getBlockMainDom()).removeClass('vp-block-style-border-top-left-radius');
        } else if (this.getHolderBlock() && this.getHolderBlock().getBlockCodeLineType() === BLOCK_CODELINE_TYPE.HOLDER) {
            $(this.getHolderBlock().getBlockMainDom()).removeClass('vp-block-style-border-top-left-radius');
        } else {
            $(this.getBlockMainDom()).removeClass('vp-block-style-border-bottom-left-radius');
        }
    }

    /** block shadow를 만드는 메소드 1 */
    Block.prototype.renderBlockHolderShadow = function(NONE_OR_BLOCK) {
        if (this.getBlockCodeLineType() === BLOCK_CODELINE_TYPE.HOLDER) {
            var blockMainDom = this.getBlockMainDom();
            $(blockMainDom).css(STR_DISPLAY, NONE_OR_BLOCK);
        }
        var blockLeftHolderDom = this.getBlockLeftHolderDom();
        $(blockLeftHolderDom).css(STR_DISPLAY, NONE_OR_BLOCK);
    }

    /** block shadow를 만드는 메소드 2 */
    Block.prototype.renderBlockHolderShadow_2 = function(NONE_OR_BLOCK) {
        if ( this.getHolderBlock() ) {
            $( this.getHolderBlock().getBlockMainDom() ).css(STR_DISPLAY, NONE_OR_BLOCK);
        }
        var blockLeftHolderDom = this.getBlockLeftHolderDom();
        $(blockLeftHolderDom).css(STR_DISPLAY, NONE_OR_BLOCK);
    }

    /** block 선택시 발생하는 메소드 */
    Block.prototype.selectThisBlock = function() {
        var blockList = this.blockContainerThis.getBlockList();
        blockList.forEach(block => {
            block.setState({
                isSelected: false
            });
            
            /** FIXME: 임시 코드 */

            var blockCodeType = block.getBlockCodeLineType();
            if (blockCodeType === BLOCK_CODELINE_TYPE.CLASS || blockCodeType === BLOCK_CODELINE_TYPE.DEF) {
                $(block.getBlockMainDom()).find(VP_CLASS_BLOCK_LEFT_HOLDER).css(STR_BACKGROUND_COLOR, COLOR_ORANGE);

            } 

            else if (blockCodeType === BLOCK_CODELINE_TYPE.IF || blockCodeType === BLOCK_CODELINE_TYPE.FOR
                || blockCodeType === BLOCK_CODELINE_TYPE.WHILE || blockCodeType === BLOCK_CODELINE_TYPE.TRY
                || blockCodeType === BLOCK_CODELINE_TYPE.ELSE || blockCodeType === BLOCK_CODELINE_TYPE.ELIF 
                || blockCodeType === BLOCK_CODELINE_TYPE.FOR_ELSE || blockCodeType === BLOCK_CODELINE_TYPE.EXCEPT 
                || blockCodeType === BLOCK_CODELINE_TYPE.FINALLY) {
                $(block.getBlockMainDom()).find(VP_CLASS_BLOCK_LEFT_HOLDER).css(STR_BACKGROUND_COLOR, COLOR_BLOCK_YELLOW);
            } 

        });

        $(this.getBlockMainDom()).find(VP_CLASS_BLOCK_LEFT_HOLDER).css(STR_BACKGROUND_COLOR, COLOR_YELLOW);

        this.setState({
            isSelected: true
        });
    }

    Block.prototype.getIsSelected = function() {
        return this.state.isSelected;
    }

    /** Block Editor에 Scroll이 생성 될지 안 될지 결정하는 메소드
     *  그 외 0% ~70% 
     *        70% ~ 100% 화면 scroll 조정 함
    */
    Block.prototype.renderEditorScrollTop = function(isNewBlock) {
        var blockContainerThis = this.getBlockContainerThis();
        var blockChildList = blockContainerThis.getRootBlock().getChildBlockList();
        
        var minusIndex = 0;
        var blockNumber = 0;

        blockChildList.some((block, index) => {
            if (block.getBlockCodeLineType() !== BLOCK_CODELINE_TYPE.HOLDER) {
                if (this.getUUID() === block.getUUID()) {
                    blockNumber = index - minusIndex;
                    return true;
                }
            } else {
                minusIndex++;
            }
        });

        var maxHeight = blockContainerThis.getMaxHeight();
        var scrollHeight = blockContainerThis.getScrollHeight();

        if (scrollHeight >= maxHeight) {
            $(VP_CLASS_NODEEDITOR_SCROLLBAR).css(STR_OVERFLOW_X, STR_HIDDEN);
            $(VP_CLASS_NODEEDITOR_SCROLLBAR).css(STR_OVERFLOW_Y, STR_AUTO);

        } else {
            $(VP_CLASS_NODEEDITOR_SCROLLBAR).css(STR_OVERFLOW_X, STR_HIDDEN);
            $(VP_CLASS_NODEEDITOR_SCROLLBAR).css(STR_OVERFLOW_Y, STR_HIDDEN);
        }
        
        var eventClientY = blockContainerThis.getEventClientY();
        if (isNewBlock === true) {
         
        } else if (eventClientY < $(window).height() * 0.68) {
            return;
        }

        var thisBlockFromRootBlockHeight = 0;
        while(blockNumber !== 0) {
            blockNumber--;
            thisBlockFromRootBlockHeight += NUM_BLOCK_MARGIN_TOP_PX;
            thisBlockFromRootBlockHeight += NUM_BLOCK_HEIGHT_PX;
            thisBlockFromRootBlockHeight += NUM_BLOCK_MARGIN_BOTTOM_PX;
        }
        if (thisBlockFromRootBlockHeight === 0) {
            thisBlockFromRootBlockHeight = blockContainerThis.getThisBlockFromRootBlockHeight();
             $(VP_CLASS_NODEEDITOR_LEFT).animate({
                scrollTop: thisBlockFromRootBlockHeight 
            }, 100);
            return;
        } else {
            blockContainerThis.setThisBlockFromRootBlockHeight(thisBlockFromRootBlockHeight);  
        }
    
        $(VP_CLASS_NODEEDITOR_LEFT).scrollTop(thisBlockFromRootBlockHeight);
    }

    Block.prototype.getState_IsIfElseOrIsForElseOrIsFinally = function() {
        var blockCodeLineType = this.getBlockCodeLineType();
        var stateStr = '';
        if (blockCodeLineType === BLOCK_CODELINE_TYPE.ELSE) {
            stateStr = STATE_isIfElse;
        } else if (blockCodeLineType === BLOCK_CODELINE_TYPE.FOR_ELSE) {
            stateStr = STATE_isForElse;
        } else {
            stateStr = STATE_isFinally;
        }
        return stateStr;
    }

    /** routrMapApi */
    var BLOCK_MAP = new Map();
    BLOCK_MAP.set(BLOCK_CODELINE_TYPE.CLASS, Block);
    BLOCK_MAP.set(BLOCK_CODELINE_TYPE.DEF, Block);
    BLOCK_MAP.set(BLOCK_CODELINE_TYPE.IF, Block);
    BLOCK_MAP.set(BLOCK_CODELINE_TYPE.FOR, Block);
    BLOCK_MAP.set(BLOCK_CODELINE_TYPE.WHILE, Block);
    BLOCK_MAP.set(BLOCK_CODELINE_TYPE.IMPORT, Block);
    BLOCK_MAP.set(BLOCK_CODELINE_TYPE.TRY, Block);
    BLOCK_MAP.set(BLOCK_CODELINE_TYPE.API, Block);

    BLOCK_MAP.set(BLOCK_CODELINE_TYPE.RETURN, Block);
    BLOCK_MAP.set(BLOCK_CODELINE_TYPE.BREAK, Block);
    BLOCK_MAP.set(BLOCK_CODELINE_TYPE.CONTINUE, Block);
    BLOCK_MAP.set(BLOCK_CODELINE_TYPE.PASS, Block);
    BLOCK_MAP.set(BLOCK_CODELINE_TYPE.PROPERTY, Block);

    BLOCK_MAP.set(BLOCK_CODELINE_TYPE.ELIF, Block);
    BLOCK_MAP.set(BLOCK_CODELINE_TYPE.ELSE, Block);
    BLOCK_MAP.set(BLOCK_CODELINE_TYPE.FOR_ELSE, Block);

    BLOCK_MAP.set(BLOCK_CODELINE_TYPE.INIT, Block);
    BLOCK_MAP.set(BLOCK_CODELINE_TYPE.DEL, Block);
    BLOCK_MAP.set(BLOCK_CODELINE_TYPE.EXCEPT, Block);
    BLOCK_MAP.set(BLOCK_CODELINE_TYPE.FINALLY, Block);

    BLOCK_MAP.set(BLOCK_CODELINE_TYPE.CODE, Block);
    BLOCK_MAP.set(BLOCK_CODELINE_TYPE.HOLDER, Block);
    BLOCK_MAP.set(BLOCK_CODELINE_TYPE.NULL, Block);

    BLOCK_MAP.set(BLOCK_CODELINE_TYPE.RETURN_SUB, Block);
    BLOCK_MAP.set(BLOCK_CODELINE_TYPE.BREAK_SUB, Block);
    BLOCK_MAP.set(BLOCK_CODELINE_TYPE.CONTINUE_SUB, Block);
    BLOCK_MAP.set(BLOCK_CODELINE_TYPE.PASS_SUB, Block);
    BLOCK_MAP.set(BLOCK_CODELINE_TYPE.PROPERTY_SUB, Block);

    var mapTypeToBlock = function(blockContainerThis, enumData, pointObj, isSubBlock) {
        if (BLOCK_MAP.has(enumData)) {
            var blockConstructor = BLOCK_MAP.get(enumData);
            return new blockConstructor(blockContainerThis, enumData, pointObj, isSubBlock)
        } else {
            /**  FIXME: 추후 제거*/
            alert('존재하지 않는 BLOCK ENUM 입니다');
        }
    }

    return {
        Block, mapTypeToBlock
    };
});
