<!--
#========================================================================
# Filename : README.md
# Function : control visualpython for Window/Linux/Mac
# Creator  : Black Logic
# Version  : 1.1.1
# License  : GPLv3
# Date     : 2020 07.27
# Mdate    : 2021 05.07
#========================================================================
-->

# Visual Python

[![PyPI version shields.io](https://img.shields.io/pypi/v/visualpython)](https://pypi.python.org/pypi/visualpython/)
[![License: GPL v3](https://img.shields.io/badge/License-GPLv3-green)](https://www.gnu.org/licenses/gpl-3.0.html)
[![Website: VP Hub](https://img.shields.io/badge/Website-VP%20Hub-orange)](https://www.visualpython.ai)


<br>

## Introduction
Visual Python is a GUI-based Python code generator, developed on the Jupyter Notebook environment as an extension. 
<br>

1. Key Features 
* Automatically generates Python code based on a graphic user interface <br>
* Creates code blocks by tasks (such as data processing, visualization) <br>
* You can save the analysis process and share it (as .vp file) with others <br>

2. Who and What is it for? <br>
Visual Python is a data analytics solution for both Programmers & Non-programmers. <br>

Programmers can use the tool : <br> 
* to save & reuse user-defined (or repeatedly used) code <br>
* to find Python packages and functions from the list <br>

Non-programmers will be able to : <br>
* learn the Python language more easily <br>
* manage big data with minimal coding skills <br>

<br>

## Getting Started

### 1. Requirements

Visual Python is developed as an extension on Jupyter Notebook. <br>
We recommend installing Anaconda (virtual environment).

- Python version 3.x
- Jupyter notebook or Anaconda env <br>

### 2. How to Install

**1)  Open Anaconda prompt**

* Windows : Click Start > Search or Select 'Anaconda Prompt' <br>
* Mac : Open Launchpad > Select 'Terminal'

**2)  Install package from**
```
pip install visualpython
```
<br>

Depending on your virtual environment settings, you may need to install Jupyter Extensions.<br>
To install Jupyter Extension, use commands either:
```
pip install jupyter_contrib_nbextensions
```
or <br>
```
conda install -c conda-forge jupyter_contrib_nbextensions
```

**3)  Enable the package**
```
visualpy install
```

**4)  Activate Visual Python on Jupyter Notebook**

Click orange square button on the right side of the Jupyter Notebook menu. <br>

### 3. Package Control Info
* Usage: visualpy **[option]** <br>
* Optional arguments:

```
help       - show help menu
uninstall  - uninstall packages
upgrade    - version upgrade
version    - version check
```
<br>

## Mission & Vision


**Mission** <br>
To support technology and education so that anyone can leverage big data analytics to create a variety of social values.

**Vision** <br>
To create an environment where you can learn and use big data analytics skills easily.


<br>

## License

GNU GPLv3 (See LICENSE file).
