define ([
    'require'
], function(requirejs) {
    "use strict";

    /**
     * path separator
     */
    const PATH_SEPARATOR = "/";

    /**
     * base path
     */
    const BASE_PATH = "nbextensions" + PATH_SEPARATOR + "visualpython" + PATH_SEPARATOR;

    /**
     * source path
     */
    const SOURCE_PATH = "src" + PATH_SEPARATOR;

    /**
     * resource path
     */
    const RESOURCE_PATH = "resource" + PATH_SEPARATOR;

    /**
     * style sheet path
     */
    const STYLE_PATH = "css" + PATH_SEPARATOR;

    /**
     * data path
     */
    const DATA_PATH = "data" + PATH_SEPARATOR;

    /**
     * main style path
     */
    const MAIN_CSS_URL = "main.css";

    /**
     * libraries data path
     */
    const VP_LIBRARIES_XML_URL = "libraries.xml";
    // const VP_LIBRARIES_XML_URL = "libraries_dev.xml";

    /**
     * toolbar btn properties
     */
    const TOOLBAR_BTN_INFO = {
        HELP: "Visual Python 1.1.7"
        // , ICON: "fa-angellist"
        , ICON: "vp-main-icon"
        , ID: "vpBtnToggle"
        , NAME: "toggle-vp"
        , PREFIX: "vp"
        , ICON_CONTAINER: ""
    }

    /**
     * prefix code signature
     */
    const PREFIX_CODE_SIGNATURE = "# Auto-Generated by VisualPython";

    /**
     * VisualPython position metadata name
     */
    const VP_POSITION_META_NAME = "vpPosition";

    /**
     * VisualPython container id
     */
    const VP_CONTAINER_ID = "vp-wrapper";

    /**
     * container html path
     */
    const VP_CONTAINER_PAGE_URL = "container" + PATH_SEPARATOR + "vpContainer.html";

    /**
     * VisualPython tag id prefix
     */
    const VP_ID_PREFIX = "vp_";
    
    /**
     * VisualPython tag class prefix FIXME: old 제거
     */
    const VP_CLASS_PREFIX = "vp-";
    const VP_CLASS_PREFIX_OLD = ".vp-";

    /**
     * html tag data attribute prefix
     */
    const TAG_DATA_PREFIX = "data-";

    /**
     * class for except event bind
     */
    const VP_EXCEPT_BIND = VP_CLASS_PREFIX + "except-bind";

    /**
     * api Mode toggle btn id
     */
    const API_PALETTE_MODE_BTN = VP_ID_PREFIX + "apiModeBtn";

    /**
     * note Mode toggle btn id
     */
    const NOTE_PALETTE_MODE_BTN = VP_ID_PREFIX + "NoteModeBtn"

    /**
     * header container id
     */
    const HEADER_CONTAINER = VP_ID_PREFIX + "headerContainer";

    /**
     * menu popup 
     */
    const MENU_POPUP = VP_ID_PREFIX + "menuPopup";

    /**
     * menu popup container
     */
    const MENU_POPUP_CONTAINER = VP_CLASS_PREFIX + "menu-popup-container";

    /**
     * menu popup header
     */
    const MENU_POPUP_HEADER = VP_CLASS_PREFIX + "menu-popup-header";

    /**
     * menu popup title
     */
    const MENU_POPUP_TITLE = VP_CLASS_PREFIX + "menu-popup-title";

    /**
     * menu popup close
     */
    const MENU_POPUP_CLOSE = VP_CLASS_PREFIX + "menu-popup-close";

    /**
     * menu popup body
     */
    const MENU_POPUP_BODY = VP_CLASS_PREFIX + "menu-popup-body";

    /**
     * header extra menu btn id
     */
    const HEADER_EXTRA_MENU_BTN = VP_ID_PREFIX + "headerExtraMenuBtn";
    
    /**
     * header extra menu container id
     */
    const HEADER_EXTRA_MENU_CONTAINER = VP_ID_PREFIX + "headerExtraMenu";

    /**
     * header extra menu list 
     */
    const HEADER_EXTRA_MENU_LIST = VP_CLASS_PREFIX + "header-extra-menu-list";

    /**
     * header extra menu list line divider class
     */
    const HEADER_EXTRA_MENU_LINE = VP_CLASS_PREFIX + "header-extra-menu-line";

    /**
     * header extra menu login id
     */
    const HEADER_EXTRA_MENU_LOGIN = VP_ID_PREFIX + 'extraMenuLogin';

    /**
     * header extra menu login caption
     */
    const HEADER_EXTRA_MENU_LOGIN_CAPTION = 'Login';

    /**
     * header extra menu preferences id
     */
    const HEADER_EXTRA_MENU_PREFERENCES = VP_ID_PREFIX + 'extraMenuPreferences';

    /**
     * header extra menu preferences caption
     */
    const HEADER_EXTRA_MENU_PREFERENCES_CAPTION = 'System Preferences';
    /**
     * header extra menu package manager id
     */
    const HEADER_EXTRA_MENU_PACKAGES = VP_ID_PREFIX + 'extraMenuPackages';

    /**
     * header extra menu package manager caption
     */
    const HEADER_EXTRA_MENU_PACKAGES_CAPTION = 'Package Manager';
    /**
     * header extra menu faq id
     */
    const HEADER_EXTRA_MENU_VPNOTE = VP_ID_PREFIX + 'extraMenuVPNote';

    /**
     * faq page link
     */
    const VPNOTE_PAGE_LINK = 'https://visualpython.ai/vpnote';

    /**
     * header extra menu faq caption
     */
    const HEADER_EXTRA_MENU_VPNOTE_CAPTION = 'VP Note';
    /**
     * header extra menu about id
     */
    const HEADER_EXTRA_MENU_ABOUT = VP_ID_PREFIX + 'extraMenuAbout';

    /**
     * header extra menu about caption
     */
    const HEADER_EXTRA_MENU_ABOUT_CAPTION = 'About Visual Python';
    
    /**
     * about visual python page link
     */
    const ABOUT_PAGE_LINK = 'https://visualpython.ai/about';
    
    /**
     * API Mode container id
     */
    const API_MODE_CONTAINER = VP_ID_PREFIX + "apiContainer";

    /**
     * note Mode container id
     */
    const NOTE_MODE_CONTAINER = VP_ID_PREFIX + "noteContainer";

    /**
     * API List caption
     */
    const API_LIST_CAPTION = "API List";

    /**
     * API Block caption
     */
    const API_BLOCK_CAPTION = "API Block";

    /**
     * vp note caption
     */
    const VP_NOTE_CAPTION = "Note";

    /**
     * workflow caption
     */
    const WORKFLOW_CAPTION = "Workflow";

    /**
     * tab control class
     */
    const TAB_CONTAINER = VP_CLASS_PREFIX + "tab-wrap";

    /**
     * tab header control class
     */
    const TAB_HEAD_CONTROL = VP_CLASS_PREFIX + "tab-header";

    /**
     * icon input text class name
     */
    const ICON_INPUT_TEXT = VP_CLASS_PREFIX + "icon-input-text"

    /**
     * Accordion continer class name
     */
    const ACCORDION_CONTAINER = VP_CLASS_PREFIX + "accordion-container";

    /**
     * Accordion head class name
     */
    const ACCORDION_HEADER = VP_CLASS_PREFIX + "accordion-header"

    /**
     * Accordion head caption class
     */
    const ACCORDION_HEADER_CAPTION = VP_CLASS_PREFIX + "accordion-caption";
    
    /**
     * Accordion box opened class
     */
    const ACCORDION_OPEN_CLASS = VP_CLASS_PREFIX + "accordion-open";

    /**
     * Accordion box content class
     */
    const ACCORDION_CONTENT_CLASS = VP_CLASS_PREFIX + "accordion-content";

    /**
     * Accordion box gray color class
     */
    const ACCORDION_GRAY_COLOR = VP_CLASS_PREFIX + "accordion-gray-color";

    /**
     * Accordion box gray background color class
     */
    const ACCORDION_GRAY_BGCOLOR = VP_CLASS_PREFIX + "accordion-gray-bgcolor";

    /**
     * Accordion box small arrow class
     */
    const ACCORDION_SMALL_ARROW = VP_CLASS_PREFIX + "accordion-small-arrow";

    /**
     * library item mother wrap node
     */
    const LIBRARY_ITEM_WRAP_NODE = "library";

    /**
     * library item type : package
     */
    const LIBRARY_ITEM_TYPE_PACKAGE = "package";

    /**
     * library item type : fucntion
     */
    const LIBRARY_ITEM_TYPE_FUNCTION = "function";

    /**
     * library xml item node name
     */
    const LIBRARY_ITEM_TAG = "item";

    /**
     * library xml item depth attribute
     */
    const LIBRARY_ITEM_DEPTH_ATTR = "level";

    /**
     * library xml item id attribute
     */
    const LIBRARY_ITEM_ID_ATTR = "id";

    /**
     * library xml item type attribute
     */
    const LIBRARY_ITEM_TYPE_ATTR = "type";

    /**
     * library xml item name attribute
     */
    const LIBRARY_ITEM_NAME_ATTR = "name";

    /**
     * library xml item tag attribute
     */
    const LIBRARY_ITEM_TAG_ATTR = "tag";

    /**
     * library xml item file url node
     */
    const LIBRARY_ITEM_FILE_URL_NODE = "file";

    /**
     * library xml item path url node
     */
    const LIBRARY_ITEM_PATH_NODE = "path";

    /**
     * library xml item desc url node
     */
    const LIBRARY_ITEM_DESCRIPTION_NODE = "desc";

    /**
     * attribute for library item content for html tag
     */
    const LIBRARY_ITEM_DATA_ID = TAG_DATA_PREFIX + "item-id";

    /**
     * api library list control class for group node
     */
    const LIST_ITEM_LIBRARY = VP_CLASS_PREFIX + "libraries-list";

    /**
     * api library list item class for group node
     */
    const LIST_ITEM_LIBRARY_GROUP = VP_CLASS_PREFIX + "libraries-group";

    /**
     * api library list item class for function node
     */
    const LIST_ITEM_LIBRARY_FUNCTION = VP_CLASS_PREFIX + "libraries-items";

    /**
     * api list library list container id
     */
    const API_LIST_LIBRARY_LIST_CONTAINER = VP_ID_PREFIX + "apiListLibContainer";

    /**
     * api block main container id
     */
    const API_BLOCK_CONTAINER = VP_ID_PREFIX + "apiBlockMainContainer";

    /**
     * temporary area for load option
     */
    const OPTION_GREEN_ROOM = VP_ID_PREFIX + "optionGreenRoom";

    /**
     * container for loaded option
     */
    const OPTION_CONTAINER = VP_ID_PREFIX + "optionBook";

    /**
     * option control button panel
     */
    const OPTION_CONTROL_PANEL = VP_ID_PREFIX + "optionBookControl";

    /**
     * loaded option navigator info panel
     */
    const OPTION_NAVIGATOR_INFO_PANEL = VP_ID_PREFIX + "optionNaviInfo";

    /**
     * loaded option navigator info panel node
     */
    const OPTION_NAVIGATOR_INFO_NODE = VP_CLASS_PREFIX + "navi-node";

    /**
     * loaded option close button
     */
    const CLOSE_OPTION_BUTTON = VP_ID_PREFIX + "OptionBookClose";

    /**
     * loaded option action button container
     */
    const ACTION_OPTION_BUTTON_PANEL = VP_ID_PREFIX + "OptionActionContainer";

    /**
     * loaded block action button container
     */
    const BLOCK_OPTION_BUTTON_PANEL = VP_ID_PREFIX + "BlockActionContainer";

    /**
     * loaded option action button
     */
    const ACTION_OPTION_BUTTON = VP_CLASS_PREFIX + "opt-action-btn";

    /**
     * orange fore color class
     */
    const COLOR_FONT_ORANGE = VP_CLASS_PREFIX + "orange-text";

    /**
     * orange border class
     */
    const COLOR_BORDER_ORANGE = VP_CLASS_PREFIX + "orange-border";

    /**
     * white box orange font color button class
     */
    const COLOR_BUTTON_WHITE_ORANGE = VP_CLASS_PREFIX + "cbtn-white-orange";

    /**
     * orange box white font color button class
     */
    const COLOR_BUTTON_ORANGE_WHITE = VP_CLASS_PREFIX + "cbtn-orange-white";

    /**
     * gray box white font color button class
     */
    const COLOR_BUTTON_GRAY_WHITE = VP_CLASS_PREFIX + "cbtn-gray-white";

    /**
     * loaded option add on cell btn
     */
    const OPTION_BTN_ADD_CELL = VP_ID_PREFIX + "addOnCell";
    
    /**
     * loaded option add on cell and run btn
     */
    const OPTION_BTN_RUN_CELL = VP_ID_PREFIX + "runCell";

    /**
     * loaded block add on cell btn
     */
    const BLOCK_BTN_ADD_CELL = VP_ID_PREFIX + "blockAddOnCell";
    
    /**
     * loaded block add on cell and run btn
     */
    const BLOCK_BTN_RUN_CELL = VP_ID_PREFIX + "blockRunCell";
    
    /**
     * loaded option save on note btn
     */
    const OPTION_BTN_SAVE_ON_NOTE = VP_ID_PREFIX + "saveOnNote";

    /**
     * loaded block add on note btn
     */
    const BLOCK_BTN_SAVE_ON_NOTE = VP_ID_PREFIX + "blockSaveOnNote";

    /**
     * loaded option container
     */
    const OPTION_LOAD_AREA = VP_ID_PREFIX + "optionLoadArea";

    /**
     * option per tab page
     */
    const API_OPTION_PAGE = VP_CLASS_PREFIX + "option-page";
    /**
     * FIXME: 항목 삭제 필요
     */
    const OPTION_PAGE = "." + VP_CLASS_PREFIX + "option-page";
    
    /**
     * note save file extension
     */
    const VP_NOTE_EXTENSION = "vp";

    /**
     * note save file keys
     */
    const VP_NOTE_NODE_DATA_CAPTION ="caption";
    const VP_NOTE_NODE_DATA_CODE ="gencode";
    const VP_NOTE_NODE_DATA_META ="genmeta";
    const VP_NOTE_NODE_DATA_TYPE ="nodetype";

    /**
     * vp note main menu(first page)
     */
    const VP_NOTE_MENU_CONTAINER = VP_ID_PREFIX + "noteMenu";

    /**
     * vp note main menu list class
     */
    const VP_NOTE_MENU_LIST = VP_CLASS_PREFIX + "note-menu-list";

    /**
     * vp note main menu item icon
     */
    const VP_NOTE_MENU_ICON = VP_CLASS_PREFIX + "note-menu-icon";

    /**
     * vp note contents (node list) container id
     */
    const VP_NOTE_NODE_CONTAINER = VP_ID_PREFIX + "noteContents";

    /**
     * vp note file info container id
     */
    const VP_NOTE_FILE_INFO_CONTAINER = VP_ID_PREFIX + "noteFileInfo";

    /**
     * vp note file name control id
     */
    const VP_NOTE_FILE_PATH_CONTROL = VP_ID_PREFIX + "noteFilePath";

    /**
     * vp note file real path control id(hidden)
     */    
    const VP_NOTE_REAL_FILE_PATH = VP_ID_PREFIX + "noteRealFilePath";
    /**
     * vp note node item list container id
     */
    const VP_NOTE_NODE_LIST_CONTAINER = VP_ID_PREFIX + "noteNodeList";

    /**
     * vp note node item wrap class
     */
    const VP_NOTE_NODE_ITEM = VP_CLASS_PREFIX + "note-node-item";

    /**
     * vp note add node item wrap class for highlight
     */
    const VP_NOTE_NEW_NODE_ITEM = VP_CLASS_PREFIX + "new-node-for-highlight";

    /**
     * vp note node type indicator
     */
    const VP_NOTE_NODE_TYPE_NODE = "NODE";
    const VP_NOTE_NODE_TYPE_MARKDOWN = "MARKDOWN";
    /**
     * vp note node type default caption
     */
    const VP_NOTE_NODE_TYPE_NODE_DEFAULT_CAPTION = "Node";
    const VP_NOTE_NODE_TYPE_MARKDOWN_DEFAULT_CAPTION = "Text Node";

    /**
     * vp note markdown node item wrap indicator class
     */
    const VP_NOTE_MARKDOWN_NODE = VP_CLASS_PREFIX + "note-markdown-node";

    /**
     * vp note markdown render value hidden class
     */
    const VP_NOTE_MARKDOWN_NODE_HIDDEN = VP_CLASS_PREFIX + "note-markdown-render-hidden";

    /**
     * note node genereted code
     */
    const NOTE_NODE_GENERATE_CODE = VP_CLASS_PREFIX + "gene-code";

    /**
     * note node genereted meta
     */
    const NOTE_NODE_GENERATE_META = VP_CLASS_PREFIX + "gene-meta";

    /**
     * vp note node icon header class
     */
    const VP_NOTE_NODE_ICON_HEADER = VP_CLASS_PREFIX + "note-node-head-icon";

    /**
     * vp note node text header class
     */
    const VP_NOTE_NODE_TEXT_HEADER = VP_CLASS_PREFIX + "note-node-head-text";

    /**
     * vp note node body class
     */
    const VP_NOTE_NODE_BODY = VP_CLASS_PREFIX + "note-node-body";

    /**
     * vp note node caption class
     */
    const VP_NOTE_NODE_CAPTION = VP_CLASS_PREFIX + "note-node-caption";

    /**
     * vp note empty node class
     */
    const VP_NOTE_EMPTY_NODE = VP_CLASS_PREFIX + "empty-node";

    /**
     * vp note node caption input class
     */
    const VP_NOTE_NODE_CAPTION_INPUT = VP_CLASS_PREFIX + "node-caption-input";

    /**
     * vp note node func name hidden class
     */
    const VP_NOTE_NODE_FUNC_NAME = VP_CLASS_PREFIX + "node-function-name";

    /**
     * vp note node caption and func name coupler
     */
    const VP_NOTE_NODE_FUNC_NAME_COUPLER = " - ";

    /**
     * vp note node additional control
     */
    const VP_NOTE_NODE_ADDITIONAL_CONTROLS = VP_CLASS_PREFIX + "note-node-controls";

    /**
     * vp note node move up button class
     */
    const VP_NOTE_NODE_MOVE_UP = VP_CLASS_PREFIX + "node-control-up";
    
    /**
     * vp note node move down button class
     */
    const VP_NOTE_NODE_MOVE_DOWN = VP_CLASS_PREFIX + "node-control-down";
        
    /**
     * vp note node modify button class
     */
    const VP_NOTE_NODE_MODIFY = VP_CLASS_PREFIX + "node-control-modify";
        
    /**
     * vp note node clone button class
     */
    const VP_NOTE_NODE_CLONE = VP_CLASS_PREFIX + "node-control-clone";

    /**
     * vp note node clone caption postfix
     */
    const VP_NOTE_NODE_CLONE_POSTFIX = "_copy";
            
    /**
     * vp note node remove button class
     */
    const VP_NOTE_NODE_REMOVE = VP_CLASS_PREFIX + "node-control-remove";

    /**
     * vp note node remove confirm message
     */
    const VP_NOTE_NODE_REMOVE_CONFIRM_MESSAGE = "Are you sure you want to delete this node?";

    /**
     * vp note node rewrite confirm message
     */
    const VP_NOTE_NODE_REWRITE_CONFIRM_MESSAGE = "Selected node is not empty. Do you want rewrite node?";

    /**
     * vp note mode extra menu btn id
     */
    const VP_NOTE_EXTRA_MENU_BTN = VP_ID_PREFIX + "noteModeExtraMenuBtn";
    
    /**
     * vp note mode extra menu container id
     */
    const VP_NOTE_EXTRA_MENU_CONTAINER = VP_ID_PREFIX + "noteModeExtraMenu";

    /**
     * vp note mode extra menu list class
     */
    const VP_NOTE_EXTRA_MENU_LIST = VP_CLASS_PREFIX + "note-mode-extra-menu-list";

    /**
     * vp note mode extra menu list line divider class
     */
    const VP_NOTE_EXTRA_MENU_LINE = VP_CLASS_PREFIX + "extra-menu-line";

    /**
     * vp note mode extra menu new note id
     */
    const VP_NOTE_EXTRA_MENU_NEW_NOTE = VP_ID_PREFIX + "extraMenuNewNote";

    /**
     * vp note mode extra menu new note caption
     */
    const VP_NOTE_EXTRA_MENU_NEW_NOTE_CAPTION = "New Note";
    
    /**
     * vp note mode extra menu open note id
     */
    const VP_NOTE_EXTRA_MENU_OPEN_NOTE = VP_ID_PREFIX + "extraMenuOpenNote";

    /**
     * vp note mode extra menu open note caption
     */
    const VP_NOTE_EXTRA_MENU_OPEN_NOTE_CAPTION = "Open";
    
    /**
     * vp note mode extra menu save note id
     */
    const VP_NOTE_EXTRA_MENU_SAVE_NOTE = VP_ID_PREFIX + "extraMenuSaveNote";

    /**
     * vp note mode extra menu save note caption
     */
    const VP_NOTE_EXTRA_MENU_SAVE_NOTE_CAPTION = "Save";
    
    /**
     * vp note mode extra menu save as note id
     */
    const VP_NOTE_EXTRA_MENU_SAVE_AS_NOTE = VP_ID_PREFIX + "extraMenuSaveAsNote";

    /**
     * vp note mode extra menu save as note caption
     */
    const VP_NOTE_EXTRA_MENU_SAVE_AS_NOTE_CAPTION = "Save as";
    
    /**
     * vp note mode extra menu close note id
     */
    const VP_NOTE_EXTRA_MENU_CLOSE_NOTE = VP_ID_PREFIX + "extraMenuCloseNote";

    /**
     * vp note mode extra menu close note caption
     */
    const VP_NOTE_EXTRA_MENU_CLOSE_NOTE_CAPTION = "Close";
    
    /**
     * vp note mode extra menu undo note id
     */
    const VP_NOTE_EXTRA_MENU_UNDO_NOTE = VP_ID_PREFIX + "extraMenuUndoNote";

    /**
     * vp note mode extra menu undo note caption
     */
    const VP_NOTE_EXTRA_MENU_UNDO_NOTE_CAPTION = "Undo";
    
    /**
     * vp note mode extra menu redo note id
     */
    const VP_NOTE_EXTRA_MENU_REDO_NOTE = VP_ID_PREFIX + "extraMenuRedoNote";

    /**
     * vp note mode extra menu undo note caption
     */
    const VP_NOTE_EXTRA_MENU_REDO_NOTE_CAPTION = "Redo";
    
    /**
     * vp note mode extra menu run all note id
     */
    const VP_NOTE_EXTRA_MENU_RUN_ALL_NOTE = VP_ID_PREFIX + "extraMenuRunAllNote";

    /**
     * vp note mode extra menu run all note caption
     */
    const VP_NOTE_EXTRA_MENU_RUN_ALL_NOTE_CAPTION = "Run All";

    /**
     * vp note mode extra menu show detail note id
     */
    const VP_NOTE_EXTRA_MENU_SHOW_DETAIL_NOTE = VP_ID_PREFIX + "extraMenuShowDetailNote";

    /**
     * vp note mode extra menu show detail note caption
     */
    const VP_NOTE_EXTRA_MENU_SHOW_DETAIL_NOTE_CAPTION = "Show Node Detail";

    /**
     * vp note mode extra menu hide detail note id
     */
    const VP_NOTE_EXTRA_MENU_HIDE_DETAIL_NOTE = VP_ID_PREFIX + "extraMenuHideDetailNote";

    /**
     * vp note mode extra menu hide detail note caption
     */
    const VP_NOTE_EXTRA_MENU_HIDE_DETAIL_NOTE_CAPTION = "Hide Node Detail";

    /**
     * vp note main menu new note item id
     */
    const VP_NOTE_MENU_NEW_NOTE = VP_ID_PREFIX + "noteMenuNew";

    /**
     * vp note main menu new note item caption
     */
    const VP_NOTE_MENU_NEW_NOTE_CAPTION = "New Note";

    /**
     * vp note main menu open note item id
     */
    const VP_NOTE_MENU_OPEN_NOTE = VP_ID_PREFIX + "noteMenuOpen";

    /**
     * vp note main menu open note item caption
     */
    const VP_NOTE_MENU_OPEN_NOTE_CAPTION = "Open";

    /**
     * vp note menu new node container id
     */
    const VP_NOTE_MENU_NEW_NODE_CONTAINER = VP_ID_PREFIX + "noteNewNodeContainer";

    /**
     * vp note munu new node type item class
     */
    const VP_NOTE_NEW_NODE_TYPE = VP_CLASS_PREFIX + "note-new-node-type";

    /**
     * vp note menu new node, text type button id
     */
    const VP_NOTE_NEW_NOTE_TYPE_TEXT = VP_ID_PREFIX + "noteNodeTypeText";

    /**
     * vp note menu new node, text type button caption
     */
    const VP_NOTE_NEW_NOTE_TYPE_TEXT_CAPTION = "+ Text";

    /**
     * vp note menu new node, node type button id
     */
    const VP_NOTE_NEW_NOTE_TYPE_NODE = VP_ID_PREFIX + "noteNodeTypeNode";

    /**
     * vp note menu new node, node type button caption
     */
    const VP_NOTE_NEW_NOTE_TYPE_NODE_CAPTION = "+ Node";

    /**
     * api option prefix code textarea id
     */
    const API_OPTION_PREFIX_CODE_ID = VP_ID_PREFIX + "prefixCodeArea";

    /**
     * api option prefix code caption
     */
    const API_OPTION_PREFIX_CAPTION = "Prefix Code";

    /**
     * api option postfix code textarea id
     */
    const API_OPTION_POSTFIX_CODE_ID = VP_ID_PREFIX + "postfixCodeArea";

    /**
     * api option prefix code caption
     */
    const API_OPTION_POSTFIX_CAPTION = "Postfix Code";

    /**
     * manual code input textline area class
     */
    const MANUAL_CODE_INPUT_AREA_LINE = VP_CLASS_PREFIX + "manual-code-area-line";

    /**
     * manual code input text area class
     */
    const MANUAL_CODE_INPUT_AREA = VP_CLASS_PREFIX + "manual-code-area";

    /**
     * api required option accordion box caption
     */
    const API_REQUIRE_OPTION_BOX_CAPTION = "Required Input";

    /**
     * api additional option accordion box caption
     */
    const API_ADDITIONAL_OPTION_BOX_CAPTION = "Additional Option";

    /**
     * table layout th highliget class
     */
    const OPTION_TABLE_LAYOUT_HEAD_HIGHLIGHT = VP_CLASS_PREFIX + "th-highlight";

    /**
     * table layout class vertical head style
     */
    const OPTION_VERTICAL_TABLE_LAYOUT = VP_CLASS_PREFIX + "option-vertical-table-layout";

    /**
     * table layout class horizontal head style
     */
    const OPTION_HORIZONTAL_TABLE_LAYOUT = VP_CLASS_PREFIX + "option-horizontal-table-layout";

    /**
     * table layout cell center align style class
     */
    const TABLE_LAYOUT_CELL_CENTER_ALIGN = VP_CLASS_PREFIX + "merged-center-align";

    /**
     * merged cell indicator. use in table layout
     */
    const TABLE_LAYOUT_MERGED_CELL = "&VPMERGEDCELL&";

    /**
     * file browser display input class
     */
    const FILE_BROWSER_INPUT = VP_CLASS_PREFIX + "file-browser";

    /**
     * file browser open button class
     */
    const FILE_BROWSER_INPUT_BUTTON = VP_CLASS_PREFIX + "file-browser-button";

    /**
     * suggest input uninitialized autocomplete class
     */
    const VP_SUGGEST_INPUT_UNINIT = VP_CLASS_PREFIX + "suggest-input-uninit";

    /**
     * suggest input initialized autocomplete class
     */
    const VP_SUGGEST_INPUT = VP_CLASS_PREFIX + "suggest-input";

    /**
     * plot select box
     */
    const VP_PLOT_SELECT_BOX_ID = "vp_varViewBox";

    /**
     * markdown editor toolbar class
     */
    const VP_MARKDOWN_EDITOR_TOOLBAR = VP_CLASS_PREFIX + "markdown-editor-toolbar";

    /**
     * markdown editor toolbar button class prefix
     */
    const VP_MARKDOWN_TOOBAR_BTN = VP_CLASS_PREFIX + "markdown-editor-toolbar-btn";

    /**
     * markdown editor toolbar button title btn
     */
    const VP_MARKDOWN_TOOBAR_BTN_TITLE = VP_MARKDOWN_TOOBAR_BTN + "-title";

    /**
     * markdown editor title toolbar default text
     */
    const VP_MARKDOWN_DEFAULT_NEW_TITLE_TEXT = "New Title";

    /**
     * markdown editor toolbar button title btn title
     */
    const VP_MARKDOWN_TOOBAR_BTN_TITLE_TITLE = "Title";

    /**
     * markdown editor toolbar button bold btn
     */
    const VP_MARKDOWN_TOOBAR_BTN_BOLD = VP_MARKDOWN_TOOBAR_BTN + "-bold";
    
    /**
     * markdown editor bold toolbar default text
     */
    const VP_MARKDOWN_DEFAULT_BOLD_TEXT = "Bold Text";

    /**
     * markdown editor toolbar button bold btn title
     */
    const VP_MARKDOWN_TOOBAR_BTN_BOLD_TITLE = "Bold";

    /**
     * markdown editor toolbar button italic btn
     */
    const VP_MARKDOWN_TOOBAR_BTN_ITALIC = VP_MARKDOWN_TOOBAR_BTN + "-italic";
    
    /**
     * markdown editor italic toolbar default text
     */
    const VP_MARKDOWN_DEFAULT_ITALIC_TEXT = "Italic Text";

    /**
     * markdown editor toolbar button italic btn title
     */
    const VP_MARKDOWN_TOOBAR_BTN_ITALIC_TITLE = "Italic";

    /**
     * markdown editor toolbar button code btn
     */
    const VP_MARKDOWN_TOOBAR_BTN_CODE = VP_MARKDOWN_TOOBAR_BTN + "-code";
    
    /**
     * markdown editor code toolbar default text
     */
    const VP_MARKDOWN_DEFAULT_CODE_TEXT = "Formatted by code";

    /**
     * markdown editor toolbar button code btn title
     */
    const VP_MARKDOWN_TOOBAR_BTN_CODE_TITLE = "Code";

    /**
     * markdown editor toolbar button link btn
     */
    const VP_MARKDOWN_TOOBAR_BTN_LINK = VP_MARKDOWN_TOOBAR_BTN + "-link";
    
    /**
     * markdown editor link toolbar default text
     */
    const VP_MARKDOWN_DEFAULT_LINK_TEXT = "link Text";

    /**
     * markdown editor toolbar button link btn title
     */
    const VP_MARKDOWN_TOOBAR_BTN_LINK_TITLE = "Link";

    /**
     * markdown editor toolbar button image btn
     */
    const VP_MARKDOWN_TOOBAR_BTN_IMAGE = VP_MARKDOWN_TOOBAR_BTN + "-image";

    /**
     * markdown editor toolbar button image btn
     */
    const VP_MARKDOWN_TOOBAR_INPUT_FILE_IMAGE = VP_CLASS_PREFIX + "input-file-image";

    /**
     * markdown editor toolbar button image result indicator
     */
    const VP_MARKDOWN_TOOLBAR_IMAGE_INDICATOR = "vpImportImage";

    /**
     * markdown editor toolbar button image btn title
     */
    const VP_MARKDOWN_TOOBAR_BTN_IMAGE_TITLE = "Image";

    /**
     * markdown editor toolbar button indent btn
     */
    const VP_MARKDOWN_TOOBAR_BTN_INDENT = VP_MARKDOWN_TOOBAR_BTN + "-indent";
    
    /**
     * markdown editor indent toolbar default text
     */
    const VP_MARKDOWN_DEFAULT_INDENT_TEXT = "\n\n> Indented block\n\n";

    /**
     * markdown editor toolbar button indent btn title
     */
    const VP_MARKDOWN_TOOBAR_BTN_INDENT_TITLE = "Indent";

    /**
     * markdown editor toolbar button order list btn
     */
    const VP_MARKDOWN_TOOBAR_BTN_ORDER_LIST = VP_MARKDOWN_TOOBAR_BTN + "-order-list";

    /**
     * markdown editor toolbar button unorder list btn
     */
    const VP_MARKDOWN_TOOBAR_BTN_UNORDER_LIST = VP_MARKDOWN_TOOBAR_BTN + "-unorder-list";

    /**
     * markdown editor toolbar button ordered list btn title
     */
    const VP_MARKDOWN_TOOBAR_BTN_ORDER_LIST_TITLE = "Ordered list";

    /**
     * markdown editor toolbar button unordered list btn title
     */
    const VP_MARKDOWN_TOOBAR_BTN_UNORDER_LIST_TITLE = "Unordered list";
    
    /**
     * markdown editor list toolbar default text
     */
    const VP_MARKDOWN_DEFAULT_LIST_TEXT = "Add item";

    /**
     * markdown editor toolbar button horizontal line btn
     */
    const VP_MARKDOWN_TOOBAR_BTN_HORIZONTAL_LINE = VP_MARKDOWN_TOOBAR_BTN + "-horizontal-line";

    /**
     * markdown editor toolbar button horizontal line btn title
     */
    const VP_MARKDOWN_TOOBAR_BTN_HORIZONTAL_LINE_TITLE = "Horizontal line";

    return {
        PATH_SEPARATOR: PATH_SEPARATOR
        , BASE_PATH: BASE_PATH
        , SOURCE_PATH: SOURCE_PATH
        , RESOURCE_PATH: RESOURCE_PATH
        , STYLE_PATH: STYLE_PATH
        , DATA_PATH: DATA_PATH
        , MAIN_CSS_URL: MAIN_CSS_URL
        , VP_LIBRARIES_XML_URL: VP_LIBRARIES_XML_URL
        , TOOLBAR_BTN_INFO: TOOLBAR_BTN_INFO
        , PREFIX_CODE_SIGNATURE: PREFIX_CODE_SIGNATURE
        , VP_POSITION_META_NAME: VP_POSITION_META_NAME
        , VP_CONTAINER_ID: VP_CONTAINER_ID
        , VP_CONTAINER_PAGE_URL: VP_CONTAINER_PAGE_URL
        , VP_ID_PREFIX: VP_ID_PREFIX
        , VP_CLASS_PREFIX: VP_CLASS_PREFIX
		, VP_CLASS_PREFIX_OLD: VP_CLASS_PREFIX_OLD
        , TAG_DATA_PREFIX: TAG_DATA_PREFIX
        , VP_EXCEPT_BIND: VP_EXCEPT_BIND
        , API_PALETTE_MODE_BTN: API_PALETTE_MODE_BTN
        , NOTE_PALETTE_MODE_BTN: NOTE_PALETTE_MODE_BTN
        , HEADER_CONTAINER: HEADER_CONTAINER
        , MENU_POPUP: MENU_POPUP
        , MENU_POPUP_CONTAINER: MENU_POPUP_CONTAINER
        , MENU_POPUP_HEADER: MENU_POPUP_HEADER
        , MENU_POPUP_TITLE: MENU_POPUP_TITLE
        , MENU_POPUP_CLOSE: MENU_POPUP_CLOSE
        , MENU_POPUP_BODY: MENU_POPUP_BODY
        , HEADER_EXTRA_MENU_BTN: HEADER_EXTRA_MENU_BTN
        , HEADER_EXTRA_MENU_CONTAINER: HEADER_EXTRA_MENU_CONTAINER
        , HEADER_EXTRA_MENU_LIST: HEADER_EXTRA_MENU_LIST
        , HEADER_EXTRA_MENU_LINE: HEADER_EXTRA_MENU_LINE
        , HEADER_EXTRA_MENU_LOGIN: HEADER_EXTRA_MENU_LOGIN
        , HEADER_EXTRA_MENU_LOGIN_CAPTION: HEADER_EXTRA_MENU_LOGIN_CAPTION
        , HEADER_EXTRA_MENU_PREFERENCES: HEADER_EXTRA_MENU_PREFERENCES
        , HEADER_EXTRA_MENU_PREFERENCES_CAPTION: HEADER_EXTRA_MENU_PREFERENCES_CAPTION
        , HEADER_EXTRA_MENU_PACKAGES: HEADER_EXTRA_MENU_PACKAGES
        , HEADER_EXTRA_MENU_PACKAGES_CAPTION: HEADER_EXTRA_MENU_PACKAGES_CAPTION
        , HEADER_EXTRA_MENU_VPNOTE: HEADER_EXTRA_MENU_VPNOTE
        , HEADER_EXTRA_MENU_VPNOTE_CAPTION: HEADER_EXTRA_MENU_VPNOTE_CAPTION
        , VPNOTE_PAGE_LINK: VPNOTE_PAGE_LINK
        , HEADER_EXTRA_MENU_ABOUT: HEADER_EXTRA_MENU_ABOUT
        , HEADER_EXTRA_MENU_ABOUT_CAPTION: HEADER_EXTRA_MENU_ABOUT_CAPTION
        , ABOUT_PAGE_LINK: ABOUT_PAGE_LINK
        , API_MODE_CONTAINER: API_MODE_CONTAINER
        , NOTE_MODE_CONTAINER: NOTE_MODE_CONTAINER
        , API_LIST_CAPTION: API_LIST_CAPTION
        , API_BLOCK_CAPTION: API_BLOCK_CAPTION
        , VP_NOTE_CAPTION: VP_NOTE_CAPTION
        , WORKFLOW_CAPTION: WORKFLOW_CAPTION
        , TAB_CONTAINER: TAB_CONTAINER
        , TAB_HEAD_CONTROL: TAB_HEAD_CONTROL
        , ICON_INPUT_TEXT: ICON_INPUT_TEXT
        , ACCORDION_CONTAINER: ACCORDION_CONTAINER
        , ACCORDION_HEADER: ACCORDION_HEADER
        , ACCORDION_HEADER_CAPTION: ACCORDION_HEADER_CAPTION
        , ACCORDION_OPEN_CLASS: ACCORDION_OPEN_CLASS
        , ACCORDION_CONTENT_CLASS: ACCORDION_CONTENT_CLASS
        , ACCORDION_GRAY_COLOR: ACCORDION_GRAY_COLOR
        , ACCORDION_GRAY_BGCOLOR: ACCORDION_GRAY_BGCOLOR
        , ACCORDION_SMALL_ARROW: ACCORDION_SMALL_ARROW 
        , LIBRARY_ITEM_WRAP_NODE: LIBRARY_ITEM_WRAP_NODE
        , LIBRARY_ITEM_TYPE_PACKAGE: LIBRARY_ITEM_TYPE_PACKAGE
        , LIBRARY_ITEM_TYPE_FUNCTION: LIBRARY_ITEM_TYPE_FUNCTION
        , LIBRARY_ITEM_TAG: LIBRARY_ITEM_TAG
        , LIBRARY_ITEM_DEPTH_ATTR: LIBRARY_ITEM_DEPTH_ATTR
        , LIBRARY_ITEM_ID_ATTR: LIBRARY_ITEM_ID_ATTR
        , LIBRARY_ITEM_TYPE_ATTR: LIBRARY_ITEM_TYPE_ATTR
        , LIBRARY_ITEM_NAME_ATTR: LIBRARY_ITEM_NAME_ATTR
        , LIBRARY_ITEM_TAG_ATTR: LIBRARY_ITEM_TAG_ATTR
        , LIBRARY_ITEM_FILE_URL_NODE: LIBRARY_ITEM_FILE_URL_NODE
        , LIBRARY_ITEM_PATH_NODE: LIBRARY_ITEM_PATH_NODE
        , LIBRARY_ITEM_DESCRIPTION_NODE: LIBRARY_ITEM_DESCRIPTION_NODE
        , LIBRARY_ITEM_DATA_ID: LIBRARY_ITEM_DATA_ID
        , LIST_ITEM_LIBRARY: LIST_ITEM_LIBRARY
        , LIST_ITEM_LIBRARY_GROUP: LIST_ITEM_LIBRARY_GROUP
        , LIST_ITEM_LIBRARY_FUNCTION: LIST_ITEM_LIBRARY_FUNCTION
        , API_LIST_LIBRARY_LIST_CONTAINER: API_LIST_LIBRARY_LIST_CONTAINER
        , API_BLOCK_CONTAINER: API_BLOCK_CONTAINER
        , OPTION_GREEN_ROOM: OPTION_GREEN_ROOM
        , OPTION_PAGE: OPTION_PAGE
        , OPTION_CONTAINER: OPTION_CONTAINER
        , OPTION_CONTROL_PANEL: OPTION_CONTROL_PANEL
        , OPTION_NAVIGATOR_INFO_PANEL: OPTION_NAVIGATOR_INFO_PANEL
        , OPTION_NAVIGATOR_INFO_NODE: OPTION_NAVIGATOR_INFO_NODE
        , CLOSE_OPTION_BUTTON: CLOSE_OPTION_BUTTON
        , ACTION_OPTION_BUTTON_PANEL: ACTION_OPTION_BUTTON_PANEL
        , BLOCK_OPTION_BUTTON_PANEL: BLOCK_OPTION_BUTTON_PANEL
        , ACTION_OPTION_BUTTON: ACTION_OPTION_BUTTON
        , COLOR_FONT_ORANGE: COLOR_FONT_ORANGE
        , COLOR_BORDER_ORANGE: COLOR_BORDER_ORANGE
        , COLOR_BUTTON_WHITE_ORANGE: COLOR_BUTTON_WHITE_ORANGE
        , COLOR_BUTTON_ORANGE_WHITE: COLOR_BUTTON_ORANGE_WHITE
        , COLOR_BUTTON_GRAY_WHITE: COLOR_BUTTON_GRAY_WHITE
        , OPTION_BTN_ADD_CELL: OPTION_BTN_ADD_CELL
        , OPTION_BTN_RUN_CELL: OPTION_BTN_RUN_CELL
        , BLOCK_BTN_ADD_CELL: BLOCK_BTN_ADD_CELL
        , BLOCK_BTN_RUN_CELL: BLOCK_BTN_RUN_CELL
        , OPTION_BTN_SAVE_ON_NOTE: OPTION_BTN_SAVE_ON_NOTE
        , BLOCK_BTN_SAVE_ON_NOTE: BLOCK_BTN_SAVE_ON_NOTE
        , OPTION_LOAD_AREA: OPTION_LOAD_AREA
        , API_OPTION_PAGE: API_OPTION_PAGE
        , VP_NOTE_EXTENSION: VP_NOTE_EXTENSION
        , VP_NOTE_NODE_DATA_CAPTION: VP_NOTE_NODE_DATA_CAPTION
        , VP_NOTE_NODE_DATA_CODE: VP_NOTE_NODE_DATA_CODE
        , VP_NOTE_NODE_DATA_META: VP_NOTE_NODE_DATA_META
        , VP_NOTE_NODE_DATA_TYPE: VP_NOTE_NODE_DATA_TYPE
        , VP_NOTE_MENU_CONTAINER: VP_NOTE_MENU_CONTAINER
        , VP_NOTE_MENU_LIST: VP_NOTE_MENU_LIST
        , VP_NOTE_MENU_ICON: VP_NOTE_MENU_ICON
        , VP_NOTE_NODE_CONTAINER: VP_NOTE_NODE_CONTAINER
        , VP_NOTE_FILE_PATH_CONTROL: VP_NOTE_FILE_PATH_CONTROL
        , VP_NOTE_REAL_FILE_PATH: VP_NOTE_REAL_FILE_PATH
        , VP_NOTE_NODE_LIST_CONTAINER: VP_NOTE_NODE_LIST_CONTAINER
        , VP_NOTE_NODE_ITEM: VP_NOTE_NODE_ITEM
        , VP_NOTE_NEW_NODE_ITEM: VP_NOTE_NEW_NODE_ITEM
        , VP_NOTE_NODE_TYPE_NODE: VP_NOTE_NODE_TYPE_NODE
        , VP_NOTE_NODE_TYPE_MARKDOWN: VP_NOTE_NODE_TYPE_MARKDOWN
        , VP_NOTE_NODE_TYPE_NODE_DEFAULT_CAPTION: VP_NOTE_NODE_TYPE_NODE_DEFAULT_CAPTION
        , VP_NOTE_NODE_TYPE_MARKDOWN_DEFAULT_CAPTION: VP_NOTE_NODE_TYPE_MARKDOWN_DEFAULT_CAPTION
        , VP_NOTE_MARKDOWN_NODE: VP_NOTE_MARKDOWN_NODE
        , VP_NOTE_MARKDOWN_NODE_HIDDEN: VP_NOTE_MARKDOWN_NODE_HIDDEN
        , NOTE_NODE_GENERATE_CODE: NOTE_NODE_GENERATE_CODE
        , NOTE_NODE_GENERATE_META: NOTE_NODE_GENERATE_META
        , VP_NOTE_NODE_ICON_HEADER: VP_NOTE_NODE_ICON_HEADER
        , VP_NOTE_NODE_TEXT_HEADER: VP_NOTE_NODE_TEXT_HEADER
        , VP_NOTE_NODE_BODY: VP_NOTE_NODE_BODY
        , VP_NOTE_NODE_CAPTION: VP_NOTE_NODE_CAPTION
        , VP_NOTE_EMPTY_NODE: VP_NOTE_EMPTY_NODE
        , VP_NOTE_NODE_CAPTION_INPUT: VP_NOTE_NODE_CAPTION_INPUT
        , VP_NOTE_NODE_FUNC_NAME: VP_NOTE_NODE_FUNC_NAME
        , VP_NOTE_NODE_FUNC_NAME_COUPLER: VP_NOTE_NODE_FUNC_NAME_COUPLER
        , VP_NOTE_NODE_ADDITIONAL_CONTROLS: VP_NOTE_NODE_ADDITIONAL_CONTROLS
        , VP_NOTE_NODE_MOVE_UP: VP_NOTE_NODE_MOVE_UP
        , VP_NOTE_NODE_MOVE_DOWN: VP_NOTE_NODE_MOVE_DOWN
        , VP_NOTE_NODE_MODIFY: VP_NOTE_NODE_MODIFY
        , VP_NOTE_NODE_CLONE: VP_NOTE_NODE_CLONE
        , VP_NOTE_NODE_CLONE_POSTFIX: VP_NOTE_NODE_CLONE_POSTFIX
        , VP_NOTE_NODE_REMOVE: VP_NOTE_NODE_REMOVE
        , VP_NOTE_NODE_REMOVE_CONFIRM_MESSAGE: VP_NOTE_NODE_REMOVE_CONFIRM_MESSAGE
        , VP_NOTE_NODE_REWRITE_CONFIRM_MESSAGE: VP_NOTE_NODE_REWRITE_CONFIRM_MESSAGE
        , VP_NOTE_EXTRA_MENU_BTN: VP_NOTE_EXTRA_MENU_BTN
        , VP_NOTE_EXTRA_MENU_CONTAINER: VP_NOTE_EXTRA_MENU_CONTAINER
        , VP_NOTE_EXTRA_MENU_LIST: VP_NOTE_EXTRA_MENU_LIST
        , VP_NOTE_EXTRA_MENU_LINE: VP_NOTE_EXTRA_MENU_LINE
        , VP_NOTE_EXTRA_MENU_NEW_NOTE: VP_NOTE_EXTRA_MENU_NEW_NOTE
        , VP_NOTE_EXTRA_MENU_NEW_NOTE_CAPTION: VP_NOTE_EXTRA_MENU_NEW_NOTE_CAPTION
        , VP_NOTE_EXTRA_MENU_OPEN_NOTE: VP_NOTE_EXTRA_MENU_OPEN_NOTE
        , VP_NOTE_EXTRA_MENU_OPEN_NOTE_CAPTION: VP_NOTE_EXTRA_MENU_OPEN_NOTE_CAPTION
        , VP_NOTE_EXTRA_MENU_SAVE_NOTE: VP_NOTE_EXTRA_MENU_SAVE_NOTE
        , VP_NOTE_EXTRA_MENU_SAVE_NOTE_CAPTION: VP_NOTE_EXTRA_MENU_SAVE_NOTE_CAPTION
        , VP_NOTE_EXTRA_MENU_SAVE_AS_NOTE: VP_NOTE_EXTRA_MENU_SAVE_AS_NOTE
        , VP_NOTE_EXTRA_MENU_SAVE_AS_NOTE_CAPTION: VP_NOTE_EXTRA_MENU_SAVE_AS_NOTE_CAPTION
        , VP_NOTE_EXTRA_MENU_CLOSE_NOTE: VP_NOTE_EXTRA_MENU_CLOSE_NOTE
        , VP_NOTE_EXTRA_MENU_CLOSE_NOTE_CAPTION: VP_NOTE_EXTRA_MENU_CLOSE_NOTE_CAPTION
        , VP_NOTE_EXTRA_MENU_UNDO_NOTE: VP_NOTE_EXTRA_MENU_UNDO_NOTE
        , VP_NOTE_EXTRA_MENU_UNDO_NOTE_CAPTION: VP_NOTE_EXTRA_MENU_UNDO_NOTE_CAPTION
        , VP_NOTE_EXTRA_MENU_REDO_NOTE: VP_NOTE_EXTRA_MENU_REDO_NOTE
        , VP_NOTE_EXTRA_MENU_REDO_NOTE_CAPTION: VP_NOTE_EXTRA_MENU_REDO_NOTE_CAPTION
        , VP_NOTE_EXTRA_MENU_RUN_ALL_NOTE: VP_NOTE_EXTRA_MENU_RUN_ALL_NOTE
        , VP_NOTE_EXTRA_MENU_RUN_ALL_NOTE_CAPTION: VP_NOTE_EXTRA_MENU_RUN_ALL_NOTE_CAPTION
        , VP_NOTE_EXTRA_MENU_SHOW_DETAIL_NOTE: VP_NOTE_EXTRA_MENU_SHOW_DETAIL_NOTE
        , VP_NOTE_EXTRA_MENU_SHOW_DETAIL_NOTE_CAPTION: VP_NOTE_EXTRA_MENU_SHOW_DETAIL_NOTE_CAPTION
        , VP_NOTE_EXTRA_MENU_HIDE_DETAIL_NOTE: VP_NOTE_EXTRA_MENU_HIDE_DETAIL_NOTE
        , VP_NOTE_EXTRA_MENU_HIDE_DETAIL_NOTE_CAPTION: VP_NOTE_EXTRA_MENU_HIDE_DETAIL_NOTE_CAPTION
        , VP_NOTE_FILE_INFO_CONTAINER: VP_NOTE_FILE_INFO_CONTAINER
        , VP_NOTE_MENU_NEW_NOTE: VP_NOTE_MENU_NEW_NOTE
        , VP_NOTE_MENU_NEW_NOTE_CAPTION: VP_NOTE_MENU_NEW_NOTE_CAPTION
        , VP_NOTE_MENU_OPEN_NOTE: VP_NOTE_MENU_OPEN_NOTE
        , VP_NOTE_MENU_OPEN_NOTE_CAPTION: VP_NOTE_MENU_OPEN_NOTE_CAPTION
        , VP_NOTE_MENU_NEW_NODE_CONTAINER: VP_NOTE_MENU_NEW_NODE_CONTAINER
        , VP_NOTE_NEW_NODE_TYPE: VP_NOTE_NEW_NODE_TYPE
        , VP_NOTE_NEW_NOTE_TYPE_TEXT: VP_NOTE_NEW_NOTE_TYPE_TEXT
        , VP_NOTE_NEW_NOTE_TYPE_TEXT_CAPTION: VP_NOTE_NEW_NOTE_TYPE_TEXT_CAPTION
        , VP_NOTE_NEW_NOTE_TYPE_NODE: VP_NOTE_NEW_NOTE_TYPE_NODE
        , VP_NOTE_NEW_NOTE_TYPE_NODE_CAPTION: VP_NOTE_NEW_NOTE_TYPE_NODE_CAPTION
        , API_OPTION_PREFIX_CODE_ID: API_OPTION_PREFIX_CODE_ID
        , API_OPTION_PREFIX_CAPTION: API_OPTION_PREFIX_CAPTION
        , API_OPTION_POSTFIX_CODE_ID: API_OPTION_POSTFIX_CODE_ID
        , API_OPTION_POSTFIX_CAPTION: API_OPTION_POSTFIX_CAPTION
        , MANUAL_CODE_INPUT_AREA_LINE: MANUAL_CODE_INPUT_AREA_LINE
        , MANUAL_CODE_INPUT_AREA: MANUAL_CODE_INPUT_AREA
        , API_REQUIRE_OPTION_BOX_CAPTION: API_REQUIRE_OPTION_BOX_CAPTION
        , API_ADDITIONAL_OPTION_BOX_CAPTION: API_ADDITIONAL_OPTION_BOX_CAPTION
        , OPTION_TABLE_LAYOUT_HEAD_HIGHLIGHT: OPTION_TABLE_LAYOUT_HEAD_HIGHLIGHT
        , OPTION_VERTICAL_TABLE_LAYOUT: OPTION_VERTICAL_TABLE_LAYOUT
        , OPTION_HORIZONTAL_TABLE_LAYOUT: OPTION_HORIZONTAL_TABLE_LAYOUT
        , TABLE_LAYOUT_CELL_CENTER_ALIGN: TABLE_LAYOUT_CELL_CENTER_ALIGN
        , TABLE_LAYOUT_MERGED_CELL: TABLE_LAYOUT_MERGED_CELL
        , FILE_BROWSER_INPUT: FILE_BROWSER_INPUT
        , FILE_BROWSER_INPUT_BUTTON: FILE_BROWSER_INPUT_BUTTON
        , VP_SUGGEST_INPUT_UNINIT: VP_SUGGEST_INPUT_UNINIT
        , VP_SUGGEST_INPUT: VP_SUGGEST_INPUT
        , VP_PLOT_SELECT_BOX_ID: VP_PLOT_SELECT_BOX_ID
        , VP_MARKDOWN_EDITOR_TOOLBAR: VP_MARKDOWN_EDITOR_TOOLBAR
        , VP_MARKDOWN_TOOBAR_BTN: VP_MARKDOWN_TOOBAR_BTN
        , VP_MARKDOWN_TOOBAR_BTN_TITLE: VP_MARKDOWN_TOOBAR_BTN_TITLE
        , VP_MARKDOWN_DEFAULT_NEW_TITLE_TEXT: VP_MARKDOWN_DEFAULT_NEW_TITLE_TEXT
        , VP_MARKDOWN_TOOBAR_BTN_TITLE_TITLE: VP_MARKDOWN_TOOBAR_BTN_TITLE_TITLE
        , VP_MARKDOWN_TOOBAR_BTN_BOLD: VP_MARKDOWN_TOOBAR_BTN_BOLD
        , VP_MARKDOWN_DEFAULT_BOLD_TEXT: VP_MARKDOWN_DEFAULT_BOLD_TEXT
        , VP_MARKDOWN_TOOBAR_BTN_BOLD_TITLE: VP_MARKDOWN_TOOBAR_BTN_BOLD_TITLE
        , VP_MARKDOWN_TOOBAR_BTN_ITALIC: VP_MARKDOWN_TOOBAR_BTN_ITALIC
        , VP_MARKDOWN_DEFAULT_ITALIC_TEXT: VP_MARKDOWN_DEFAULT_ITALIC_TEXT
        , VP_MARKDOWN_TOOBAR_BTN_ITALIC_TITLE: VP_MARKDOWN_TOOBAR_BTN_ITALIC_TITLE
        , VP_MARKDOWN_TOOBAR_BTN_CODE: VP_MARKDOWN_TOOBAR_BTN_CODE
        , VP_MARKDOWN_DEFAULT_CODE_TEXT : VP_MARKDOWN_DEFAULT_CODE_TEXT
        , VP_MARKDOWN_TOOBAR_BTN_CODE_TITLE: VP_MARKDOWN_TOOBAR_BTN_CODE_TITLE
        , VP_MARKDOWN_TOOBAR_BTN_LINK: VP_MARKDOWN_TOOBAR_BTN_LINK
        , VP_MARKDOWN_DEFAULT_LINK_TEXT: VP_MARKDOWN_DEFAULT_LINK_TEXT
        , VP_MARKDOWN_TOOBAR_BTN_LINK_TITLE: VP_MARKDOWN_TOOBAR_BTN_LINK_TITLE
        , VP_MARKDOWN_TOOBAR_BTN_IMAGE: VP_MARKDOWN_TOOBAR_BTN_IMAGE
        , VP_MARKDOWN_TOOBAR_INPUT_FILE_IMAGE: VP_MARKDOWN_TOOBAR_INPUT_FILE_IMAGE
        , VP_MARKDOWN_TOOLBAR_IMAGE_INDICATOR: VP_MARKDOWN_TOOLBAR_IMAGE_INDICATOR
        , VP_MARKDOWN_TOOBAR_BTN_IMAGE_TITLE: VP_MARKDOWN_TOOBAR_BTN_IMAGE_TITLE
        , VP_MARKDOWN_TOOBAR_BTN_INDENT: VP_MARKDOWN_TOOBAR_BTN_INDENT
        , VP_MARKDOWN_DEFAULT_INDENT_TEXT: VP_MARKDOWN_DEFAULT_INDENT_TEXT
        , VP_MARKDOWN_TOOBAR_BTN_INDENT_TITLE: VP_MARKDOWN_TOOBAR_BTN_INDENT_TITLE
        , VP_MARKDOWN_TOOBAR_BTN_ORDER_LIST: VP_MARKDOWN_TOOBAR_BTN_ORDER_LIST
        , VP_MARKDOWN_TOOBAR_BTN_UNORDER_LIST: VP_MARKDOWN_TOOBAR_BTN_UNORDER_LIST
        , VP_MARKDOWN_TOOBAR_BTN_ORDER_LIST_TITLE: VP_MARKDOWN_TOOBAR_BTN_ORDER_LIST_TITLE
        , VP_MARKDOWN_TOOBAR_BTN_UNORDER_LIST_TITLE: VP_MARKDOWN_TOOBAR_BTN_UNORDER_LIST_TITLE
        , VP_MARKDOWN_DEFAULT_LIST_TEXT: VP_MARKDOWN_DEFAULT_LIST_TEXT
        , VP_MARKDOWN_TOOBAR_BTN_HORIZONTAL_LINE: VP_MARKDOWN_TOOBAR_BTN_HORIZONTAL_LINE
        , VP_MARKDOWN_TOOBAR_BTN_HORIZONTAL_LINE_TITLE: VP_MARKDOWN_TOOBAR_BTN_HORIZONTAL_LINE_TITLE
    };
});
