# Contributing to the Visual Python

Dear contributors, thanks for your interest in Visual Python. <br>
We welcome all skills from: 
* [Programmers](#Programmers)
* [Non-programmers](#Non-programmers)
* [Designers](#Designers) <br>


and your contribution would be greatly appreciated ! <br><br>

## Programmers

### Responding to an issue
1. Find an issue you would like to work on.
2. Follow the process from [GitHub Guides: Forking Projects](https://guides.github.com/activities/forking/)

NOTE : Any submissions are understood to be under the same GPLv3 License that covers the project.

* GUI Kit available as a Figma library: [Visual Python GUI Kit 1.0](https://www.figma.com/community/file/976035035360380841).


### Creating an issue
1. Go to [Issues], click [New Issue].
2. Select the issue template: [Bug Report](https://github.com/visualpython/visualpython/issues/new?assignees=&labels=bug&template=bug_report.md&title=%5BBUG%5D+) / [Feature Request](https://github.com/visualpython/visualpython/issues/new?assignees=&labels=enhancement&template=feature_request.md&title=) / [Blank](https://github.com/visualpython/visualpython/issues/new)
3. Write a clear and concise description.
4. Submit a new issue. 

NOTE : If you are reporting a bug, please include steps to reproduce the problem. <br>


## Non-programmers

### Creating & Sharing VP Notes
1. Create a data analysis task note using Visual Python.
2. Save the note as a (.vp) format.
3. Share your work and knowledge on [Visual Python Hub](https://www.visualpython.ai/vpnote).

NOTE : Your work can be of great help for someone who struggles to find a solution.

### Contributing to Documentation
* Help with reviewing and editing official project documentation.

### Helping raise a better awareness of Visual Python
* Create educational material using Visual Python.
* Create content like videos, blogs that you can share your experience and ideas about Visual Python.


## Designers

### Responding to a design-related issue
1. Find a design-related issue you would like to work on. 
2. Follow the process from [GitHub Guides: Forking Projects](https://guides.github.com/activities/forking/)

### Improving UI Kit
1. Take a look at the latest version on Figma: [Visual Python GUI Kit 1.0](https://www.figma.com/community/file/976035035360380841).
2. Duplicate the file to add a copy to your folder. 
3. Make changes on the copy and publish the file to Figma Community as a remix version. 

NOTE : Recommend reading [Figma: Publish Community files](https://help.figma.com/hc/en-us/articles/360040035974-Publish-Community-files) before starting the work for better understanding of the system. 

<br>

