
![Visual Python](https://i.esdrop.com/d/7o0dj05m8rnz/JNGCMedl18.png)


[![PyPI version shields.io](https://img.shields.io/pypi/v/visualpython)](https://pypi.python.org/pypi/visualpython/)
![Python: 3.x](https://img.shields.io/badge/Python-3.x-yellowgreen)
[![License: GPLv3](https://img.shields.io/badge/License-GPLv3-brightgreen)](https://github.com/visualpython/visualpython/blob/main/LICENSE)
[![Code of Conduct: Contributor Covenant](https://img.shields.io/badge/Code%20of%20Conduct-Contributor%20Covenant-pink)](https://github.com/visualpython/visualpython/blob/main/CODE_OF_CONDUCT.md)
[![Downloads: ](https://img.shields.io/pypi/dm/visualpython?color=orange)](https://pypistats.org/packages/visualpython)
[![Issues: ](https://img.shields.io/github/issues/visualpython/visualpython?color=%23FF6347)](https://github.com/visualpython/visualpython/issues)

## Introduction
Visual Python is a GUI-based Python code generator, developed on the Jupyter Notebook as an extension. <br>
Visual Python is an open source project started for students who struggle with coding during Python classes for data science.

<br>

Try Visual Python if you would like to: <br>
* manage big data with minimal coding skills. <br>
* help students / business analysts / researchers to overcome learning barriers for Python. <br>
* save & reuse repeatedly used codes(snippets). <br>

<br>
<img src="https://i.esdrop.com/d/7o0dj05m8rnz/Vo69p6HOwb.gif" width="85%">

## Getting Started

### 1. Requirements

Visual Python is a Jupyter Notebook extension. <br>
We recommend installing Anaconda (virtual environment).

- Python version 3.x
- Jupyter notebook or Anaconda env 

### 2. How to Install

**1)  Open Anaconda prompt**

* Windows : Click Start > Search or Select 'Anaconda Prompt' <br>
* Mac : Open Launchpad > Select 'Terminal'

**2)  Install package from**
```
pip install visualpython
```
NOTE : Depending on your virtual environment settings, you may need to install Jupyter Extensions.<br>
To install Jupyter Extension, use commands either:
```
pip install jupyter_contrib_nbextensions
```
or <br>
```
conda install -c conda-forge jupyter_contrib_nbextensions
```

**3)  Enable the package**
```
visualpy install
```
NOTE : If you are using multiple versions of Python, specify the pip version as 3 like the following. <br>
```
visualpy install --pip3 
```

**4)  Activate Visual Python on Jupyter Notebook**

Click orange square button on the right side of the Jupyter Notebook menu. 

### 3. Package Control Info
* Usage: visualpy **[option]** <br>
* Optional arguments:

```
help       - show help menu
install    - install packages
uninstall  - uninstall packages
upgrade    - version upgrade
version    - version check
```

## Contributing
If you are interested in contributing to the Visual Python, please see [`CONTRIBUTING.md`](CONTRIBUTING.md). <br>
All skills from programmers, non-programmers, designers are welcomed.

* Programming Guide: [Developer Documentation](https://bird-energy-733.notion.site/visualpython-docs-85c0274ff7564747bb8e8d77909fc8b7)
* GUI Design Guide: [Visual Python GUI Kit 1.0](https://www.figma.com/community/file/976035035360380841)

## License
GNU GPLv3 with Visual Python special exception (See LICENSE file).

## Mission & Vision
**Mission** <br>
To support technology and education so that anyone can leverage big data analytics to create a variety of social values.

**Vision** <br>
To create an environment where everyone can learn and use big data analytics skills easily.

## Support Visual Python
Love Visual Python? Caffeine keeps us awake and do the work ☕
THANK YOU for your support! 👍

<a href="https://www.buymeacoffee.com/visualpython" target="_blank"><img src="https://img.buymeacoffee.com/button-api/?text=Buy me a coffee&emoji=&slug=visualpython&button_colour=ffa238&font_colour=000000&font_family=Comic&outline_colour=000000&coffee_colour=FFDD00"></a>