// *************************************************************************
// * This file is generated by vl-convert-vendor/src/main.rs. Do not edit! *
// *************************************************************************
use deno_runtime::deno_core::anyhow::bail;
use deno_runtime::deno_core::error::AnyError;
use std::collections::HashMap;
use std::str::FromStr;

pub const JSDELIVR_URL: &str = "https://cdn.jsdelivr.net";
pub const VEGA_PATH: &str = "/npm/vega@6.2.0/+esm";
pub const VEGA_THEMES_PATH: &str = "/npm/vega-themes@3.0.0/+esm";
pub const VEGA_EMBED_PATH: &str = "/npm/vega-embed@7.0.2/+esm";
pub const DEBOUNCE_PATH: &str = "/npm/lodash.debounce@4.0.8/+esm";

pub const VEGA_VERSION: &str = "6.2.0";
pub const VEGA_THEMES_VERSION: &str = "3.0.0";
pub const VEGA_EMBED_VERSION: &str = "7.0.2";

pub fn url_for_path(path: &str) -> String {
    format!("{}{}", JSDELIVR_URL, path)
}

pub fn vega_url() -> String {
    url_for_path(VEGA_PATH)
}

pub fn vega_themes_url() -> String {
    url_for_path(VEGA_THEMES_PATH)
}

#[derive(Debug, Copy, Clone, Eq, PartialEq, Hash)]
#[allow(non_camel_case_types)]
pub enum VlVersion {
    v5_8,
    v5_14,
    v5_15,
    v5_16,
    v5_17,
    v5_20,
    v5_21,
    v6_1,
    v6_4,
}

impl VlVersion {
    pub fn to_path(self) -> String {
        use VlVersion::*;
        let path = match self {
            v5_8 => "/npm/vega-lite@5.8.0/+esm",
            v5_14 => "/npm/vega-lite@5.14.1/+esm",
            v5_15 => "/npm/vega-lite@5.15.1/+esm",
            v5_16 => "/npm/vega-lite@5.16.3/+esm",
            v5_17 => "/npm/vega-lite@5.17.0/+esm",
            v5_20 => "/npm/vega-lite@5.20.1/+esm",
            v5_21 => "/npm/vega-lite@5.21.0/+esm",
            v6_1 => "/npm/vega-lite@6.1.0/+esm",
            v6_4 => "/npm/vega-lite@6.4.1/+esm",
        };
        path.to_string()
    }

    pub fn to_url(self) -> String {
        format!("{}{}", JSDELIVR_URL, self.to_path())
    }

    pub fn to_semver(self) -> &'static str {
        use VlVersion::*;
        match self {
            v5_8 => "5.8",
            v5_14 => "5.14",
            v5_15 => "5.15",
            v5_16 => "5.16",
            v5_17 => "5.17",
            v5_20 => "5.20",
            v5_21 => "5.21",
            v6_1 => "6.1",
            v6_4 => "6.4",
        }
    }
}

impl Default for VlVersion {
    fn default() -> Self {
        VlVersion::from_str("6.4").unwrap()
    }
}

impl FromStr for VlVersion {
    type Err = AnyError;

    fn from_str(s: &str) -> Result<Self, Self::Err> {
        Ok(match s {
            "5.8" | "v5.8" | "5_8" | "v5_8" => Self::v5_8,
            "5.14" | "v5.14" | "5_14" | "v5_14" => Self::v5_14,
            "5.15" | "v5.15" | "5_15" | "v5_15" => Self::v5_15,
            "5.16" | "v5.16" | "5_16" | "v5_16" => Self::v5_16,
            "5.17" | "v5.17" | "5_17" | "v5_17" => Self::v5_17,
            "5.20" | "v5.20" | "5_20" | "v5_20" => Self::v5_20,
            "5.21" | "v5.21" | "5_21" | "v5_21" => Self::v5_21,
            "6.1" | "v6.1" | "6_1" | "v6_1" => Self::v6_1,
            "6.4" | "v6.4" | "6_4" | "v6_4" => Self::v6_4,
            _ => bail!("Unsupported Vega-Lite version string {}", s),
        })
    }
}

pub const VL_VERSIONS: &[VlVersion] = &[
    VlVersion::v5_8,
    VlVersion::v5_14,
    VlVersion::v5_15,
    VlVersion::v5_16,
    VlVersion::v5_17,
    VlVersion::v5_20,
    VlVersion::v5_21,
    VlVersion::v6_1,
    VlVersion::v6_4,
];

pub fn build_import_map() -> HashMap<String, String> {
    let mut m: HashMap<String, String> = HashMap::new();
    m.insert(
        "/npm/clone@2.1.2/+esm".to_string(),
        include_str!("../../vendor/cdn.jsdelivr.net/npm/clone@2.1.2/+esm.js").to_string(),
    );
    m.insert(
        "/npm/d3-array@3.2.4/+esm".to_string(),
        include_str!("../../vendor/cdn.jsdelivr.net/npm/d3-array@3.2.4/+esm.js").to_string(),
    );
    m.insert(
        "/npm/d3-color@3.1.0/+esm".to_string(),
        include_str!("../../vendor/cdn.jsdelivr.net/npm/d3-color@3.1.0/+esm.js").to_string(),
    );
    m.insert(
        "/npm/d3-delaunay@6.0.4/+esm".to_string(),
        include_str!("../../vendor/cdn.jsdelivr.net/npm/d3-delaunay@6.0.4/+esm.js").to_string(),
    );
    m.insert(
        "/npm/d3-dispatch@3.0.1/+esm".to_string(),
        include_str!("../../vendor/cdn.jsdelivr.net/npm/d3-dispatch@3.0.1/+esm.js").to_string(),
    );
    m.insert(
        "/npm/d3-dsv@3.0.1/+esm".to_string(),
        include_str!("../../vendor/cdn.jsdelivr.net/npm/d3-dsv@3.0.1/+esm.js").to_string(),
    );
    m.insert(
        "/npm/d3-force@3.0.0/+esm".to_string(),
        include_str!("../../vendor/cdn.jsdelivr.net/npm/d3-force@3.0.0/+esm.js").to_string(),
    );
    m.insert(
        "/npm/d3-format@3.1.0/+esm".to_string(),
        include_str!("../../vendor/cdn.jsdelivr.net/npm/d3-format@3.1.0/+esm.js").to_string(),
    );
    m.insert(
        "/npm/d3-geo-projection@4.0.0/+esm".to_string(),
        include_str!("../../vendor/cdn.jsdelivr.net/npm/d3-geo-projection@4.0.0/+esm.js")
            .to_string(),
    );
    m.insert(
        "/npm/d3-geo@3.1.1/+esm".to_string(),
        include_str!("../../vendor/cdn.jsdelivr.net/npm/d3-geo@3.1.1/+esm.js").to_string(),
    );
    m.insert(
        "/npm/d3-hierarchy@3.1.2/+esm".to_string(),
        include_str!("../../vendor/cdn.jsdelivr.net/npm/d3-hierarchy@3.1.2/+esm.js").to_string(),
    );
    m.insert(
        "/npm/d3-interpolate@3.0.1/+esm".to_string(),
        include_str!("../../vendor/cdn.jsdelivr.net/npm/d3-interpolate@3.0.1/+esm.js").to_string(),
    );
    m.insert(
        "/npm/d3-path@3.1.0/+esm".to_string(),
        include_str!("../../vendor/cdn.jsdelivr.net/npm/d3-path@3.1.0/+esm.js").to_string(),
    );
    m.insert(
        "/npm/d3-quadtree@3.0.1/+esm".to_string(),
        include_str!("../../vendor/cdn.jsdelivr.net/npm/d3-quadtree@3.0.1/+esm.js").to_string(),
    );
    m.insert(
        "/npm/d3-scale-chromatic@3.1.0/+esm".to_string(),
        include_str!("../../vendor/cdn.jsdelivr.net/npm/d3-scale-chromatic@3.1.0/+esm.js")
            .to_string(),
    );
    m.insert(
        "/npm/d3-scale@4.0.2/+esm".to_string(),
        include_str!("../../vendor/cdn.jsdelivr.net/npm/d3-scale@4.0.2/+esm.js").to_string(),
    );
    m.insert(
        "/npm/d3-shape@3.2.0/+esm".to_string(),
        include_str!("../../vendor/cdn.jsdelivr.net/npm/d3-shape@3.2.0/+esm.js").to_string(),
    );
    m.insert(
        "/npm/d3-time-format@4.1.0/+esm".to_string(),
        include_str!("../../vendor/cdn.jsdelivr.net/npm/d3-time-format@4.1.0/+esm.js").to_string(),
    );
    m.insert(
        "/npm/d3-time@3.1.0/+esm".to_string(),
        include_str!("../../vendor/cdn.jsdelivr.net/npm/d3-time@3.1.0/+esm.js").to_string(),
    );
    m.insert(
        "/npm/d3-timer@3.0.1/+esm".to_string(),
        include_str!("../../vendor/cdn.jsdelivr.net/npm/d3-timer@3.0.1/+esm.js").to_string(),
    );
    m.insert(
        "/npm/delaunator@5.0.0/+esm".to_string(),
        include_str!("../../vendor/cdn.jsdelivr.net/npm/delaunator@5.0.0/+esm.js").to_string(),
    );
    m.insert(
        "/npm/fast-deep-equal@3.1.3/+esm".to_string(),
        include_str!("../../vendor/cdn.jsdelivr.net/npm/fast-deep-equal@3.1.3/+esm.js").to_string(),
    );
    m.insert(
        "/npm/fast-json-stable-stringify@2.1.0/+esm".to_string(),
        include_str!("../../vendor/cdn.jsdelivr.net/npm/fast-json-stable-stringify@2.1.0/+esm.js")
            .to_string(),
    );
    m.insert(
        "/npm/internmap@2.0.3/+esm".to_string(),
        include_str!("../../vendor/cdn.jsdelivr.net/npm/internmap@2.0.3/+esm.js").to_string(),
    );
    m.insert(
        "/npm/json-stringify-pretty-compact@4.0.0/+esm".to_string(),
        include_str!(
            "../../vendor/cdn.jsdelivr.net/npm/json-stringify-pretty-compact@4.0.0/+esm.js"
        )
        .to_string(),
    );
    m.insert(
        "/npm/lodash.debounce@4.0.8/+esm".to_string(),
        include_str!("../../vendor/cdn.jsdelivr.net/npm/lodash.debounce@4.0.8/+esm.js").to_string(),
    );
    m.insert(
        "/npm/robust-predicates@3.0.0/+esm".to_string(),
        include_str!("../../vendor/cdn.jsdelivr.net/npm/robust-predicates@3.0.0/+esm.js")
            .to_string(),
    );
    m.insert(
        "/npm/topojson-client@3.1.0/+esm".to_string(),
        include_str!("../../vendor/cdn.jsdelivr.net/npm/topojson-client@3.1.0/+esm.js").to_string(),
    );
    m.insert(
        "/npm/vega-canvas@2.0.0/+esm".to_string(),
        include_str!("../../vendor/cdn.jsdelivr.net/npm/vega-canvas@2.0.0/+esm.js").to_string(),
    );
    m.insert(
        "/npm/vega-crossfilter@5.1.0/+esm".to_string(),
        include_str!("../../vendor/cdn.jsdelivr.net/npm/vega-crossfilter@5.1.0/+esm.js")
            .to_string(),
    );
    m.insert(
        "/npm/vega-dataflow@6.1.0/+esm".to_string(),
        include_str!("../../vendor/cdn.jsdelivr.net/npm/vega-dataflow@6.1.0/+esm.js").to_string(),
    );
    m.insert(
        "/npm/vega-embed@7.0.2/+esm".to_string(),
        include_str!("../../vendor/cdn.jsdelivr.net/npm/vega-embed@7.0.2/+esm.js").to_string(),
    );
    m.insert(
        "/npm/vega-encode@5.1.0/+esm".to_string(),
        include_str!("../../vendor/cdn.jsdelivr.net/npm/vega-encode@5.1.0/+esm.js").to_string(),
    );
    m.insert(
        "/npm/vega-event-selector@4.0.0/+esm".to_string(),
        include_str!("../../vendor/cdn.jsdelivr.net/npm/vega-event-selector@4.0.0/+esm.js")
            .to_string(),
    );
    m.insert(
        "/npm/vega-expression@6.1.0/+esm".to_string(),
        include_str!("../../vendor/cdn.jsdelivr.net/npm/vega-expression@6.1.0/+esm.js").to_string(),
    );
    m.insert(
        "/npm/vega-force@5.1.0/+esm".to_string(),
        include_str!("../../vendor/cdn.jsdelivr.net/npm/vega-force@5.1.0/+esm.js").to_string(),
    );
    m.insert(
        "/npm/vega-format@2.1.0/+esm".to_string(),
        include_str!("../../vendor/cdn.jsdelivr.net/npm/vega-format@2.1.0/+esm.js").to_string(),
    );
    m.insert(
        "/npm/vega-functions@6.1.0/+esm".to_string(),
        include_str!("../../vendor/cdn.jsdelivr.net/npm/vega-functions@6.1.0/+esm.js").to_string(),
    );
    m.insert(
        "/npm/vega-geo@5.1.0/+esm".to_string(),
        include_str!("../../vendor/cdn.jsdelivr.net/npm/vega-geo@5.1.0/+esm.js").to_string(),
    );
    m.insert(
        "/npm/vega-hierarchy@5.1.0/+esm".to_string(),
        include_str!("../../vendor/cdn.jsdelivr.net/npm/vega-hierarchy@5.1.0/+esm.js").to_string(),
    );
    m.insert(
        "/npm/vega-interpreter@2.0.0/+esm".to_string(),
        include_str!("../../vendor/cdn.jsdelivr.net/npm/vega-interpreter@2.0.0/+esm.js")
            .to_string(),
    );
    m.insert(
        "/npm/vega-label@2.1.0/+esm".to_string(),
        include_str!("../../vendor/cdn.jsdelivr.net/npm/vega-label@2.1.0/+esm.js").to_string(),
    );
    m.insert(
        "/npm/vega-lite@5.14.1/+esm".to_string(),
        include_str!("../../vendor/cdn.jsdelivr.net/npm/vega-lite@5.14.1/+esm.js").to_string(),
    );
    m.insert(
        "/npm/vega-lite@5.15.1/+esm".to_string(),
        include_str!("../../vendor/cdn.jsdelivr.net/npm/vega-lite@5.15.1/+esm.js").to_string(),
    );
    m.insert(
        "/npm/vega-lite@5.16.3/+esm".to_string(),
        include_str!("../../vendor/cdn.jsdelivr.net/npm/vega-lite@5.16.3/+esm.js").to_string(),
    );
    m.insert(
        "/npm/vega-lite@5.17.0/+esm".to_string(),
        include_str!("../../vendor/cdn.jsdelivr.net/npm/vega-lite@5.17.0/+esm.js").to_string(),
    );
    m.insert(
        "/npm/vega-lite@5.20.1/+esm".to_string(),
        include_str!("../../vendor/cdn.jsdelivr.net/npm/vega-lite@5.20.1/+esm.js").to_string(),
    );
    m.insert(
        "/npm/vega-lite@5.21.0/+esm".to_string(),
        include_str!("../../vendor/cdn.jsdelivr.net/npm/vega-lite@5.21.0/+esm.js").to_string(),
    );
    m.insert(
        "/npm/vega-lite@5.8.0/+esm".to_string(),
        include_str!("../../vendor/cdn.jsdelivr.net/npm/vega-lite@5.8.0/+esm.js").to_string(),
    );
    m.insert(
        "/npm/vega-lite@6.1.0/+esm".to_string(),
        include_str!("../../vendor/cdn.jsdelivr.net/npm/vega-lite@6.1.0/+esm.js").to_string(),
    );
    m.insert(
        "/npm/vega-lite@6.4.1/+esm".to_string(),
        include_str!("../../vendor/cdn.jsdelivr.net/npm/vega-lite@6.4.1/+esm.js").to_string(),
    );
    m.insert(
        "/npm/vega-loader@5.1.0/+esm".to_string(),
        include_str!("../../vendor/cdn.jsdelivr.net/npm/vega-loader@5.1.0/+esm.js").to_string(),
    );
    m.insert(
        "/npm/vega-parser@7.1.0/+esm".to_string(),
        include_str!("../../vendor/cdn.jsdelivr.net/npm/vega-parser@7.1.0/+esm.js").to_string(),
    );
    m.insert(
        "/npm/vega-projection@2.1.0/+esm".to_string(),
        include_str!("../../vendor/cdn.jsdelivr.net/npm/vega-projection@2.1.0/+esm.js").to_string(),
    );
    m.insert(
        "/npm/vega-regression@2.1.0/+esm".to_string(),
        include_str!("../../vendor/cdn.jsdelivr.net/npm/vega-regression@2.1.0/+esm.js").to_string(),
    );
    m.insert(
        "/npm/vega-runtime@7.1.0/+esm".to_string(),
        include_str!("../../vendor/cdn.jsdelivr.net/npm/vega-runtime@7.1.0/+esm.js").to_string(),
    );
    m.insert(
        "/npm/vega-scale@8.1.0/+esm".to_string(),
        include_str!("../../vendor/cdn.jsdelivr.net/npm/vega-scale@8.1.0/+esm.js").to_string(),
    );
    m.insert(
        "/npm/vega-scenegraph@5.1.0/+esm".to_string(),
        include_str!("../../vendor/cdn.jsdelivr.net/npm/vega-scenegraph@5.1.0/+esm.js").to_string(),
    );
    m.insert(
        "/npm/vega-schema-url-parser@3.0.2/+esm".to_string(),
        include_str!("../../vendor/cdn.jsdelivr.net/npm/vega-schema-url-parser@3.0.2/+esm.js")
            .to_string(),
    );
    m.insert(
        "/npm/vega-selections@6.1.0/+esm".to_string(),
        include_str!("../../vendor/cdn.jsdelivr.net/npm/vega-selections@6.1.0/+esm.js").to_string(),
    );
    m.insert(
        "/npm/vega-statistics@2.0.0/+esm".to_string(),
        include_str!("../../vendor/cdn.jsdelivr.net/npm/vega-statistics@2.0.0/+esm.js").to_string(),
    );
    m.insert(
        "/npm/vega-themes@3.0.0/+esm".to_string(),
        include_str!("../../vendor/cdn.jsdelivr.net/npm/vega-themes@3.0.0/+esm.js").to_string(),
    );
    m.insert(
        "/npm/vega-time@3.1.0/+esm".to_string(),
        include_str!("../../vendor/cdn.jsdelivr.net/npm/vega-time@3.1.0/+esm.js").to_string(),
    );
    m.insert(
        "/npm/vega-tooltip@1.0.0/+esm".to_string(),
        include_str!("../../vendor/cdn.jsdelivr.net/npm/vega-tooltip@1.0.0/+esm.js").to_string(),
    );
    m.insert(
        "/npm/vega-transforms@5.1.0/+esm".to_string(),
        include_str!("../../vendor/cdn.jsdelivr.net/npm/vega-transforms@5.1.0/+esm.js").to_string(),
    );
    m.insert(
        "/npm/vega-util@2.1.0/+esm".to_string(),
        include_str!("../../vendor/cdn.jsdelivr.net/npm/vega-util@2.1.0/+esm.js").to_string(),
    );
    m.insert(
        "/npm/vega-view-transforms@5.1.0/+esm".to_string(),
        include_str!("../../vendor/cdn.jsdelivr.net/npm/vega-view-transforms@5.1.0/+esm.js")
            .to_string(),
    );
    m.insert(
        "/npm/vega-view@6.1.0/+esm".to_string(),
        include_str!("../../vendor/cdn.jsdelivr.net/npm/vega-view@6.1.0/+esm.js").to_string(),
    );
    m.insert(
        "/npm/vega-voronoi@5.1.0/+esm".to_string(),
        include_str!("../../vendor/cdn.jsdelivr.net/npm/vega-voronoi@5.1.0/+esm.js").to_string(),
    );
    m.insert(
        "/npm/vega-wordcloud@5.1.0/+esm".to_string(),
        include_str!("../../vendor/cdn.jsdelivr.net/npm/vega-wordcloud@5.1.0/+esm.js").to_string(),
    );
    m.insert(
        "/npm/vega@6.2.0/+esm".to_string(),
        include_str!("../../vendor/cdn.jsdelivr.net/npm/vega@6.2.0/+esm.js").to_string(),
    );
    m
}

pub fn build_format_locale_map() -> HashMap<String, String> {
    let mut m: HashMap<String, String> = HashMap::new();
    m.insert(
        "ar-001".to_string(),
        include_str!("../../locales/format/ar-001.json").to_string(),
    );
    m.insert(
        "ar-AE".to_string(),
        include_str!("../../locales/format/ar-AE.json").to_string(),
    );
    m.insert(
        "ar-BH".to_string(),
        include_str!("../../locales/format/ar-BH.json").to_string(),
    );
    m.insert(
        "ar-DJ".to_string(),
        include_str!("../../locales/format/ar-DJ.json").to_string(),
    );
    m.insert(
        "ar-DZ".to_string(),
        include_str!("../../locales/format/ar-DZ.json").to_string(),
    );
    m.insert(
        "ar-EG".to_string(),
        include_str!("../../locales/format/ar-EG.json").to_string(),
    );
    m.insert(
        "ar-EH".to_string(),
        include_str!("../../locales/format/ar-EH.json").to_string(),
    );
    m.insert(
        "ar-ER".to_string(),
        include_str!("../../locales/format/ar-ER.json").to_string(),
    );
    m.insert(
        "ar-IL".to_string(),
        include_str!("../../locales/format/ar-IL.json").to_string(),
    );
    m.insert(
        "ar-IQ".to_string(),
        include_str!("../../locales/format/ar-IQ.json").to_string(),
    );
    m.insert(
        "ar-JO".to_string(),
        include_str!("../../locales/format/ar-JO.json").to_string(),
    );
    m.insert(
        "ar-KM".to_string(),
        include_str!("../../locales/format/ar-KM.json").to_string(),
    );
    m.insert(
        "ar-KW".to_string(),
        include_str!("../../locales/format/ar-KW.json").to_string(),
    );
    m.insert(
        "ar-LB".to_string(),
        include_str!("../../locales/format/ar-LB.json").to_string(),
    );
    m.insert(
        "ar-LY".to_string(),
        include_str!("../../locales/format/ar-LY.json").to_string(),
    );
    m.insert(
        "ar-MA".to_string(),
        include_str!("../../locales/format/ar-MA.json").to_string(),
    );
    m.insert(
        "ar-MR".to_string(),
        include_str!("../../locales/format/ar-MR.json").to_string(),
    );
    m.insert(
        "ar-OM".to_string(),
        include_str!("../../locales/format/ar-OM.json").to_string(),
    );
    m.insert(
        "ar-PS".to_string(),
        include_str!("../../locales/format/ar-PS.json").to_string(),
    );
    m.insert(
        "ar-QA".to_string(),
        include_str!("../../locales/format/ar-QA.json").to_string(),
    );
    m.insert(
        "ar-SA".to_string(),
        include_str!("../../locales/format/ar-SA.json").to_string(),
    );
    m.insert(
        "ar-SD".to_string(),
        include_str!("../../locales/format/ar-SD.json").to_string(),
    );
    m.insert(
        "ar-SO".to_string(),
        include_str!("../../locales/format/ar-SO.json").to_string(),
    );
    m.insert(
        "ar-SS".to_string(),
        include_str!("../../locales/format/ar-SS.json").to_string(),
    );
    m.insert(
        "ar-SY".to_string(),
        include_str!("../../locales/format/ar-SY.json").to_string(),
    );
    m.insert(
        "ar-TD".to_string(),
        include_str!("../../locales/format/ar-TD.json").to_string(),
    );
    m.insert(
        "ar-TN".to_string(),
        include_str!("../../locales/format/ar-TN.json").to_string(),
    );
    m.insert(
        "ar-YE".to_string(),
        include_str!("../../locales/format/ar-YE.json").to_string(),
    );
    m.insert(
        "ca-ES".to_string(),
        include_str!("../../locales/format/ca-ES.json").to_string(),
    );
    m.insert(
        "cs-CZ".to_string(),
        include_str!("../../locales/format/cs-CZ.json").to_string(),
    );
    m.insert(
        "da-DK".to_string(),
        include_str!("../../locales/format/da-DK.json").to_string(),
    );
    m.insert(
        "de-CH".to_string(),
        include_str!("../../locales/format/de-CH.json").to_string(),
    );
    m.insert(
        "de-DE".to_string(),
        include_str!("../../locales/format/de-DE.json").to_string(),
    );
    m.insert(
        "en-CA".to_string(),
        include_str!("../../locales/format/en-CA.json").to_string(),
    );
    m.insert(
        "en-GB".to_string(),
        include_str!("../../locales/format/en-GB.json").to_string(),
    );
    m.insert(
        "en-IE".to_string(),
        include_str!("../../locales/format/en-IE.json").to_string(),
    );
    m.insert(
        "en-IN".to_string(),
        include_str!("../../locales/format/en-IN.json").to_string(),
    );
    m.insert(
        "en-US".to_string(),
        include_str!("../../locales/format/en-US.json").to_string(),
    );
    m.insert(
        "es-BO".to_string(),
        include_str!("../../locales/format/es-BO.json").to_string(),
    );
    m.insert(
        "es-ES".to_string(),
        include_str!("../../locales/format/es-ES.json").to_string(),
    );
    m.insert(
        "es-MX".to_string(),
        include_str!("../../locales/format/es-MX.json").to_string(),
    );
    m.insert(
        "fi-FI".to_string(),
        include_str!("../../locales/format/fi-FI.json").to_string(),
    );
    m.insert(
        "fr-CA".to_string(),
        include_str!("../../locales/format/fr-CA.json").to_string(),
    );
    m.insert(
        "fr-FR".to_string(),
        include_str!("../../locales/format/fr-FR.json").to_string(),
    );
    m.insert(
        "he-IL".to_string(),
        include_str!("../../locales/format/he-IL.json").to_string(),
    );
    m.insert(
        "hu-HU".to_string(),
        include_str!("../../locales/format/hu-HU.json").to_string(),
    );
    m.insert(
        "it-IT".to_string(),
        include_str!("../../locales/format/it-IT.json").to_string(),
    );
    m.insert(
        "ja-JP".to_string(),
        include_str!("../../locales/format/ja-JP.json").to_string(),
    );
    m.insert(
        "ko-KR".to_string(),
        include_str!("../../locales/format/ko-KR.json").to_string(),
    );
    m.insert(
        "mk-MK".to_string(),
        include_str!("../../locales/format/mk-MK.json").to_string(),
    );
    m.insert(
        "nl-NL".to_string(),
        include_str!("../../locales/format/nl-NL.json").to_string(),
    );
    m.insert(
        "pl-PL".to_string(),
        include_str!("../../locales/format/pl-PL.json").to_string(),
    );
    m.insert(
        "pt-BR".to_string(),
        include_str!("../../locales/format/pt-BR.json").to_string(),
    );
    m.insert(
        "pt-PT".to_string(),
        include_str!("../../locales/format/pt-PT.json").to_string(),
    );
    m.insert(
        "ru-RU".to_string(),
        include_str!("../../locales/format/ru-RU.json").to_string(),
    );
    m.insert(
        "sl-SI".to_string(),
        include_str!("../../locales/format/sl-SI.json").to_string(),
    );
    m.insert(
        "sv-SE".to_string(),
        include_str!("../../locales/format/sv-SE.json").to_string(),
    );
    m.insert(
        "uk-UA".to_string(),
        include_str!("../../locales/format/uk-UA.json").to_string(),
    );
    m.insert(
        "zh-CN".to_string(),
        include_str!("../../locales/format/zh-CN.json").to_string(),
    );
    m
}

pub fn build_time_format_locale_map() -> HashMap<String, String> {
    let mut m: HashMap<String, String> = HashMap::new();
    m.insert(
        "ar-EG".to_string(),
        include_str!("../../locales/time-format/ar-EG.json").to_string(),
    );
    m.insert(
        "ar-SY".to_string(),
        include_str!("../../locales/time-format/ar-SY.json").to_string(),
    );
    m.insert(
        "ca-ES".to_string(),
        include_str!("../../locales/time-format/ca-ES.json").to_string(),
    );
    m.insert(
        "cs-CZ".to_string(),
        include_str!("../../locales/time-format/cs-CZ.json").to_string(),
    );
    m.insert(
        "da-DK".to_string(),
        include_str!("../../locales/time-format/da-DK.json").to_string(),
    );
    m.insert(
        "de-CH".to_string(),
        include_str!("../../locales/time-format/de-CH.json").to_string(),
    );
    m.insert(
        "de-DE".to_string(),
        include_str!("../../locales/time-format/de-DE.json").to_string(),
    );
    m.insert(
        "en-CA".to_string(),
        include_str!("../../locales/time-format/en-CA.json").to_string(),
    );
    m.insert(
        "en-GB".to_string(),
        include_str!("../../locales/time-format/en-GB.json").to_string(),
    );
    m.insert(
        "en-US".to_string(),
        include_str!("../../locales/time-format/en-US.json").to_string(),
    );
    m.insert(
        "es-ES".to_string(),
        include_str!("../../locales/time-format/es-ES.json").to_string(),
    );
    m.insert(
        "es-MX".to_string(),
        include_str!("../../locales/time-format/es-MX.json").to_string(),
    );
    m.insert(
        "fa-IR".to_string(),
        include_str!("../../locales/time-format/fa-IR.json").to_string(),
    );
    m.insert(
        "fi-FI".to_string(),
        include_str!("../../locales/time-format/fi-FI.json").to_string(),
    );
    m.insert(
        "fr-CA".to_string(),
        include_str!("../../locales/time-format/fr-CA.json").to_string(),
    );
    m.insert(
        "fr-FR".to_string(),
        include_str!("../../locales/time-format/fr-FR.json").to_string(),
    );
    m.insert(
        "he-IL".to_string(),
        include_str!("../../locales/time-format/he-IL.json").to_string(),
    );
    m.insert(
        "hr-HR".to_string(),
        include_str!("../../locales/time-format/hr-HR.json").to_string(),
    );
    m.insert(
        "hu-HU".to_string(),
        include_str!("../../locales/time-format/hu-HU.json").to_string(),
    );
    m.insert(
        "it-IT".to_string(),
        include_str!("../../locales/time-format/it-IT.json").to_string(),
    );
    m.insert(
        "ja-JP".to_string(),
        include_str!("../../locales/time-format/ja-JP.json").to_string(),
    );
    m.insert(
        "ko-KR".to_string(),
        include_str!("../../locales/time-format/ko-KR.json").to_string(),
    );
    m.insert(
        "mk-MK".to_string(),
        include_str!("../../locales/time-format/mk-MK.json").to_string(),
    );
    m.insert(
        "nb-NO".to_string(),
        include_str!("../../locales/time-format/nb-NO.json").to_string(),
    );
    m.insert(
        "nl-BE".to_string(),
        include_str!("../../locales/time-format/nl-BE.json").to_string(),
    );
    m.insert(
        "nl-NL".to_string(),
        include_str!("../../locales/time-format/nl-NL.json").to_string(),
    );
    m.insert(
        "pl-PL".to_string(),
        include_str!("../../locales/time-format/pl-PL.json").to_string(),
    );
    m.insert(
        "pt-BR".to_string(),
        include_str!("../../locales/time-format/pt-BR.json").to_string(),
    );
    m.insert(
        "ru-RU".to_string(),
        include_str!("../../locales/time-format/ru-RU.json").to_string(),
    );
    m.insert(
        "sv-SE".to_string(),
        include_str!("../../locales/time-format/sv-SE.json").to_string(),
    );
    m.insert(
        "tr-TR".to_string(),
        include_str!("../../locales/time-format/tr-TR.json").to_string(),
    );
    m.insert(
        "uk-UA".to_string(),
        include_str!("../../locales/time-format/uk-UA.json").to_string(),
    );
    m.insert(
        "vi-VN".to_string(),
        include_str!("../../locales/time-format/vi-VN.json").to_string(),
    );
    m.insert(
        "zh-CN".to_string(),
        include_str!("../../locales/time-format/zh-CN.json").to_string(),
    );
    m.insert(
        "zh-TW".to_string(),
        include_str!("../../locales/time-format/zh-TW.json").to_string(),
    );
    m
}
