from typing import List

from .._models import BaseModel

__all__ = ["CreateTokenizationResponse"]


class CreateTokenizationResponse(BaseModel):
    tokens: List[str]
    """The list of tokens generated by the model."""

    total_tokens: int
    """The total number of tokens generated by the model."""

    token_ids: List[int]
    """The list of ids of tokens generated by the model."""

    offset_mapping: List[List[int]]
    """The list of offsets of tokens generated by the model."""

