from typing import List, Optional
from typing_extensions import Literal

from ..._models import BaseModel

__all__ = ["MultimodalEmbedding", "SparseEmbedding"]


class SparseEmbedding(BaseModel):
    index: int
    """The token index of the embedding."""
    value: float
    """The value of the embedding."""


class MultimodalEmbedding(BaseModel):
    embedding: List[float]
    """The embedding vector, which is a list of floats."""

    object: Literal["embedding"]
    """The object type, which is always "embedding"."""

    sparse_embedding: Optional[SparseEmbedding] = None
    """The sparse embeddings generated by the model."""
