
# Copyright (c) [2025] [OpenAI]
# Copyright (c) [2025] [ByteDance Ltd. and/or its affiliates.]
# SPDX-License-Identifier: Apache-2.0
#
# This file has been modified by [ByteDance Ltd. and/or its affiliates.] on 2025.7
#
# Original file was released under Apache License Version 2.0, with the full license text
# available at https://github.com/openai/openai-python/blob/main/LICENSE.
#
# This modified file is released under the same license.

from typing import List, Dict

from .completion_usage import CompletionUsage
from .._models import BaseModel

__all__ = ["CreateClassificationResponse"]


class LabelLogprobosValue(BaseModel):
    tokens: List[str]
    """The tokens of the label generated by the model."""

    token_logprobs: List[float]
    """The logprobs of the tokens generated by the model."""


class CreateClassificationResponse(BaseModel):
    label: str
    """The label generated by the model."""

    label_logprobos: Dict[str, LabelLogprobosValue]
    """The logprobos of labels generated by the model."""

    usage: CompletionUsage
    """Usage statistics for the completion request."""
