
# Copyright (c) [2025] [OpenAI]
# Copyright (c) [2025] [ByteDance Ltd. and/or its affiliates.]
# SPDX-License-Identifier: Apache-2.0
#
# This file has been modified by [ByteDance Ltd. and/or its affiliates.] on 2025.7
#
# Original file was released under Apache License Version 2.0, with the full license text
# available at https://github.com/openai/openai-python/blob/main/LICENSE.
#
# This modified file is released under the same license.

from typing import List
from typing_extensions import Literal

from .embedding_data import MultimodalEmbedding
from .embedding_usage import MultimodalEmbeddingUsage
from ..._models import BaseModel

__all__ = ["MultimodalEmbeddingResponse"]


class MultimodalEmbeddingResponse(BaseModel):
    id: str
    """A unique identifier for the embeddings."""

    created: int
    """The Unix timestamp (in seconds) of when the embeddings was created."""

    data: MultimodalEmbedding
    """The embeddings generated by the model."""

    model: str
    """The name of the model used to generate the embedding."""

    object: Literal["list"]
    """The object type, which is always "list"."""

    usage: MultimodalEmbeddingUsage
    """The usage information for the request."""
