# Copyright (c) [2025] [OpenAI]
# Copyright (c) [2025] [ByteDance Ltd. and/or its affiliates.]
# SPDX-License-Identifier: Apache-2.0
#
# This file has been modified by [ByteDance Ltd. and/or its affiliates.] on 2025.7
#
# Original file was released under Apache License Version 2.0, with the full license text
# available at https://github.com/openai/openai-python/blob/main/LICENSE.
#
# This modified file is released under the same license.

from typing import List
from typing_extensions import Literal

from .._models import BaseModel
from .embedding import Embedding

__all__ = ["CreateEmbeddingResponse", "Usage"]


class Usage(BaseModel):
    prompt_tokens: int
    """The number of tokens used by the prompt."""

    total_tokens: int
    """The total number of tokens used by the request."""


class CreateEmbeddingResponse(BaseModel):
    id: str
    """A unique identifier for the embeddings."""

    created: int
    """The Unix timestamp (in seconds) of when the embeddings was created."""

    data: List[Embedding]
    """The list of embeddings generated by the model."""

    model: str
    """The name of the model used to generate the embedding."""

    object: Literal["list"]
    """The object type, which is always "list"."""

    usage: Usage
    """The usage information for the request."""
