use vortex_error::VortexResult;

mod array;
mod dtype;
mod recordbatch;
pub mod wrappers;

pub trait FromArrowArray<A> {
    fn from_arrow(array: A, nullable: bool) -> Self;
}

pub trait FromArrowType<T>: Sized {
    fn from_arrow(value: T) -> Self;
}

pub trait TryFromArrowType<T>: Sized {
    fn try_from_arrow(value: T) -> VortexResult<Self>;
}
