from . import _lib
from ._lib import register
from ._lib.arrays import (
    AlpArray,
    AlpRdArray,
    BinaryTypeArray,
    BoolArray,
    BoolTypeArray,
    ChunkedArray,
    ConstantArray,
    DateTimePartsArray,
    DictArray,
    ExtensionArray,
    ExtensionTypeArray,
    FastLanesBitPackedArray,
    FastLanesDeltaArray,
    FastLanesFoRArray,
    Float16TypeArray,
    Float32TypeArray,
    Float64TypeArray,
    FloatTypeArray,
    FsstArray,
    Int8TypeArray,
    Int16TypeArray,
    Int32TypeArray,
    Int64TypeArray,
    IntegerTypeArray,
    IntTypeArray,
    ListArray,
    ListTypeArray,
    NullArray,
    NullTypeArray,
    PrimitiveArray,
    PrimitiveTypeArray,
    PyEncoding,
    RunEndArray,
    SparseArray,
    StructArray,
    StructTypeArray,
    UInt8TypeArray,
    UInt16TypeArray,
    UInt32TypeArray,
    UInt64TypeArray,
    UIntTypeArray,
    Utf8TypeArray,
    VarBinArray,
    VarBinViewArray,
    ZigZagArray,
)
from ._lib.compress import compress
from ._lib.dtype import (
    BinaryDType,
    BoolDType,
    DType,
    ExtensionDType,
    ListDType,
    NullDType,
    PrimitiveDType,
    StructDType,
    Utf8DType,
    binary,
    bool_,
    float_,
    int_,
    list_,
    null,
    struct,
    uint,
    utf8,
)
from ._lib.scalar import (
    BinaryScalar,
    BoolScalar,
    ExtensionScalar,
    ListScalar,
    NullScalar,
    PrimitiveScalar,
    Scalar,
    StructScalar,
    Utf8Scalar,
    scalar,
)
from .arrays import Array, array

assert _lib, "Ensure we eagerly import the Vortex native library"

__all__ = [
    "array",
    "compress",
    "register",
    # Arrays
    "Array",
    "NullTypeArray",
    "BoolTypeArray",
    "PrimitiveTypeArray",
    "IntegerTypeArray",
    "UIntTypeArray",
    "UInt8TypeArray",
    "UInt16TypeArray",
    "UInt32TypeArray",
    "UInt64TypeArray",
    "IntTypeArray",
    "Int8TypeArray",
    "Int16TypeArray",
    "Int32TypeArray",
    "Int64TypeArray",
    "FloatTypeArray",
    "Float16TypeArray",
    "Float32TypeArray",
    "Float64TypeArray",
    "Utf8TypeArray",
    "BinaryTypeArray",
    "StructTypeArray",
    "ListTypeArray",
    "ExtensionTypeArray",
    # DTypes
    "DType",
    "NullDType",
    "BoolDType",
    "PrimitiveDType",
    "Utf8DType",
    "BinaryDType",
    "StructDType",
    "ListDType",
    "ExtensionDType",
    "null",
    "bool_",
    "int_",
    "uint",
    "float_",
    "utf8",
    "binary",
    "struct",
    "list_",
    # Encodings
    "ConstantArray",
    "ChunkedArray",
    "NullArray",
    "BoolArray",
    "PrimitiveArray",
    "VarBinArray",
    "VarBinViewArray",
    "StructArray",
    "ListArray",
    "ExtensionArray",
    "PyEncoding",
    "AlpArray",
    "AlpRdArray",
    "DateTimePartsArray",
    "DictArray",
    "FsstArray",
    "RunEndArray",
    "SparseArray",
    "ZigZagArray",
    "FastLanesBitPackedArray",
    "FastLanesDeltaArray",
    "FastLanesFoRArray",
    # Scalars
    "scalar",
    "Scalar",
    "NullScalar",
    "BoolScalar",
    "PrimitiveScalar",
    "Utf8Scalar",
    "BinaryScalar",
    "StructScalar",
    "ListScalar",
    "ExtensionScalar",
]
