from typing import Any, final

import numpy as np
import pandas as pd
import polars as pl
import pyarrow as pa

import vortex as vx

class Array:
    def __lt__(self, other: Array) -> Array: ...
    def __le__(self, other: Array) -> Array: ...
    def __gt__(self, other: Array) -> Array: ...
    def __ge__(self, other: Array) -> Array: ...
    def __len__(self) -> int: ...
    @staticmethod
    def from_arrow(obj: pa.Array | pa.ChunkedArray | pa.Table) -> Array: ...
    def to_arrow_array(self) -> pa.Array: ...
    @property
    def encoding(self) -> str: ...
    @property
    def nbytes(self) -> int: ...
    @property
    def dtype(self) -> vx.DType: ...
    def filter(self, mask: Array) -> Array: ...
    def fill_forward(self) -> Array: ...
    def scalar_at(self, index: int) -> Any: ...
    def take(self, indices: Array) -> Array: ...
    def slice(self, start: int, end: int) -> Array: ...
    def tree_display(self) -> str: ...
    def to_arrow_table(self) -> pa.Table: ...
    def to_numpy(self, *, zero_copy_only: bool = True) -> np.ndarray: ...
    def to_pandas_df(self) -> pd.DataFrame: ...
    def to_polars_dataframe(self) -> pl.DataFrame: ...
    def to_polars_series(self) -> pl.Series: ...
    def to_pylist(self) -> list: ...

@final
class NullArray(vx.Array): ...

@final
class BoolArray(vx.Array): ...

@final
class PrimitiveArray(vx.Array): ...

@final
class VarBinArray(vx.Array): ...

@final
class VarBinViewArray(vx.Array): ...

@final
class StructArray(vx.Array):
    def field(self, name: str) -> vx.Array: ...

@final
class ListArray(vx.Array): ...

@final
class ExtensionArray(vx.Array): ...

class PyEncoding(vx.Array): ...

@final
class ConstantArray(vx.Array):
    def scalar(self) -> vx.Scalar: ...

@final
class ChunkedArray(vx.Array):
    def chunks(self) -> list[vx.Array]: ...

@final
class AlpArray(vx.Array): ...

@final
class AlpRdArray(vx.Array): ...

@final
class DateTimePartsArray(vx.Array): ...

@final
class DictArray(vx.Array): ...

@final
class FsstArray(vx.Array): ...

@final
class RunEndArray(vx.Array): ...

@final
class SparseArray(vx.Array): ...

@final
class ZigZagArray(vx.Array): ...

@final
class FastLanesBitPackedArray(vx.Array):
    @property
    def bit_width(self) -> int: ...

@final
class FastLanesDeltaArray(vx.Array): ...

@final
class FastLanesFoRArray(vx.Array): ...

@final
class NullTypeArray(Array): ...

@final
class BoolTypeArray(Array): ...

@final
class PrimitiveTypeArray(Array): ...

@final
class IntegerTypeArray(vx.Array): ...

@final
class UIntTypeArray(Array): ...

@final
class IntTypeArray(Array): ...

@final
class UInt8TypeArray(Array): ...

@final
class UInt16TypeArray(Array): ...

@final
class UInt32TypeArray(Array): ...

@final
class UInt64TypeArray(Array): ...

@final
class Int8TypeArray(Array): ...

@final
class Int16TypeArray(Array): ...

@final
class Int32TypeArray(Array): ...

@final
class Int64TypeArray(Array): ...

@final
class FloatTypeArray(Array): ...

@final
class Float16TypeArray(Array): ...

@final
class Float32TypeArray(Array): ...

@final
class Float64TypeArray(Array): ...

@final
class Utf8TypeArray(Array): ...

@final
class BinaryTypeArray(Array): ...

@final
class StructTypeArray(Array): ...

@final
class ListTypeArray(Array): ...

@final
class ExtensionTypeArray(Array): ...
