from typing import Literal, final

import pyarrow as pa

class DType:
    @classmethod
    def from_arrow(cls, arrow_dtype: pa.DataType, *, non_nullable: bool = False) -> DType: ...

@final
class NullDType(DType): ...

@final
class BoolDType(DType): ...

@final
class PrimitiveDType(DType): ...

@final
class Utf8DType(DType): ...

@final
class BinaryDType(DType): ...

@final
class StructDType(DType):
    def names(self) -> list[str]: ...
    def fields(self) -> list[DType]: ...

@final
class ListDType(DType): ...

@final
class ExtensionDType(DType): ...

def null() -> DType: ...
def bool_(*, nullable: bool = False) -> DType: ...
def int_(width: Literal[8, 16, 32, 64] = 64, *, nullable: bool = False) -> DType: ...
def uint(width: Literal[8, 16, 32, 64] = 64, *, nullable: bool = False) -> DType: ...
def float_(width: Literal[16, 32, 64] = 64, *, nullable: bool = False) -> DType: ...
def utf8(*, nullable: bool = False) -> DType: ...
def binary(*, nullable: bool = False) -> DType: ...
def struct(fields: dict[str, DType] | None = None, *, nullable: bool = False) -> DType: ...
def list_(element: DType, *, nullable: bool = False) -> DType: ...
