#![feature(once_cell_try)]
#![feature(portable_simd)]
#![feature(substr_range)]
#![feature(trusted_len)]
//! Vortex crate containing core logic for encoding and memory representation of [arrays](ArrayRef).
//!
//! At the heart of Vortex are [arrays](ArrayRef) and [encodings](vtable::EncodingVTable).
//! Arrays are typed views of memory buffers that hold [scalars](vortex_scalar::Scalar). These
//! buffers can be held in a number of physical encodings to perform lightweight compression that
//! exploits the particular data distribution of the array's values.
//!
//! Every data type recognized by Vortex also has a canonical physical encoding format, which
//! arrays can be [canonicalized](Canonical) into for ease of access in compute functions.

pub use array::*;
pub use canonical::*;
pub use context::*;
pub use encoding::*;
pub use metadata::*;

pub mod accessor;
pub mod aliases;
pub mod arcref;
mod array;
pub mod arrays;
pub mod arrow;
pub mod builders;
mod canonical;
pub mod compress;
pub mod compute;
mod context;
mod encoding;
pub mod iter;
mod metadata;
pub mod nbytes;
mod partial_ord;
pub mod patches;
pub mod serde;
pub mod stats;
pub mod stream;
#[cfg(feature = "test-harness")]
pub mod test_harness;
mod tree;
pub mod validity;
pub mod variants;
pub mod vtable;

pub mod flatbuffers {
    //! Re-exported autogenerated code from the core Vortex flatbuffer definitions.
    pub use vortex_flatbuffers::array::*;
}
