mod eval_expr;
mod reader;
pub mod writer;

use std::collections::BTreeSet;
use std::sync::Arc;

use vortex_array::ArrayContext;
use vortex_dtype::FieldMask;
use vortex_error::VortexResult;

use crate::layouts::flat::reader::FlatReader;
use crate::reader::{LayoutReader, LayoutReaderExt};
use crate::segments::SegmentSource;
use crate::vtable::LayoutVTable;
use crate::{FLAT_LAYOUT_ID, Layout, LayoutId};

#[derive(Debug)]
pub struct FlatLayout;

impl LayoutVTable for FlatLayout {
    fn id(&self) -> LayoutId {
        FLAT_LAYOUT_ID
    }

    fn reader(
        &self,
        layout: Layout,
        segment_source: &Arc<dyn SegmentSource>,
        ctx: &ArrayContext,
    ) -> VortexResult<Arc<dyn LayoutReader>> {
        Ok(FlatReader::try_new(layout, segment_source.clone(), ctx.clone())?.into_arc())
    }

    fn register_splits(
        &self,
        layout: &Layout,
        field_mask: &[FieldMask],
        row_offset: u64,
        splits: &mut BTreeSet<u64>,
    ) -> VortexResult<()> {
        for path in field_mask {
            if path.matches_root() {
                splits.insert(row_offset + layout.row_count());
                break;
            }
        }
        Ok(())
    }
}
