use vortex_error::{VortexResult, vortex_err};
use vortex_scalar::BinaryNumericOperator;

use crate::arrays::{ConstantArray, ConstantEncoding};
use crate::compute::BinaryNumericFn;
use crate::{Array, ArrayRef};

impl BinaryNumericFn<&ConstantArray> for ConstantEncoding {
    fn binary_numeric(
        &self,
        array: &ConstantArray,
        rhs: &dyn Array,
        op: BinaryNumericOperator,
    ) -> VortexResult<Option<ArrayRef>> {
        let Some(rhs) = rhs.as_constant() else {
            return Ok(None);
        };

        Ok(Some(
            ConstantArray::new(
                array
                    .scalar()
                    .as_primitive()
                    .checked_binary_numeric(&rhs.as_primitive(), op)
                    .ok_or_else(|| vortex_err!("numeric overflow"))?,
                array.len(),
            )
            .into_array(),
        ))
    }
}
