# Vouchsafe-python

Vouchsafe offers a REST API to conduct operations programmatically.

You can request and manage verifications, as well as perform smart lookups.

To use the API, you need a client ID and secret from the Vouchsafe dashboard. [Sign up here](https://app.vouchsafe.id/) if you haven't already.

We also have a [video guide](https://www.youtube.com/playlist?list=PLx6V6SSTMuF_ZNWBPnysvwmdIwboLViE8) showing the basics, as well as [SDKs and libraries](https://help.vouchsafe.id/en/articles/12026847-vouchsafe-sdks-and-libraries) for popular languages.

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.1.0
- Package version: 0.1.0
- Generator version: 7.16.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen
  For more information, please visit [https://help.vouchsafe.id](https://help.vouchsafe.id)

## Requirements.

Python 3.9+

## Installation & Usage

### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```

(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:

```python
import vouchsafe_python
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```

(or `sudo python setup.py install` to install the package for all users)

Then import the package:

```python
import vouchsafe_python
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import vouchsafe_python
from vouchsafe_python.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://app.vouchsafe.id/api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = vouchsafe_python.Configuration(
    host = "https://app.vouchsafe.id/api/v1"
)



# Enter a context with an instance of the API client
with vouchsafe_python.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = vouchsafe_python.AuthenticationApi(api_client)
    authenticate_input = vouchsafe_python.AuthenticateInput() # AuthenticateInput |

    try:
        api_response = api_instance.authenticate(authenticate_input)
        print("The response of AuthenticationApi->authenticate:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling AuthenticationApi->authenticate: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://app.vouchsafe.id/api/v1*

| Class               | Method                                                                    | HTTP request                    | Description |
| ------------------- | ------------------------------------------------------------------------- | ------------------------------- | ----------- |
| _AuthenticationApi_ | [**authenticate**](docs/AuthenticationApi.md#authenticate)                | **POST** /authenticate          |
| _FlowsApi_          | [**get_flow**](docs/FlowsApi.md#get_flow)                                 | **GET** /flows/{id}             |
| _FlowsApi_          | [**list_flows**](docs/FlowsApi.md#list_flows)                             | **GET** /flows                  |
| _SmartLookupsApi_   | [**perform_smart_lookup**](docs/SmartLookupsApi.md#perform_smart_lookup)  | **POST** /smart-lookups         |
| _SmartLookupsApi_   | [**search_postcode**](docs/SmartLookupsApi.md#search_postcode)            | **GET** /smart-lookups/postcode |
| _TeamApi_           | [**create_team**](docs/TeamApi.md#create_team)                            | **POST** /team                  |
| _TeamApi_           | [**get_team**](docs/TeamApi.md#get_team)                                  | **GET** /team                   |
| _VerificationsApi_  | [**get_verification**](docs/VerificationsApi.md#get_verification)         | **GET** /verifications/{id}     |
| _VerificationsApi_  | [**list_verifications**](docs/VerificationsApi.md#list_verifications)     | **GET** /verifications          |
| _VerificationsApi_  | [**request_verification**](docs/VerificationsApi.md#request_verification) | **POST** /verifications         |

## Documentation For Models

- [ApiErrorResponse](docs/ApiErrorResponse.md)
- [AuthenticateInput](docs/AuthenticateInput.md)
- [AuthenticateResponse](docs/AuthenticateResponse.md)
- [CheckResult](docs/CheckResult.md)
- [CheckState](docs/CheckState.md)
- [CreateTeamInput](docs/CreateTeamInput.md)
- [CreateTeamResponse](docs/CreateTeamResponse.md)
- [CreateTeamResponseCredentials](docs/CreateTeamResponseCredentials.md)
- [Flow](docs/Flow.md)
- [FlowTemplate](docs/FlowTemplate.md)
- [GetSmartLookupResponse](docs/GetSmartLookupResponse.md)
- [Model36EnumsBackgroundCheck](docs/Model36EnumsBackgroundCheck.md)
- [Model36EnumsEnvironment](docs/Model36EnumsEnvironment.md)
- [PostcodeResponse](docs/PostcodeResponse.md)
- [Reason](docs/Reason.md)
- [RecordAddressVerificationChecksCheckResult](docs/RecordAddressVerificationChecksCheckResult.md)
- [Report](docs/Report.md)
- [RequestVerificationInput](docs/RequestVerificationInput.md)
- [RequestVerificationResponse](docs/RequestVerificationResponse.md)
- [SmartLookupInput](docs/SmartLookupInput.md)
- [Status](docs/Status.md)
- [Team](docs/Team.md)
- [Verification](docs/Verification.md)

<a id="documentation-for-authorization"></a>

## Documentation For Authorization

Authentication schemes defined for the API:
<a id="bearerAuth"></a>

### bearerAuth

- **Type**: Bearer authentication (JWT)

## Author

help@vouchsafe.id
