# coding: utf-8

"""
    Vouchsafe API docs

    Vouchsafe offers a REST API to conduct operations programmatically.  You can request and manage verifications, as well as perform smart lookups.  To use the API, you need a client ID and secret from the Vouchsafe dashboard. [Sign up here](https://app.vouchsafe.id/) if you haven't already.  We also have a [video guide](https://www.youtube.com/playlist?list=PLx6V6SSTMuF_ZNWBPnysvwmdIwboLViE8) showing the basics, as well as [SDKs and libraries](https://help.vouchsafe.id/en/articles/12026847-vouchsafe-sdks-and-libraries) for popular languages.

    The version of the OpenAPI document: 0.1.0
    Contact: help@vouchsafe.id
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from vouchsafe_python.models.model36_enums_background_check import Model36EnumsBackgroundCheck
from vouchsafe_python.models.report import Report
from typing import Optional, Set
from typing_extensions import Self

class GetSmartLookupResponse(BaseModel):
    """
    GetSmartLookupResponse
    """ # noqa: E501
    id: StrictStr
    team_id: StrictStr
    checks: List[Model36EnumsBackgroundCheck]
    first_name: Optional[StrictStr]
    last_name: Optional[StrictStr]
    first_line_of_address: Optional[StrictStr]
    postcode: Optional[StrictStr]
    address_verification_report: Optional[Report] = Field(description="Whether the overall check and its sub-checks passed, failed or somethng else.")
    metadata: Optional[Any] = Field(description="Extra information to aid debugging. May change without notice.")
    created_at: StrictStr
    __properties: ClassVar[List[str]] = ["id", "team_id", "checks", "first_name", "last_name", "first_line_of_address", "postcode", "address_verification_report", "metadata", "created_at"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetSmartLookupResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of address_verification_report
        if self.address_verification_report:
            _dict['address_verification_report'] = self.address_verification_report.to_dict()
        # set to None if first_name (nullable) is None
        # and model_fields_set contains the field
        if self.first_name is None and "first_name" in self.model_fields_set:
            _dict['first_name'] = None

        # set to None if last_name (nullable) is None
        # and model_fields_set contains the field
        if self.last_name is None and "last_name" in self.model_fields_set:
            _dict['last_name'] = None

        # set to None if first_line_of_address (nullable) is None
        # and model_fields_set contains the field
        if self.first_line_of_address is None and "first_line_of_address" in self.model_fields_set:
            _dict['first_line_of_address'] = None

        # set to None if postcode (nullable) is None
        # and model_fields_set contains the field
        if self.postcode is None and "postcode" in self.model_fields_set:
            _dict['postcode'] = None

        # set to None if address_verification_report (nullable) is None
        # and model_fields_set contains the field
        if self.address_verification_report is None and "address_verification_report" in self.model_fields_set:
            _dict['address_verification_report'] = None

        # set to None if metadata (nullable) is None
        # and model_fields_set contains the field
        if self.metadata is None and "metadata" in self.model_fields_set:
            _dict['metadata'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetSmartLookupResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "team_id": obj.get("team_id"),
            "checks": obj.get("checks"),
            "first_name": obj.get("first_name"),
            "last_name": obj.get("last_name"),
            "first_line_of_address": obj.get("first_line_of_address"),
            "postcode": obj.get("postcode"),
            "address_verification_report": Report.from_dict(obj["address_verification_report"]) if obj.get("address_verification_report") is not None else None,
            "metadata": obj.get("metadata"),
            "created_at": obj.get("created_at")
        })
        return _obj


