# coding: utf-8

"""
    Vouchsafe API docs

    Vouchsafe offers a REST API to conduct operations programmatically.  You can request and manage verifications, as well as perform smart lookups.  To use the API, you need a client ID and secret from the Vouchsafe dashboard. [Sign up here](https://app.vouchsafe.id/) if you haven't already.  We also have a [video guide](https://www.youtube.com/playlist?list=PLx6V6SSTMuF_ZNWBPnysvwmdIwboLViE8) showing the basics, as well as [SDKs and libraries](https://help.vouchsafe.id/en/articles/12026847-vouchsafe-sdks-and-libraries) for popular languages.

    The version of the OpenAPI document: 0.1.0
    Contact: help@vouchsafe.id
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List
from vouchsafe_python.models.check_result import CheckResult
from typing import Optional, Set
from typing_extensions import Self

class RecordAddressVerificationChecksCheckResult(BaseModel):
    """
    Construct a type with a set of properties K of type T
    """ # noqa: E501
    postcode_exists: CheckResult = Field(alias="POSTCODE_EXISTS")
    address_exists: CheckResult = Field(alias="ADDRESS_EXISTS")
    person_lives_at_address: CheckResult = Field(alias="PERSON_LIVES_AT_ADDRESS")
    __properties: ClassVar[List[str]] = ["POSTCODE_EXISTS", "ADDRESS_EXISTS", "PERSON_LIVES_AT_ADDRESS"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RecordAddressVerificationChecksCheckResult from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of postcode_exists
        if self.postcode_exists:
            _dict['POSTCODE_EXISTS'] = self.postcode_exists.to_dict()
        # override the default output from pydantic by calling `to_dict()` of address_exists
        if self.address_exists:
            _dict['ADDRESS_EXISTS'] = self.address_exists.to_dict()
        # override the default output from pydantic by calling `to_dict()` of person_lives_at_address
        if self.person_lives_at_address:
            _dict['PERSON_LIVES_AT_ADDRESS'] = self.person_lives_at_address.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RecordAddressVerificationChecksCheckResult from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "POSTCODE_EXISTS": CheckResult.from_dict(obj["POSTCODE_EXISTS"]) if obj.get("POSTCODE_EXISTS") is not None else None,
            "ADDRESS_EXISTS": CheckResult.from_dict(obj["ADDRESS_EXISTS"]) if obj.get("ADDRESS_EXISTS") is not None else None,
            "PERSON_LIVES_AT_ADDRESS": CheckResult.from_dict(obj["PERSON_LIVES_AT_ADDRESS"]) if obj.get("PERSON_LIVES_AT_ADDRESS") is not None else None
        })
        return _obj


