# coding: utf-8

"""
    Vouchsafe API docs

    Vouchsafe offers a REST API to conduct operations programmatically.  You can request and manage verifications, as well as perform smart lookups.  To use the API, you need a client ID and secret from the Vouchsafe dashboard. [Sign up here](https://app.vouchsafe.id/) if you haven't already.  We also have a [video guide](https://www.youtube.com/playlist?list=PLx6V6SSTMuF_ZNWBPnysvwmdIwboLViE8) showing the basics, as well as [SDKs and libraries](https://help.vouchsafe.id/en/articles/12026847-vouchsafe-sdks-and-libraries) for popular languages.

    The version of the OpenAPI document: 0.1.0
    Contact: help@vouchsafe.id
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class RequestVerificationInput(BaseModel):
    """
    RequestVerificationInput
    """ # noqa: E501
    email: StrictStr = Field(description="The user's email address")
    first_name: Optional[StrictStr] = Field(default=None, description="The user's first name, if you have it")
    last_name: Optional[StrictStr] = Field(default=None, description="The user's last name, if you have it")
    street_address: Optional[StrictStr] = Field(default=None, description="The user's street address, if you have it")
    postcode: Optional[StrictStr] = Field(default=None, description="The user's postcode, if you have it")
    date_of_birth: Optional[StrictStr] = Field(default=None, description="The user's date of birth, if you have it")
    workflow_id: Optional[StrictStr] = Field(default=None, description="Which verification flow to use.  Get the flow ID from the URL of the builder page.  For example: `/admin/teams/abc123/builder/[workflow_id]`  If not provided, the last published flow is used instead.")
    external_id: Optional[StrictStr] = Field(default=None, description="An identifier from your own systems, to avoid needing to store Vouchsafe's own ID")
    redirect_url: Optional[StrictStr] = Field(default=None, description="A generic or unique URL to send the user back to upon success.  If not provided, the verification flow default will be used.")
    expires_at: Optional[StrictStr] = Field(default=None, description="When will the verification session expire and the user cease getting reminders?  If not provided, the verification flow default will be used.")
    __properties: ClassVar[List[str]] = ["email", "first_name", "last_name", "street_address", "postcode", "date_of_birth", "workflow_id", "external_id", "redirect_url", "expires_at"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RequestVerificationInput from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RequestVerificationInput from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "email": obj.get("email"),
            "first_name": obj.get("first_name"),
            "last_name": obj.get("last_name"),
            "street_address": obj.get("street_address"),
            "postcode": obj.get("postcode"),
            "date_of_birth": obj.get("date_of_birth"),
            "workflow_id": obj.get("workflow_id"),
            "external_id": obj.get("external_id"),
            "redirect_url": obj.get("redirect_url"),
            "expires_at": obj.get("expires_at")
        })
        return _obj


