# coding: utf-8

"""
    Vouchsafe API docs

    Vouchsafe offers a REST API to conduct operations programmatically.  You can request and manage verifications, as well as perform smart lookups.  To use the API, you need a client ID and secret from the Vouchsafe dashboard. [Sign up here](https://app.vouchsafe.id/) if you haven't already.  We also have a [video guide](https://www.youtube.com/playlist?list=PLx6V6SSTMuF_ZNWBPnysvwmdIwboLViE8) showing the basics, as well as [SDKs and libraries](https://help.vouchsafe.id/en/articles/12026847-vouchsafe-sdks-and-libraries) for popular languages.

    The version of the OpenAPI document: 0.1.0
    Contact: help@vouchsafe.id
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List
from typing import Optional, Set
from typing_extensions import Self

class SmartLookupInput(BaseModel):
    """
    SmartLookupInput
    """ # noqa: E501
    first_line_of_address: StrictStr = Field(description="Should be taken from GET /postcode endpoint")
    postcode: StrictStr
    first_name: StrictStr
    last_name: StrictStr
    checks: List[StrictStr] = Field(description="Experimental, other checks coming soon")
    __properties: ClassVar[List[str]] = ["first_line_of_address", "postcode", "first_name", "last_name", "checks"]

    @field_validator('checks')
    def checks_validate_enum(cls, value):
        """Validates the enum"""
        for i in value:
            if i not in set(['Address']):
                raise ValueError("each list item must be one of ('Address')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SmartLookupInput from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SmartLookupInput from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "first_line_of_address": obj.get("first_line_of_address"),
            "postcode": obj.get("postcode"),
            "first_name": obj.get("first_name"),
            "last_name": obj.get("last_name"),
            "checks": obj.get("checks")
        })
        return _obj


