# coding: utf-8

"""
    Vouchsafe API docs

    Vouchsafe offers a REST API to conduct operations programmatically.  You can request and manage verifications, as well as perform smart lookups.  To use the API, you need a client ID and secret from the Vouchsafe dashboard. [Sign up here](https://app.vouchsafe.id/) if you haven't already.  We also have a [video guide](https://www.youtube.com/playlist?list=PLx6V6SSTMuF_ZNWBPnysvwmdIwboLViE8) showing the basics, as well as [SDKs and libraries](https://help.vouchsafe.id/en/articles/12026847-vouchsafe-sdks-and-libraries) for popular languages.

    The version of the OpenAPI document: 0.1.0
    Contact: help@vouchsafe.id
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List
from typing import Optional, Set
from typing_extensions import Self

class Team(BaseModel):
    """
    Team
    """ # noqa: E501
    id: StrictStr = Field(description="The client ID of the team, as shown in the dashboard")
    name: StrictStr = Field(description="The name of the team")
    public_name: StrictStr = Field(description="The public name of the team, shown in end-user facing screens and communications. If set, overrides the name.")
    plan: StrictStr = Field(description="Which plan is the team on?")
    logo_url: StrictStr = Field(description="Path to the team's logo image")
    updated_at: StrictStr = Field(description="When the team's details were last changed, formatted as an ISO 8601 string")
    created_at: StrictStr = Field(description="When the team was created, formatted as an ISO 8601 string")
    __properties: ClassVar[List[str]] = ["id", "name", "public_name", "plan", "logo_url", "updated_at", "created_at"]

    @field_validator('plan')
    def plan_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['Trial', 'PAYG', 'Flex', 'Enterprise']):
            raise ValueError("must be one of enum values ('Trial', 'PAYG', 'Flex', 'Enterprise')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Team from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Team from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "public_name": obj.get("public_name"),
            "plan": obj.get("plan"),
            "logo_url": obj.get("logo_url"),
            "updated_at": obj.get("updated_at"),
            "created_at": obj.get("created_at")
        })
        return _obj


