# Generated by Django 4.1.7 on 2023-11-29 09:30

from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone


class Migration(migrations.Migration):

    dependencies = [
        ("vulnerabilities", "0042_advisory_status_vulnerability_status"),
    ]

    operations = [
        migrations.AlterUniqueTogether(
            name="advisory",
            unique_together=set(),
        ),
        migrations.AddField(
            model_name="advisory",
            name="url",
            field=models.URLField(
                blank=True, help_text="Link to the advisory on the upstream website"
            ),
        ),
        migrations.AlterField(
            model_name="vulnerability",
            name="status",
            field=models.IntegerField(
                choices=[(1, "Published"), (2, "Disputed"), (3, "Invalid")], default=1
            ),
        ),
        migrations.AlterUniqueTogether(
            name="advisory",
            unique_together={("aliases", "unique_content_id", "date_published", "url")},
        ),
        migrations.CreateModel(
            name="VulnerabilityChangeLog",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                (
                    "action_time",
                    models.DateTimeField(
                        default=django.utils.timezone.now,
                        editable=False,
                        help_text="Time of the change",
                    ),
                ),
                (
                    "actor_name",
                    models.CharField(
                        help_text="Name of the actor: either a script or username for instance tgoel, NVDImporter or NginxImprover.",
                        max_length=100,
                    ),
                ),
                (
                    "source_url",
                    models.URLField(
                        blank=True,
                        help_text="URL to the source of this change",
                        max_length=1024,
                        null=True,
                    ),
                ),
                (
                    "software_version",
                    models.CharField(
                        default="33.6.5",
                        help_text="Version of the software at the time of change",
                        max_length=100,
                    ),
                ),
                (
                    "action_type",
                    models.PositiveSmallIntegerField(choices=[(1, "Import"), (2, "Improve")]),
                ),
                (
                    "vulnerability",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="changelog",
                        to="vulnerabilities.vulnerability",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="PackageChangeLog",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                (
                    "action_time",
                    models.DateTimeField(
                        default=django.utils.timezone.now,
                        editable=False,
                        help_text="Time of the change",
                    ),
                ),
                (
                    "actor_name",
                    models.CharField(
                        help_text="Name of the actor: either a script or username for instance tgoel, NVDImporter or NginxImprover.",
                        max_length=100,
                    ),
                ),
                (
                    "source_url",
                    models.URLField(
                        blank=True,
                        help_text="URL to the source of this change",
                        max_length=1024,
                        null=True,
                    ),
                ),
                (
                    "software_version",
                    models.CharField(
                        default="33.6.5",
                        help_text="Version of the software at the time of change",
                        max_length=100,
                    ),
                ),
                (
                    "related_vulnerability",
                    models.CharField(
                        blank=True,
                        help_text="VCID of the vulnerability related to this package",
                        max_length=1024,
                        null=True,
                    ),
                ),
                (
                    "action_type",
                    models.PositiveSmallIntegerField(
                        choices=[(1, "Affected by"), (2, "Fixing")]
                    ),
                ),
                (
                    "package",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="changelog",
                        to="vulnerabilities.package",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
    ]
