# Generated by Django 4.1.13 on 2023-12-05 14:54

from itertools import groupby

from django.db import migrations
from django.db.models import Count


class Migration(migrations.Migration):

    def remove_dupes(apps, schema_editor):
        """
        Remove duplicated Package with the same purl and the same "serialized"
        qualifiers. Some qualifiers have been stored in the JSON field as
        dicts/objects and some have been seralized as query strings/normalized
        qualifiers and then just stored as a JSON string.

        We are keeping the JSON dict over the string variant.
        """
        Package = apps.get_model("vulnerabilities", "Package")

        duplicates = (
            Package.objects
            .exclude(qualifiers__in=("", None, {}))
            .values_list("package_url")
            .order_by("package_url")
            .annotate(count_id=Count("id"))
            .filter(count_id__gt=1)
        )
        to_delete = []
        # Get all rows with the same purl,
        # delete the qualifier(s) that are a string
        # and keep the others
        for purl, _cid in duplicates:
            for package in Package.objects.filter(package_url=purl):
                if isinstance(package.qualifiers, str):
                    to_delete.append(package.id)

        deleted, _ = Package.objects.filter(id__in=to_delete).delete()
        print(f"Deleted {deleted} duplicated Packages")

    dependencies = [
        ("vulnerabilities", "0044_alter_packagechangelog_options_and_more"),
    ]

    operations = [
        migrations.RunPython(remove_dupes, reverse_code=migrations.RunPython.noop),
    ]
