# Generated by Django 4.1.13 on 2024-08-14 14:52

from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ("vulnerabilities", "0059_vulnerabilityseverity_published_at_and_more"),
    ]

    operations = [
        migrations.AlterField(
            model_name="kev",
            name="known_ransomware_campaign_use",
            field=models.BooleanField(
                default=False,
                help_text="Known if this vulnerability is known to have been leveraged as part of a ransomware campaign;\n        or 'Unknown' if CISA lacks confirmation that the vulnerability has been utilized for ransomware.",
            ),
        ),
        migrations.AlterField(
            model_name="packagechangelog",
            name="software_version",
            field=models.CharField(
                default="34.0.0rc5",
                help_text="Version of the software at the time of change",
                max_length=100,
            ),
        ),
        migrations.AlterField(
            model_name="vulnerabilitychangelog",
            name="software_version",
            field=models.CharField(
                default="34.0.0rc5",
                help_text="Version of the software at the time of change",
                max_length=100,
            ),
        ),
        migrations.AlterField(
            model_name="vulnerabilityseverity",
            name="scoring_system",
            field=models.CharField(
                choices=[
                    ("cvssv2", "CVSSv2 Base Score"),
                    ("cvssv3", "CVSSv3 Base Score"),
                    ("cvssv3.1", "CVSSv3.1 Base Score"),
                    ("cvssv4", "CVSSv4 Base Score"),
                    ("rhbs", "RedHat Bugzilla severity"),
                    ("rhas", "RedHat Aggregate severity"),
                    ("archlinux", "Archlinux Vulnerability Group Severity"),
                    ("cvssv3.1_qr", "CVSSv3.1 Qualitative Severity Rating"),
                    ("generic_textual", "Generic textual severity rating"),
                    ("apache_httpd", "Apache Httpd Severity"),
                    ("apache_tomcat", "Apache Tomcat Severity"),
                    ("epss", "Exploit Prediction Scoring System"),
                    ("ssvc", "Stakeholder-Specific Vulnerability Categorization"),
                ],
                help_text="Identifier for the scoring system used. Available choices are: cvssv2: CVSSv2 Base Score,\ncvssv3: CVSSv3 Base Score,\ncvssv3.1: CVSSv3.1 Base Score,\ncvssv4: CVSSv4 Base Score,\nrhbs: RedHat Bugzilla severity,\nrhas: RedHat Aggregate severity,\narchlinux: Archlinux Vulnerability Group Severity,\ncvssv3.1_qr: CVSSv3.1 Qualitative Severity Rating,\ngeneric_textual: Generic textual severity rating,\napache_httpd: Apache Httpd Severity,\napache_tomcat: Apache Tomcat Severity,\nepss: Exploit Prediction Scoring System,\nssvc: Stakeholder-Specific Vulnerability Categorization ",
                max_length=50,
            ),
        ),
    ]
