# Generated by Django 4.2.15 on 2024-09-27 13:08

from django.db import migrations

"""
Update the created_by field on Advisory from the old qualified_name
to the new pipeline_id.
"""


def update_created_by(apps, schema_editor):
    from vulnerabilities.pipelines.gitlab_importer import GitLabImporterPipeline

    Advisory = apps.get_model("vulnerabilities", "Advisory")
    Advisory.objects.filter(created_by="vulnerabilities.importers.gitlab.GitLabAPIImporter").update(
        created_by=GitLabImporterPipeline.pipeline_id
    )



def reverse_update_created_by(apps, schema_editor):
    from vulnerabilities.pipelines.gitlab_importer import GitLabImporterPipeline

    Advisory = apps.get_model("vulnerabilities", "Advisory")
    Advisory.objects.filter(created_by=GitLabImporterPipeline.pipeline_id).update(
        created_by="vulnerabilities.importers.gitlab.GitLabAPIImporter"
    )


class Migration(migrations.Migration):

    dependencies = [
        ("vulnerabilities", "0065_update_nginx_advisory_created_by"),
    ]

    operations = [
        migrations.RunPython(update_created_by, reverse_code=reverse_update_created_by),
    ]
