# do not import all endpoints into this module because that uses a lot of memory and stack frames
# if you need the ability to import all endpoints from this module, import them with
# from openapi_client.apis.path_to_api import path_to_api

import enum


class PathValues(str, enum.Enum):
    PRIVATENETWORKS_NETWORKID = "/private-networks/{network-id}"
    PRIVATENETWORKS = "/private-networks"
    VPCS_VPCID = "/vpcs/{vpc-id}"
    VPCS = "/vpcs"
    USERS_USERID = "/users/{user-id}"
    USERS = "/users"
    STARTUPSCRIPTS_STARTUPID = "/startup-scripts/{startup-id}"
    STARTUPSCRIPTS = "/startup-scripts"
    SSHKEYS_SSHKEYID = "/ssh-keys/{ssh-key-id}"
    SSHKEYS = "/ssh-keys"
    SNAPSHOTS_SNAPSHOTID = "/snapshots/{snapshot-id}"
    SNAPSHOTS = "/snapshots"
    SNAPSHOTS_CREATEFROMURL = "/snapshots/create-from-url"
    RESERVEDIPS_RESERVEDIP = "/reserved-ips/{reserved-ip}"
    RESERVEDIPS = "/reserved-ips"
    RESERVEDIPS_RESERVEDIP_ATTACH = "/reserved-ips/{reserved-ip}/attach"
    RESERVEDIPS_RESERVEDIP_DETACH = "/reserved-ips/{reserved-ip}/detach"
    RESERVEDIPS_CONVERT = "/reserved-ips/convert"
    OS = "/os"
    APPLICATIONS = "/applications"
    ACCOUNT = "/account"
    BACKUPS = "/backups"
    BLOCKS = "/blocks"
    BLOCKS_BLOCKID = "/blocks/{block-id}"
    BLOCKS_BLOCKID_ATTACH = "/blocks/{block-id}/attach"
    BLOCKS_BLOCKID_DETACH = "/blocks/{block-id}/detach"
    FIREWALLS = "/firewalls"
    FIREWALLS_FIREWALLGROUPID = "/firewalls/{firewall-group-id}"
    FIREWALLS_FIREWALLGROUPID_RULES = "/firewalls/{firewall-group-id}/rules"
    FIREWALLS_FIREWALLGROUPID_RULES_FIREWALLRULEID = "/firewalls/{firewall-group-id}/rules/{firewall-rule-id}"
    ISO = "/iso"
    ISO_ISOID = "/iso/{iso-id}"
    ISOPUBLIC = "/iso-public"
    OBJECTSTORAGE = "/object-storage"
    OBJECTSTORAGE_OBJECTSTORAGEID = "/object-storage/{object-storage-id}"
    OBJECTSTORAGE_OBJECTSTORAGEID_REGENERATEKEYS = "/object-storage/{object-storage-id}/regenerate-keys"
    OBJECTSTORAGE_CLUSTERS = "/object-storage/clusters"
    DOMAINS = "/domains"
    DOMAINS_DNSDOMAIN = "/domains/{dns-domain}"
    DOMAINS_DNSDOMAIN_SOA = "/domains/{dns-domain}/soa"
    DOMAINS_DNSDOMAIN_DNSSEC = "/domains/{dns-domain}/dnssec"
    DOMAINS_DNSDOMAIN_RECORDS = "/domains/{dns-domain}/records"
    DOMAINS_DNSDOMAIN_RECORDS_RECORDID = "/domains/{dns-domain}/records/{record-id}"
    REGIONS = "/regions"
    REGIONS_REGIONID_AVAILABILITY = "/regions/{region-id}/availability"
    LOADBALANCERS = "/load-balancers"
    LOADBALANCERS_LOADBALANCERID = "/load-balancers/{load-balancer-id}"
    LOADBALANCERS_LOADBALANCERID_FORWARDINGRULES = "/load-balancers/{load-balancer-id}/forwarding-rules"
    LOADBALANCERS_LOADBALANCERID_FORWARDINGRULES_FORWARDINGRULEID = "/load-balancers/{load-balancer-id}/forwarding-rules/{forwarding-rule-id}"
    PLANS = "/plans"
    PLANSMETAL = "/plans-metal"
    BAREMETALS = "/bare-metals"
    BAREMETALS_BAREMETALID = "/bare-metals/{baremetal-id}"
    BAREMETALS_BAREMETALID_IPV4 = "/bare-metals/{baremetal-id}/ipv4"
    BAREMETALS_BAREMETALID_IPV6 = "/bare-metals/{baremetal-id}/ipv6"
    BAREMETALS_BAREMETALID_START = "/bare-metals/{baremetal-id}/start"
    BAREMETALS_BAREMETALID_REBOOT = "/bare-metals/{baremetal-id}/reboot"
    BAREMETALS_BAREMETALID_REINSTALL = "/bare-metals/{baremetal-id}/reinstall"
    BAREMETALS_BAREMETALID_HALT = "/bare-metals/{baremetal-id}/halt"
    BAREMETALS_BAREMETALID_BANDWIDTH = "/bare-metals/{baremetal-id}/bandwidth"
    BAREMETALS_HALT = "/bare-metals/halt"
    BAREMETALS_REBOOT = "/bare-metals/reboot"
    BAREMETALS_START = "/bare-metals/start"
    BAREMETALS_BAREMETALID_USERDATA = "/bare-metals/{baremetal-id}/user-data"
    INSTANCES = "/instances"
    INSTANCES_INSTANCEID = "/instances/{instance-id}"
    INSTANCES_HALT = "/instances/halt"
    INSTANCES_REBOOT = "/instances/reboot"
    INSTANCES_START = "/instances/start"
    INSTANCES_INSTANCEID_START = "/instances/{instance-id}/start"
    INSTANCES_INSTANCEID_REBOOT = "/instances/{instance-id}/reboot"
    INSTANCES_INSTANCEID_REINSTALL = "/instances/{instance-id}/reinstall"
    INSTANCES_INSTANCEID_BANDWIDTH = "/instances/{instance-id}/bandwidth"
    INSTANCES_INSTANCEID_NEIGHBORS = "/instances/{instance-id}/neighbors"
    INSTANCES_INSTANCEID_PRIVATENETWORKS = "/instances/{instance-id}/private-networks"
    INSTANCES_INSTANCEID_VPCS = "/instances/{instance-id}/vpcs"
    INSTANCES_INSTANCEID_ISO = "/instances/{instance-id}/iso"
    INSTANCES_INSTANCEID_ISO_ATTACH = "/instances/{instance-id}/iso/attach"
    INSTANCES_INSTANCEID_ISO_DETACH = "/instances/{instance-id}/iso/detach"
    INSTANCES_INSTANCEID_PRIVATENETWORKS_ATTACH = "/instances/{instance-id}/private-networks/attach"
    INSTANCES_INSTANCEID_PRIVATENETWORKS_DETACH = "/instances/{instance-id}/private-networks/detach"
    INSTANCES_INSTANCEID_VPCS_ATTACH = "/instances/{instance-id}/vpcs/attach"
    INSTANCES_INSTANCEID_VPCS_DETACH = "/instances/{instance-id}/vpcs/detach"
    INSTANCES_INSTANCEID_BACKUPSCHEDULE = "/instances/{instance-id}/backup-schedule"
    INSTANCES_INSTANCEID_RESTORE = "/instances/{instance-id}/restore"
    INSTANCES_INSTANCEID_IPV4 = "/instances/{instance-id}/ipv4"
    INSTANCES_INSTANCEID_IPV6 = "/instances/{instance-id}/ipv6"
    INSTANCES_INSTANCEID_IPV6_REVERSE = "/instances/{instance-id}/ipv6/reverse"
    INSTANCES_INSTANCEID_IPV4_REVERSE = "/instances/{instance-id}/ipv4/reverse"
    BACKUPS_BACKUPID = "/backups/{backup-id}"
    INSTANCES_INSTANCEID_USERDATA = "/instances/{instance-id}/user-data"
    INSTANCES_INSTANCEID_HALT = "/instances/{instance-id}/halt"
    INSTANCES_INSTANCEID_IPV4_REVERSE_DEFAULT = "/instances/{instance-id}/ipv4/reverse/default"
    INSTANCES_INSTANCEID_IPV4_IPV4 = "/instances/{instance-id}/ipv4/{ipv4}"
    INSTANCES_INSTANCEID_IPV6_REVERSE_IPV6 = "/instances/{instance-id}/ipv6/reverse/{ipv6}"
    INSTANCES_INSTANCEID_UPGRADES = "/instances/{instance-id}/upgrades"
    BAREMETALS_BAREMETALID_UPGRADES = "/bare-metals/{baremetal-id}/upgrades"
    BAREMETALS_BAREMETALID_VNC = "/bare-metals/{baremetal-id}/vnc"
    LOADBALANCERS_LOADBALANCERID_FIREWALLRULES = "/load-balancers/{loadbalancer-id}/firewall-rules"
    LOADBALANCERS_LOADBALANCERID_FIREWALLRULES_FIREWALLRULEID = "/load-balancers/{loadbalancer-id}/firewall-rules/{firewall-rule-id}"
    KUBERNETES_CLUSTERS = "/kubernetes/clusters"
    KUBERNETES_CLUSTERS_VKEID = "/kubernetes/clusters/{vke-id}"
    KUBERNETES_CLUSTERS_VKEID_DELETEWITHLINKEDRESOURCES = "/kubernetes/clusters/{vke-id}/delete-with-linked-resources"
    KUBERNETES_CLUSTERS_VKEID_RESOURCES = "/kubernetes/clusters/{vke-id}/resources"
    KUBERNETES_CLUSTERS_VKEID_AVAILABLEUPGRADES = "/kubernetes/clusters/{vke-id}/available-upgrades"
    KUBERNETES_CLUSTERS_VKEID_UPGRADES = "/kubernetes/clusters/{vke-id}/upgrades"
    KUBERNETES_CLUSTERS_VKEID_NODEPOOLS = "/kubernetes/clusters/{vke-id}/node-pools"
    KUBERNETES_CLUSTERS_VKEID_NODEPOOLS_NODEPOOLID = "/kubernetes/clusters/{vke-id}/node-pools/{nodepool-id}"
    KUBERNETES_CLUSTERS_VKEID_NODEPOOLS_NODEPOOLID_NODES_NODEID = "/kubernetes/clusters/{vke-id}/node-pools/{nodepool-id}/nodes/{node-id}"
    KUBERNETES_CLUSTERS_VKEID_NODEPOOLS_NODEPOOLID_NODES_NODEID_RECYCLE = "/kubernetes/clusters/{vke-id}/node-pools/{nodepool-id}/nodes/{node-id}/recycle"
    KUBERNETES_CLUSTERS_VKEID_CONFIG = "/kubernetes/clusters/{vke-id}/config"
    KUBERNETES_VERSIONS = "/kubernetes/versions"
    BILLING_HISTORY = "/billing/history"
    BILLING_INVOICES = "/billing/invoices"
    BILLING_INVOICES_INVOICEID = "/billing/invoices/{invoice-id}"
    BILLING_INVOICES_INVOICEID_ITEMS = "/billing/invoices/{invoice-id}/items"
