# coding: utf-8

"""
    Wandelbots Nova Public API

    Interact with robots in an easy and intuitive way. 

    The version of the OpenAPI document: 1.0.0 beta
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from furl import furl
import json
import humps
import re
import warnings
import websockets
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, AsyncGenerator, Callable, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Optional, Union
from typing_extensions import Annotated
from wandelbots_api_client.models.execute_to_trajectory_request import ExecuteToTrajectoryRequest
from wandelbots_api_client.models.get_trajectory_response import GetTrajectoryResponse
from wandelbots_api_client.models.get_trajectory_sample_response import GetTrajectorySampleResponse
from wandelbots_api_client.models.motion_ids_list_response import MotionIdsListResponse
from wandelbots_api_client.models.move_request import MoveRequest
from wandelbots_api_client.models.plan_request import PlanRequest
from wandelbots_api_client.models.plan_response import PlanResponse
from wandelbots_api_client.models.stream_move_response import StreamMoveResponse

from wandelbots_api_client.api_client import ApiClient, RequestSerialized
from wandelbots_api_client.api_response import ApiResponse
from wandelbots_api_client.rest import RESTResponseType

class MotionApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_call
    async def delete_all_motions(
        self,
        cell: Annotated[str, Field(strict=True, description="Unique identifier addressing a cell in all API calls. Since the cell identifier is used as Kubernetes namespace, the following rules apply: * Contain only lowercase alphanumeric characters or '-'. * Start with an alphanumeric character. * End with an alphanumeric character. * A maximum length of 63 characters. * The identifier \"kube-system\", \"default\" and \"wandelbots\" are reserved and cannot be used. ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """All Motions

        Delete all registered motions.

        :param cell: Unique identifier addressing a cell in all API calls. Since the cell identifier is used as Kubernetes namespace, the following rules apply: * Contain only lowercase alphanumeric characters or '-'. * Start with an alphanumeric character. * End with an alphanumeric character. * A maximum length of 63 characters. * The identifier \"kube-system\", \"default\" and \"wandelbots\" are reserved and cannot be used.  (required)
        :type cell: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_all_motions_serialize(
            cell=cell,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def delete_all_motions_with_http_info(
        self,
        cell: Annotated[str, Field(strict=True, description="Unique identifier addressing a cell in all API calls. Since the cell identifier is used as Kubernetes namespace, the following rules apply: * Contain only lowercase alphanumeric characters or '-'. * Start with an alphanumeric character. * End with an alphanumeric character. * A maximum length of 63 characters. * The identifier \"kube-system\", \"default\" and \"wandelbots\" are reserved and cannot be used. ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """All Motions

        Delete all registered motions.

        :param cell: Unique identifier addressing a cell in all API calls. Since the cell identifier is used as Kubernetes namespace, the following rules apply: * Contain only lowercase alphanumeric characters or '-'. * Start with an alphanumeric character. * End with an alphanumeric character. * A maximum length of 63 characters. * The identifier \"kube-system\", \"default\" and \"wandelbots\" are reserved and cannot be used.  (required)
        :type cell: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_all_motions_serialize(
            cell=cell,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def delete_all_motions_without_preload_content(
        self,
        cell: Annotated[str, Field(strict=True, description="Unique identifier addressing a cell in all API calls. Since the cell identifier is used as Kubernetes namespace, the following rules apply: * Contain only lowercase alphanumeric characters or '-'. * Start with an alphanumeric character. * End with an alphanumeric character. * A maximum length of 63 characters. * The identifier \"kube-system\", \"default\" and \"wandelbots\" are reserved and cannot be used. ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """All Motions

        Delete all registered motions.

        :param cell: Unique identifier addressing a cell in all API calls. Since the cell identifier is used as Kubernetes namespace, the following rules apply: * Contain only lowercase alphanumeric characters or '-'. * Start with an alphanumeric character. * End with an alphanumeric character. * A maximum length of 63 characters. * The identifier \"kube-system\", \"default\" and \"wandelbots\" are reserved and cannot be used.  (required)
        :type cell: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_all_motions_serialize(
            cell=cell,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _delete_all_motions_serialize(
        self,
        cell,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if cell is not None:
            _path_params['cell'] = cell
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'BasicAuth'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/cells/{cell}/motions',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )



    @validate_call
    async def delete_motion(
        self,
        cell: Annotated[str, Field(strict=True, description="Unique identifier addressing a cell in all API calls. Since the cell identifier is used as Kubernetes namespace, the following rules apply: * Contain only lowercase alphanumeric characters or '-'. * Start with an alphanumeric character. * End with an alphanumeric character. * A maximum length of 63 characters. * The identifier \"kube-system\", \"default\" and \"wandelbots\" are reserved and cannot be used. ")],
        motion: Annotated[StrictStr, Field(description="This represents the UUID of a motion. Every executable or partially executable motion is cached and an UUID is returned. Indicate the UUID to execute the motion or retrieve information on the motion.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Remove

        Remove a previously created motion from cache. Use [listMotions](listMotions) to list all available motions. Motions are removed automatically if the motion group or the corresponding controller is disconnected.

        :param cell: Unique identifier addressing a cell in all API calls. Since the cell identifier is used as Kubernetes namespace, the following rules apply: * Contain only lowercase alphanumeric characters or '-'. * Start with an alphanumeric character. * End with an alphanumeric character. * A maximum length of 63 characters. * The identifier \"kube-system\", \"default\" and \"wandelbots\" are reserved and cannot be used.  (required)
        :type cell: str
        :param motion: This represents the UUID of a motion. Every executable or partially executable motion is cached and an UUID is returned. Indicate the UUID to execute the motion or retrieve information on the motion. (required)
        :type motion: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_motion_serialize(
            cell=cell,
            motion=motion,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def delete_motion_with_http_info(
        self,
        cell: Annotated[str, Field(strict=True, description="Unique identifier addressing a cell in all API calls. Since the cell identifier is used as Kubernetes namespace, the following rules apply: * Contain only lowercase alphanumeric characters or '-'. * Start with an alphanumeric character. * End with an alphanumeric character. * A maximum length of 63 characters. * The identifier \"kube-system\", \"default\" and \"wandelbots\" are reserved and cannot be used. ")],
        motion: Annotated[StrictStr, Field(description="This represents the UUID of a motion. Every executable or partially executable motion is cached and an UUID is returned. Indicate the UUID to execute the motion or retrieve information on the motion.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Remove

        Remove a previously created motion from cache. Use [listMotions](listMotions) to list all available motions. Motions are removed automatically if the motion group or the corresponding controller is disconnected.

        :param cell: Unique identifier addressing a cell in all API calls. Since the cell identifier is used as Kubernetes namespace, the following rules apply: * Contain only lowercase alphanumeric characters or '-'. * Start with an alphanumeric character. * End with an alphanumeric character. * A maximum length of 63 characters. * The identifier \"kube-system\", \"default\" and \"wandelbots\" are reserved and cannot be used.  (required)
        :type cell: str
        :param motion: This represents the UUID of a motion. Every executable or partially executable motion is cached and an UUID is returned. Indicate the UUID to execute the motion or retrieve information on the motion. (required)
        :type motion: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_motion_serialize(
            cell=cell,
            motion=motion,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def delete_motion_without_preload_content(
        self,
        cell: Annotated[str, Field(strict=True, description="Unique identifier addressing a cell in all API calls. Since the cell identifier is used as Kubernetes namespace, the following rules apply: * Contain only lowercase alphanumeric characters or '-'. * Start with an alphanumeric character. * End with an alphanumeric character. * A maximum length of 63 characters. * The identifier \"kube-system\", \"default\" and \"wandelbots\" are reserved and cannot be used. ")],
        motion: Annotated[StrictStr, Field(description="This represents the UUID of a motion. Every executable or partially executable motion is cached and an UUID is returned. Indicate the UUID to execute the motion or retrieve information on the motion.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Remove

        Remove a previously created motion from cache. Use [listMotions](listMotions) to list all available motions. Motions are removed automatically if the motion group or the corresponding controller is disconnected.

        :param cell: Unique identifier addressing a cell in all API calls. Since the cell identifier is used as Kubernetes namespace, the following rules apply: * Contain only lowercase alphanumeric characters or '-'. * Start with an alphanumeric character. * End with an alphanumeric character. * A maximum length of 63 characters. * The identifier \"kube-system\", \"default\" and \"wandelbots\" are reserved and cannot be used.  (required)
        :type cell: str
        :param motion: This represents the UUID of a motion. Every executable or partially executable motion is cached and an UUID is returned. Indicate the UUID to execute the motion or retrieve information on the motion. (required)
        :type motion: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_motion_serialize(
            cell=cell,
            motion=motion,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _delete_motion_serialize(
        self,
        cell,
        motion,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if cell is not None:
            _path_params['cell'] = cell
        if motion is not None:
            _path_params['motion'] = motion
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'BasicAuth'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/cells/{cell}/motions/{motion}/delete',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )



    @validate_call
    async def get_motion_trajectory(
        self,
        cell: Annotated[str, Field(strict=True, description="Unique identifier addressing a cell in all API calls. Since the cell identifier is used as Kubernetes namespace, the following rules apply: * Contain only lowercase alphanumeric characters or '-'. * Start with an alphanumeric character. * End with an alphanumeric character. * A maximum length of 63 characters. * The identifier \"kube-system\", \"default\" and \"wandelbots\" are reserved and cannot be used. ")],
        motion: Annotated[StrictStr, Field(description="This represents the UUID of a motion. Every executable or partially executable motion is cached and an UUID is returned. Indicate the UUID to execute the motion or retrieve information on the motion.")],
        sample_time: Annotated[StrictInt, Field(description="-| The value of `sample_time` is the time in milliseconds (ms) between each point in the trajectory.")],
        responses_coordinate_system: Annotated[Optional[StrictStr], Field(description="Unique identifier addressing a coordinate system to which the cartesian data of the responses should be converted. Default is the world coordinate system.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetTrajectoryResponse:
        """Get Trajectory

        Get the trajectory of a planned motion with defined `sample_time` in milliseconds (ms). The trajectory is a list of points containing cartesian and joint data. The cartesian data is in the requested coordinate system. To get a single point of the trajectory, please use the [getMotionTrajectorySample](getMotionTrajectorySample) endpoint.

        :param cell: Unique identifier addressing a cell in all API calls. Since the cell identifier is used as Kubernetes namespace, the following rules apply: * Contain only lowercase alphanumeric characters or '-'. * Start with an alphanumeric character. * End with an alphanumeric character. * A maximum length of 63 characters. * The identifier \"kube-system\", \"default\" and \"wandelbots\" are reserved and cannot be used.  (required)
        :type cell: str
        :param motion: This represents the UUID of a motion. Every executable or partially executable motion is cached and an UUID is returned. Indicate the UUID to execute the motion or retrieve information on the motion. (required)
        :type motion: str
        :param sample_time: -| The value of `sample_time` is the time in milliseconds (ms) between each point in the trajectory. (required)
        :type sample_time: int
        :param responses_coordinate_system: Unique identifier addressing a coordinate system to which the cartesian data of the responses should be converted. Default is the world coordinate system.
        :type responses_coordinate_system: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_motion_trajectory_serialize(
            cell=cell,
            motion=motion,
            sample_time=sample_time,
            responses_coordinate_system=responses_coordinate_system,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetTrajectoryResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_motion_trajectory_with_http_info(
        self,
        cell: Annotated[str, Field(strict=True, description="Unique identifier addressing a cell in all API calls. Since the cell identifier is used as Kubernetes namespace, the following rules apply: * Contain only lowercase alphanumeric characters or '-'. * Start with an alphanumeric character. * End with an alphanumeric character. * A maximum length of 63 characters. * The identifier \"kube-system\", \"default\" and \"wandelbots\" are reserved and cannot be used. ")],
        motion: Annotated[StrictStr, Field(description="This represents the UUID of a motion. Every executable or partially executable motion is cached and an UUID is returned. Indicate the UUID to execute the motion or retrieve information on the motion.")],
        sample_time: Annotated[StrictInt, Field(description="-| The value of `sample_time` is the time in milliseconds (ms) between each point in the trajectory.")],
        responses_coordinate_system: Annotated[Optional[StrictStr], Field(description="Unique identifier addressing a coordinate system to which the cartesian data of the responses should be converted. Default is the world coordinate system.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetTrajectoryResponse]:
        """Get Trajectory

        Get the trajectory of a planned motion with defined `sample_time` in milliseconds (ms). The trajectory is a list of points containing cartesian and joint data. The cartesian data is in the requested coordinate system. To get a single point of the trajectory, please use the [getMotionTrajectorySample](getMotionTrajectorySample) endpoint.

        :param cell: Unique identifier addressing a cell in all API calls. Since the cell identifier is used as Kubernetes namespace, the following rules apply: * Contain only lowercase alphanumeric characters or '-'. * Start with an alphanumeric character. * End with an alphanumeric character. * A maximum length of 63 characters. * The identifier \"kube-system\", \"default\" and \"wandelbots\" are reserved and cannot be used.  (required)
        :type cell: str
        :param motion: This represents the UUID of a motion. Every executable or partially executable motion is cached and an UUID is returned. Indicate the UUID to execute the motion or retrieve information on the motion. (required)
        :type motion: str
        :param sample_time: -| The value of `sample_time` is the time in milliseconds (ms) between each point in the trajectory. (required)
        :type sample_time: int
        :param responses_coordinate_system: Unique identifier addressing a coordinate system to which the cartesian data of the responses should be converted. Default is the world coordinate system.
        :type responses_coordinate_system: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_motion_trajectory_serialize(
            cell=cell,
            motion=motion,
            sample_time=sample_time,
            responses_coordinate_system=responses_coordinate_system,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetTrajectoryResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_motion_trajectory_without_preload_content(
        self,
        cell: Annotated[str, Field(strict=True, description="Unique identifier addressing a cell in all API calls. Since the cell identifier is used as Kubernetes namespace, the following rules apply: * Contain only lowercase alphanumeric characters or '-'. * Start with an alphanumeric character. * End with an alphanumeric character. * A maximum length of 63 characters. * The identifier \"kube-system\", \"default\" and \"wandelbots\" are reserved and cannot be used. ")],
        motion: Annotated[StrictStr, Field(description="This represents the UUID of a motion. Every executable or partially executable motion is cached and an UUID is returned. Indicate the UUID to execute the motion or retrieve information on the motion.")],
        sample_time: Annotated[StrictInt, Field(description="-| The value of `sample_time` is the time in milliseconds (ms) between each point in the trajectory.")],
        responses_coordinate_system: Annotated[Optional[StrictStr], Field(description="Unique identifier addressing a coordinate system to which the cartesian data of the responses should be converted. Default is the world coordinate system.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Trajectory

        Get the trajectory of a planned motion with defined `sample_time` in milliseconds (ms). The trajectory is a list of points containing cartesian and joint data. The cartesian data is in the requested coordinate system. To get a single point of the trajectory, please use the [getMotionTrajectorySample](getMotionTrajectorySample) endpoint.

        :param cell: Unique identifier addressing a cell in all API calls. Since the cell identifier is used as Kubernetes namespace, the following rules apply: * Contain only lowercase alphanumeric characters or '-'. * Start with an alphanumeric character. * End with an alphanumeric character. * A maximum length of 63 characters. * The identifier \"kube-system\", \"default\" and \"wandelbots\" are reserved and cannot be used.  (required)
        :type cell: str
        :param motion: This represents the UUID of a motion. Every executable or partially executable motion is cached and an UUID is returned. Indicate the UUID to execute the motion or retrieve information on the motion. (required)
        :type motion: str
        :param sample_time: -| The value of `sample_time` is the time in milliseconds (ms) between each point in the trajectory. (required)
        :type sample_time: int
        :param responses_coordinate_system: Unique identifier addressing a coordinate system to which the cartesian data of the responses should be converted. Default is the world coordinate system.
        :type responses_coordinate_system: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_motion_trajectory_serialize(
            cell=cell,
            motion=motion,
            sample_time=sample_time,
            responses_coordinate_system=responses_coordinate_system,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetTrajectoryResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_motion_trajectory_serialize(
        self,
        cell,
        motion,
        sample_time,
        responses_coordinate_system,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if cell is not None:
            _path_params['cell'] = cell
        if motion is not None:
            _path_params['motion'] = motion
        # process the query parameters
        if sample_time is not None:
            
            _query_params.append(('sample_time', sample_time))
            
        if responses_coordinate_system is not None:
            
            _query_params.append(('responses_coordinate_system', responses_coordinate_system))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'BasicAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/cells/{cell}/motions/{motion}/trajectory',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )



    @validate_call
    async def get_motion_trajectory_sample(
        self,
        cell: Annotated[str, Field(strict=True, description="Unique identifier addressing a cell in all API calls. Since the cell identifier is used as Kubernetes namespace, the following rules apply: * Contain only lowercase alphanumeric characters or '-'. * Start with an alphanumeric character. * End with an alphanumeric character. * A maximum length of 63 characters. * The identifier \"kube-system\", \"default\" and \"wandelbots\" are reserved and cannot be used. ")],
        motion: Annotated[StrictStr, Field(description="This represents the UUID of a motion. Every executable or partially executable motion is cached and an UUID is returned. Indicate the UUID to execute the motion or retrieve information on the motion.")],
        location_on_trajectory: Optional[Union[StrictFloat, StrictInt]] = None,
        response_coordinate_system: Annotated[Optional[StrictStr], Field(description="Unique identifier addressing a coordinate system in which the cartesian data of the response should be converted to. Default is the world coordinate system.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetTrajectorySampleResponse:
        """Get Trajectory Sample

        -| Get a single point at a certain location of a planned motion. To get the whole trajectory, use the [getMotionTrajectory](getMotionTrajectory) endpoint.

        :param cell: Unique identifier addressing a cell in all API calls. Since the cell identifier is used as Kubernetes namespace, the following rules apply: * Contain only lowercase alphanumeric characters or '-'. * Start with an alphanumeric character. * End with an alphanumeric character. * A maximum length of 63 characters. * The identifier \"kube-system\", \"default\" and \"wandelbots\" are reserved and cannot be used.  (required)
        :type cell: str
        :param motion: This represents the UUID of a motion. Every executable or partially executable motion is cached and an UUID is returned. Indicate the UUID to execute the motion or retrieve information on the motion. (required)
        :type motion: str
        :param location_on_trajectory:
        :type location_on_trajectory: float
        :param response_coordinate_system: Unique identifier addressing a coordinate system in which the cartesian data of the response should be converted to. Default is the world coordinate system.
        :type response_coordinate_system: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_motion_trajectory_sample_serialize(
            cell=cell,
            motion=motion,
            location_on_trajectory=location_on_trajectory,
            response_coordinate_system=response_coordinate_system,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetTrajectorySampleResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_motion_trajectory_sample_with_http_info(
        self,
        cell: Annotated[str, Field(strict=True, description="Unique identifier addressing a cell in all API calls. Since the cell identifier is used as Kubernetes namespace, the following rules apply: * Contain only lowercase alphanumeric characters or '-'. * Start with an alphanumeric character. * End with an alphanumeric character. * A maximum length of 63 characters. * The identifier \"kube-system\", \"default\" and \"wandelbots\" are reserved and cannot be used. ")],
        motion: Annotated[StrictStr, Field(description="This represents the UUID of a motion. Every executable or partially executable motion is cached and an UUID is returned. Indicate the UUID to execute the motion or retrieve information on the motion.")],
        location_on_trajectory: Optional[Union[StrictFloat, StrictInt]] = None,
        response_coordinate_system: Annotated[Optional[StrictStr], Field(description="Unique identifier addressing a coordinate system in which the cartesian data of the response should be converted to. Default is the world coordinate system.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetTrajectorySampleResponse]:
        """Get Trajectory Sample

        -| Get a single point at a certain location of a planned motion. To get the whole trajectory, use the [getMotionTrajectory](getMotionTrajectory) endpoint.

        :param cell: Unique identifier addressing a cell in all API calls. Since the cell identifier is used as Kubernetes namespace, the following rules apply: * Contain only lowercase alphanumeric characters or '-'. * Start with an alphanumeric character. * End with an alphanumeric character. * A maximum length of 63 characters. * The identifier \"kube-system\", \"default\" and \"wandelbots\" are reserved and cannot be used.  (required)
        :type cell: str
        :param motion: This represents the UUID of a motion. Every executable or partially executable motion is cached and an UUID is returned. Indicate the UUID to execute the motion or retrieve information on the motion. (required)
        :type motion: str
        :param location_on_trajectory:
        :type location_on_trajectory: float
        :param response_coordinate_system: Unique identifier addressing a coordinate system in which the cartesian data of the response should be converted to. Default is the world coordinate system.
        :type response_coordinate_system: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_motion_trajectory_sample_serialize(
            cell=cell,
            motion=motion,
            location_on_trajectory=location_on_trajectory,
            response_coordinate_system=response_coordinate_system,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetTrajectorySampleResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_motion_trajectory_sample_without_preload_content(
        self,
        cell: Annotated[str, Field(strict=True, description="Unique identifier addressing a cell in all API calls. Since the cell identifier is used as Kubernetes namespace, the following rules apply: * Contain only lowercase alphanumeric characters or '-'. * Start with an alphanumeric character. * End with an alphanumeric character. * A maximum length of 63 characters. * The identifier \"kube-system\", \"default\" and \"wandelbots\" are reserved and cannot be used. ")],
        motion: Annotated[StrictStr, Field(description="This represents the UUID of a motion. Every executable or partially executable motion is cached and an UUID is returned. Indicate the UUID to execute the motion or retrieve information on the motion.")],
        location_on_trajectory: Optional[Union[StrictFloat, StrictInt]] = None,
        response_coordinate_system: Annotated[Optional[StrictStr], Field(description="Unique identifier addressing a coordinate system in which the cartesian data of the response should be converted to. Default is the world coordinate system.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Trajectory Sample

        -| Get a single point at a certain location of a planned motion. To get the whole trajectory, use the [getMotionTrajectory](getMotionTrajectory) endpoint.

        :param cell: Unique identifier addressing a cell in all API calls. Since the cell identifier is used as Kubernetes namespace, the following rules apply: * Contain only lowercase alphanumeric characters or '-'. * Start with an alphanumeric character. * End with an alphanumeric character. * A maximum length of 63 characters. * The identifier \"kube-system\", \"default\" and \"wandelbots\" are reserved and cannot be used.  (required)
        :type cell: str
        :param motion: This represents the UUID of a motion. Every executable or partially executable motion is cached and an UUID is returned. Indicate the UUID to execute the motion or retrieve information on the motion. (required)
        :type motion: str
        :param location_on_trajectory:
        :type location_on_trajectory: float
        :param response_coordinate_system: Unique identifier addressing a coordinate system in which the cartesian data of the response should be converted to. Default is the world coordinate system.
        :type response_coordinate_system: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_motion_trajectory_sample_serialize(
            cell=cell,
            motion=motion,
            location_on_trajectory=location_on_trajectory,
            response_coordinate_system=response_coordinate_system,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetTrajectorySampleResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_motion_trajectory_sample_serialize(
        self,
        cell,
        motion,
        location_on_trajectory,
        response_coordinate_system,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if cell is not None:
            _path_params['cell'] = cell
        if motion is not None:
            _path_params['motion'] = motion
        # process the query parameters
        if location_on_trajectory is not None:
            
            _query_params.append(('location_on_trajectory', location_on_trajectory))
            
        if response_coordinate_system is not None:
            
            _query_params.append(('response_coordinate_system', response_coordinate_system))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'BasicAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/cells/{cell}/motions/{motion}/trajectorysample',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )



    @validate_call
    async def list_motions(
        self,
        cell: Annotated[str, Field(strict=True, description="Unique identifier addressing a cell in all API calls. Since the cell identifier is used as Kubernetes namespace, the following rules apply: * Contain only lowercase alphanumeric characters or '-'. * Start with an alphanumeric character. * End with an alphanumeric character. * A maximum length of 63 characters. * The identifier \"kube-system\", \"default\" and \"wandelbots\" are reserved and cannot be used. ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> MotionIdsListResponse:
        """List All Motions

        List all currently planned and available motions. Use [planMotion](planMotion) to plan a new motion. Motions are removed if the corresponding motion group or controller disconnects.

        :param cell: Unique identifier addressing a cell in all API calls. Since the cell identifier is used as Kubernetes namespace, the following rules apply: * Contain only lowercase alphanumeric characters or '-'. * Start with an alphanumeric character. * End with an alphanumeric character. * A maximum length of 63 characters. * The identifier \"kube-system\", \"default\" and \"wandelbots\" are reserved and cannot be used.  (required)
        :type cell: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_motions_serialize(
            cell=cell,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "MotionIdsListResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def list_motions_with_http_info(
        self,
        cell: Annotated[str, Field(strict=True, description="Unique identifier addressing a cell in all API calls. Since the cell identifier is used as Kubernetes namespace, the following rules apply: * Contain only lowercase alphanumeric characters or '-'. * Start with an alphanumeric character. * End with an alphanumeric character. * A maximum length of 63 characters. * The identifier \"kube-system\", \"default\" and \"wandelbots\" are reserved and cannot be used. ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[MotionIdsListResponse]:
        """List All Motions

        List all currently planned and available motions. Use [planMotion](planMotion) to plan a new motion. Motions are removed if the corresponding motion group or controller disconnects.

        :param cell: Unique identifier addressing a cell in all API calls. Since the cell identifier is used as Kubernetes namespace, the following rules apply: * Contain only lowercase alphanumeric characters or '-'. * Start with an alphanumeric character. * End with an alphanumeric character. * A maximum length of 63 characters. * The identifier \"kube-system\", \"default\" and \"wandelbots\" are reserved and cannot be used.  (required)
        :type cell: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_motions_serialize(
            cell=cell,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "MotionIdsListResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def list_motions_without_preload_content(
        self,
        cell: Annotated[str, Field(strict=True, description="Unique identifier addressing a cell in all API calls. Since the cell identifier is used as Kubernetes namespace, the following rules apply: * Contain only lowercase alphanumeric characters or '-'. * Start with an alphanumeric character. * End with an alphanumeric character. * A maximum length of 63 characters. * The identifier \"kube-system\", \"default\" and \"wandelbots\" are reserved and cannot be used. ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List All Motions

        List all currently planned and available motions. Use [planMotion](planMotion) to plan a new motion. Motions are removed if the corresponding motion group or controller disconnects.

        :param cell: Unique identifier addressing a cell in all API calls. Since the cell identifier is used as Kubernetes namespace, the following rules apply: * Contain only lowercase alphanumeric characters or '-'. * Start with an alphanumeric character. * End with an alphanumeric character. * A maximum length of 63 characters. * The identifier \"kube-system\", \"default\" and \"wandelbots\" are reserved and cannot be used.  (required)
        :type cell: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_motions_serialize(
            cell=cell,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "MotionIdsListResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _list_motions_serialize(
        self,
        cell,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if cell is not None:
            _path_params['cell'] = cell
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'BasicAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/cells/{cell}/motions',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )



    @validate_call
    async def plan_motion(
        self,
        cell: Annotated[str, Field(strict=True, description="Unique identifier addressing a cell in all API calls. Since the cell identifier is used as Kubernetes namespace, the following rules apply: * Contain only lowercase alphanumeric characters or '-'. * Start with an alphanumeric character. * End with an alphanumeric character. * A maximum length of 63 characters. * The identifier \"kube-system\", \"default\" and \"wandelbots\" are reserved and cannot be used. ")],
        plan_request: PlanRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> PlanResponse:
        """Plan

        This endpoint plans a new motion for a single previously configured [motion group](listMotionGroups). Motions are described by a sequence of motion commands starting with start joints. A motion is planned from standstill to standstill. A single motion has constant TCP and payload. Currently, I/O actions can't be attached to a motion to execute the action in realtime while a motion is executed. If an I/O is needed at a specific point, multiple motions need to be planned. If an I/O is needed to be set while a motion is executed, the enpoint [setOutputValues](setOutputValues) could be used.

        :param cell: Unique identifier addressing a cell in all API calls. Since the cell identifier is used as Kubernetes namespace, the following rules apply: * Contain only lowercase alphanumeric characters or '-'. * Start with an alphanumeric character. * End with an alphanumeric character. * A maximum length of 63 characters. * The identifier \"kube-system\", \"default\" and \"wandelbots\" are reserved and cannot be used.  (required)
        :type cell: str
        :param plan_request: (required)
        :type plan_request: PlanRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._plan_motion_serialize(
            cell=cell,
            plan_request=plan_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PlanResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def plan_motion_with_http_info(
        self,
        cell: Annotated[str, Field(strict=True, description="Unique identifier addressing a cell in all API calls. Since the cell identifier is used as Kubernetes namespace, the following rules apply: * Contain only lowercase alphanumeric characters or '-'. * Start with an alphanumeric character. * End with an alphanumeric character. * A maximum length of 63 characters. * The identifier \"kube-system\", \"default\" and \"wandelbots\" are reserved and cannot be used. ")],
        plan_request: PlanRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[PlanResponse]:
        """Plan

        This endpoint plans a new motion for a single previously configured [motion group](listMotionGroups). Motions are described by a sequence of motion commands starting with start joints. A motion is planned from standstill to standstill. A single motion has constant TCP and payload. Currently, I/O actions can't be attached to a motion to execute the action in realtime while a motion is executed. If an I/O is needed at a specific point, multiple motions need to be planned. If an I/O is needed to be set while a motion is executed, the enpoint [setOutputValues](setOutputValues) could be used.

        :param cell: Unique identifier addressing a cell in all API calls. Since the cell identifier is used as Kubernetes namespace, the following rules apply: * Contain only lowercase alphanumeric characters or '-'. * Start with an alphanumeric character. * End with an alphanumeric character. * A maximum length of 63 characters. * The identifier \"kube-system\", \"default\" and \"wandelbots\" are reserved and cannot be used.  (required)
        :type cell: str
        :param plan_request: (required)
        :type plan_request: PlanRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._plan_motion_serialize(
            cell=cell,
            plan_request=plan_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PlanResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def plan_motion_without_preload_content(
        self,
        cell: Annotated[str, Field(strict=True, description="Unique identifier addressing a cell in all API calls. Since the cell identifier is used as Kubernetes namespace, the following rules apply: * Contain only lowercase alphanumeric characters or '-'. * Start with an alphanumeric character. * End with an alphanumeric character. * A maximum length of 63 characters. * The identifier \"kube-system\", \"default\" and \"wandelbots\" are reserved and cannot be used. ")],
        plan_request: PlanRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Plan

        This endpoint plans a new motion for a single previously configured [motion group](listMotionGroups). Motions are described by a sequence of motion commands starting with start joints. A motion is planned from standstill to standstill. A single motion has constant TCP and payload. Currently, I/O actions can't be attached to a motion to execute the action in realtime while a motion is executed. If an I/O is needed at a specific point, multiple motions need to be planned. If an I/O is needed to be set while a motion is executed, the enpoint [setOutputValues](setOutputValues) could be used.

        :param cell: Unique identifier addressing a cell in all API calls. Since the cell identifier is used as Kubernetes namespace, the following rules apply: * Contain only lowercase alphanumeric characters or '-'. * Start with an alphanumeric character. * End with an alphanumeric character. * A maximum length of 63 characters. * The identifier \"kube-system\", \"default\" and \"wandelbots\" are reserved and cannot be used.  (required)
        :type cell: str
        :param plan_request: (required)
        :type plan_request: PlanRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._plan_motion_serialize(
            cell=cell,
            plan_request=plan_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PlanResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _plan_motion_serialize(
        self,
        cell,
        plan_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if cell is not None:
            _path_params['cell'] = cell
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if plan_request is not None:
            _body_params = plan_request


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'BasicAuth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/cells/{cell}/motions',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )



    @validate_call
    async def stop_execution(
        self,
        cell: Annotated[str, Field(strict=True, description="Unique identifier addressing a cell in all API calls. Since the cell identifier is used as Kubernetes namespace, the following rules apply: * Contain only lowercase alphanumeric characters or '-'. * Start with an alphanumeric character. * End with an alphanumeric character. * A maximum length of 63 characters. * The identifier \"kube-system\", \"default\" and \"wandelbots\" are reserved and cannot be used. ")],
        motion: Annotated[StrictStr, Field(description="This represents the UUID of a motion. Every executable or partially executable motion is cached and an UUID is returned. Indicate the UUID to execute the motion or retrieve information on the motion.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Stop

        Stops an active motion gracefully with deceleration until standstill while staying on the planned trajectory. When an active movement is stopped any further update request will be rejected. The active movement request returns until the robot has reached standstill. Currently it is not possible to restart the motion. Please send in a feature request if you need to restart/continue the motion.

        :param cell: Unique identifier addressing a cell in all API calls. Since the cell identifier is used as Kubernetes namespace, the following rules apply: * Contain only lowercase alphanumeric characters or '-'. * Start with an alphanumeric character. * End with an alphanumeric character. * A maximum length of 63 characters. * The identifier \"kube-system\", \"default\" and \"wandelbots\" are reserved and cannot be used.  (required)
        :type cell: str
        :param motion: This represents the UUID of a motion. Every executable or partially executable motion is cached and an UUID is returned. Indicate the UUID to execute the motion or retrieve information on the motion. (required)
        :type motion: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._stop_execution_serialize(
            cell=cell,
            motion=motion,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def stop_execution_with_http_info(
        self,
        cell: Annotated[str, Field(strict=True, description="Unique identifier addressing a cell in all API calls. Since the cell identifier is used as Kubernetes namespace, the following rules apply: * Contain only lowercase alphanumeric characters or '-'. * Start with an alphanumeric character. * End with an alphanumeric character. * A maximum length of 63 characters. * The identifier \"kube-system\", \"default\" and \"wandelbots\" are reserved and cannot be used. ")],
        motion: Annotated[StrictStr, Field(description="This represents the UUID of a motion. Every executable or partially executable motion is cached and an UUID is returned. Indicate the UUID to execute the motion or retrieve information on the motion.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Stop

        Stops an active motion gracefully with deceleration until standstill while staying on the planned trajectory. When an active movement is stopped any further update request will be rejected. The active movement request returns until the robot has reached standstill. Currently it is not possible to restart the motion. Please send in a feature request if you need to restart/continue the motion.

        :param cell: Unique identifier addressing a cell in all API calls. Since the cell identifier is used as Kubernetes namespace, the following rules apply: * Contain only lowercase alphanumeric characters or '-'. * Start with an alphanumeric character. * End with an alphanumeric character. * A maximum length of 63 characters. * The identifier \"kube-system\", \"default\" and \"wandelbots\" are reserved and cannot be used.  (required)
        :type cell: str
        :param motion: This represents the UUID of a motion. Every executable or partially executable motion is cached and an UUID is returned. Indicate the UUID to execute the motion or retrieve information on the motion. (required)
        :type motion: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._stop_execution_serialize(
            cell=cell,
            motion=motion,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def stop_execution_without_preload_content(
        self,
        cell: Annotated[str, Field(strict=True, description="Unique identifier addressing a cell in all API calls. Since the cell identifier is used as Kubernetes namespace, the following rules apply: * Contain only lowercase alphanumeric characters or '-'. * Start with an alphanumeric character. * End with an alphanumeric character. * A maximum length of 63 characters. * The identifier \"kube-system\", \"default\" and \"wandelbots\" are reserved and cannot be used. ")],
        motion: Annotated[StrictStr, Field(description="This represents the UUID of a motion. Every executable or partially executable motion is cached and an UUID is returned. Indicate the UUID to execute the motion or retrieve information on the motion.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Stop

        Stops an active motion gracefully with deceleration until standstill while staying on the planned trajectory. When an active movement is stopped any further update request will be rejected. The active movement request returns until the robot has reached standstill. Currently it is not possible to restart the motion. Please send in a feature request if you need to restart/continue the motion.

        :param cell: Unique identifier addressing a cell in all API calls. Since the cell identifier is used as Kubernetes namespace, the following rules apply: * Contain only lowercase alphanumeric characters or '-'. * Start with an alphanumeric character. * End with an alphanumeric character. * A maximum length of 63 characters. * The identifier \"kube-system\", \"default\" and \"wandelbots\" are reserved and cannot be used.  (required)
        :type cell: str
        :param motion: This represents the UUID of a motion. Every executable or partially executable motion is cached and an UUID is returned. Indicate the UUID to execute the motion or retrieve information on the motion. (required)
        :type motion: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._stop_execution_serialize(
            cell=cell,
            motion=motion,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _stop_execution_serialize(
        self,
        cell,
        motion,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if cell is not None:
            _path_params['cell'] = cell
        if motion is not None:
            _path_params['motion'] = motion
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'BasicAuth'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/cells/{cell}/motions/{motion}/stop',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )



    @validate_call
    async def stream_move_backward(self, cell: Annotated[str, Field(strict=True, description="Unique identifier addressing a cell in all API calls. Since the cell identifier is used as Kubernetes namespace, the following rules apply: * Contain only lowercase alphanumeric characters or '-'. * Start with an alphanumeric character. * End with an alphanumeric character. * A maximum length of 63 characters. * The identifier \"kube-system\", \"default\" and \"wandelbots\" are reserved and cannot be used. ")], motion: Annotated[StrictStr, Field(description="This represents the UUID of a motion. Every executable or partially executable motion is cached and an UUID is returned. Indicate the UUID to execute the motion or retrieve information on the motion.")], move_request: MoveRequest) -> AsyncGenerator[StreamMoveResponse, None]:  # noqa: E501
        """Stream Backward  # noqa: E501

        Request to move the motion group backward along a previously planned motion. Once started, you can stop a motion using the [stopExecution](stopExecution) endpoint. Prerequisites, before starting the motion execution:  - The motion group is currently at the endpoint of the planned motion. OR  - The motion was stopped using [stopExecution](stopExecution) endpoint. Then it is possible to resume the motion exection from where it stopped. OR  - The motion group was moved onto the motion using the [streamMoveToTrajectoryViaJointP2P](streamMoveToTrajectoryViaJointP2P) endpoint.  # noqa: E501
        :param request: A StreamMoveBackwardRequest
        :info All responses from the server will be yielded
        :type StreamMoveBackwardRequest
        """

        def format_path_parameters(path):
            # Find all substrings that are enclosed in brackets
            bracket_contents = re.findall(r'\{(.*?)\}', path)

            # For each found substring, replace underscores with spaces
            for content in bracket_contents:
                content = "{" + content + "}"
                modified_content = humps.dekebabize(content)
                path = path.replace(content, modified_content)

            return path

        def append_attributes(url_schema, attributes, object_prefix=""):
            for k, v in attributes.items():
                if v is not None:
                    if hasattr(v, "__dict__"):
                        url_schema = append_attributes(url_schema, vars(v), object_prefix + k + ".")
                    else:
                        url_schema = url_schema + f"{object_prefix}{k}={v}&"
            return url_schema

        path = format_path_parameters("/cells/{cell}/motions/{motion}/executebackward")
        path = path.format(cell=cell,motion=motion,)

        tmp_host = self.api_client.configuration.host
        if self.api_client.configuration.host.startswith("https://"):
            tmp_host = self.api_client.configuration.host.replace("https://", "")
            tmp_host = f"wss://{self.api_client.configuration.username}:{self.api_client.configuration.password}@{tmp_host}"
        else:
            tmp_host = tmp_host.replace("http://", "ws://")

        url_schema = tmp_host + path
        attributes = vars(move_request)
        if len(attributes) > 0:
            url_schema = url_schema + "?"
            url_schema = append_attributes(url_schema, attributes)
        full_url = furl(url_schema)

        async with websockets.connect(full_url.url, open_timeout=10) as websocket:
            try:
                async for response in websocket:
                    response_data = json.loads(response)
                    if "result" not in response_data:
                        raise Exception(response_data)
                    yield StreamMoveResponse.from_dict(response_data["result"])
            except websockets.exceptions.ConnectionClosed:
                return


    @validate_call
    async def stream_move_forward(self, cell: Annotated[str, Field(strict=True, description="Unique identifier addressing a cell in all API calls. Since the cell identifier is used as Kubernetes namespace, the following rules apply: * Contain only lowercase alphanumeric characters or '-'. * Start with an alphanumeric character. * End with an alphanumeric character. * A maximum length of 63 characters. * The identifier \"kube-system\", \"default\" and \"wandelbots\" are reserved and cannot be used. ")], motion: Annotated[StrictStr, Field(description="This represents the UUID of a motion. Every executable or partially executable motion is cached and an UUID is returned. Indicate the UUID to execute the motion or retrieve information on the motion.")], move_request: MoveRequest) -> AsyncGenerator[StreamMoveResponse, None]:  # noqa: E501
        """Stream Forward  # noqa: E501

        Moves the motion group forward along a previously planned motion. Once started, you can stop a motion using the [stopExecution](stopExecution) endpoint. Prerequisites, before starting the motion execution:  - The motion group is currently at the startpoint of the planned motion. OR  - The motion was stopped using [stopExecution](stopExecution) endpoint. Then it is possible to resume the motion exection from where it stopped. OR  - The motion group was moved onto the motion using the [streamMoveToTrajectoryViaJointP2P](streamMoveToTrajectoryViaJointP2P) endpoint.  # noqa: E501
        :param request: A StreamMoveForwardRequest
        :info All responses from the server will be yielded
        :type StreamMoveForwardRequest
        """

        def format_path_parameters(path):
            # Find all substrings that are enclosed in brackets
            bracket_contents = re.findall(r'\{(.*?)\}', path)

            # For each found substring, replace underscores with spaces
            for content in bracket_contents:
                content = "{" + content + "}"
                modified_content = humps.dekebabize(content)
                path = path.replace(content, modified_content)

            return path

        def append_attributes(url_schema, attributes, object_prefix=""):
            for k, v in attributes.items():
                if v is not None:
                    if hasattr(v, "__dict__"):
                        url_schema = append_attributes(url_schema, vars(v), object_prefix + k + ".")
                    else:
                        url_schema = url_schema + f"{object_prefix}{k}={v}&"
            return url_schema

        path = format_path_parameters("/cells/{cell}/motions/{motion}/executeforward")
        path = path.format(cell=cell,motion=motion,)

        tmp_host = self.api_client.configuration.host
        if self.api_client.configuration.host.startswith("https://"):
            tmp_host = self.api_client.configuration.host.replace("https://", "")
            tmp_host = f"wss://{self.api_client.configuration.username}:{self.api_client.configuration.password}@{tmp_host}"
        else:
            tmp_host = tmp_host.replace("http://", "ws://")

        url_schema = tmp_host + path
        attributes = vars(move_request)
        if len(attributes) > 0:
            url_schema = url_schema + "?"
            url_schema = append_attributes(url_schema, attributes)
        full_url = furl(url_schema)

        async with websockets.connect(full_url.url, open_timeout=10) as websocket:
            try:
                async for response in websocket:
                    response_data = json.loads(response)
                    if "result" not in response_data:
                        raise Exception(response_data)
                    yield StreamMoveResponse.from_dict(response_data["result"])
            except websockets.exceptions.ConnectionClosed:
                return


    @validate_call
    async def stream_move_to_trajectory_via_joint_ptp(self, cell: Annotated[str, Field(strict=True, description="Unique identifier addressing a cell in all API calls. Since the cell identifier is used as Kubernetes namespace, the following rules apply: * Contain only lowercase alphanumeric characters or '-'. * Start with an alphanumeric character. * End with an alphanumeric character. * A maximum length of 63 characters. * The identifier \"kube-system\", \"default\" and \"wandelbots\" are reserved and cannot be used. ")], motion: Annotated[StrictStr, Field(description="This represents the UUID of a motion. Every executable or partially executable motion is cached and an UUID is returned. Indicate the UUID to execute the motion or retrieve information on the motion.")], execute_to_trajectory_request: ExecuteToTrajectoryRequest) -> AsyncGenerator[StreamMoveResponse, None]:  # noqa: E501
        """Stream to Trajectory  # noqa: E501

        Request to move the motion group via joint point-to-point to a given location on a planned motion. You must use this endpoint in order to start moving from an arbritrary location of the trajectory. Afterwards, you are able to call [streamMoveForward](streamMoveForward) or [streamMoveBackward](streamMoveBackward) to move along planned motion. Use the [stopExecution](stopExecution) endpoint to stop the motion gracefully.  # noqa: E501
        :param request: A StreamMoveToTrajectoryViaJointPtpRequest
        :info All responses from the server will be yielded
        :type StreamMoveToTrajectoryViaJointPtpRequest
        """

        def format_path_parameters(path):
            # Find all substrings that are enclosed in brackets
            bracket_contents = re.findall(r'\{(.*?)\}', path)

            # For each found substring, replace underscores with spaces
            for content in bracket_contents:
                content = "{" + content + "}"
                modified_content = humps.dekebabize(content)
                path = path.replace(content, modified_content)

            return path

        def append_attributes(url_schema, attributes, object_prefix=""):
            for k, v in attributes.items():
                if v is not None:
                    if hasattr(v, "__dict__"):
                        url_schema = append_attributes(url_schema, vars(v), object_prefix + k + ".")
                    else:
                        url_schema = url_schema + f"{object_prefix}{k}={v}&"
            return url_schema

        path = format_path_parameters("/cells/{cell}/motions/{motion}/executetotrajectory")
        path = path.format(cell=cell,motion=motion,)

        tmp_host = self.api_client.configuration.host
        if self.api_client.configuration.host.startswith("https://"):
            tmp_host = self.api_client.configuration.host.replace("https://", "")
            tmp_host = f"wss://{self.api_client.configuration.username}:{self.api_client.configuration.password}@{tmp_host}"
        else:
            tmp_host = tmp_host.replace("http://", "ws://")

        url_schema = tmp_host + path
        attributes = vars(execute_to_trajectory_request)
        if len(attributes) > 0:
            url_schema = url_schema + "?"
            url_schema = append_attributes(url_schema, attributes)
        full_url = furl(url_schema)

        async with websockets.connect(full_url.url, open_timeout=10) as websocket:
            try:
                async for response in websocket:
                    response_data = json.loads(response)
                    if "result" not in response_data:
                        raise Exception(response_data)
                    yield StreamMoveResponse.from_dict(response_data["result"])
            except websockets.exceptions.ConnectionClosed:
                return

