# coding: utf-8

"""
    Wandelbots Nova Public API

    Interact with robots in an easy and intuitive way. 

    The version of the OpenAPI document: 1.0.0 beta
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool
from typing import Any, ClassVar, Dict, List, Optional
from wandelbots_api_client.models.collider_input import ColliderInput
from typing import Optional, Set
from typing_extensions import Self

class CollisionRobotConfigurationInput(BaseModel):
    """
    Configuration of a robot in the collision scene.  Default link shapes are provided for all supported robots. Apply `use_default_link_shapes` with `true`.  `link_attachements` are additional shapes that are attached to the link reference frames. The reference frame of the `link_attachements` is obtained after applying all sets of DH-parameters from base to (including) the specified index. Adjacent links in the kinematic chain of the robot are not checked for collision.  The tool is treated like another link attached to the end (flange) of the chain. All tool shapes are described in the flange frame. 
    """ # noqa: E501
    use_default_link_shapes: StrictBool = Field(description="If `true`, default shapes are used for all links.")
    link_attachements: Optional[Dict[str, Dict[str, ColliderInput]]] = Field(default=None, description="Shapes to attach to link reference frames, additionally to default shapes. The keys are integers representing the link indices, and the values are objects mapping shape names to their collider definitions. ")
    tool: Optional[Dict[str, ColliderInput]] = Field(default=None, description="Shapes that make up the tool, attached to the flange frame.")
    __properties: ClassVar[List[str]] = ["use_default_link_shapes", "link_attachements", "tool"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CollisionRobotConfigurationInput from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each value in link_attachements (dict)
        _field_dict = {}
        if self.link_attachements:
            for _key in self.link_attachements:
                if self.link_attachements[_key]:
                    _field_dict[_key] = self.link_attachements[_key].to_dict()
            _dict['link_attachements'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of each value in tool (dict)
        _field_dict = {}
        if self.tool:
            for _key in self.tool:
                if self.tool[_key]:
                    _field_dict[_key] = self.tool[_key].to_dict()
            _dict['tool'] = _field_dict
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CollisionRobotConfigurationInput from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "use_default_link_shapes": obj.get("use_default_link_shapes") if obj.get("use_default_link_shapes") is not None else True,
            "link_attachements": dict(
                (_k, dict(
                    (_ik, ColliderInput.from_dict(_iv))
                        for _ik, _iv in _v.items()
                    )
                    if _v is not None
                    else None
                )
                for _k, _v in obj.get("link_attachements").items()
            )
            if obj.get("link_attachements") is not None
            else None,
            "tool": dict(
                (_k, ColliderInput.from_dict(_v))
                for _k, _v in obj["tool"].items()
            )
            if obj.get("tool") is not None
            else None
        })
        return _obj


