# coding: utf-8

"""
    Wandelbots Nova Public API

    Interact with robots in an easy and intuitive way. 

    The version of the OpenAPI document: 1.0.0 beta
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from wandelbots_api_client.models.io_value import IOValue
from typing import Optional, Set
from typing_extensions import Self

class IODescription(BaseModel):
    """
    IODescription
    """ # noqa: E501
    id: StrictStr = Field(description="Unique identifier defined by the controller. Identifiers are only defined uniquely per controller, e.g. I/Os for two different robots on the same controller can have the same identifier.")
    name: StrictStr = Field(description="Name of the I/O. Customize it on the physical controller or in the virtual robot specification.")
    group: Optional[StrictStr] = Field(default=None, description="Name of the I/O group. Customize it on the physical controller or in the virtual robot specification.")
    type: StrictStr = Field(description="Identifies the I/O type. Possible responses \"input\" or \"output\".")
    value_type: StrictStr = Field(description="Data type of the I/O.")
    bit_size: StrictInt = Field(description="OBSOLETE! Replaced by min/max. Amount of bits the value is encoded in.")
    unit: Optional[StrictStr] = Field(default=None, description="The unit of I/O value.")
    min: Optional[IOValue] = None
    max: Optional[IOValue] = None
    __properties: ClassVar[List[str]] = ["id", "name", "group", "type", "value_type", "bit_size", "unit", "min", "max"]

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['IO_TYPE_INPUT', 'IO_TYPE_OUTPUT']):
            raise ValueError("must be one of enum values ('IO_TYPE_INPUT', 'IO_TYPE_OUTPUT')")
        return value

    @field_validator('value_type')
    def value_type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['IO_VALUE_DIGITAL', 'IO_VALUE_ANALOG_FLOATING', 'IO_VALUE_ANALOG_INTEGER']):
            raise ValueError("must be one of enum values ('IO_VALUE_DIGITAL', 'IO_VALUE_ANALOG_FLOATING', 'IO_VALUE_ANALOG_INTEGER')")
        return value

    @field_validator('unit')
    def unit_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['UNIT_NONE', 'UNIT_KILOGRAM', 'UNIT_AMPERE', 'UNIT_KELVIN', 'UNIT_HERTZ', 'UNIT_NEWTON', 'UNIT_VOLT', 'UNIT_CELSIUS', 'UNIT_NEWTON_METER', 'UNIT_METER']):
            raise ValueError("must be one of enum values ('UNIT_NONE', 'UNIT_KILOGRAM', 'UNIT_AMPERE', 'UNIT_KELVIN', 'UNIT_HERTZ', 'UNIT_NEWTON', 'UNIT_VOLT', 'UNIT_CELSIUS', 'UNIT_NEWTON_METER', 'UNIT_METER')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of IODescription from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of min
        if self.min:
            _dict['min'] = self.min.to_dict()
        # override the default output from pydantic by calling `to_dict()` of max
        if self.max:
            _dict['max'] = self.max.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of IODescription from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "group": obj.get("group"),
            "type": obj.get("type"),
            "value_type": obj.get("value_type"),
            "bit_size": obj.get("bit_size"),
            "unit": obj.get("unit"),
            "min": IOValue.from_dict(obj["min"]) if obj.get("min") is not None else None,
            "max": IOValue.from_dict(obj["max"]) if obj.get("max") is not None else None
        })
        return _obj


