# coding: utf-8

"""
    Wandelbots Nova Public API

    Interact with robots in an easy and intuitive way. 

    The version of the OpenAPI document: 1.0.0 beta
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class MoveRequest(BaseModel):
    """
    A request to move the joints of a motion group.
    """ # noqa: E501
    playback_speed_in_percent: StrictInt = Field(description="Set the velocity for executed movements of the motion in percent. A percentage of 100% means that the robot moves as fast as possible without violating the limits. Setting this value does not affect the overall shape of the velocity profile. Everything is slowed down by the same factor. Therefore, this should only be used for teaching and trajectory evaluation purposes. If the process requires a certain velocity, the respective limits should be set when planning the motion. This will not change the velocity override of the controller. The controller velocity override value shall be 100% to ensure controllability of the motion group.")
    start_location_on_trajectory: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Location the motion is requested to start at. Default value for forward movement is the trajectory's start. Default value for backward movement is the trajectory's end. The location is a scalar value that defines a position along a path. It typically ranges from 0 to `n`, where `n` denotes the number of motion commands. Each integer value of the location corresponds to a specific motion command, while non-integer values interpolate positions within the segments. The location is calculated from the joint path.")
    response_rate: Optional[StrictInt] = Field(default=None, description="Update rate for the response message in milliseconds (ms). Default is 200 ms. We recommend to use the step rate of the controller or a multiple of the step rate as Nova updates the state in the controller's step rate as well. Minimal response rate is the step rate of controller.")
    response_coordinate_system: Optional[StrictStr] = Field(default=None, description="Unique identifier addressing a coordinate system to which the cartesian data of the responses should be converted. Default is the world coordinate system. ")
    __properties: ClassVar[List[str]] = ["playback_speed_in_percent", "start_location_on_trajectory", "response_rate", "response_coordinate_system"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MoveRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MoveRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "playback_speed_in_percent": obj.get("playback_speed_in_percent"),
            "start_location_on_trajectory": obj.get("start_location_on_trajectory"),
            "response_rate": obj.get("response_rate"),
            "response_coordinate_system": obj.get("response_coordinate_system")
        })
        return _obj


