# coding: utf-8

"""
    Wandelbots Nova Public API

    Interact with robots in an easy and intuitive way. 

    The version of the OpenAPI document: 1.0.0 beta
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from wandelbots_api_client.models.path import Path
from wandelbots_api_client.models.program_run_state import ProgramRunState
from typing import Optional, Set
from typing_extensions import Self

class ProgramRun(BaseModel):
    """
    ProgramRun
    """ # noqa: E501
    id: StrictStr
    state: ProgramRunState
    path: Optional[Path] = None
    logs: Optional[StrictStr] = ''
    store: Optional[Dict[str, Any]] = None
    error: Optional[StrictStr] = None
    traceback: Optional[StrictStr] = None
    start_time: Optional[Union[StrictFloat, StrictInt]] = None
    execution_time: Optional[Union[StrictFloat, StrictInt]] = None
    execution_duration: Optional[Union[StrictFloat, StrictInt]] = None
    __properties: ClassVar[List[str]] = ["id", "state", "path", "logs", "store", "error", "traceback", "start_time", "execution_time", "execution_duration"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ProgramRun from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of path
        if self.path:
            _dict['path'] = self.path.to_dict()
        # set to None if error (nullable) is None
        # and model_fields_set contains the field
        if self.error is None and "error" in self.model_fields_set:
            _dict['error'] = None

        # set to None if traceback (nullable) is None
        # and model_fields_set contains the field
        if self.traceback is None and "traceback" in self.model_fields_set:
            _dict['traceback'] = None

        # set to None if start_time (nullable) is None
        # and model_fields_set contains the field
        if self.start_time is None and "start_time" in self.model_fields_set:
            _dict['start_time'] = None

        # set to None if execution_time (nullable) is None
        # and model_fields_set contains the field
        if self.execution_time is None and "execution_time" in self.model_fields_set:
            _dict['execution_time'] = None

        # set to None if execution_duration (nullable) is None
        # and model_fields_set contains the field
        if self.execution_duration is None and "execution_duration" in self.model_fields_set:
            _dict['execution_duration'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ProgramRun from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "state": obj.get("state"),
            "path": Path.from_dict(obj["path"]) if obj.get("path") is not None else None,
            "logs": obj.get("logs") if obj.get("logs") is not None else '',
            "store": obj.get("store"),
            "error": obj.get("error"),
            "traceback": obj.get("traceback"),
            "start_time": obj.get("start_time"),
            "execution_time": obj.get("execution_time"),
            "execution_duration": obj.get("execution_duration")
        })
        return _obj


