# coding: utf-8

"""
    Wandelbots Nova Public API

    Interact with robots in an easy and intuitive way. 

    The version of the OpenAPI document: 2.0.0 beta
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from furl import furl
import json
import humps
import re
import warnings
import websockets
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, AsyncGenerator, Callable, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated
from urllib.parse import quote

from pydantic import Field, StrictBytes, StrictStr, field_validator
from typing import Union
from typing_extensions import Annotated
from wandelbots_api_client.v2.models.list_recipe_metadata_response import ListRecipeMetadataResponse
from wandelbots_api_client.v2.models.recipe_metadata import RecipeMetadata
from wandelbots_api_client.v2.models.update_recipe_metadata_request import UpdateRecipeMetadataRequest

from wandelbots_api_client.v2.api_client import ApiClient, RequestSerialized
from wandelbots_api_client.v2.api_response import ApiResponse
from wandelbots_api_client.v2.rest import RESTResponseType

class LibraryRecipeMetadataApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_call
    async def get_recipe_metadata(
        self,
        cell: Annotated[str, Field(strict=True, description="Unique identifier addressing a cell in all API calls.  Since the cell identifier is used as Kubernetes namespace, the following rules apply: * Contain only lowercase alphanumeric characters or '-'. * Start with an alphanumeric character. * End with an alphanumeric character. * A maximum length of 63 characters. * The identifier \"kube-system\", \"default\" and \"wandelbots\" are reserved and cannot be used. ")],
        recipe: Annotated[StrictStr, Field(description="Recieved from [listRecipeMetadata](listRecipeMetadata) or from the response of [createRecipe](createRecipe). ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RecipeMetadata:
        """Get Recipe Metadata

        # EXPERIMENTAL  > **Note:** This endpoint is experimental and might experience functional changes in the future. Returns the metadata of the recipe. 

        :param cell: Unique identifier addressing a cell in all API calls.  Since the cell identifier is used as Kubernetes namespace, the following rules apply: * Contain only lowercase alphanumeric characters or '-'. * Start with an alphanumeric character. * End with an alphanumeric character. * A maximum length of 63 characters. * The identifier \"kube-system\", \"default\" and \"wandelbots\" are reserved and cannot be used.  (required)
        :type cell: str
        :param recipe: Recieved from [listRecipeMetadata](listRecipeMetadata) or from the response of [createRecipe](createRecipe).  (required)
        :type recipe: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_recipe_metadata_serialize(
            cell=cell,
            recipe=recipe,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RecipeMetadata",
            '404': "HTTPExceptionResponse",
            '422': "HTTPValidationError",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_recipe_metadata_with_http_info(
        self,
        cell: Annotated[str, Field(strict=True, description="Unique identifier addressing a cell in all API calls.  Since the cell identifier is used as Kubernetes namespace, the following rules apply: * Contain only lowercase alphanumeric characters or '-'. * Start with an alphanumeric character. * End with an alphanumeric character. * A maximum length of 63 characters. * The identifier \"kube-system\", \"default\" and \"wandelbots\" are reserved and cannot be used. ")],
        recipe: Annotated[StrictStr, Field(description="Recieved from [listRecipeMetadata](listRecipeMetadata) or from the response of [createRecipe](createRecipe). ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[RecipeMetadata]:
        """Get Recipe Metadata

        # EXPERIMENTAL  > **Note:** This endpoint is experimental and might experience functional changes in the future. Returns the metadata of the recipe. 

        :param cell: Unique identifier addressing a cell in all API calls.  Since the cell identifier is used as Kubernetes namespace, the following rules apply: * Contain only lowercase alphanumeric characters or '-'. * Start with an alphanumeric character. * End with an alphanumeric character. * A maximum length of 63 characters. * The identifier \"kube-system\", \"default\" and \"wandelbots\" are reserved and cannot be used.  (required)
        :type cell: str
        :param recipe: Recieved from [listRecipeMetadata](listRecipeMetadata) or from the response of [createRecipe](createRecipe).  (required)
        :type recipe: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_recipe_metadata_serialize(
            cell=cell,
            recipe=recipe,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RecipeMetadata",
            '404': "HTTPExceptionResponse",
            '422': "HTTPValidationError",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_recipe_metadata_without_preload_content(
        self,
        cell: Annotated[str, Field(strict=True, description="Unique identifier addressing a cell in all API calls.  Since the cell identifier is used as Kubernetes namespace, the following rules apply: * Contain only lowercase alphanumeric characters or '-'. * Start with an alphanumeric character. * End with an alphanumeric character. * A maximum length of 63 characters. * The identifier \"kube-system\", \"default\" and \"wandelbots\" are reserved and cannot be used. ")],
        recipe: Annotated[StrictStr, Field(description="Recieved from [listRecipeMetadata](listRecipeMetadata) or from the response of [createRecipe](createRecipe). ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Recipe Metadata

        # EXPERIMENTAL  > **Note:** This endpoint is experimental and might experience functional changes in the future. Returns the metadata of the recipe. 

        :param cell: Unique identifier addressing a cell in all API calls.  Since the cell identifier is used as Kubernetes namespace, the following rules apply: * Contain only lowercase alphanumeric characters or '-'. * Start with an alphanumeric character. * End with an alphanumeric character. * A maximum length of 63 characters. * The identifier \"kube-system\", \"default\" and \"wandelbots\" are reserved and cannot be used.  (required)
        :type cell: str
        :param recipe: Recieved from [listRecipeMetadata](listRecipeMetadata) or from the response of [createRecipe](createRecipe).  (required)
        :type recipe: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_recipe_metadata_serialize(
            cell=cell,
            recipe=recipe,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RecipeMetadata",
            '404': "HTTPExceptionResponse",
            '422': "HTTPValidationError",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_recipe_metadata_serialize(
        self,
        cell,
        recipe,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if cell is not None:
            _path_params['cell'] = cell
        if recipe is not None:
            _path_params['recipe'] = recipe
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'BasicAuth', 
            'BearerAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/cells/{cell}/store/recipes/{recipe}/metadata',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )



    @validate_call
    async def list_recipe_metadata(
        self,
        cell: Annotated[str, Field(strict=True, description="Unique identifier addressing a cell in all API calls.  Since the cell identifier is used as Kubernetes namespace, the following rules apply: * Contain only lowercase alphanumeric characters or '-'. * Start with an alphanumeric character. * End with an alphanumeric character. * A maximum length of 63 characters. * The identifier \"kube-system\", \"default\" and \"wandelbots\" are reserved and cannot be used. ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ListRecipeMetadataResponse:
        """List Recipe Metadata

        # EXPERIMENTAL  > **Note:** This endpoint is experimental and might experience functional changes in the future.  List of all the stored recipes, represented by their metadata. 

        :param cell: Unique identifier addressing a cell in all API calls.  Since the cell identifier is used as Kubernetes namespace, the following rules apply: * Contain only lowercase alphanumeric characters or '-'. * Start with an alphanumeric character. * End with an alphanumeric character. * A maximum length of 63 characters. * The identifier \"kube-system\", \"default\" and \"wandelbots\" are reserved and cannot be used.  (required)
        :type cell: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_recipe_metadata_serialize(
            cell=cell,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListRecipeMetadataResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def list_recipe_metadata_with_http_info(
        self,
        cell: Annotated[str, Field(strict=True, description="Unique identifier addressing a cell in all API calls.  Since the cell identifier is used as Kubernetes namespace, the following rules apply: * Contain only lowercase alphanumeric characters or '-'. * Start with an alphanumeric character. * End with an alphanumeric character. * A maximum length of 63 characters. * The identifier \"kube-system\", \"default\" and \"wandelbots\" are reserved and cannot be used. ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ListRecipeMetadataResponse]:
        """List Recipe Metadata

        # EXPERIMENTAL  > **Note:** This endpoint is experimental and might experience functional changes in the future.  List of all the stored recipes, represented by their metadata. 

        :param cell: Unique identifier addressing a cell in all API calls.  Since the cell identifier is used as Kubernetes namespace, the following rules apply: * Contain only lowercase alphanumeric characters or '-'. * Start with an alphanumeric character. * End with an alphanumeric character. * A maximum length of 63 characters. * The identifier \"kube-system\", \"default\" and \"wandelbots\" are reserved and cannot be used.  (required)
        :type cell: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_recipe_metadata_serialize(
            cell=cell,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListRecipeMetadataResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def list_recipe_metadata_without_preload_content(
        self,
        cell: Annotated[str, Field(strict=True, description="Unique identifier addressing a cell in all API calls.  Since the cell identifier is used as Kubernetes namespace, the following rules apply: * Contain only lowercase alphanumeric characters or '-'. * Start with an alphanumeric character. * End with an alphanumeric character. * A maximum length of 63 characters. * The identifier \"kube-system\", \"default\" and \"wandelbots\" are reserved and cannot be used. ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List Recipe Metadata

        # EXPERIMENTAL  > **Note:** This endpoint is experimental and might experience functional changes in the future.  List of all the stored recipes, represented by their metadata. 

        :param cell: Unique identifier addressing a cell in all API calls.  Since the cell identifier is used as Kubernetes namespace, the following rules apply: * Contain only lowercase alphanumeric characters or '-'. * Start with an alphanumeric character. * End with an alphanumeric character. * A maximum length of 63 characters. * The identifier \"kube-system\", \"default\" and \"wandelbots\" are reserved and cannot be used.  (required)
        :type cell: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_recipe_metadata_serialize(
            cell=cell,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListRecipeMetadataResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _list_recipe_metadata_serialize(
        self,
        cell,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if cell is not None:
            _path_params['cell'] = cell
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'BasicAuth', 
            'BearerAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/cells/{cell}/store/recipes',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )



    @validate_call
    async def update_recipe_metadata(
        self,
        cell: Annotated[str, Field(strict=True, description="Unique identifier addressing a cell in all API calls.  Since the cell identifier is used as Kubernetes namespace, the following rules apply: * Contain only lowercase alphanumeric characters or '-'. * Start with an alphanumeric character. * End with an alphanumeric character. * A maximum length of 63 characters. * The identifier \"kube-system\", \"default\" and \"wandelbots\" are reserved and cannot be used. ")],
        recipe: Annotated[StrictStr, Field(description="Recieved from [listRecipeMetadata](listRecipeMetadata) or from the response of [createRecipe](createRecipe). ")],
        update_recipe_metadata_request: UpdateRecipeMetadataRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RecipeMetadata:
        """Update Recipe Metadata

        # EXPERIMENTAL  > **Note:** This endpoint is experimental and might experience functional changes in the future.  Updates the metadata of a recipe. The update is partial, only the set fields get updated. 

        :param cell: Unique identifier addressing a cell in all API calls.  Since the cell identifier is used as Kubernetes namespace, the following rules apply: * Contain only lowercase alphanumeric characters or '-'. * Start with an alphanumeric character. * End with an alphanumeric character. * A maximum length of 63 characters. * The identifier \"kube-system\", \"default\" and \"wandelbots\" are reserved and cannot be used.  (required)
        :type cell: str
        :param recipe: Recieved from [listRecipeMetadata](listRecipeMetadata) or from the response of [createRecipe](createRecipe).  (required)
        :type recipe: str
        :param update_recipe_metadata_request: (required)
        :type update_recipe_metadata_request: UpdateRecipeMetadataRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_recipe_metadata_serialize(
            cell=cell,
            recipe=recipe,
            update_recipe_metadata_request=update_recipe_metadata_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RecipeMetadata",
            '404': "HTTPExceptionResponse",
            '422': "HTTPValidationError",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def update_recipe_metadata_with_http_info(
        self,
        cell: Annotated[str, Field(strict=True, description="Unique identifier addressing a cell in all API calls.  Since the cell identifier is used as Kubernetes namespace, the following rules apply: * Contain only lowercase alphanumeric characters or '-'. * Start with an alphanumeric character. * End with an alphanumeric character. * A maximum length of 63 characters. * The identifier \"kube-system\", \"default\" and \"wandelbots\" are reserved and cannot be used. ")],
        recipe: Annotated[StrictStr, Field(description="Recieved from [listRecipeMetadata](listRecipeMetadata) or from the response of [createRecipe](createRecipe). ")],
        update_recipe_metadata_request: UpdateRecipeMetadataRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[RecipeMetadata]:
        """Update Recipe Metadata

        # EXPERIMENTAL  > **Note:** This endpoint is experimental and might experience functional changes in the future.  Updates the metadata of a recipe. The update is partial, only the set fields get updated. 

        :param cell: Unique identifier addressing a cell in all API calls.  Since the cell identifier is used as Kubernetes namespace, the following rules apply: * Contain only lowercase alphanumeric characters or '-'. * Start with an alphanumeric character. * End with an alphanumeric character. * A maximum length of 63 characters. * The identifier \"kube-system\", \"default\" and \"wandelbots\" are reserved and cannot be used.  (required)
        :type cell: str
        :param recipe: Recieved from [listRecipeMetadata](listRecipeMetadata) or from the response of [createRecipe](createRecipe).  (required)
        :type recipe: str
        :param update_recipe_metadata_request: (required)
        :type update_recipe_metadata_request: UpdateRecipeMetadataRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_recipe_metadata_serialize(
            cell=cell,
            recipe=recipe,
            update_recipe_metadata_request=update_recipe_metadata_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RecipeMetadata",
            '404': "HTTPExceptionResponse",
            '422': "HTTPValidationError",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def update_recipe_metadata_without_preload_content(
        self,
        cell: Annotated[str, Field(strict=True, description="Unique identifier addressing a cell in all API calls.  Since the cell identifier is used as Kubernetes namespace, the following rules apply: * Contain only lowercase alphanumeric characters or '-'. * Start with an alphanumeric character. * End with an alphanumeric character. * A maximum length of 63 characters. * The identifier \"kube-system\", \"default\" and \"wandelbots\" are reserved and cannot be used. ")],
        recipe: Annotated[StrictStr, Field(description="Recieved from [listRecipeMetadata](listRecipeMetadata) or from the response of [createRecipe](createRecipe). ")],
        update_recipe_metadata_request: UpdateRecipeMetadataRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Update Recipe Metadata

        # EXPERIMENTAL  > **Note:** This endpoint is experimental and might experience functional changes in the future.  Updates the metadata of a recipe. The update is partial, only the set fields get updated. 

        :param cell: Unique identifier addressing a cell in all API calls.  Since the cell identifier is used as Kubernetes namespace, the following rules apply: * Contain only lowercase alphanumeric characters or '-'. * Start with an alphanumeric character. * End with an alphanumeric character. * A maximum length of 63 characters. * The identifier \"kube-system\", \"default\" and \"wandelbots\" are reserved and cannot be used.  (required)
        :type cell: str
        :param recipe: Recieved from [listRecipeMetadata](listRecipeMetadata) or from the response of [createRecipe](createRecipe).  (required)
        :type recipe: str
        :param update_recipe_metadata_request: (required)
        :type update_recipe_metadata_request: UpdateRecipeMetadataRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_recipe_metadata_serialize(
            cell=cell,
            recipe=recipe,
            update_recipe_metadata_request=update_recipe_metadata_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RecipeMetadata",
            '404': "HTTPExceptionResponse",
            '422': "HTTPValidationError",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _update_recipe_metadata_serialize(
        self,
        cell,
        recipe,
        update_recipe_metadata_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if cell is not None:
            _path_params['cell'] = cell
        if recipe is not None:
            _path_params['recipe'] = recipe
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if update_recipe_metadata_request is not None:
            _body_params = update_recipe_metadata_request


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'BasicAuth', 
            'BearerAuth'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/cells/{cell}/store/recipes/{recipe}/metadata',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )



    @validate_call
    async def upload_recipe_metadata_image(
        self,
        cell: Annotated[str, Field(strict=True, description="Unique identifier addressing a cell in all API calls.  Since the cell identifier is used as Kubernetes namespace, the following rules apply: * Contain only lowercase alphanumeric characters or '-'. * Start with an alphanumeric character. * End with an alphanumeric character. * A maximum length of 63 characters. * The identifier \"kube-system\", \"default\" and \"wandelbots\" are reserved and cannot be used. ")],
        recipe: Annotated[StrictStr, Field(description="Recieved from [listRecipeMetadata](listRecipeMetadata) or from the response of [createRecipe](createRecipe). ")],
        file: Union[StrictBytes, StrictStr],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RecipeMetadata:
        """Upload Recipe Metadata Image

        # EXPERIMENTAL  > **Note:** This endpoint is experimental and might experience functional changes in the future.  Uploads an image for a recipe. The image is served as a static file and the path is stored in the metadata. 

        :param cell: Unique identifier addressing a cell in all API calls.  Since the cell identifier is used as Kubernetes namespace, the following rules apply: * Contain only lowercase alphanumeric characters or '-'. * Start with an alphanumeric character. * End with an alphanumeric character. * A maximum length of 63 characters. * The identifier \"kube-system\", \"default\" and \"wandelbots\" are reserved and cannot be used.  (required)
        :type cell: str
        :param recipe: Recieved from [listRecipeMetadata](listRecipeMetadata) or from the response of [createRecipe](createRecipe).  (required)
        :type recipe: str
        :param file: (required)
        :type file: bytearray
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._upload_recipe_metadata_image_serialize(
            cell=cell,
            recipe=recipe,
            file=file,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RecipeMetadata",
            '404': "HTTPExceptionResponse",
            '422': "HTTPValidationError",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def upload_recipe_metadata_image_with_http_info(
        self,
        cell: Annotated[str, Field(strict=True, description="Unique identifier addressing a cell in all API calls.  Since the cell identifier is used as Kubernetes namespace, the following rules apply: * Contain only lowercase alphanumeric characters or '-'. * Start with an alphanumeric character. * End with an alphanumeric character. * A maximum length of 63 characters. * The identifier \"kube-system\", \"default\" and \"wandelbots\" are reserved and cannot be used. ")],
        recipe: Annotated[StrictStr, Field(description="Recieved from [listRecipeMetadata](listRecipeMetadata) or from the response of [createRecipe](createRecipe). ")],
        file: Union[StrictBytes, StrictStr],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[RecipeMetadata]:
        """Upload Recipe Metadata Image

        # EXPERIMENTAL  > **Note:** This endpoint is experimental and might experience functional changes in the future.  Uploads an image for a recipe. The image is served as a static file and the path is stored in the metadata. 

        :param cell: Unique identifier addressing a cell in all API calls.  Since the cell identifier is used as Kubernetes namespace, the following rules apply: * Contain only lowercase alphanumeric characters or '-'. * Start with an alphanumeric character. * End with an alphanumeric character. * A maximum length of 63 characters. * The identifier \"kube-system\", \"default\" and \"wandelbots\" are reserved and cannot be used.  (required)
        :type cell: str
        :param recipe: Recieved from [listRecipeMetadata](listRecipeMetadata) or from the response of [createRecipe](createRecipe).  (required)
        :type recipe: str
        :param file: (required)
        :type file: bytearray
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._upload_recipe_metadata_image_serialize(
            cell=cell,
            recipe=recipe,
            file=file,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RecipeMetadata",
            '404': "HTTPExceptionResponse",
            '422': "HTTPValidationError",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def upload_recipe_metadata_image_without_preload_content(
        self,
        cell: Annotated[str, Field(strict=True, description="Unique identifier addressing a cell in all API calls.  Since the cell identifier is used as Kubernetes namespace, the following rules apply: * Contain only lowercase alphanumeric characters or '-'. * Start with an alphanumeric character. * End with an alphanumeric character. * A maximum length of 63 characters. * The identifier \"kube-system\", \"default\" and \"wandelbots\" are reserved and cannot be used. ")],
        recipe: Annotated[StrictStr, Field(description="Recieved from [listRecipeMetadata](listRecipeMetadata) or from the response of [createRecipe](createRecipe). ")],
        file: Union[StrictBytes, StrictStr],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Upload Recipe Metadata Image

        # EXPERIMENTAL  > **Note:** This endpoint is experimental and might experience functional changes in the future.  Uploads an image for a recipe. The image is served as a static file and the path is stored in the metadata. 

        :param cell: Unique identifier addressing a cell in all API calls.  Since the cell identifier is used as Kubernetes namespace, the following rules apply: * Contain only lowercase alphanumeric characters or '-'. * Start with an alphanumeric character. * End with an alphanumeric character. * A maximum length of 63 characters. * The identifier \"kube-system\", \"default\" and \"wandelbots\" are reserved and cannot be used.  (required)
        :type cell: str
        :param recipe: Recieved from [listRecipeMetadata](listRecipeMetadata) or from the response of [createRecipe](createRecipe).  (required)
        :type recipe: str
        :param file: (required)
        :type file: bytearray
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._upload_recipe_metadata_image_serialize(
            cell=cell,
            recipe=recipe,
            file=file,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RecipeMetadata",
            '404': "HTTPExceptionResponse",
            '422': "HTTPValidationError",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _upload_recipe_metadata_image_serialize(
        self,
        cell,
        recipe,
        file,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if cell is not None:
            _path_params['cell'] = cell
        if recipe is not None:
            _path_params['recipe'] = recipe
        # process the query parameters
        # process the header parameters
        # process the form parameters
        if file is not None:
            _files['file'] = file
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'BasicAuth', 
            'BearerAuth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/cells/{cell}/store/recipes/{recipe}/metadata/image',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


