# coding: utf-8

"""
    Wandelbots Nova Public API

    Interact with robots in an easy and intuitive way. 

    The version of the OpenAPI document: 2.0.0 beta
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt
from typing import Any, ClassVar, Dict, List, Optional, Union
from wandelbots_api_client.v2.models.planning_limits_limit_range import PlanningLimitsLimitRange
from typing import Optional, Set
from typing_extensions import Self

class PlanningLimits(BaseModel):
    """
    All known joint and cartesian limits of a motion-group. Used for motion planning.
    """ # noqa: E501
    joint_position_limits: Optional[List[PlanningLimitsLimitRange]] = Field(default=None, description="Joint position limits in [rad], configured in the safety setup, starting at base. ")
    joint_velocity_limits: Optional[List[Union[StrictFloat, StrictInt]]] = Field(default=None, description="Maximum allowed velocity for joints in [rad/s or mm/s] of the safety setup, starting at base. ")
    joint_acceleration_limits: Optional[List[Union[StrictFloat, StrictInt]]] = Field(default=None, description="Maximum allowed acceleration for joints in [rad/s^2 or mm/s^2] of the safety setup, starting at base. ")
    joint_torque_limits: Optional[List[Union[StrictFloat, StrictInt]]] = Field(default=None, description="Maximum allowed torque for joints in [Nm or N] of the safety setup, starting at base. ")
    tcp_velocity_limit: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="At maximum one dimensional velocity in [mm/s] at TCP allowed. ")
    tcp_acceleration_limit: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="At maximum one dimensional acceleration in [mm/s^2] at TCP allowed. ")
    tcp_orientation_velocity_limit: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="At maximum one dimensional orientation velocity in [rad/s] at TCP allowed. ")
    tcp_orientation_acceleration_limit: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="At maximum one dimensional orientation acceleration in [rad/s^2] at TCP allowed. ")
    tcp_force_limit: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="At maximum one dimensional force in [N] at TCP allowed. ")
    elbow_velocity_limit: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="At maximum one dimensional velocity in [mm/s] at the elbow allowed. ")
    elbow_acceleration_limit: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="At maximum one dimensional acceleration in [mm/s^2] at the elbow allowed. ")
    elbow_force_limit: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="At maximum one dimensional force in [N] at the elbow allowed. ")
    __properties: ClassVar[List[str]] = ["joint_position_limits", "joint_velocity_limits", "joint_acceleration_limits", "joint_torque_limits", "tcp_velocity_limit", "tcp_acceleration_limit", "tcp_orientation_velocity_limit", "tcp_orientation_acceleration_limit", "tcp_force_limit", "elbow_velocity_limit", "elbow_acceleration_limit", "elbow_force_limit"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PlanningLimits from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in joint_position_limits (list)
        _items = []
        if self.joint_position_limits:
            for _item in self.joint_position_limits:
                # >>> Modified from https://github.com/OpenAPITools/openapi-generator/blob/v7.6.0/modules/openapi-generator/src/main/resources/python/model_generic.mustache
                #     to not drop empty elements in lists
                if _item is not None:
                    _items.append(_item.to_dict())
                # <<< End modification
            _dict['joint_position_limits'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PlanningLimits from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "joint_position_limits": [
                # >>> Modified from https://github.com/OpenAPITools/openapi-generator/blob/v7.6.0/modules/openapi-generator/src/main/resources/python/model_generic.mustache
                #     to allow dicts in lists
                PlanningLimitsLimitRange.from_dict(_item) if hasattr(PlanningLimitsLimitRange, 'from_dict') else _item
                # <<< End modification
                for _item in obj["joint_position_limits"]
            ] if obj.get("joint_position_limits") is not None else None,
            "joint_velocity_limits": obj.get("joint_velocity_limits"),
            "joint_acceleration_limits": obj.get("joint_acceleration_limits"),
            "joint_torque_limits": obj.get("joint_torque_limits"),
            "tcp_velocity_limit": obj.get("tcp_velocity_limit"),
            "tcp_acceleration_limit": obj.get("tcp_acceleration_limit"),
            "tcp_orientation_velocity_limit": obj.get("tcp_orientation_velocity_limit"),
            "tcp_orientation_acceleration_limit": obj.get("tcp_orientation_acceleration_limit"),
            "tcp_force_limit": obj.get("tcp_force_limit"),
            "elbow_velocity_limit": obj.get("elbow_velocity_limit"),
            "elbow_acceleration_limit": obj.get("elbow_acceleration_limit"),
            "elbow_force_limit": obj.get("elbow_force_limit")
        })
        return _obj


