# coding: utf-8

"""
    Wandelbots Nova Public API

    Interact with robots in an easy and intuitive way. 

    The version of the OpenAPI document: 2.0.0 beta
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List
from wandelbots_api_client.v2.models.planner_pose import PlannerPose
from wandelbots_api_client.v2.models.safety_configuration import SafetyConfiguration
from typing import Optional, Set
from typing_extensions import Self

class OptimizerSetup(BaseModel):
    """
    The configuration of a motion-group used for motion planning.
    """ # noqa: E501
    motion_group_type: StrictStr
    mounting: PlannerPose
    tcp: PlannerPose
    safety_setup: SafetyConfiguration
    __properties: ClassVar[List[str]] = ["motion_group_type", "mounting", "tcp", "safety_setup"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of OptimizerSetup from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of mounting
        if self.mounting:
            _dict['mounting'] = self.mounting.to_dict()
        # override the default output from pydantic by calling `to_dict()` of tcp
        if self.tcp:
            _dict['tcp'] = self.tcp.to_dict()
        # override the default output from pydantic by calling `to_dict()` of safety_setup
        if self.safety_setup:
            _dict['safety_setup'] = self.safety_setup.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of OptimizerSetup from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "motion_group_type": obj.get("motion_group_type"),
            "mounting": PlannerPose.from_dict(obj["mounting"]) if obj.get("mounting") is not None else None,
            "tcp": PlannerPose.from_dict(obj["tcp"]) if obj.get("tcp") is not None else None,
            "safety_setup": SafetyConfiguration.from_dict(obj["safety_setup"]) if obj.get("safety_setup") is not None else None
        })
        return _obj


