# coding: utf-8

"""
    Wandelbots Nova Public API

    Interact with robots in an easy and intuitive way. 

    The version of the OpenAPI document: 2.0.0 beta
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
from inspect import getfullargspec
import json
import pprint
import re  # noqa: F401
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Optional
from wandelbots_api_client.v2.models.io_bool import IOBool
from wandelbots_api_client.v2.models.io_double import IODouble
from wandelbots_api_client.v2.models.io_integer import IOInteger
from typing import Union, Any, List, Set, TYPE_CHECKING, Optional, Dict
from typing_extensions import Literal, Self
from pydantic import Field

IOSIOSINNER_ANY_OF_SCHEMAS = ["IOBool", "IODouble", "IOInteger"]

class IOsIOsInner(BaseModel):
    """
    IOsIOsInner
    """

    # data type: IOInteger
    anyof_schema_1_validator: Optional[IOInteger] = None
    # data type: IOBool
    anyof_schema_2_validator: Optional[IOBool] = None
    # data type: IODouble
    anyof_schema_3_validator: Optional[IODouble] = None
    if TYPE_CHECKING:
        actual_instance: Optional[Union[IOBool, IODouble, IOInteger]] = None
    else:
        actual_instance: Any = None
    any_of_schemas: Set[str] = { "IOBool", "IODouble", "IOInteger" }

    model_config = {
        "validate_assignment": True,
        "protected_namespaces": (),
    }

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_anyof(cls, v):
        instance = IOsIOsInner.model_construct()
        error_messages = []
        # validate data type: IOInteger
        if not isinstance(v, IOInteger):
            error_messages.append(f"Error! Input type `{type(v)}` is not `IOInteger`")
        else:
            return v

        # validate data type: IOBool
        if not isinstance(v, IOBool):
            error_messages.append(f"Error! Input type `{type(v)}` is not `IOBool`")
        else:
            return v

        # validate data type: IODouble
        if not isinstance(v, IODouble):
            error_messages.append(f"Error! Input type `{type(v)}` is not `IODouble`")
        else:
            return v

        if error_messages:
            # no match
            raise ValueError("No match found when setting the actual_instance in IOsIOsInner with anyOf schemas: IOBool, IODouble, IOInteger. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Dict[str, Any]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        # anyof_schema_1_validator: Optional[IOInteger] = None
        try:
            instance.actual_instance = IOInteger.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_2_validator: Optional[IOBool] = None
        try:
            instance.actual_instance = IOBool.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_3_validator: Optional[IODouble] = None
        try:
            instance.actual_instance = IODouble.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))

        if error_messages:
            # no match
            raise ValueError("No match found when deserializing the JSON string into IOsIOsInner with anyOf schemas: IOBool, IODouble, IOInteger. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], IOBool, IODouble, IOInteger]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


