# coding: utf-8

"""
    Wandelbots Nova API

    Interact with robots in an easy and intuitive way. 

    The version of the OpenAPI document: 2.0.0 beta
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
import pprint
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Any, List, Optional
from wandelbots_api_client.v2.models.box2 import Box2
from wandelbots_api_client.v2.models.capsule2 import Capsule2
from wandelbots_api_client.v2.models.convex_hull2 import ConvexHull2
from wandelbots_api_client.v2.models.cylinder2 import Cylinder2
from wandelbots_api_client.v2.models.plane2 import Plane2
from wandelbots_api_client.v2.models.rectangle2 import Rectangle2
from wandelbots_api_client.v2.models.rectangular_capsule2 import RectangularCapsule2
from wandelbots_api_client.v2.models.sphere2 import Sphere2
from pydantic import StrictStr, Field
from typing import Union, List, Set, Optional, Dict
from typing_extensions import Literal, Self

COLLIDERSHAPE_ONE_OF_SCHEMAS = ["Box2", "Capsule2", "ConvexHull2", "Cylinder2", "Plane2", "Rectangle2", "RectangularCapsule2", "Sphere2"]

class ColliderShape(BaseModel):
    """
    ColliderShape
    """
    # data type: Sphere2
    oneof_schema_1_validator: Optional[Sphere2] = None
    # data type: Box2
    oneof_schema_2_validator: Optional[Box2] = None
    # data type: Rectangle2
    oneof_schema_3_validator: Optional[Rectangle2] = None
    # data type: Plane2
    oneof_schema_4_validator: Optional[Plane2] = None
    # data type: Cylinder2
    oneof_schema_5_validator: Optional[Cylinder2] = None
    # data type: Capsule2
    oneof_schema_6_validator: Optional[Capsule2] = None
    # data type: RectangularCapsule2
    oneof_schema_7_validator: Optional[RectangularCapsule2] = None
    # data type: ConvexHull2
    oneof_schema_8_validator: Optional[ConvexHull2] = None
    actual_instance: Optional[Union[Box2, Capsule2, ConvexHull2, Cylinder2, Plane2, Rectangle2, RectangularCapsule2, Sphere2]] = None
    one_of_schemas: Set[str] = { "Box2", "Capsule2", "ConvexHull2", "Cylinder2", "Plane2", "Rectangle2", "RectangularCapsule2", "Sphere2" }

    model_config = ConfigDict(
        validate_assignment=True,
        protected_namespaces=(),
    )


    discriminator_value_class_map: Dict[str, str] = {
    }

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = ColliderShape.model_construct()
        error_messages = []
        match = 0
        # validate data type: Sphere2
        if not isinstance(v, Sphere2):
            error_messages.append(f"Error! Input type `{type(v)}` is not `Sphere2`")
        else:
            match += 1
        # validate data type: Box2
        if not isinstance(v, Box2):
            error_messages.append(f"Error! Input type `{type(v)}` is not `Box2`")
        else:
            match += 1
        # validate data type: Rectangle2
        if not isinstance(v, Rectangle2):
            error_messages.append(f"Error! Input type `{type(v)}` is not `Rectangle2`")
        else:
            match += 1
        # validate data type: Plane2
        if not isinstance(v, Plane2):
            error_messages.append(f"Error! Input type `{type(v)}` is not `Plane2`")
        else:
            match += 1
        # validate data type: Cylinder2
        if not isinstance(v, Cylinder2):
            error_messages.append(f"Error! Input type `{type(v)}` is not `Cylinder2`")
        else:
            match += 1
        # validate data type: Capsule2
        if not isinstance(v, Capsule2):
            error_messages.append(f"Error! Input type `{type(v)}` is not `Capsule2`")
        else:
            match += 1
        # validate data type: RectangularCapsule2
        if not isinstance(v, RectangularCapsule2):
            error_messages.append(f"Error! Input type `{type(v)}` is not `RectangularCapsule2`")
        else:
            match += 1
        # validate data type: ConvexHull2
        if not isinstance(v, ConvexHull2):
            error_messages.append(f"Error! Input type `{type(v)}` is not `ConvexHull2`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in ColliderShape with oneOf schemas: Box2, Capsule2, ConvexHull2, Cylinder2, Plane2, Rectangle2, RectangularCapsule2, Sphere2. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in ColliderShape with oneOf schemas: Box2, Capsule2, ConvexHull2, Cylinder2, Plane2, Rectangle2, RectangularCapsule2, Sphere2. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Union[str, Dict[str, Any]]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        match = 0

        # use oneOf discriminator to lookup the data type
        _data_type = json.loads(json_str).get("shape_type")
        if not _data_type:
            raise ValueError("Failed to lookup data type from the field `shape_type` in the input.")

        # check if data type is `Box2`
        if _data_type == "box":
            instance.actual_instance = Box2.from_json(json_str)
            return instance

        # check if data type is `Capsule2`
        if _data_type == "capsule":
            instance.actual_instance = Capsule2.from_json(json_str)
            return instance

        # check if data type is `ConvexHull2`
        if _data_type == "convex_hull":
            instance.actual_instance = ConvexHull2.from_json(json_str)
            return instance

        # check if data type is `Cylinder2`
        if _data_type == "cylinder":
            instance.actual_instance = Cylinder2.from_json(json_str)
            return instance

        # check if data type is `Plane2`
        if _data_type == "plane":
            instance.actual_instance = Plane2.from_json(json_str)
            return instance

        # check if data type is `Rectangle2`
        if _data_type == "rectangle":
            instance.actual_instance = Rectangle2.from_json(json_str)
            return instance

        # check if data type is `RectangularCapsule2`
        if _data_type == "rectangular_capsule":
            instance.actual_instance = RectangularCapsule2.from_json(json_str)
            return instance

        # check if data type is `Sphere2`
        if _data_type == "sphere":
            instance.actual_instance = Sphere2.from_json(json_str)
            return instance

        # check if data type is `Box2`
        if _data_type == "Box-2":
            instance.actual_instance = Box2.from_json(json_str)
            return instance

        # check if data type is `Capsule2`
        if _data_type == "Capsule-2":
            instance.actual_instance = Capsule2.from_json(json_str)
            return instance

        # check if data type is `ConvexHull2`
        if _data_type == "ConvexHull-2":
            instance.actual_instance = ConvexHull2.from_json(json_str)
            return instance

        # check if data type is `Cylinder2`
        if _data_type == "Cylinder-2":
            instance.actual_instance = Cylinder2.from_json(json_str)
            return instance

        # check if data type is `Plane2`
        if _data_type == "Plane-2":
            instance.actual_instance = Plane2.from_json(json_str)
            return instance

        # check if data type is `Rectangle2`
        if _data_type == "Rectangle-2":
            instance.actual_instance = Rectangle2.from_json(json_str)
            return instance

        # check if data type is `RectangularCapsule2`
        if _data_type == "RectangularCapsule-2":
            instance.actual_instance = RectangularCapsule2.from_json(json_str)
            return instance

        # check if data type is `Sphere2`
        if _data_type == "Sphere-2":
            instance.actual_instance = Sphere2.from_json(json_str)
            return instance

        # deserialize data into Sphere2
        try:
            instance.actual_instance = Sphere2.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into Box2
        try:
            instance.actual_instance = Box2.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into Rectangle2
        try:
            instance.actual_instance = Rectangle2.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into Plane2
        try:
            instance.actual_instance = Plane2.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into Cylinder2
        try:
            instance.actual_instance = Cylinder2.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into Capsule2
        try:
            instance.actual_instance = Capsule2.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into RectangularCapsule2
        try:
            instance.actual_instance = RectangularCapsule2.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into ConvexHull2
        try:
            instance.actual_instance = ConvexHull2.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into ColliderShape with oneOf schemas: Box2, Capsule2, ConvexHull2, Cylinder2, Plane2, Rectangle2, RectangularCapsule2, Sphere2. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into ColliderShape with oneOf schemas: Box2, Capsule2, ConvexHull2, Cylinder2, Plane2, Rectangle2, RectangularCapsule2, Sphere2. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], Box2, Capsule2, ConvexHull2, Cylinder2, Plane2, Rectangle2, RectangularCapsule2, Sphere2]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


