# coding: utf-8

"""
    Wandelbots Nova API

    Interact with robots in an easy and intuitive way. 

    The version of the OpenAPI document: 2.0.0 beta
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
import pprint
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Any, List, Optional
from wandelbots_api_client.v2.models.stream_move_backward import StreamMoveBackward
from wandelbots_api_client.v2.models.stream_move_forward import StreamMoveForward
from wandelbots_api_client.v2.models.stream_move_playback_speed import StreamMovePlaybackSpeed
from wandelbots_api_client.v2.models.stream_move_to_trajectory import StreamMoveToTrajectory
from wandelbots_api_client.v2.models.stream_stop import StreamStop
from pydantic import StrictStr, Field
from typing import Union, List, Set, Optional, Dict
from typing_extensions import Literal, Self

STREAMMOVEREQUEST_ONE_OF_SCHEMAS = ["StreamMoveBackward", "StreamMoveForward", "StreamMovePlaybackSpeed", "StreamMoveToTrajectory", "StreamStop"]

class StreamMoveRequest(BaseModel):
    """
    StreamMoveRequest
    """
    # data type: StreamMoveForward
    oneof_schema_1_validator: Optional[StreamMoveForward] = None
    # data type: StreamMoveBackward
    oneof_schema_2_validator: Optional[StreamMoveBackward] = None
    # data type: StreamMoveToTrajectory
    oneof_schema_3_validator: Optional[StreamMoveToTrajectory] = None
    # data type: StreamMovePlaybackSpeed
    oneof_schema_4_validator: Optional[StreamMovePlaybackSpeed] = None
    # data type: StreamStop
    oneof_schema_5_validator: Optional[StreamStop] = None
    actual_instance: Optional[Union[StreamMoveBackward, StreamMoveForward, StreamMovePlaybackSpeed, StreamMoveToTrajectory, StreamStop]] = None
    one_of_schemas: Set[str] = { "StreamMoveBackward", "StreamMoveForward", "StreamMovePlaybackSpeed", "StreamMoveToTrajectory", "StreamStop" }

    model_config = ConfigDict(
        validate_assignment=True,
        protected_namespaces=(),
    )


    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = StreamMoveRequest.model_construct()
        error_messages = []
        match = 0
        # validate data type: StreamMoveForward
        if not isinstance(v, StreamMoveForward):
            error_messages.append(f"Error! Input type `{type(v)}` is not `StreamMoveForward`")
        else:
            match += 1
        # validate data type: StreamMoveBackward
        if not isinstance(v, StreamMoveBackward):
            error_messages.append(f"Error! Input type `{type(v)}` is not `StreamMoveBackward`")
        else:
            match += 1
        # validate data type: StreamMoveToTrajectory
        if not isinstance(v, StreamMoveToTrajectory):
            error_messages.append(f"Error! Input type `{type(v)}` is not `StreamMoveToTrajectory`")
        else:
            match += 1
        # validate data type: StreamMovePlaybackSpeed
        if not isinstance(v, StreamMovePlaybackSpeed):
            error_messages.append(f"Error! Input type `{type(v)}` is not `StreamMovePlaybackSpeed`")
        else:
            match += 1
        # validate data type: StreamStop
        if not isinstance(v, StreamStop):
            error_messages.append(f"Error! Input type `{type(v)}` is not `StreamStop`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in StreamMoveRequest with oneOf schemas: StreamMoveBackward, StreamMoveForward, StreamMovePlaybackSpeed, StreamMoveToTrajectory, StreamStop. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in StreamMoveRequest with oneOf schemas: StreamMoveBackward, StreamMoveForward, StreamMovePlaybackSpeed, StreamMoveToTrajectory, StreamStop. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Union[str, Dict[str, Any]]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        match = 0

        # deserialize data into StreamMoveForward
        try:
            instance.actual_instance = StreamMoveForward.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into StreamMoveBackward
        try:
            instance.actual_instance = StreamMoveBackward.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into StreamMoveToTrajectory
        try:
            instance.actual_instance = StreamMoveToTrajectory.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into StreamMovePlaybackSpeed
        try:
            instance.actual_instance = StreamMovePlaybackSpeed.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into StreamStop
        try:
            instance.actual_instance = StreamStop.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into StreamMoveRequest with oneOf schemas: StreamMoveBackward, StreamMoveForward, StreamMovePlaybackSpeed, StreamMoveToTrajectory, StreamStop. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into StreamMoveRequest with oneOf schemas: StreamMoveBackward, StreamMoveForward, StreamMovePlaybackSpeed, StreamMoveToTrajectory, StreamStop. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], StreamMoveBackward, StreamMoveForward, StreamMovePlaybackSpeed, StreamMoveToTrajectory, StreamStop]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


