# coding: utf-8

"""
    Wandelbots NOVA API

    Interact with robots in an easy and intuitive way. 

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt
from typing import Any, ClassVar, Dict, List, Optional, Union
from wandelbots_api_client.models.limits_override import LimitsOverride
from typing import Optional, Set
from typing_extensions import Self

class CommandSettings(BaseModel):
    """
    Settings which can be used to modify the behavior in a command-wise manner.
    """ # noqa: E501
    auto_blending: Optional[StrictInt] = Field(default=None, description="Auto-blending is used to keep a constant velocity when blending between two motion commands. It changes the TCP path around the target point of a motion command. The value represents the percentage of the original velocity.  What is blending? Blending alters the geometry of the TCP path at the target point of a motion command to ensure that the velocity does not drop to zero between two motion commands.") 
    position_blending: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="If auto-blending blends too much of the resulting trajectory, position-blending could be used between two motion commands. Specifies the maximum radius in [mm] around the motion command's target point where the geometry of the TCP path is allowed to be changed to blend the current motion command into the next one.") 
    limits_override: Optional[LimitsOverride] = None 
    __properties: ClassVar[List[str]] = ["auto_blending", "position_blending", "limits_override"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True, exclude_none=True))

    def to_json(self) -> str:
        """
        Returns the JSON representation of the model using alias
        
        Do not use pydantic v2 .model_dump_json(by_alias=True, exclude_unset=True) here!
        It is unable to resolve nested types generated by openapi-generator.
        """
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CommandSettings from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of limits_override
        if self.limits_override:
            _dict['limits_override'] = self.limits_override.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CommandSettings from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "auto_blending": obj.get("auto_blending"),
            "position_blending": obj.get("position_blending"),
            "limits_override": LimitsOverride.from_dict(obj["limits_override"]) if obj.get("limits_override") is not None else None
        })
        return _obj


