# coding: utf-8

"""
    Wandelbots NOVA API

    Interact with robots in an easy and intuitive way. 

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from wandelbots_api_client.models.vector3d import Vector3d
from typing import Optional, Set
from typing_extensions import Self

class Payload(BaseModel):
    """
    Payload
    """ # noqa: E501
    name: StrictStr = Field(description="Unique identifier of the payload.") 
    payload: Union[StrictFloat, StrictInt] = Field(description="Mass of payload in [kg].") 
    center_of_mass: Optional[Vector3d] = None 
    moment_of_inertia: Optional[Vector3d] = None 
    __properties: ClassVar[List[str]] = ["name", "payload", "center_of_mass", "moment_of_inertia"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True, exclude_none=True))

    def to_json(self) -> str:
        """
        Returns the JSON representation of the model using alias
        
        Do not use pydantic v2 .model_dump_json(by_alias=True, exclude_unset=True) here!
        It is unable to resolve nested types generated by openapi-generator.
        """
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Payload from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of center_of_mass
        if self.center_of_mass:
            _dict['center_of_mass'] = self.center_of_mass.to_dict()
        # override the default output from pydantic by calling `to_dict()` of moment_of_inertia
        if self.moment_of_inertia:
            _dict['moment_of_inertia'] = self.moment_of_inertia.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Payload from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "payload": obj.get("payload"),
            "center_of_mass": Vector3d.from_dict(obj["center_of_mass"]) if obj.get("center_of_mass") is not None else None,
            "moment_of_inertia": Vector3d.from_dict(obj["moment_of_inertia"]) if obj.get("moment_of_inertia") is not None else None
        })
        return _obj


