# coding: utf-8

"""
    Wandelbots NOVA API

    Interact with robots in an easy and intuitive way. 

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from wandelbots_api_client.models.vector3d import Vector3d
from typing import Optional, Set
from typing_extensions import Self

class Pose(BaseModel):
    """
    Representing a pose in space with its origin in `coordinate_system`. A pose consists of positional coordinates [x, y, z] in millimeters (mm) and orientational coordinates in axis-angle representation [rx, ry, rz] in radian (rad).
    """ # noqa: E501
    position: Vector3d = Field(description="Position vector, defined in [x, y, z] with floating numbers in millimeters (ms).") 
    orientation: Optional[Vector3d] = Field(default=None, description="Rotation vector, defined in [rx, ry, rz] with floating numbers. The rotation is represented in vector3 using an axis-angle representation: axis.normalized * angle (angle in radians).") 
    coordinate_system: Optional[StrictStr] = Field(default=None, description="Unique identifier addressing the reference coordinate system of the pose. Default is the world coordinate system.") 
    __properties: ClassVar[List[str]] = ["position", "orientation", "coordinate_system"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True, exclude_none=True))

    def to_json(self) -> str:
        """
        Returns the JSON representation of the model using alias
        
        Do not use pydantic v2 .model_dump_json(by_alias=True, exclude_unset=True) here!
        It is unable to resolve nested types generated by openapi-generator.
        """
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Pose from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of position
        if self.position:
            _dict['position'] = self.position.to_dict()
        # override the default output from pydantic by calling `to_dict()` of orientation
        if self.orientation:
            _dict['orientation'] = self.orientation.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Pose from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "position": Vector3d.from_dict(obj["position"]) if obj.get("position") is not None else None,
            "orientation": Vector3d.from_dict(obj["orientation"]) if obj.get("orientation") is not None else None,
            "coordinate_system": obj.get("coordinate_system")
        })
        return _obj


