# coding: utf-8

"""
    Wandelbots NOVA API

    Interact with robots in an easy and intuitive way. 

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from wandelbots_api_client.models.joints import Joints
from typing import Optional, Set
from typing_extensions import Self

class Singularity(BaseModel):
    """
    A Singularity is a point in the robot's workspace where the robot loses one or more degrees of freedom with regards to moving its TCP. This means the robot cannot move or rotate the TCP in a certain direction from this specific point.  The singularity type is the type of singularity that the robot is in. The singular joint position is the joint position of the robot when it is in a singularity.
    """ # noqa: E501
    singularity_type: Optional[StrictStr] = None 
    singular_joint_position: Optional[Joints] = None 
    __properties: ClassVar[List[str]] = ["singularity_type", "singular_joint_position"]

    @field_validator('singularity_type')
    def singularity_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['SINGULARITY_TYPE_UNKNOWN', 'SINGULARITY_TYPE_WRIST', 'SINGULARITY_TYPE_ELBOW', 'SINGULARITY_TYPE_SHOULDER']):
            raise ValueError("must be one of enum values ('SINGULARITY_TYPE_UNKNOWN', 'SINGULARITY_TYPE_WRIST', 'SINGULARITY_TYPE_ELBOW', 'SINGULARITY_TYPE_SHOULDER')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True, exclude_none=True))

    def to_json(self) -> str:
        """
        Returns the JSON representation of the model using alias
        
        Do not use pydantic v2 .model_dump_json(by_alias=True, exclude_unset=True) here!
        It is unable to resolve nested types generated by openapi-generator.
        """
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Singularity from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of singular_joint_position
        if self.singular_joint_position:
            _dict['singular_joint_position'] = self.singular_joint_position.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Singularity from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "singularity_type": obj.get("singularity_type"),
            "singular_joint_position": Joints.from_dict(obj["singular_joint_position"]) if obj.get("singular_joint_position") is not None else None
        })
        return _obj


