# coding: utf-8

"""
    Wandelbots NOVA API

    Interact with robots in an easy and intuitive way.  > **Note:** API version 2 is experimental and will experience functional changes. 

    The version of the OpenAPI document: 2.0.0 beta
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from wandelbots_api_client.v2.models.container_environment_inner import ContainerEnvironmentInner
from wandelbots_api_client.v2.models.container_image import ContainerImage
from wandelbots_api_client.v2.models.container_resources import ContainerResources
from wandelbots_api_client.v2.models.container_storage import ContainerStorage
from typing import Optional, Set
from typing_extensions import Self

class App(BaseModel):
    """
    An App is defined by a webserver, packed inside a container, serving a web-application. 
    """ # noqa: E501
    name: Annotated[str, Field(min_length=1, strict=True)] = Field(description="The name of the provided application. The name must be unique within the cell and is used as a identifier for addressing the application in all API calls , e.g., when updating the application.  It also defines where the application is reachable (/$cell/$name).  It must be a valid k8s label name as defined by [RFC 1035](https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#rfc-1035-label-names). ") 
    app_icon: Annotated[str, Field(min_length=1, strict=True)] = Field(description="The path of the icon for the App (/$cell/$name/$app_icon).") 
    container_image: ContainerImage 
    port: Optional[StrictInt] = Field(default=8080, description="The port the containerized webserver is listening on.") 
    environment: Optional[List[ContainerEnvironmentInner]] = Field(default=None, description="A list of environment variables with name and their value. These can be used to configure the containerized application, and turn features on or off. ") 
    storage: Optional[ContainerStorage] = None 
    resources: Optional[ContainerResources] = None 
    health_path: Optional[StrictStr] = Field(default=None, description="Defines the URL path suffix used to check the application's health status. The complete health check URL is constructed as `/$cell/$name/$health_path`. When the application is working as expected, the endpoint returns an HTTP 200 status code.  If not specified, the system will default to using the application icon path suffix (the value of `app_icon`) as the health check endpoint, resulting in `/$cell/$name/$app_icon`.  If the health check fails (no response or non-200 status code), the system will automatically restart the application container to restore service. ") 
    diagnosis_path: Optional[StrictStr] = Field(default=None, description="Defines the URL path suffix used to provide an endpoint for diagnosis data collection. The complete diagnosis check URL is constructed as `/$cell/$name/$diagnosis_path`.  The endpoint is called when a diagnosis package is requested via the diagnosis API. The endpoint needs to return the data within a zip file `application/zip` response. ") 
    __properties: ClassVar[List[str]] = ["name", "app_icon", "container_image", "port", "environment", "storage", "resources", "health_path", "diagnosis_path"]

    @field_validator('name')
    def name_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^[a-z][a-z0-9-]{0,61}[a-z0-9]$", value):
            raise ValueError(r"must validate the regular expression /^[a-z][a-z0-9-]{0,61}[a-z0-9]$/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True, exclude_none=True))

    def to_json(self) -> str:
        """
        Returns the JSON representation of the model using alias
        
        Do not use pydantic v2 .model_dump_json(by_alias=True, exclude_unset=True) here!
        It is unable to resolve nested types generated by openapi-generator.
        """
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of App from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of container_image
        if self.container_image:
            _dict['container_image'] = self.container_image.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in environment (list)
        _items = []
        if self.environment:
            for _item in self.environment:
                # >>> Modified from https://github.com/OpenAPITools/openapi-generator/blob/v7.6.0/modules/openapi-generator/src/main/resources/python/model_generic.mustache
                #     to not drop empty elements in lists
                if _item is not None:
                    _items.append(_item.to_dict())
                # <<< End modification
            _dict['environment'] = _items
        # override the default output from pydantic by calling `to_dict()` of storage
        if self.storage:
            _dict['storage'] = self.storage.to_dict()
        # override the default output from pydantic by calling `to_dict()` of resources
        if self.resources:
            _dict['resources'] = self.resources.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of App from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "app_icon": obj.get("app_icon"),
            "container_image": ContainerImage.from_dict(obj["container_image"]) if obj.get("container_image") is not None else None,
            "port": obj.get("port") if obj.get("port") is not None else 8080,
            "environment": [
                # >>> Modified from https://github.com/OpenAPITools/openapi-generator/blob/v7.6.0/modules/openapi-generator/src/main/resources/python/model_generic.mustache
                #     to allow dicts in lists
                ContainerEnvironmentInner.from_dict(_item) if hasattr(ContainerEnvironmentInner, 'from_dict') else _item
                # <<< End modification
                for _item in obj["environment"]
            ] if obj.get("environment") is not None else None,
            "storage": ContainerStorage.from_dict(obj["storage"]) if obj.get("storage") is not None else None,
            "resources": ContainerResources.from_dict(obj["resources"]) if obj.get("resources") is not None else None,
            "health_path": obj.get("health_path"),
            "diagnosis_path": obj.get("diagnosis_path")
        })
        return _obj


