# coding: utf-8

"""
    Wandelbots NOVA API

    Interact with robots in an easy and intuitive way.  > **Note:** API version 2 is experimental and will experience functional changes. 

    The version of the OpenAPI document: 2.0.0 beta
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List
from wandelbots_api_client.v2.models.bus_io_modbus_tcp_server import BusIOModbusTCPServer
from typing import Optional, Set
from typing_extensions import Self

class BusIOModbusServer(BaseModel):
    """
    MODBUS server inputs/outputs service configuration. 
    """ # noqa: E501
    bus_type: str = "modbus_server"
    network: BusIOModbusTCPServer 
    connections: StrictInt = Field(description="Number of connections this MODBUS server can handle. ") 
    coils_size: StrictInt = Field(description="Size of the Coils memory area. ") 
    discrete_inputs_size: StrictInt = Field(description="Size of the Discrete Inputs memory area. ") 
    holding_registers_size: StrictInt = Field(description="Size of the Holding Registers memory area. ") 
    input_registers_size: StrictInt = Field(description="Size of the Input Registers memory area. ") 
    __properties: ClassVar[List[str]] = ["bus_type", "network", "connections", "coils_size", "discrete_inputs_size", "holding_registers_size", "input_registers_size"]

    @field_validator('bus_type')
    def bus_type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['modbus_server']):
            raise ValueError("must be one of enum values ('modbus_server')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True, exclude_none=True))

    def to_json(self) -> str:
        """
        Returns the JSON representation of the model using alias
        
        Do not use pydantic v2 .model_dump_json(by_alias=True, exclude_unset=True) here!
        It is unable to resolve nested types generated by openapi-generator.
        """
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BusIOModbusServer from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of network
        if self.network:
            _dict['network'] = self.network.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BusIOModbusServer from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "bus_type": obj.get("bus_type"),
            "network": BusIOModbusTCPServer.from_dict(obj["network"]) if obj.get("network") is not None else None,
            "connections": obj.get("connections"),
            "coils_size": obj.get("coils_size"),
            "discrete_inputs_size": obj.get("discrete_inputs_size"),
            "holding_registers_size": obj.get("holding_registers_size"),
            "input_registers_size": obj.get("input_registers_size")
        })
        return _obj


