# coding: utf-8

"""
    Wandelbots NOVA API

    Interact with robots in an easy and intuitive way.  > **Note:** API version 2 is experimental and will experience functional changes. 

    The version of the OpenAPI document: 2.0.0 beta
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from wandelbots_api_client.v2.models.bus_io_profinet_ip_config import BusIOProfinetIpConfig
from typing import Optional, Set
from typing_extensions import Self

class BusIOProfinetNetwork(BaseModel):
    """
    BusIOProfinetNetwork
    """ # noqa: E501
    device_name: Optional[StrictStr] = Field(default=None, description="Name of Station (NoS) of the PROFINET device. The NoS is used in combination with IPv4 record to identify your device in the PROFINET network. The `device_name` will be used as NoS if no REMA XML file is already present on your machine and no `rema_xml_content` is provided. ") 
    ip_config: Optional[BusIOProfinetIpConfig] = None 
    rema_xml_content: Optional[StrictStr] = Field(default=None, description="Content of the PROFINET REMA XML file. Is used when PROFINET service is added for the first time to create the REMA XML file that holds data to be kept for the next session. Stores information like IP address, Name of Station (NoS) and hardware configuration. If you use a PROFINET controller to assign an IP address to the PROFINET device, this information will be written to the REMA XML file.  Refer to the PDF version of the \"PN Driver I/O Base programming interface\" documentation for more information and an example REMA file. ") 
    __properties: ClassVar[List[str]] = ["device_name", "ip_config", "rema_xml_content"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True, exclude_none=True))

    def to_json(self) -> str:
        """
        Returns the JSON representation of the model using alias
        
        Do not use pydantic v2 .model_dump_json(by_alias=True, exclude_unset=True) here!
        It is unable to resolve nested types generated by openapi-generator.
        """
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BusIOProfinetNetwork from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of ip_config
        if self.ip_config:
            _dict['ip_config'] = self.ip_config.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BusIOProfinetNetwork from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "device_name": obj.get("device_name"),
            "ip_config": BusIOProfinetIpConfig.from_dict(obj["ip_config"]) if obj.get("ip_config") is not None else None,
            "rema_xml_content": obj.get("rema_xml_content")
        })
        return _obj


